// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Network.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Network
{
    /// <summary>
    /// A class representing the BgpConnection data model.
    /// Virtual Appliance Site resource.
    /// </summary>
    public partial class BgpConnectionData : NetworkResourceData
    {
        /// <summary> Initializes a new instance of <see cref="BgpConnectionData"/>. </summary>
        public BgpConnectionData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BgpConnectionData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="peerAsn"> Peer ASN. </param>
        /// <param name="peerIP"> Peer IP. </param>
        /// <param name="hubVirtualNetworkConnection"> The reference to the HubVirtualNetworkConnection resource. </param>
        /// <param name="provisioningState"> The provisioning state of the resource. </param>
        /// <param name="connectionState"> The current state of the VirtualHub to Peer. </param>
        internal BgpConnectionData(ResourceIdentifier id, string name, ResourceType? resourceType, IDictionary<string, BinaryData> serializedAdditionalRawData, ETag? etag, long? peerAsn, string peerIP, WritableSubResource hubVirtualNetworkConnection, NetworkProvisioningState? provisioningState, HubBgpConnectionStatus? connectionState) : base(id, name, resourceType, serializedAdditionalRawData)
        {
            ETag = etag;
            PeerAsn = peerAsn;
            PeerIP = peerIP;
            HubVirtualNetworkConnection = hubVirtualNetworkConnection;
            ProvisioningState = provisioningState;
            ConnectionState = connectionState;
        }

        /// <summary> A unique read-only string that changes whenever the resource is updated. </summary>
        public ETag? ETag { get; }
        /// <summary> Peer ASN. </summary>
        public long? PeerAsn { get; set; }
        /// <summary> Peer IP. </summary>
        public string PeerIP { get; set; }
        /// <summary> The reference to the HubVirtualNetworkConnection resource. </summary>
        internal WritableSubResource HubVirtualNetworkConnection { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier HubVirtualNetworkConnectionId
        {
            get => HubVirtualNetworkConnection is null ? default : HubVirtualNetworkConnection.Id;
            set
            {
                if (HubVirtualNetworkConnection is null)
                    HubVirtualNetworkConnection = new WritableSubResource();
                HubVirtualNetworkConnection.Id = value;
            }
        }

        /// <summary> The provisioning state of the resource. </summary>
        public NetworkProvisioningState? ProvisioningState { get; }
        /// <summary> The current state of the VirtualHub to Peer. </summary>
        public HubBgpConnectionStatus? ConnectionState { get; }
    }
}
