// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Network.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Network
{
    /// <summary>
    /// A class representing the BastionHost data model.
    /// Bastion Host resource.
    /// </summary>
    public partial class BastionHostData : NetworkTrackedResourceData
    {
        /// <summary> Initializes a new instance of <see cref="BastionHostData"/>. </summary>
        public BastionHostData()
        {
            Zones = new ChangeTrackingList<string>();
            IPConfigurations = new ChangeTrackingList<BastionHostIPConfiguration>();
        }

        /// <summary> Initializes a new instance of <see cref="BastionHostData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="zones"> A list of availability zones denoting where the resource needs to come from. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="sku"> The sku of this Bastion Host. </param>
        /// <param name="ipConfigurations"> IP configuration of the Bastion Host resource. </param>
        /// <param name="dnsName"> FQDN for the endpoint on which bastion host is accessible. </param>
        /// <param name="virtualNetwork"> Reference to an existing virtual network required for Developer Bastion Host only. </param>
        /// <param name="networkAcls"></param>
        /// <param name="provisioningState"> The provisioning state of the bastion host resource. </param>
        /// <param name="scaleUnits"> The scale units for the Bastion Host resource. </param>
        /// <param name="disableCopyPaste"> Enable/Disable Copy/Paste feature of the Bastion Host resource. </param>
        /// <param name="enableFileCopy"> Enable/Disable File Copy feature of the Bastion Host resource. </param>
        /// <param name="enableIPConnect"> Enable/Disable IP Connect feature of the Bastion Host resource. </param>
        /// <param name="enableShareableLink"> Enable/Disable Shareable Link of the Bastion Host resource. </param>
        /// <param name="enableTunneling"> Enable/Disable Tunneling feature of the Bastion Host resource. </param>
        /// <param name="enableKerberos"> Enable/Disable Kerberos feature of the Bastion Host resource. </param>
        /// <param name="enableSessionRecording"> Enable/Disable Session Recording feature of the Bastion Host resource. </param>
        internal BastionHostData(ResourceIdentifier id, string name, ResourceType? resourceType, AzureLocation? location, IDictionary<string, string> tags, IDictionary<string, BinaryData> serializedAdditionalRawData, IList<string> zones, ETag? etag, NetworkSku sku, IList<BastionHostIPConfiguration> ipConfigurations, string dnsName, WritableSubResource virtualNetwork, BastionHostPropertiesFormatNetworkAcls networkAcls, NetworkProvisioningState? provisioningState, int? scaleUnits, bool? disableCopyPaste, bool? enableFileCopy, bool? enableIPConnect, bool? enableShareableLink, bool? enableTunneling, bool? enableKerberos, bool? enableSessionRecording) : base(id, name, resourceType, location, tags, serializedAdditionalRawData)
        {
            Zones = zones;
            ETag = etag;
            Sku = sku;
            IPConfigurations = ipConfigurations;
            DnsName = dnsName;
            VirtualNetwork = virtualNetwork;
            NetworkAcls = networkAcls;
            ProvisioningState = provisioningState;
            ScaleUnits = scaleUnits;
            DisableCopyPaste = disableCopyPaste;
            EnableFileCopy = enableFileCopy;
            EnableIPConnect = enableIPConnect;
            EnableShareableLink = enableShareableLink;
            EnableTunneling = enableTunneling;
            EnableKerberos = enableKerberos;
            EnableSessionRecording = enableSessionRecording;
        }

        /// <summary> A list of availability zones denoting where the resource needs to come from. </summary>
        public IList<string> Zones { get; }
        /// <summary> A unique read-only string that changes whenever the resource is updated. </summary>
        public ETag? ETag { get; }
        /// <summary> The sku of this Bastion Host. </summary>
        internal NetworkSku Sku { get; set; }
        /// <summary> The name of the sku of this Bastion Host. </summary>
        public BastionHostSkuName? SkuName
        {
            get => Sku is null ? default : Sku.Name;
            set
            {
                if (Sku is null)
                    Sku = new NetworkSku();
                Sku.Name = value;
            }
        }

        /// <summary> IP configuration of the Bastion Host resource. </summary>
        public IList<BastionHostIPConfiguration> IPConfigurations { get; }
        /// <summary> FQDN for the endpoint on which bastion host is accessible. </summary>
        public string DnsName { get; set; }
        /// <summary> Reference to an existing virtual network required for Developer Bastion Host only. </summary>
        internal WritableSubResource VirtualNetwork { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier VirtualNetworkId
        {
            get => VirtualNetwork is null ? default : VirtualNetwork.Id;
            set
            {
                if (VirtualNetwork is null)
                    VirtualNetwork = new WritableSubResource();
                VirtualNetwork.Id = value;
            }
        }

        /// <summary> Gets or sets the network acls. </summary>
        internal BastionHostPropertiesFormatNetworkAcls NetworkAcls { get; set; }
        /// <summary> Sets the IP ACL rules for Developer Bastion Host. </summary>
        public IList<BastionHostIPRule> NetworkAclsIPRules
        {
            get
            {
                if (NetworkAcls is null)
                    NetworkAcls = new BastionHostPropertiesFormatNetworkAcls();
                return NetworkAcls.IPRules;
            }
        }

        /// <summary> The provisioning state of the bastion host resource. </summary>
        public NetworkProvisioningState? ProvisioningState { get; }
        /// <summary> The scale units for the Bastion Host resource. </summary>
        public int? ScaleUnits { get; set; }
        /// <summary> Enable/Disable Copy/Paste feature of the Bastion Host resource. </summary>
        public bool? DisableCopyPaste { get; set; }
        /// <summary> Enable/Disable File Copy feature of the Bastion Host resource. </summary>
        public bool? EnableFileCopy { get; set; }
        /// <summary> Enable/Disable IP Connect feature of the Bastion Host resource. </summary>
        public bool? EnableIPConnect { get; set; }
        /// <summary> Enable/Disable Shareable Link of the Bastion Host resource. </summary>
        public bool? EnableShareableLink { get; set; }
        /// <summary> Enable/Disable Tunneling feature of the Bastion Host resource. </summary>
        public bool? EnableTunneling { get; set; }
        /// <summary> Enable/Disable Kerberos feature of the Bastion Host resource. </summary>
        public bool? EnableKerberos { get; set; }
        /// <summary> Enable/Disable Session Recording feature of the Bastion Host resource. </summary>
        public bool? EnableSessionRecording { get; set; }
    }
}
