// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Network.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Network
{
    /// <summary>
    /// A class representing the AzureFirewall data model.
    /// Azure Firewall resource.
    /// </summary>
    public partial class AzureFirewallData : NetworkTrackedResourceData
    {
        /// <summary> Initializes a new instance of <see cref="AzureFirewallData"/>. </summary>
        public AzureFirewallData()
        {
            Zones = new ChangeTrackingList<string>();
            ApplicationRuleCollections = new ChangeTrackingList<AzureFirewallApplicationRuleCollectionData>();
            NatRuleCollections = new ChangeTrackingList<AzureFirewallNatRuleCollectionData>();
            NetworkRuleCollections = new ChangeTrackingList<AzureFirewallNetworkRuleCollectionData>();
            IPConfigurations = new ChangeTrackingList<AzureFirewallIPConfiguration>();
            IPGroups = new ChangeTrackingList<AzureFirewallIPGroups>();
            AdditionalProperties = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="AzureFirewallData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="zones"> A list of availability zones denoting where the resource needs to come from. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="applicationRuleCollections"> Collection of application rule collections used by Azure Firewall. </param>
        /// <param name="natRuleCollections"> Collection of NAT rule collections used by Azure Firewall. </param>
        /// <param name="networkRuleCollections"> Collection of network rule collections used by Azure Firewall. </param>
        /// <param name="ipConfigurations"> IP configuration of the Azure Firewall resource. </param>
        /// <param name="managementIPConfiguration"> IP configuration of the Azure Firewall used for management traffic. </param>
        /// <param name="provisioningState"> The provisioning state of the Azure firewall resource. </param>
        /// <param name="threatIntelMode"> The operation mode for Threat Intelligence. </param>
        /// <param name="virtualHub"> The virtualHub to which the firewall belongs. </param>
        /// <param name="firewallPolicy"> The firewallPolicy associated with this azure firewall. </param>
        /// <param name="hubIPAddresses"> IP addresses associated with AzureFirewall. </param>
        /// <param name="ipGroups"> IpGroups associated with AzureFirewall. </param>
        /// <param name="sku"> The Azure Firewall Resource SKU. </param>
        /// <param name="additionalProperties"> The additional properties used to further config this azure firewall. </param>
        /// <param name="autoscaleConfiguration"> Properties to provide a custom autoscale configuration to this azure firewall. </param>
        internal AzureFirewallData(ResourceIdentifier id, string name, ResourceType? resourceType, AzureLocation? location, IDictionary<string, string> tags, IDictionary<string, BinaryData> serializedAdditionalRawData, IList<string> zones, ETag? etag, IList<AzureFirewallApplicationRuleCollectionData> applicationRuleCollections, IList<AzureFirewallNatRuleCollectionData> natRuleCollections, IList<AzureFirewallNetworkRuleCollectionData> networkRuleCollections, IList<AzureFirewallIPConfiguration> ipConfigurations, AzureFirewallIPConfiguration managementIPConfiguration, NetworkProvisioningState? provisioningState, AzureFirewallThreatIntelMode? threatIntelMode, WritableSubResource virtualHub, WritableSubResource firewallPolicy, HubIPAddresses hubIPAddresses, IReadOnlyList<AzureFirewallIPGroups> ipGroups, AzureFirewallSku sku, IDictionary<string, string> additionalProperties, AzureFirewallAutoscaleConfiguration autoscaleConfiguration) : base(id, name, resourceType, location, tags, serializedAdditionalRawData)
        {
            Zones = zones;
            ETag = etag;
            ApplicationRuleCollections = applicationRuleCollections;
            NatRuleCollections = natRuleCollections;
            NetworkRuleCollections = networkRuleCollections;
            IPConfigurations = ipConfigurations;
            ManagementIPConfiguration = managementIPConfiguration;
            ProvisioningState = provisioningState;
            ThreatIntelMode = threatIntelMode;
            VirtualHub = virtualHub;
            FirewallPolicy = firewallPolicy;
            HubIPAddresses = hubIPAddresses;
            IPGroups = ipGroups;
            Sku = sku;
            AdditionalProperties = additionalProperties;
            AutoscaleConfiguration = autoscaleConfiguration;
        }

        /// <summary> A list of availability zones denoting where the resource needs to come from. </summary>
        public IList<string> Zones { get; }
        /// <summary> A unique read-only string that changes whenever the resource is updated. </summary>
        public ETag? ETag { get; }
        /// <summary> Collection of application rule collections used by Azure Firewall. </summary>
        public IList<AzureFirewallApplicationRuleCollectionData> ApplicationRuleCollections { get; }
        /// <summary> Collection of NAT rule collections used by Azure Firewall. </summary>
        public IList<AzureFirewallNatRuleCollectionData> NatRuleCollections { get; }
        /// <summary> Collection of network rule collections used by Azure Firewall. </summary>
        public IList<AzureFirewallNetworkRuleCollectionData> NetworkRuleCollections { get; }
        /// <summary> IP configuration of the Azure Firewall resource. </summary>
        public IList<AzureFirewallIPConfiguration> IPConfigurations { get; }
        /// <summary> IP configuration of the Azure Firewall used for management traffic. </summary>
        public AzureFirewallIPConfiguration ManagementIPConfiguration { get; set; }
        /// <summary> The provisioning state of the Azure firewall resource. </summary>
        public NetworkProvisioningState? ProvisioningState { get; }
        /// <summary> The operation mode for Threat Intelligence. </summary>
        public AzureFirewallThreatIntelMode? ThreatIntelMode { get; set; }
        /// <summary> The virtualHub to which the firewall belongs. </summary>
        internal WritableSubResource VirtualHub { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier VirtualHubId
        {
            get => VirtualHub is null ? default : VirtualHub.Id;
            set
            {
                if (VirtualHub is null)
                    VirtualHub = new WritableSubResource();
                VirtualHub.Id = value;
            }
        }

        /// <summary> The firewallPolicy associated with this azure firewall. </summary>
        internal WritableSubResource FirewallPolicy { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier FirewallPolicyId
        {
            get => FirewallPolicy is null ? default : FirewallPolicy.Id;
            set
            {
                if (FirewallPolicy is null)
                    FirewallPolicy = new WritableSubResource();
                FirewallPolicy.Id = value;
            }
        }

        /// <summary> IP addresses associated with AzureFirewall. </summary>
        public HubIPAddresses HubIPAddresses { get; set; }
        /// <summary> IpGroups associated with AzureFirewall. </summary>
        public IReadOnlyList<AzureFirewallIPGroups> IPGroups { get; }
        /// <summary> The Azure Firewall Resource SKU. </summary>
        public AzureFirewallSku Sku { get; set; }
        /// <summary> The additional properties used to further config this azure firewall. </summary>
        public IDictionary<string, string> AdditionalProperties { get; }
        /// <summary> Properties to provide a custom autoscale configuration to this azure firewall. </summary>
        public AzureFirewallAutoscaleConfiguration AutoscaleConfiguration { get; set; }
    }
}
