// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Net;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmNetworkModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Network.ApplicationGatewayData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="availabilityZones"> A list of availability zones denoting where the resource needs to come from. </param>
        /// <param name="identity"> The identity of the application gateway, if configured. </param>
        /// <param name="sku"> SKU of the application gateway resource. </param>
        /// <param name="sslPolicy"> SSL policy of the application gateway resource. </param>
        /// <param name="operationalState"> Operational state of the application gateway resource. </param>
        /// <param name="gatewayIPConfigurations"> Subnets of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits). </param>
        /// <param name="authenticationCertificates"> Authentication certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits). </param>
        /// <param name="trustedRootCertificates"> Trusted Root certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits). </param>
        /// <param name="trustedClientCertificates"> Trusted client certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits). </param>
        /// <param name="sslCertificates"> SSL certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits). </param>
        /// <param name="frontendIPConfigurations"> Frontend IP addresses of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits). </param>
        /// <param name="frontendPorts"> Frontend ports of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits). </param>
        /// <param name="probes"> Probes of the application gateway resource. </param>
        /// <param name="backendAddressPools"> Backend address pool of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits). </param>
        /// <param name="backendHttpSettingsCollection"> Backend http settings of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits). </param>
        /// <param name="backendSettingsCollection"> Backend settings of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits). </param>
        /// <param name="httpListeners"> Http listeners of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits). </param>
        /// <param name="listeners"> Listeners of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits). </param>
        /// <param name="sslProfiles"> SSL profiles of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits). </param>
        /// <param name="urlPathMaps"> URL path map of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits). </param>
        /// <param name="requestRoutingRules"> Request routing rules of the application gateway resource. </param>
        /// <param name="routingRules"> Routing rules of the application gateway resource. </param>
        /// <param name="rewriteRuleSets"> Rewrite rules for the application gateway resource. </param>
        /// <param name="redirectConfigurations"> Redirect configurations of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits). </param>
        /// <param name="webApplicationFirewallConfiguration"> Web application firewall configuration. </param>
        /// <param name="firewallPolicyId"> Reference to the FirewallPolicy resource. </param>
        /// <param name="enableHttp2"> Whether HTTP2 is enabled on the application gateway resource. </param>
        /// <param name="enableFips"> Whether FIPS is enabled on the application gateway resource. </param>
        /// <param name="autoscaleConfiguration"> Autoscale Configuration. </param>
        /// <param name="privateLinkConfigurations"> PrivateLink configurations on application gateway. </param>
        /// <param name="privateEndpointConnections"> Private Endpoint connections on application gateway. </param>
        /// <param name="resourceGuid"> The resource GUID property of the application gateway resource. </param>
        /// <param name="provisioningState"> The provisioning state of the application gateway resource. </param>
        /// <param name="customErrorConfigurations"> Custom error configurations of the application gateway resource. </param>
        /// <param name="forceFirewallPolicyAssociation"> If true, associates a firewall policy with an application gateway regardless whether the policy differs from the WAF Config. </param>
        /// <param name="loadDistributionPolicies"> Load distribution policies of the application gateway resource. </param>
        /// <param name="globalConfiguration"> Global Configuration. </param>
        /// <param name="defaultPredefinedSslPolicy"> The default predefined SSL Policy applied on the application gateway resource. </param>
        /// <returns> A new <see cref="Network.ApplicationGatewayData"/> instance for mocking. </returns>
        public static ApplicationGatewayData ApplicationGatewayData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, IEnumerable<string> availabilityZones = null, ManagedServiceIdentity identity = null, ApplicationGatewaySku sku = null, ApplicationGatewaySslPolicy sslPolicy = null, ApplicationGatewayOperationalState? operationalState = null, IEnumerable<ApplicationGatewayIPConfiguration> gatewayIPConfigurations = null, IEnumerable<ApplicationGatewayAuthenticationCertificate> authenticationCertificates = null, IEnumerable<ApplicationGatewayTrustedRootCertificate> trustedRootCertificates = null, IEnumerable<ApplicationGatewayTrustedClientCertificate> trustedClientCertificates = null, IEnumerable<ApplicationGatewaySslCertificate> sslCertificates = null, IEnumerable<ApplicationGatewayFrontendIPConfiguration> frontendIPConfigurations = null, IEnumerable<ApplicationGatewayFrontendPort> frontendPorts = null, IEnumerable<ApplicationGatewayProbe> probes = null, IEnumerable<ApplicationGatewayBackendAddressPool> backendAddressPools = null, IEnumerable<ApplicationGatewayBackendHttpSettings> backendHttpSettingsCollection = null, IEnumerable<ApplicationGatewayBackendSettings> backendSettingsCollection = null, IEnumerable<ApplicationGatewayHttpListener> httpListeners = null, IEnumerable<ApplicationGatewayListener> listeners = null, IEnumerable<ApplicationGatewaySslProfile> sslProfiles = null, IEnumerable<ApplicationGatewayUrlPathMap> urlPathMaps = null, IEnumerable<ApplicationGatewayRequestRoutingRule> requestRoutingRules = null, IEnumerable<ApplicationGatewayRoutingRule> routingRules = null, IEnumerable<ApplicationGatewayRewriteRuleSet> rewriteRuleSets = null, IEnumerable<ApplicationGatewayRedirectConfiguration> redirectConfigurations = null, ApplicationGatewayWebApplicationFirewallConfiguration webApplicationFirewallConfiguration = null, ResourceIdentifier firewallPolicyId = null, bool? enableHttp2 = null, bool? enableFips = null, ApplicationGatewayAutoscaleConfiguration autoscaleConfiguration = null, IEnumerable<ApplicationGatewayPrivateLinkConfiguration> privateLinkConfigurations = null, IEnumerable<ApplicationGatewayPrivateEndpointConnectionData> privateEndpointConnections = null, Guid? resourceGuid = null, NetworkProvisioningState? provisioningState = null, IEnumerable<ApplicationGatewayCustomError> customErrorConfigurations = null, bool? forceFirewallPolicyAssociation = null, IEnumerable<ApplicationGatewayLoadDistributionPolicy> loadDistributionPolicies = null, ApplicationGatewayGlobalConfiguration globalConfiguration = null, ApplicationGatewaySslPolicyName? defaultPredefinedSslPolicy = null)
        {
            tags ??= new Dictionary<string, string>();
            availabilityZones ??= new List<string>();
            gatewayIPConfigurations ??= new List<ApplicationGatewayIPConfiguration>();
            authenticationCertificates ??= new List<ApplicationGatewayAuthenticationCertificate>();
            trustedRootCertificates ??= new List<ApplicationGatewayTrustedRootCertificate>();
            trustedClientCertificates ??= new List<ApplicationGatewayTrustedClientCertificate>();
            sslCertificates ??= new List<ApplicationGatewaySslCertificate>();
            frontendIPConfigurations ??= new List<ApplicationGatewayFrontendIPConfiguration>();
            frontendPorts ??= new List<ApplicationGatewayFrontendPort>();
            probes ??= new List<ApplicationGatewayProbe>();
            backendAddressPools ??= new List<ApplicationGatewayBackendAddressPool>();
            backendHttpSettingsCollection ??= new List<ApplicationGatewayBackendHttpSettings>();
            backendSettingsCollection ??= new List<ApplicationGatewayBackendSettings>();
            httpListeners ??= new List<ApplicationGatewayHttpListener>();
            listeners ??= new List<ApplicationGatewayListener>();
            sslProfiles ??= new List<ApplicationGatewaySslProfile>();
            urlPathMaps ??= new List<ApplicationGatewayUrlPathMap>();
            requestRoutingRules ??= new List<ApplicationGatewayRequestRoutingRule>();
            routingRules ??= new List<ApplicationGatewayRoutingRule>();
            rewriteRuleSets ??= new List<ApplicationGatewayRewriteRuleSet>();
            redirectConfigurations ??= new List<ApplicationGatewayRedirectConfiguration>();
            privateLinkConfigurations ??= new List<ApplicationGatewayPrivateLinkConfiguration>();
            privateEndpointConnections ??= new List<ApplicationGatewayPrivateEndpointConnectionData>();
            customErrorConfigurations ??= new List<ApplicationGatewayCustomError>();
            loadDistributionPolicies ??= new List<ApplicationGatewayLoadDistributionPolicy>();

            return new ApplicationGatewayData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                availabilityZones?.ToList(),
                identity,
                sku,
                sslPolicy,
                operationalState,
                gatewayIPConfigurations?.ToList(),
                authenticationCertificates?.ToList(),
                trustedRootCertificates?.ToList(),
                trustedClientCertificates?.ToList(),
                sslCertificates?.ToList(),
                frontendIPConfigurations?.ToList(),
                frontendPorts?.ToList(),
                probes?.ToList(),
                backendAddressPools?.ToList(),
                backendHttpSettingsCollection?.ToList(),
                backendSettingsCollection?.ToList(),
                httpListeners?.ToList(),
                listeners?.ToList(),
                sslProfiles?.ToList(),
                urlPathMaps?.ToList(),
                requestRoutingRules?.ToList(),
                routingRules?.ToList(),
                rewriteRuleSets?.ToList(),
                redirectConfigurations?.ToList(),
                webApplicationFirewallConfiguration,
                firewallPolicyId != null ? ResourceManagerModelFactory.WritableSubResource(firewallPolicyId) : null,
                enableHttp2,
                enableFips,
                autoscaleConfiguration,
                privateLinkConfigurations?.ToList(),
                privateEndpointConnections?.ToList(),
                resourceGuid,
                provisioningState,
                customErrorConfigurations?.ToList(),
                forceFirewallPolicyAssociation,
                loadDistributionPolicies?.ToList(),
                globalConfiguration,
                defaultPredefinedSslPolicy);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewayIPConfiguration"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="subnetId"> Reference to the subnet resource. A subnet from where application gateway gets its private address. </param>
        /// <param name="provisioningState"> The provisioning state of the application gateway IP configuration resource. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewayIPConfiguration"/> instance for mocking. </returns>
        public static ApplicationGatewayIPConfiguration ApplicationGatewayIPConfiguration(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, ResourceIdentifier subnetId = null, NetworkProvisioningState? provisioningState = null)
        {
            return new ApplicationGatewayIPConfiguration(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                subnetId != null ? ResourceManagerModelFactory.WritableSubResource(subnetId) : null,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkResourceData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <returns> A new <see cref="Models.NetworkResourceData"/> instance for mocking. </returns>
        public static NetworkResourceData NetworkResourceData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null)
        {
            return new NetworkResourceData(id, name, resourceType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewayAuthenticationCertificate"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="data"> Certificate public data. </param>
        /// <param name="provisioningState"> The provisioning state of the authentication certificate resource. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewayAuthenticationCertificate"/> instance for mocking. </returns>
        public static ApplicationGatewayAuthenticationCertificate ApplicationGatewayAuthenticationCertificate(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, BinaryData data = null, NetworkProvisioningState? provisioningState = null)
        {
            return new ApplicationGatewayAuthenticationCertificate(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                data,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewayTrustedRootCertificate"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="data"> Certificate public data. </param>
        /// <param name="keyVaultSecretId"> Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault. </param>
        /// <param name="provisioningState"> The provisioning state of the trusted root certificate resource. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewayTrustedRootCertificate"/> instance for mocking. </returns>
        public static ApplicationGatewayTrustedRootCertificate ApplicationGatewayTrustedRootCertificate(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, BinaryData data = null, string keyVaultSecretId = null, NetworkProvisioningState? provisioningState = null)
        {
            return new ApplicationGatewayTrustedRootCertificate(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                data,
                keyVaultSecretId,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewayTrustedClientCertificate"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="data"> Certificate public data. </param>
        /// <param name="validatedCertData"> Validated certificate data. </param>
        /// <param name="clientCertIssuerDN"> Distinguished name of client certificate issuer. </param>
        /// <param name="provisioningState"> The provisioning state of the trusted client certificate resource. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewayTrustedClientCertificate"/> instance for mocking. </returns>
        public static ApplicationGatewayTrustedClientCertificate ApplicationGatewayTrustedClientCertificate(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, BinaryData data = null, BinaryData validatedCertData = null, string clientCertIssuerDN = null, NetworkProvisioningState? provisioningState = null)
        {
            return new ApplicationGatewayTrustedClientCertificate(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                data,
                validatedCertData,
                clientCertIssuerDN,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewaySslCertificate"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="data"> Base-64 encoded pfx certificate. Only applicable in PUT Request. </param>
        /// <param name="password"> Password for the pfx file specified in data. Only applicable in PUT request. </param>
        /// <param name="publicCertData"> Base-64 encoded Public cert data corresponding to pfx specified in data. Only applicable in GET request. </param>
        /// <param name="keyVaultSecretId"> Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault. </param>
        /// <param name="provisioningState"> The provisioning state of the SSL certificate resource. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewaySslCertificate"/> instance for mocking. </returns>
        public static ApplicationGatewaySslCertificate ApplicationGatewaySslCertificate(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, BinaryData data = null, string password = null, BinaryData publicCertData = null, string keyVaultSecretId = null, NetworkProvisioningState? provisioningState = null)
        {
            return new ApplicationGatewaySslCertificate(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                data,
                password,
                publicCertData,
                keyVaultSecretId,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewayFrontendPort"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="port"> Frontend port. </param>
        /// <param name="provisioningState"> The provisioning state of the frontend port resource. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewayFrontendPort"/> instance for mocking. </returns>
        public static ApplicationGatewayFrontendPort ApplicationGatewayFrontendPort(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, int? port = null, NetworkProvisioningState? provisioningState = null)
        {
            return new ApplicationGatewayFrontendPort(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                port,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewayProbe"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="protocol"> The protocol used for the probe. </param>
        /// <param name="host"> Host name to send the probe to. </param>
        /// <param name="path"> Relative path of probe. Valid path starts from '/'. Probe is sent to &lt;Protocol&gt;://&lt;host&gt;:&lt;port&gt;&lt;path&gt;. </param>
        /// <param name="intervalInSeconds"> The probing interval in seconds. This is the time interval between two consecutive probes. Acceptable values are from 1 second to 86400 seconds. </param>
        /// <param name="timeoutInSeconds"> The probe timeout in seconds. Probe marked as failed if valid response is not received with this timeout period. Acceptable values are from 1 second to 86400 seconds. </param>
        /// <param name="unhealthyThreshold"> The probe retry count. Backend server is marked down after consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second to 20. </param>
        /// <param name="pickHostNameFromBackendHttpSettings"> Whether the host header should be picked from the backend http settings. Default value is false. </param>
        /// <param name="pickHostNameFromBackendSettings"> Whether the server name indication should be picked from the backend settings for Tls protocol. Default value is false. </param>
        /// <param name="minServers"> Minimum number of servers that are always marked healthy. Default value is 0. </param>
        /// <param name="match"> Criterion for classifying a healthy probe response. </param>
        /// <param name="provisioningState"> The provisioning state of the probe resource. </param>
        /// <param name="port"> Custom port which will be used for probing the backend servers. The valid value ranges from 1 to 65535. In case not set, port from http settings will be used. This property is valid for Basic, Standard_v2 and WAF_v2 only. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewayProbe"/> instance for mocking. </returns>
        public static ApplicationGatewayProbe ApplicationGatewayProbe(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, ApplicationGatewayProtocol? protocol = null, string host = null, string path = null, int? intervalInSeconds = null, int? timeoutInSeconds = null, int? unhealthyThreshold = null, bool? pickHostNameFromBackendHttpSettings = null, bool? pickHostNameFromBackendSettings = null, int? minServers = null, ApplicationGatewayProbeHealthResponseMatch match = null, NetworkProvisioningState? provisioningState = null, int? port = null)
        {
            return new ApplicationGatewayProbe(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                protocol,
                host,
                path,
                intervalInSeconds,
                timeoutInSeconds,
                unhealthyThreshold,
                pickHostNameFromBackendHttpSettings,
                pickHostNameFromBackendSettings,
                minServers,
                match,
                provisioningState,
                port);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewayBackendAddressPool"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="backendIPConfigurations"> Collection of references to IPs defined in network interfaces. </param>
        /// <param name="backendAddresses"> Backend addresses. </param>
        /// <param name="provisioningState"> The provisioning state of the backend address pool resource. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewayBackendAddressPool"/> instance for mocking. </returns>
        public static ApplicationGatewayBackendAddressPool ApplicationGatewayBackendAddressPool(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, IEnumerable<NetworkInterfaceIPConfigurationData> backendIPConfigurations = null, IEnumerable<ApplicationGatewayBackendAddress> backendAddresses = null, NetworkProvisioningState? provisioningState = null)
        {
            backendIPConfigurations ??= new List<NetworkInterfaceIPConfigurationData>();
            backendAddresses ??= new List<ApplicationGatewayBackendAddress>();

            return new ApplicationGatewayBackendAddressPool(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                backendIPConfigurations?.ToList(),
                backendAddresses?.ToList(),
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Network.NetworkInterfaceIPConfigurationData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="gatewayLoadBalancerId"> The reference to gateway load balancer frontend IP. </param>
        /// <param name="virtualNetworkTaps"> The reference to Virtual Network Taps. </param>
        /// <param name="applicationGatewayBackendAddressPools"> The reference to ApplicationGatewayBackendAddressPool resource. </param>
        /// <param name="loadBalancerBackendAddressPools"> The reference to LoadBalancerBackendAddressPool resource. </param>
        /// <param name="loadBalancerInboundNatRules"> A list of references of LoadBalancerInboundNatRules. </param>
        /// <param name="privateIPAddress"> Private IP address of the IP configuration. It can be a single IP address or a CIDR block in the format &lt;address&gt;/&lt;prefix-length&gt;. </param>
        /// <param name="privateIPAddressPrefixLength"> The private IP address prefix length. If specified and the allocation method is dynamic, the service will allocate a CIDR block instead of a single IP address. </param>
        /// <param name="privateIPAllocationMethod"> The private IP address allocation method. </param>
        /// <param name="privateIPAddressVersion"> Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4. </param>
        /// <param name="subnet"> Subnet bound to the IP configuration. </param>
        /// <param name="primary"> Whether this is a primary customer address on the network interface. </param>
        /// <param name="publicIPAddress"> Public IP address bound to the IP configuration. </param>
        /// <param name="applicationSecurityGroups"> Application security groups in which the IP configuration is included. </param>
        /// <param name="provisioningState"> The provisioning state of the network interface IP configuration. </param>
        /// <param name="privateLinkConnectionProperties"> PrivateLinkConnection properties for the network interface. </param>
        /// <returns> A new <see cref="Network.NetworkInterfaceIPConfigurationData"/> instance for mocking. </returns>
        public static NetworkInterfaceIPConfigurationData NetworkInterfaceIPConfigurationData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, ResourceIdentifier gatewayLoadBalancerId = null, IEnumerable<VirtualNetworkTapData> virtualNetworkTaps = null, IEnumerable<ApplicationGatewayBackendAddressPool> applicationGatewayBackendAddressPools = null, IEnumerable<BackendAddressPoolData> loadBalancerBackendAddressPools = null, IEnumerable<InboundNatRuleData> loadBalancerInboundNatRules = null, string privateIPAddress = null, int? privateIPAddressPrefixLength = null, NetworkIPAllocationMethod? privateIPAllocationMethod = null, NetworkIPVersion? privateIPAddressVersion = null, SubnetData subnet = null, bool? primary = null, PublicIPAddressData publicIPAddress = null, IEnumerable<ApplicationSecurityGroupData> applicationSecurityGroups = null, NetworkProvisioningState? provisioningState = null, NetworkInterfaceIPConfigurationPrivateLinkConnectionProperties privateLinkConnectionProperties = null)
        {
            virtualNetworkTaps ??= new List<VirtualNetworkTapData>();
            applicationGatewayBackendAddressPools ??= new List<ApplicationGatewayBackendAddressPool>();
            loadBalancerBackendAddressPools ??= new List<BackendAddressPoolData>();
            loadBalancerInboundNatRules ??= new List<InboundNatRuleData>();
            applicationSecurityGroups ??= new List<ApplicationSecurityGroupData>();

            return new NetworkInterfaceIPConfigurationData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                gatewayLoadBalancerId != null ? ResourceManagerModelFactory.WritableSubResource(gatewayLoadBalancerId) : null,
                virtualNetworkTaps?.ToList(),
                applicationGatewayBackendAddressPools?.ToList(),
                loadBalancerBackendAddressPools?.ToList(),
                loadBalancerInboundNatRules?.ToList(),
                privateIPAddress,
                privateIPAddressPrefixLength,
                privateIPAllocationMethod,
                privateIPAddressVersion,
                subnet,
                primary,
                publicIPAddress,
                applicationSecurityGroups?.ToList(),
                provisioningState,
                privateLinkConnectionProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Network.VirtualNetworkTapData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="networkInterfaceTapConfigurations"> Specifies the list of resource IDs for the network interface IP configuration that needs to be tapped. </param>
        /// <param name="resourceGuid"> The resource GUID property of the virtual network tap resource. </param>
        /// <param name="provisioningState"> The provisioning state of the virtual network tap resource. </param>
        /// <param name="destinationNetworkInterfaceIPConfiguration"> The reference to the private IP Address of the collector nic that will receive the tap. </param>
        /// <param name="destinationLoadBalancerFrontEndIPConfiguration"> The reference to the private IP address on the internal Load Balancer that will receive the tap. </param>
        /// <param name="destinationPort"> The VXLAN destination port that will receive the tapped traffic. </param>
        /// <returns> A new <see cref="Network.VirtualNetworkTapData"/> instance for mocking. </returns>
        public static VirtualNetworkTapData VirtualNetworkTapData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, IEnumerable<NetworkInterfaceTapConfigurationData> networkInterfaceTapConfigurations = null, Guid? resourceGuid = null, NetworkProvisioningState? provisioningState = null, NetworkInterfaceIPConfigurationData destinationNetworkInterfaceIPConfiguration = null, FrontendIPConfigurationData destinationLoadBalancerFrontEndIPConfiguration = null, int? destinationPort = null)
        {
            tags ??= new Dictionary<string, string>();
            networkInterfaceTapConfigurations ??= new List<NetworkInterfaceTapConfigurationData>();

            return new VirtualNetworkTapData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                networkInterfaceTapConfigurations?.ToList(),
                resourceGuid,
                provisioningState,
                destinationNetworkInterfaceIPConfiguration,
                destinationLoadBalancerFrontEndIPConfiguration,
                destinationPort);
        }

        /// <summary> Initializes a new instance of <see cref="Network.NetworkInterfaceTapConfigurationData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="virtualNetworkTap"> The reference to the Virtual Network Tap resource. </param>
        /// <param name="provisioningState"> The provisioning state of the network interface tap configuration resource. </param>
        /// <returns> A new <see cref="Network.NetworkInterfaceTapConfigurationData"/> instance for mocking. </returns>
        public static NetworkInterfaceTapConfigurationData NetworkInterfaceTapConfigurationData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, VirtualNetworkTapData virtualNetworkTap = null, NetworkProvisioningState? provisioningState = null)
        {
            return new NetworkInterfaceTapConfigurationData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                virtualNetworkTap,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Network.FrontendIPConfigurationData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="zones"> A list of availability zones denoting the IP allocated for the resource needs to come from. </param>
        /// <param name="inboundNatRules"> An array of references to inbound rules that use this frontend IP. </param>
        /// <param name="inboundNatPools"> An array of references to inbound pools that use this frontend IP. </param>
        /// <param name="outboundRules"> An array of references to outbound rules that use this frontend IP. </param>
        /// <param name="loadBalancingRules"> An array of references to load balancing rules that use this frontend IP. </param>
        /// <param name="privateIPAddress"> The private IP address of the IP configuration. </param>
        /// <param name="privateIPAllocationMethod"> The Private IP allocation method. </param>
        /// <param name="privateIPAddressVersion"> Whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. </param>
        /// <param name="subnet"> The reference to the subnet resource. </param>
        /// <param name="publicIPAddress"> The reference to the Public IP resource. </param>
        /// <param name="publicIPPrefixId"> The reference to the Public IP Prefix resource. </param>
        /// <param name="gatewayLoadBalancerId"> The reference to gateway load balancer frontend IP. </param>
        /// <param name="provisioningState"> The provisioning state of the frontend IP configuration resource. </param>
        /// <returns> A new <see cref="Network.FrontendIPConfigurationData"/> instance for mocking. </returns>
        public static FrontendIPConfigurationData FrontendIPConfigurationData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, IEnumerable<string> zones = null, IEnumerable<WritableSubResource> inboundNatRules = null, IEnumerable<WritableSubResource> inboundNatPools = null, IEnumerable<WritableSubResource> outboundRules = null, IEnumerable<WritableSubResource> loadBalancingRules = null, string privateIPAddress = null, NetworkIPAllocationMethod? privateIPAllocationMethod = null, NetworkIPVersion? privateIPAddressVersion = null, SubnetData subnet = null, PublicIPAddressData publicIPAddress = null, ResourceIdentifier publicIPPrefixId = null, ResourceIdentifier gatewayLoadBalancerId = null, NetworkProvisioningState? provisioningState = null)
        {
            zones ??= new List<string>();
            inboundNatRules ??= new List<WritableSubResource>();
            inboundNatPools ??= new List<WritableSubResource>();
            outboundRules ??= new List<WritableSubResource>();
            loadBalancingRules ??= new List<WritableSubResource>();

            return new FrontendIPConfigurationData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                zones?.ToList(),
                inboundNatRules?.ToList(),
                inboundNatPools?.ToList(),
                outboundRules?.ToList(),
                loadBalancingRules?.ToList(),
                privateIPAddress,
                privateIPAllocationMethod,
                privateIPAddressVersion,
                subnet,
                publicIPAddress,
                publicIPPrefixId != null ? ResourceManagerModelFactory.WritableSubResource(publicIPPrefixId) : null,
                gatewayLoadBalancerId != null ? ResourceManagerModelFactory.WritableSubResource(gatewayLoadBalancerId) : null,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Network.SubnetData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="addressPrefix"> The address prefix for the subnet. </param>
        /// <param name="addressPrefixes"> List of address prefixes for the subnet. </param>
        /// <param name="networkSecurityGroup"> The reference to the NetworkSecurityGroup resource. </param>
        /// <param name="routeTable"> The reference to the RouteTable resource. </param>
        /// <param name="natGatewayId"> Nat gateway associated with this subnet. </param>
        /// <param name="serviceEndpoints"> An array of service endpoints. </param>
        /// <param name="serviceEndpointPolicies"> An array of service endpoint policies. </param>
        /// <param name="privateEndpoints"> An array of references to private endpoints. </param>
        /// <param name="ipConfigurations"> An array of references to the network interface IP configurations using subnet. </param>
        /// <param name="ipConfigurationProfiles"> Array of IP configuration profiles which reference this subnet. </param>
        /// <param name="ipAllocations"> Array of IpAllocation which reference this subnet. </param>
        /// <param name="resourceNavigationLinks"> An array of references to the external resources using subnet. </param>
        /// <param name="serviceAssociationLinks"> An array of references to services injecting into this subnet. </param>
        /// <param name="delegations"> An array of references to the delegations on the subnet. </param>
        /// <param name="purpose"> A read-only string identifying the intention of use for this subnet based on delegations and other user-defined properties. </param>
        /// <param name="provisioningState"> The provisioning state of the subnet resource. </param>
        /// <param name="privateEndpointNetworkPolicy"> Enable or Disable apply network policies on private end point in the subnet. </param>
        /// <param name="privateLinkServiceNetworkPolicy"> Enable or Disable apply network policies on private link service in the subnet. </param>
        /// <param name="applicationGatewayIPConfigurations"> Application gateway IP configurations of virtual network resource. </param>
        /// <param name="sharingScope"> Set this property to Tenant to allow sharing subnet with other subscriptions in your AAD tenant. This property can only be set if defaultOutboundAccess is set to false, both properties can only be set if subnet is empty. </param>
        /// <param name="defaultOutboundAccess"> Set this property to false to disable default outbound connectivity for all VMs in the subnet. This property can only be set at the time of subnet creation and cannot be updated for an existing subnet. </param>
        /// <returns> A new <see cref="Network.SubnetData"/> instance for mocking. </returns>
        public static SubnetData SubnetData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, string addressPrefix = null, IEnumerable<string> addressPrefixes = null, NetworkSecurityGroupData networkSecurityGroup = null, RouteTableData routeTable = null, ResourceIdentifier natGatewayId = null, IEnumerable<ServiceEndpointProperties> serviceEndpoints = null, IEnumerable<ServiceEndpointPolicyData> serviceEndpointPolicies = null, IEnumerable<PrivateEndpointData> privateEndpoints = null, IEnumerable<NetworkIPConfiguration> ipConfigurations = null, IEnumerable<NetworkIPConfigurationProfile> ipConfigurationProfiles = null, IEnumerable<WritableSubResource> ipAllocations = null, IEnumerable<ResourceNavigationLink> resourceNavigationLinks = null, IEnumerable<ServiceAssociationLink> serviceAssociationLinks = null, IEnumerable<ServiceDelegation> delegations = null, string purpose = null, NetworkProvisioningState? provisioningState = null, VirtualNetworkPrivateEndpointNetworkPolicy? privateEndpointNetworkPolicy = null, VirtualNetworkPrivateLinkServiceNetworkPolicy? privateLinkServiceNetworkPolicy = null, IEnumerable<ApplicationGatewayIPConfiguration> applicationGatewayIPConfigurations = null, SharingScope? sharingScope = null, bool? defaultOutboundAccess = null)
        {
            addressPrefixes ??= new List<string>();
            serviceEndpoints ??= new List<ServiceEndpointProperties>();
            serviceEndpointPolicies ??= new List<ServiceEndpointPolicyData>();
            privateEndpoints ??= new List<PrivateEndpointData>();
            ipConfigurations ??= new List<NetworkIPConfiguration>();
            ipConfigurationProfiles ??= new List<NetworkIPConfigurationProfile>();
            ipAllocations ??= new List<WritableSubResource>();
            resourceNavigationLinks ??= new List<ResourceNavigationLink>();
            serviceAssociationLinks ??= new List<ServiceAssociationLink>();
            delegations ??= new List<ServiceDelegation>();
            applicationGatewayIPConfigurations ??= new List<ApplicationGatewayIPConfiguration>();

            return new SubnetData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                addressPrefix,
                addressPrefixes?.ToList(),
                networkSecurityGroup,
                routeTable,
                natGatewayId != null ? ResourceManagerModelFactory.WritableSubResource(natGatewayId) : null,
                serviceEndpoints?.ToList(),
                serviceEndpointPolicies?.ToList(),
                privateEndpoints?.ToList(),
                ipConfigurations?.ToList(),
                ipConfigurationProfiles?.ToList(),
                ipAllocations?.ToList(),
                resourceNavigationLinks?.ToList(),
                serviceAssociationLinks?.ToList(),
                delegations?.ToList(),
                purpose,
                provisioningState,
                privateEndpointNetworkPolicy,
                privateLinkServiceNetworkPolicy,
                applicationGatewayIPConfigurations?.ToList(),
                sharingScope,
                defaultOutboundAccess);
        }

        /// <summary> Initializes a new instance of <see cref="Network.NetworkSecurityGroupData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="flushConnection"> When enabled, flows created from Network Security Group connections will be re-evaluated when rules are updates. Initial enablement will trigger re-evaluation. </param>
        /// <param name="securityRules"> A collection of security rules of the network security group. </param>
        /// <param name="defaultSecurityRules"> The default security rules of network security group. </param>
        /// <param name="networkInterfaces"> A collection of references to network interfaces. </param>
        /// <param name="subnets"> A collection of references to subnets. </param>
        /// <param name="flowLogs"> A collection of references to flow log resources. </param>
        /// <param name="resourceGuid"> The resource GUID property of the network security group resource. </param>
        /// <param name="provisioningState"> The provisioning state of the network security group resource. </param>
        /// <returns> A new <see cref="Network.NetworkSecurityGroupData"/> instance for mocking. </returns>
        public static NetworkSecurityGroupData NetworkSecurityGroupData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, bool? flushConnection = null, IEnumerable<SecurityRuleData> securityRules = null, IEnumerable<SecurityRuleData> defaultSecurityRules = null, IEnumerable<NetworkInterfaceData> networkInterfaces = null, IEnumerable<SubnetData> subnets = null, IEnumerable<FlowLogData> flowLogs = null, Guid? resourceGuid = null, NetworkProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            securityRules ??= new List<SecurityRuleData>();
            defaultSecurityRules ??= new List<SecurityRuleData>();
            networkInterfaces ??= new List<NetworkInterfaceData>();
            subnets ??= new List<SubnetData>();
            flowLogs ??= new List<FlowLogData>();

            return new NetworkSecurityGroupData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                flushConnection,
                securityRules?.ToList(),
                defaultSecurityRules?.ToList(),
                networkInterfaces?.ToList(),
                subnets?.ToList(),
                flowLogs?.ToList(),
                resourceGuid,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Network.SecurityRuleData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="description"> A description for this rule. Restricted to 140 chars. </param>
        /// <param name="protocol"> Network protocol this rule applies to. </param>
        /// <param name="sourcePortRange"> The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports. </param>
        /// <param name="destinationPortRange"> The destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports. </param>
        /// <param name="sourceAddressPrefix"> The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from. </param>
        /// <param name="sourceAddressPrefixes"> The CIDR or source IP ranges. </param>
        /// <param name="sourceApplicationSecurityGroups"> The application security group specified as source. </param>
        /// <param name="destinationAddressPrefix"> The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. </param>
        /// <param name="destinationAddressPrefixes"> The destination address prefixes. CIDR or destination IP ranges. </param>
        /// <param name="destinationApplicationSecurityGroups"> The application security group specified as destination. </param>
        /// <param name="sourcePortRanges"> The source port ranges. </param>
        /// <param name="destinationPortRanges"> The destination port ranges. </param>
        /// <param name="access"> The network traffic is allowed or denied. </param>
        /// <param name="priority"> The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule. </param>
        /// <param name="direction"> The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic. </param>
        /// <param name="provisioningState"> The provisioning state of the security rule resource. </param>
        /// <returns> A new <see cref="Network.SecurityRuleData"/> instance for mocking. </returns>
        public static SecurityRuleData SecurityRuleData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, string description = null, SecurityRuleProtocol? protocol = null, string sourcePortRange = null, string destinationPortRange = null, string sourceAddressPrefix = null, IEnumerable<string> sourceAddressPrefixes = null, IEnumerable<ApplicationSecurityGroupData> sourceApplicationSecurityGroups = null, string destinationAddressPrefix = null, IEnumerable<string> destinationAddressPrefixes = null, IEnumerable<ApplicationSecurityGroupData> destinationApplicationSecurityGroups = null, IEnumerable<string> sourcePortRanges = null, IEnumerable<string> destinationPortRanges = null, SecurityRuleAccess? access = null, int? priority = null, SecurityRuleDirection? direction = null, NetworkProvisioningState? provisioningState = null)
        {
            sourceAddressPrefixes ??= new List<string>();
            sourceApplicationSecurityGroups ??= new List<ApplicationSecurityGroupData>();
            destinationAddressPrefixes ??= new List<string>();
            destinationApplicationSecurityGroups ??= new List<ApplicationSecurityGroupData>();
            sourcePortRanges ??= new List<string>();
            destinationPortRanges ??= new List<string>();

            return new SecurityRuleData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                description,
                protocol,
                sourcePortRange,
                destinationPortRange,
                sourceAddressPrefix,
                sourceAddressPrefixes?.ToList(),
                sourceApplicationSecurityGroups?.ToList(),
                destinationAddressPrefix,
                destinationAddressPrefixes?.ToList(),
                destinationApplicationSecurityGroups?.ToList(),
                sourcePortRanges?.ToList(),
                destinationPortRanges?.ToList(),
                access,
                priority,
                direction,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Network.ApplicationSecurityGroupData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="resourceGuid"> The resource GUID property of the application security group resource. It uniquely identifies a resource, even if the user changes its name or migrate the resource across subscriptions or resource groups. </param>
        /// <param name="provisioningState"> The provisioning state of the application security group resource. </param>
        /// <returns> A new <see cref="Network.ApplicationSecurityGroupData"/> instance for mocking. </returns>
        public static ApplicationSecurityGroupData ApplicationSecurityGroupData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, Guid? resourceGuid = null, NetworkProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();

            return new ApplicationSecurityGroupData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                resourceGuid,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkTrackedResourceData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <returns> A new <see cref="Models.NetworkTrackedResourceData"/> instance for mocking. </returns>
        public static NetworkTrackedResourceData NetworkTrackedResourceData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null)
        {
            tags ??= new Dictionary<string, string>();

            return new NetworkTrackedResourceData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.NetworkInterfaceData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="extendedLocation"> The extended location of the network interface. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="virtualMachineId"> The reference to a virtual machine. </param>
        /// <param name="networkSecurityGroup"> The reference to the NetworkSecurityGroup resource. </param>
        /// <param name="privateEndpoint"> A reference to the private endpoint to which the network interface is linked. </param>
        /// <param name="ipConfigurations"> A list of IPConfigurations of the network interface. </param>
        /// <param name="tapConfigurations"> A list of TapConfigurations of the network interface. </param>
        /// <param name="dnsSettings"> The DNS settings in network interface. </param>
        /// <param name="macAddress"> The MAC address of the network interface. </param>
        /// <param name="primary"> Whether this is a primary network interface on a virtual machine. </param>
        /// <param name="vnetEncryptionSupported"> Whether the virtual machine this nic is attached to supports encryption. </param>
        /// <param name="enableAcceleratedNetworking"> If the network interface is configured for accelerated networking. Not applicable to VM sizes which require accelerated networking. </param>
        /// <param name="disableTcpStateTracking"> Indicates whether to disable tcp state tracking. </param>
        /// <param name="enableIPForwarding"> Indicates whether IP forwarding is enabled on this network interface. </param>
        /// <param name="hostedWorkloads"> A list of references to linked BareMetal resources. </param>
        /// <param name="dscpConfigurationId"> A reference to the dscp configuration to which the network interface is linked. </param>
        /// <param name="resourceGuid"> The resource GUID property of the network interface resource. </param>
        /// <param name="provisioningState"> The provisioning state of the network interface resource. </param>
        /// <param name="workloadType"> WorkloadType of the NetworkInterface for BareMetal resources. </param>
        /// <param name="nicType"> Type of Network Interface resource. </param>
        /// <param name="privateLinkService"> Privatelinkservice of the network interface resource. </param>
        /// <param name="migrationPhase"> Migration phase of Network Interface resource. </param>
        /// <param name="auxiliaryMode"> Auxiliary mode of Network Interface resource. </param>
        /// <param name="auxiliarySku"> Auxiliary sku of Network Interface resource. </param>
        /// <returns> A new <see cref="Network.NetworkInterfaceData"/> instance for mocking. </returns>
        public static NetworkInterfaceData NetworkInterfaceData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ExtendedLocation extendedLocation = null, ETag? etag = null, ResourceIdentifier virtualMachineId = null, NetworkSecurityGroupData networkSecurityGroup = null, PrivateEndpointData privateEndpoint = null, IEnumerable<NetworkInterfaceIPConfigurationData> ipConfigurations = null, IEnumerable<NetworkInterfaceTapConfigurationData> tapConfigurations = null, NetworkInterfaceDnsSettings dnsSettings = null, string macAddress = null, bool? primary = null, bool? vnetEncryptionSupported = null, bool? enableAcceleratedNetworking = null, bool? disableTcpStateTracking = null, bool? enableIPForwarding = null, IEnumerable<string> hostedWorkloads = null, ResourceIdentifier dscpConfigurationId = null, Guid? resourceGuid = null, NetworkProvisioningState? provisioningState = null, string workloadType = null, NetworkInterfaceNicType? nicType = null, PrivateLinkServiceData privateLinkService = null, NetworkInterfaceMigrationPhase? migrationPhase = null, NetworkInterfaceAuxiliaryMode? auxiliaryMode = null, NetworkInterfaceAuxiliarySku? auxiliarySku = null)
        {
            tags ??= new Dictionary<string, string>();
            ipConfigurations ??= new List<NetworkInterfaceIPConfigurationData>();
            tapConfigurations ??= new List<NetworkInterfaceTapConfigurationData>();
            hostedWorkloads ??= new List<string>();

            return new NetworkInterfaceData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                extendedLocation,
                etag,
                virtualMachineId != null ? ResourceManagerModelFactory.WritableSubResource(virtualMachineId) : null,
                networkSecurityGroup,
                privateEndpoint,
                ipConfigurations?.ToList(),
                tapConfigurations?.ToList(),
                dnsSettings,
                macAddress,
                primary,
                vnetEncryptionSupported,
                enableAcceleratedNetworking,
                disableTcpStateTracking,
                enableIPForwarding,
                hostedWorkloads?.ToList(),
                dscpConfigurationId != null ? ResourceManagerModelFactory.WritableSubResource(dscpConfigurationId) : null,
                resourceGuid,
                provisioningState,
                workloadType,
                nicType,
                privateLinkService,
                migrationPhase,
                auxiliaryMode,
                auxiliarySku);
        }

        /// <summary> Initializes a new instance of <see cref="Network.PrivateEndpointData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="extendedLocation"> The extended location of the load balancer. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="subnet"> The ID of the subnet from which the private IP will be allocated. </param>
        /// <param name="networkInterfaces"> An array of references to the network interfaces created for this private endpoint. </param>
        /// <param name="provisioningState"> The provisioning state of the private endpoint resource. </param>
        /// <param name="privateLinkServiceConnections"> A grouping of information about the connection to the remote resource. </param>
        /// <param name="manualPrivateLinkServiceConnections"> A grouping of information about the connection to the remote resource. Used when the network admin does not have access to approve connections to the remote resource. </param>
        /// <param name="customDnsConfigs"> An array of custom dns configurations. </param>
        /// <param name="applicationSecurityGroups"> Application security groups in which the private endpoint IP configuration is included. </param>
        /// <param name="ipConfigurations"> A list of IP configurations of the private endpoint. This will be used to map to the First Party Service's endpoints. </param>
        /// <param name="customNetworkInterfaceName"> The custom name of the network interface attached to the private endpoint. </param>
        /// <returns> A new <see cref="Network.PrivateEndpointData"/> instance for mocking. </returns>
        public static PrivateEndpointData PrivateEndpointData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ExtendedLocation extendedLocation = null, ETag? etag = null, SubnetData subnet = null, IEnumerable<NetworkInterfaceData> networkInterfaces = null, NetworkProvisioningState? provisioningState = null, IEnumerable<NetworkPrivateLinkServiceConnection> privateLinkServiceConnections = null, IEnumerable<NetworkPrivateLinkServiceConnection> manualPrivateLinkServiceConnections = null, IEnumerable<CustomDnsConfigProperties> customDnsConfigs = null, IEnumerable<ApplicationSecurityGroupData> applicationSecurityGroups = null, IEnumerable<PrivateEndpointIPConfiguration> ipConfigurations = null, string customNetworkInterfaceName = null)
        {
            tags ??= new Dictionary<string, string>();
            networkInterfaces ??= new List<NetworkInterfaceData>();
            privateLinkServiceConnections ??= new List<NetworkPrivateLinkServiceConnection>();
            manualPrivateLinkServiceConnections ??= new List<NetworkPrivateLinkServiceConnection>();
            customDnsConfigs ??= new List<CustomDnsConfigProperties>();
            applicationSecurityGroups ??= new List<ApplicationSecurityGroupData>();
            ipConfigurations ??= new List<PrivateEndpointIPConfiguration>();

            return new PrivateEndpointData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                extendedLocation,
                etag,
                subnet,
                networkInterfaces?.ToList(),
                provisioningState,
                privateLinkServiceConnections?.ToList(),
                manualPrivateLinkServiceConnections?.ToList(),
                customDnsConfigs?.ToList(),
                applicationSecurityGroups?.ToList(),
                ipConfigurations?.ToList(),
                customNetworkInterfaceName);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkPrivateLinkServiceConnection"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="provisioningState"> The provisioning state of the private link service connection resource. </param>
        /// <param name="privateLinkServiceId"> The resource id of private link service. </param>
        /// <param name="groupIds"> The ID(s) of the group(s) obtained from the remote resource that this private endpoint should connect to. </param>
        /// <param name="requestMessage"> A message passed to the owner of the remote resource with this connection request. Restricted to 140 chars. </param>
        /// <param name="connectionState"> A collection of read-only information about the state of the connection to the remote resource. </param>
        /// <returns> A new <see cref="Models.NetworkPrivateLinkServiceConnection"/> instance for mocking. </returns>
        public static NetworkPrivateLinkServiceConnection NetworkPrivateLinkServiceConnection(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, NetworkProvisioningState? provisioningState = null, ResourceIdentifier privateLinkServiceId = null, IEnumerable<string> groupIds = null, string requestMessage = null, NetworkPrivateLinkServiceConnectionState connectionState = null)
        {
            groupIds ??= new List<string>();

            return new NetworkPrivateLinkServiceConnection(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                provisioningState,
                privateLinkServiceId,
                groupIds?.ToList(),
                requestMessage,
                connectionState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PrivateEndpointIPConfiguration"/>. </summary>
        /// <param name="name"> The name of the resource that is unique within a resource group. </param>
        /// <param name="privateEndpointIPConfigurationType"> The resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="groupId"> The ID of a group obtained from the remote resource that this private endpoint should connect to. </param>
        /// <param name="memberName"> The member name of a group obtained from the remote resource that this private endpoint should connect to. </param>
        /// <param name="privateIPAddress"> A private ip address obtained from the private endpoint's subnet. </param>
        /// <returns> A new <see cref="Models.PrivateEndpointIPConfiguration"/> instance for mocking. </returns>
        public static PrivateEndpointIPConfiguration PrivateEndpointIPConfiguration(string name = null, string privateEndpointIPConfigurationType = null, ETag? etag = null, string groupId = null, string memberName = null, IPAddress privateIPAddress = null)
        {
            return new PrivateEndpointIPConfiguration(
                name,
                privateEndpointIPConfigurationType,
                etag,
                groupId,
                memberName,
                privateIPAddress,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkInterfaceDnsSettings"/>. </summary>
        /// <param name="dnsServers"> List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it must be the only value in dnsServers collection. </param>
        /// <param name="appliedDnsServers"> If the VM that uses this NIC is part of an Availability Set, then this list will have the union of all DNS servers from all NICs that are part of the Availability Set. This property is what is configured on each of those VMs. </param>
        /// <param name="internalDnsNameLabel"> Relative DNS name for this NIC used for internal communications between VMs in the same virtual network. </param>
        /// <param name="internalFqdn"> Fully qualified DNS name supporting internal communications between VMs in the same virtual network. </param>
        /// <param name="internalDomainNameSuffix"> Even if internalDnsNameLabel is not specified, a DNS entry is created for the primary NIC of the VM. This DNS name can be constructed by concatenating the VM name with the value of internalDomainNameSuffix. </param>
        /// <returns> A new <see cref="Models.NetworkInterfaceDnsSettings"/> instance for mocking. </returns>
        public static NetworkInterfaceDnsSettings NetworkInterfaceDnsSettings(IEnumerable<string> dnsServers = null, IEnumerable<string> appliedDnsServers = null, string internalDnsNameLabel = null, string internalFqdn = null, string internalDomainNameSuffix = null)
        {
            dnsServers ??= new List<string>();
            appliedDnsServers ??= new List<string>();

            return new NetworkInterfaceDnsSettings(
                dnsServers?.ToList(),
                appliedDnsServers?.ToList(),
                internalDnsNameLabel,
                internalFqdn,
                internalDomainNameSuffix,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.PrivateLinkServiceData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="extendedLocation"> The extended location of the load balancer. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="loadBalancerFrontendIPConfigurations"> An array of references to the load balancer IP configurations. </param>
        /// <param name="ipConfigurations"> An array of private link service IP configurations. </param>
        /// <param name="destinationIPAddress"> The destination IP address of the private link service. </param>
        /// <param name="networkInterfaces"> An array of references to the network interfaces created for this private link service. </param>
        /// <param name="provisioningState"> The provisioning state of the private link service resource. </param>
        /// <param name="privateEndpointConnections"> An array of list about connections to the private endpoint. </param>
        /// <param name="visibilitySubscriptions"> The visibility list of the private link service. </param>
        /// <param name="autoApprovalSubscriptions"> The auto-approval list of the private link service. </param>
        /// <param name="fqdns"> The list of Fqdn. </param>
        /// <param name="alias"> The alias of the private link service. </param>
        /// <param name="enableProxyProtocol"> Whether the private link service is enabled for proxy protocol or not. </param>
        /// <returns> A new <see cref="Network.PrivateLinkServiceData"/> instance for mocking. </returns>
        public static PrivateLinkServiceData PrivateLinkServiceData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ExtendedLocation extendedLocation = null, ETag? etag = null, IEnumerable<FrontendIPConfigurationData> loadBalancerFrontendIPConfigurations = null, IEnumerable<PrivateLinkServiceIPConfiguration> ipConfigurations = null, string destinationIPAddress = null, IEnumerable<NetworkInterfaceData> networkInterfaces = null, NetworkProvisioningState? provisioningState = null, IEnumerable<NetworkPrivateEndpointConnectionData> privateEndpointConnections = null, IEnumerable<string> visibilitySubscriptions = null, IEnumerable<string> autoApprovalSubscriptions = null, IEnumerable<string> fqdns = null, string @alias = null, bool? enableProxyProtocol = null)
        {
            tags ??= new Dictionary<string, string>();
            loadBalancerFrontendIPConfigurations ??= new List<FrontendIPConfigurationData>();
            ipConfigurations ??= new List<PrivateLinkServiceIPConfiguration>();
            networkInterfaces ??= new List<NetworkInterfaceData>();
            privateEndpointConnections ??= new List<NetworkPrivateEndpointConnectionData>();
            visibilitySubscriptions ??= new List<string>();
            autoApprovalSubscriptions ??= new List<string>();
            fqdns ??= new List<string>();

            return new PrivateLinkServiceData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                extendedLocation,
                etag,
                loadBalancerFrontendIPConfigurations?.ToList(),
                ipConfigurations?.ToList(),
                destinationIPAddress,
                networkInterfaces?.ToList(),
                provisioningState,
                privateEndpointConnections?.ToList(),
                visibilitySubscriptions != null ? new PrivateLinkServicePropertiesVisibility(visibilitySubscriptions?.ToList(), serializedAdditionalRawData: null) : null,
                autoApprovalSubscriptions != null ? new PrivateLinkServicePropertiesAutoApproval(autoApprovalSubscriptions?.ToList(), serializedAdditionalRawData: null) : null,
                fqdns?.ToList(),
                @alias,
                enableProxyProtocol);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PrivateLinkServiceIPConfiguration"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="privateIPAddress"> The private IP address of the IP configuration. </param>
        /// <param name="privateIPAllocationMethod"> The private IP address allocation method. </param>
        /// <param name="subnet"> The reference to the subnet resource. </param>
        /// <param name="primary"> Whether the ip configuration is primary or not. </param>
        /// <param name="provisioningState"> The provisioning state of the private link service IP configuration resource. </param>
        /// <param name="privateIPAddressVersion"> Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4. </param>
        /// <returns> A new <see cref="Models.PrivateLinkServiceIPConfiguration"/> instance for mocking. </returns>
        public static PrivateLinkServiceIPConfiguration PrivateLinkServiceIPConfiguration(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, string privateIPAddress = null, NetworkIPAllocationMethod? privateIPAllocationMethod = null, SubnetData subnet = null, bool? primary = null, NetworkProvisioningState? provisioningState = null, NetworkIPVersion? privateIPAddressVersion = null)
        {
            return new PrivateLinkServiceIPConfiguration(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                privateIPAddress,
                privateIPAllocationMethod,
                subnet,
                primary,
                provisioningState,
                privateIPAddressVersion);
        }

        /// <summary> Initializes a new instance of <see cref="Network.NetworkPrivateEndpointConnectionData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="privateEndpoint"> The resource of private end point. </param>
        /// <param name="connectionState"> A collection of information about the state of the connection between service consumer and provider. </param>
        /// <param name="provisioningState"> The provisioning state of the private endpoint connection resource. </param>
        /// <param name="linkIdentifier"> The consumer link id. </param>
        /// <param name="privateEndpointLocation"> The location of the private endpoint. </param>
        /// <returns> A new <see cref="Network.NetworkPrivateEndpointConnectionData"/> instance for mocking. </returns>
        public static NetworkPrivateEndpointConnectionData NetworkPrivateEndpointConnectionData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, PrivateEndpointData privateEndpoint = null, NetworkPrivateLinkServiceConnectionState connectionState = null, NetworkProvisioningState? provisioningState = null, string linkIdentifier = null, string privateEndpointLocation = null)
        {
            return new NetworkPrivateEndpointConnectionData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                privateEndpoint,
                connectionState,
                provisioningState,
                linkIdentifier,
                privateEndpointLocation);
        }

        /// <summary> Initializes a new instance of <see cref="Network.FlowLogData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="identity"> FlowLog resource Managed Identity. </param>
        /// <param name="targetResourceId"> ID of network security group to which flow log will be applied. </param>
        /// <param name="targetResourceGuid"> Guid of network security group to which flow log will be applied. </param>
        /// <param name="storageId"> ID of the storage account which is used to store the flow log. </param>
        /// <param name="enabledFilteringCriteria"> Optional field to filter network traffic logs based on SrcIP, SrcPort, DstIP, DstPort, Protocol, Encryption, Direction and Action. If not specified, all network traffic will be logged. </param>
        /// <param name="enabled"> Flag to enable/disable flow logging. </param>
        /// <param name="retentionPolicy"> Parameters that define the retention policy for flow log. </param>
        /// <param name="format"> Parameters that define the flow log format. </param>
        /// <param name="trafficAnalyticsConfiguration"> Parameters that define the configuration of traffic analytics. </param>
        /// <param name="provisioningState"> The provisioning state of the flow log. </param>
        /// <returns> A new <see cref="Network.FlowLogData"/> instance for mocking. </returns>
        public static FlowLogData FlowLogData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, ManagedServiceIdentity identity = null, ResourceIdentifier targetResourceId = null, Guid? targetResourceGuid = null, ResourceIdentifier storageId = null, string enabledFilteringCriteria = null, bool? enabled = null, RetentionPolicyParameters retentionPolicy = null, FlowLogProperties format = null, TrafficAnalyticsConfigurationProperties trafficAnalyticsConfiguration = null, NetworkProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();

            return new FlowLogData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                identity,
                targetResourceId,
                targetResourceGuid,
                storageId,
                enabledFilteringCriteria,
                enabled,
                retentionPolicy,
                format,
                trafficAnalyticsConfiguration != null ? new TrafficAnalyticsProperties(trafficAnalyticsConfiguration, serializedAdditionalRawData: null) : null,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Network.RouteTableData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="routes"> Collection of routes contained within a route table. </param>
        /// <param name="subnets"> A collection of references to subnets. </param>
        /// <param name="disableBgpRoutePropagation"> Whether to disable the routes learned by BGP on that route table. True means disable. </param>
        /// <param name="provisioningState"> The provisioning state of the route table resource. </param>
        /// <param name="resourceGuid"> The resource GUID property of the route table. </param>
        /// <returns> A new <see cref="Network.RouteTableData"/> instance for mocking. </returns>
        public static RouteTableData RouteTableData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, IEnumerable<RouteData> routes = null, IEnumerable<SubnetData> subnets = null, bool? disableBgpRoutePropagation = null, NetworkProvisioningState? provisioningState = null, Guid? resourceGuid = null)
        {
            tags ??= new Dictionary<string, string>();
            routes ??= new List<RouteData>();
            subnets ??= new List<SubnetData>();

            return new RouteTableData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                routes?.ToList(),
                subnets?.ToList(),
                disableBgpRoutePropagation,
                provisioningState,
                resourceGuid);
        }

        /// <summary> Initializes a new instance of <see cref="Network.RouteData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="addressPrefix"> The destination CIDR to which the route applies. </param>
        /// <param name="nextHopType"> The type of Azure hop the packet should be sent to. </param>
        /// <param name="nextHopIPAddress"> The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance. </param>
        /// <param name="provisioningState"> The provisioning state of the route resource. </param>
        /// <param name="hasBgpOverride"> A value indicating whether this route overrides overlapping BGP routes regardless of LPM. </param>
        /// <returns> A new <see cref="Network.RouteData"/> instance for mocking. </returns>
        public static RouteData RouteData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, string addressPrefix = null, RouteNextHopType? nextHopType = null, string nextHopIPAddress = null, NetworkProvisioningState? provisioningState = null, bool? hasBgpOverride = null)
        {
            return new RouteData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                addressPrefix,
                nextHopType,
                nextHopIPAddress,
                provisioningState,
                hasBgpOverride);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServiceEndpointProperties"/>. </summary>
        /// <param name="service"> The type of the endpoint service. </param>
        /// <param name="networkIdentifierId"> SubResource as network identifier. </param>
        /// <param name="locations"> A list of locations. </param>
        /// <param name="provisioningState"> The provisioning state of the service endpoint resource. </param>
        /// <returns> A new <see cref="Models.ServiceEndpointProperties"/> instance for mocking. </returns>
        public static ServiceEndpointProperties ServiceEndpointProperties(string service = null, ResourceIdentifier networkIdentifierId = null, IEnumerable<AzureLocation> locations = null, NetworkProvisioningState? provisioningState = null)
        {
            locations ??= new List<AzureLocation>();

            return new ServiceEndpointProperties(service, networkIdentifierId != null ? ResourceManagerModelFactory.WritableSubResource(networkIdentifierId) : null, locations?.ToList(), provisioningState, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.ServiceEndpointPolicyData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="kind"> Kind of service endpoint policy. This is metadata used for the Azure portal experience. </param>
        /// <param name="serviceEndpointPolicyDefinitions"> A collection of service endpoint policy definitions of the service endpoint policy. </param>
        /// <param name="subnets"> A collection of references to subnets. </param>
        /// <param name="resourceGuid"> The resource GUID property of the service endpoint policy resource. </param>
        /// <param name="provisioningState"> The provisioning state of the service endpoint policy resource. </param>
        /// <param name="serviceAlias"> The alias indicating if the policy belongs to a service. </param>
        /// <param name="contextualServiceEndpointPolicies"> A collection of contextual service endpoint policy. </param>
        /// <returns> A new <see cref="Network.ServiceEndpointPolicyData"/> instance for mocking. </returns>
        public static ServiceEndpointPolicyData ServiceEndpointPolicyData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, string kind = null, IEnumerable<ServiceEndpointPolicyDefinitionData> serviceEndpointPolicyDefinitions = null, IEnumerable<SubnetData> subnets = null, Guid? resourceGuid = null, NetworkProvisioningState? provisioningState = null, string serviceAlias = null, IEnumerable<string> contextualServiceEndpointPolicies = null)
        {
            tags ??= new Dictionary<string, string>();
            serviceEndpointPolicyDefinitions ??= new List<ServiceEndpointPolicyDefinitionData>();
            subnets ??= new List<SubnetData>();
            contextualServiceEndpointPolicies ??= new List<string>();

            return new ServiceEndpointPolicyData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                kind,
                serviceEndpointPolicyDefinitions?.ToList(),
                subnets?.ToList(),
                resourceGuid,
                provisioningState,
                serviceAlias,
                contextualServiceEndpointPolicies?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Network.ServiceEndpointPolicyDefinitionData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="description"> A description for this rule. Restricted to 140 chars. </param>
        /// <param name="service"> Service endpoint name. </param>
        /// <param name="serviceResources"> A list of service resources. </param>
        /// <param name="provisioningState"> The provisioning state of the service endpoint policy definition resource. </param>
        /// <returns> A new <see cref="Network.ServiceEndpointPolicyDefinitionData"/> instance for mocking. </returns>
        public static ServiceEndpointPolicyDefinitionData ServiceEndpointPolicyDefinitionData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, string description = null, string service = null, IEnumerable<ResourceIdentifier> serviceResources = null, NetworkProvisioningState? provisioningState = null)
        {
            serviceResources ??= new List<ResourceIdentifier>();

            return new ServiceEndpointPolicyDefinitionData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                description,
                service,
                serviceResources?.ToList(),
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkIPConfiguration"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="privateIPAddress"> The private IP address of the IP configuration. </param>
        /// <param name="privateIPAllocationMethod"> The private IP address allocation method. </param>
        /// <param name="subnet"> The reference to the subnet resource. </param>
        /// <param name="publicIPAddress"> The reference to the public IP resource. </param>
        /// <param name="provisioningState"> The provisioning state of the IP configuration resource. </param>
        /// <returns> A new <see cref="Models.NetworkIPConfiguration"/> instance for mocking. </returns>
        public static NetworkIPConfiguration NetworkIPConfiguration(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, string privateIPAddress = null, NetworkIPAllocationMethod? privateIPAllocationMethod = null, SubnetData subnet = null, PublicIPAddressData publicIPAddress = null, NetworkProvisioningState? provisioningState = null)
        {
            return new NetworkIPConfiguration(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                privateIPAddress,
                privateIPAllocationMethod,
                subnet,
                publicIPAddress,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Network.PublicIPAddressData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="extendedLocation"> The extended location of the public ip address. </param>
        /// <param name="sku"> The public IP address SKU. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="zones"> A list of availability zones denoting the IP allocated for the resource needs to come from. </param>
        /// <param name="publicIPAllocationMethod"> The public IP address allocation method. </param>
        /// <param name="publicIPAddressVersion"> The public IP address version. </param>
        /// <param name="ipConfiguration"> The IP configuration associated with the public IP address. </param>
        /// <param name="dnsSettings"> The FQDN of the DNS record associated with the public IP address. </param>
        /// <param name="ddosSettings"> The DDoS protection custom policy associated with the public IP address. </param>
        /// <param name="ipTags"> The list of tags associated with the public IP address. </param>
        /// <param name="ipAddress"> The IP address associated with the public IP address resource. </param>
        /// <param name="publicIPPrefixId"> The Public IP Prefix this Public IP Address should be allocated from. </param>
        /// <param name="idleTimeoutInMinutes"> The idle timeout of the public IP address. </param>
        /// <param name="resourceGuid"> The resource GUID property of the public IP address resource. </param>
        /// <param name="provisioningState"> The provisioning state of the public IP address resource. </param>
        /// <param name="servicePublicIPAddress"> The service public IP address of the public IP address resource. </param>
        /// <param name="natGateway"> The NatGateway for the Public IP address. </param>
        /// <param name="migrationPhase"> Migration phase of Public IP Address. </param>
        /// <param name="linkedPublicIPAddress"> The linked public IP address of the public IP address resource. </param>
        /// <param name="deleteOption"> Specify what happens to the public IP address when the VM using it is deleted. </param>
        /// <returns> A new <see cref="Network.PublicIPAddressData"/> instance for mocking. </returns>
        public static PublicIPAddressData PublicIPAddressData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ExtendedLocation extendedLocation = null, PublicIPAddressSku sku = null, ETag? etag = null, IEnumerable<string> zones = null, NetworkIPAllocationMethod? publicIPAllocationMethod = null, NetworkIPVersion? publicIPAddressVersion = null, NetworkIPConfiguration ipConfiguration = null, PublicIPAddressDnsSettings dnsSettings = null, DdosSettings ddosSettings = null, IEnumerable<IPTag> ipTags = null, string ipAddress = null, ResourceIdentifier publicIPPrefixId = null, int? idleTimeoutInMinutes = null, Guid? resourceGuid = null, NetworkProvisioningState? provisioningState = null, PublicIPAddressData servicePublicIPAddress = null, NatGatewayData natGateway = null, PublicIPAddressMigrationPhase? migrationPhase = null, PublicIPAddressData linkedPublicIPAddress = null, IPAddressDeleteOption? deleteOption = null)
        {
            tags ??= new Dictionary<string, string>();
            zones ??= new List<string>();
            ipTags ??= new List<IPTag>();

            return new PublicIPAddressData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                extendedLocation,
                sku,
                etag,
                zones?.ToList(),
                publicIPAllocationMethod,
                publicIPAddressVersion,
                ipConfiguration,
                dnsSettings,
                ddosSettings,
                ipTags?.ToList(),
                ipAddress,
                publicIPPrefixId != null ? ResourceManagerModelFactory.WritableSubResource(publicIPPrefixId) : null,
                idleTimeoutInMinutes,
                resourceGuid,
                provisioningState,
                servicePublicIPAddress,
                natGateway,
                migrationPhase,
                linkedPublicIPAddress,
                deleteOption);
        }

        /// <summary> Initializes a new instance of <see cref="Network.NatGatewayData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="skuName"> The nat gateway SKU. </param>
        /// <param name="zones"> A list of availability zones denoting the zone in which Nat Gateway should be deployed. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="idleTimeoutInMinutes"> The idle timeout of the nat gateway. </param>
        /// <param name="publicIPAddresses"> An array of public ip addresses associated with the nat gateway resource. </param>
        /// <param name="publicIPPrefixes"> An array of public ip prefixes associated with the nat gateway resource. </param>
        /// <param name="subnets"> An array of references to the subnets using this nat gateway resource. </param>
        /// <param name="resourceGuid"> The resource GUID property of the NAT gateway resource. </param>
        /// <param name="provisioningState"> The provisioning state of the NAT gateway resource. </param>
        /// <returns> A new <see cref="Network.NatGatewayData"/> instance for mocking. </returns>
        public static NatGatewayData NatGatewayData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, NatGatewaySkuName? skuName = null, IEnumerable<string> zones = null, ETag? etag = null, int? idleTimeoutInMinutes = null, IEnumerable<WritableSubResource> publicIPAddresses = null, IEnumerable<WritableSubResource> publicIPPrefixes = null, IEnumerable<WritableSubResource> subnets = null, Guid? resourceGuid = null, NetworkProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            zones ??= new List<string>();
            publicIPAddresses ??= new List<WritableSubResource>();
            publicIPPrefixes ??= new List<WritableSubResource>();
            subnets ??= new List<WritableSubResource>();

            return new NatGatewayData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                skuName != null ? new NatGatewaySku(skuName, serializedAdditionalRawData: null) : null,
                zones?.ToList(),
                etag,
                idleTimeoutInMinutes,
                publicIPAddresses?.ToList(),
                publicIPPrefixes?.ToList(),
                subnets?.ToList(),
                resourceGuid,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkIPConfigurationProfile"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="subnet"> The reference to the subnet resource to create a container network interface ip configuration. </param>
        /// <param name="provisioningState"> The provisioning state of the IP configuration profile resource. </param>
        /// <returns> A new <see cref="Models.NetworkIPConfigurationProfile"/> instance for mocking. </returns>
        public static NetworkIPConfigurationProfile NetworkIPConfigurationProfile(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, SubnetData subnet = null, NetworkProvisioningState? provisioningState = null)
        {
            return new NetworkIPConfigurationProfile(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                subnet,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ResourceNavigationLink"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="linkedResourceType"> Resource type of the linked resource. </param>
        /// <param name="link"> Link to the external resource. </param>
        /// <param name="provisioningState"> The provisioning state of the resource navigation link resource. </param>
        /// <returns> A new <see cref="Models.ResourceNavigationLink"/> instance for mocking. </returns>
        public static ResourceNavigationLink ResourceNavigationLink(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, ResourceType? linkedResourceType = null, ResourceIdentifier link = null, NetworkProvisioningState? provisioningState = null)
        {
            return new ResourceNavigationLink(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                linkedResourceType,
                link,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServiceAssociationLink"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="linkedResourceType"> Resource type of the linked resource. </param>
        /// <param name="link"> Link to the external resource. </param>
        /// <param name="provisioningState"> The provisioning state of the service association link resource. </param>
        /// <param name="allowDelete"> If true, the resource can be deleted. </param>
        /// <param name="locations"> A list of locations. </param>
        /// <returns> A new <see cref="Models.ServiceAssociationLink"/> instance for mocking. </returns>
        public static ServiceAssociationLink ServiceAssociationLink(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, ResourceType? linkedResourceType = null, ResourceIdentifier link = null, NetworkProvisioningState? provisioningState = null, bool? allowDelete = null, IEnumerable<AzureLocation> locations = null)
        {
            locations ??= new List<AzureLocation>();

            return new ServiceAssociationLink(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                linkedResourceType,
                link,
                provisioningState,
                allowDelete,
                locations?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServiceDelegation"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="serviceName"> The name of the service to whom the subnet should be delegated (e.g. Microsoft.Sql/servers). </param>
        /// <param name="actions"> The actions permitted to the service upon delegation. </param>
        /// <param name="provisioningState"> The provisioning state of the service delegation resource. </param>
        /// <returns> A new <see cref="Models.ServiceDelegation"/> instance for mocking. </returns>
        public static ServiceDelegation ServiceDelegation(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, string serviceName = null, IEnumerable<string> actions = null, NetworkProvisioningState? provisioningState = null)
        {
            actions ??= new List<string>();

            return new ServiceDelegation(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                serviceName,
                actions?.ToList(),
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Network.BackendAddressPoolData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="location"> The location of the backend address pool. </param>
        /// <param name="tunnelInterfaces"> An array of gateway load balancer tunnel interfaces. </param>
        /// <param name="loadBalancerBackendAddresses"> An array of backend addresses. </param>
        /// <param name="backendIPConfigurations"> An array of references to IP addresses defined in network interfaces. </param>
        /// <param name="loadBalancingRules"> An array of references to load balancing rules that use this backend address pool. </param>
        /// <param name="outboundRuleId"> A reference to an outbound rule that uses this backend address pool. </param>
        /// <param name="outboundRules"> An array of references to outbound rules that use this backend address pool. </param>
        /// <param name="inboundNatRules"> An array of references to inbound NAT rules that use this backend address pool. </param>
        /// <param name="provisioningState"> The provisioning state of the backend address pool resource. </param>
        /// <param name="drainPeriodInSeconds"> Amount of seconds Load Balancer waits for before sending RESET to client and backend address. </param>
        /// <param name="virtualNetworkId"> A reference to a virtual network. </param>
        /// <param name="syncMode"> Backend address synchronous mode for the backend pool. </param>
        /// <returns> A new <see cref="Network.BackendAddressPoolData"/> instance for mocking. </returns>
        public static BackendAddressPoolData BackendAddressPoolData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, AzureLocation? location = null, IEnumerable<GatewayLoadBalancerTunnelInterface> tunnelInterfaces = null, IEnumerable<LoadBalancerBackendAddress> loadBalancerBackendAddresses = null, IEnumerable<NetworkInterfaceIPConfigurationData> backendIPConfigurations = null, IEnumerable<WritableSubResource> loadBalancingRules = null, ResourceIdentifier outboundRuleId = null, IEnumerable<WritableSubResource> outboundRules = null, IEnumerable<WritableSubResource> inboundNatRules = null, NetworkProvisioningState? provisioningState = null, int? drainPeriodInSeconds = null, ResourceIdentifier virtualNetworkId = null, BackendAddressSyncMode? syncMode = null)
        {
            tunnelInterfaces ??= new List<GatewayLoadBalancerTunnelInterface>();
            loadBalancerBackendAddresses ??= new List<LoadBalancerBackendAddress>();
            backendIPConfigurations ??= new List<NetworkInterfaceIPConfigurationData>();
            loadBalancingRules ??= new List<WritableSubResource>();
            outboundRules ??= new List<WritableSubResource>();
            inboundNatRules ??= new List<WritableSubResource>();

            return new BackendAddressPoolData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                location,
                tunnelInterfaces?.ToList(),
                loadBalancerBackendAddresses?.ToList(),
                backendIPConfigurations?.ToList(),
                loadBalancingRules?.ToList(),
                outboundRuleId != null ? ResourceManagerModelFactory.WritableSubResource(outboundRuleId) : null,
                outboundRules?.ToList(),
                inboundNatRules?.ToList(),
                provisioningState,
                drainPeriodInSeconds,
                virtualNetworkId != null ? ResourceManagerModelFactory.WritableSubResource(virtualNetworkId) : null,
                syncMode);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LoadBalancerBackendAddress"/>. </summary>
        /// <param name="name"> Name of the backend address. </param>
        /// <param name="virtualNetworkId"> Reference to an existing virtual network. </param>
        /// <param name="subnetId"> Reference to an existing subnet. </param>
        /// <param name="ipAddress"> IP Address belonging to the referenced virtual network. </param>
        /// <param name="networkInterfaceIPConfigurationId"> Reference to IP address defined in network interfaces. </param>
        /// <param name="loadBalancerFrontendIPConfigurationId"> Reference to the frontend ip address configuration defined in regional loadbalancer. </param>
        /// <param name="inboundNatRulesPortMapping"> Collection of inbound NAT rule port mappings. </param>
        /// <param name="adminState"> A list of administrative states which once set can override health probe so that Load Balancer will always forward new connections to backend, or deny new connections and reset existing connections. </param>
        /// <returns> A new <see cref="Models.LoadBalancerBackendAddress"/> instance for mocking. </returns>
        public static LoadBalancerBackendAddress LoadBalancerBackendAddress(string name = null, ResourceIdentifier virtualNetworkId = null, ResourceIdentifier subnetId = null, string ipAddress = null, ResourceIdentifier networkInterfaceIPConfigurationId = null, ResourceIdentifier loadBalancerFrontendIPConfigurationId = null, IEnumerable<NatRulePortMapping> inboundNatRulesPortMapping = null, LoadBalancerBackendAddressAdminState? adminState = null)
        {
            inboundNatRulesPortMapping ??= new List<NatRulePortMapping>();

            return new LoadBalancerBackendAddress(
                name,
                virtualNetworkId != null ? ResourceManagerModelFactory.WritableSubResource(virtualNetworkId) : null,
                subnetId != null ? ResourceManagerModelFactory.WritableSubResource(subnetId) : null,
                ipAddress,
                networkInterfaceIPConfigurationId != null ? ResourceManagerModelFactory.WritableSubResource(networkInterfaceIPConfigurationId) : null,
                loadBalancerFrontendIPConfigurationId != null ? ResourceManagerModelFactory.WritableSubResource(loadBalancerFrontendIPConfigurationId) : null,
                inboundNatRulesPortMapping?.ToList(),
                adminState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NatRulePortMapping"/>. </summary>
        /// <param name="inboundNatRuleName"> Name of inbound NAT rule. </param>
        /// <param name="frontendPort"> Frontend port. </param>
        /// <param name="backendPort"> Backend port. </param>
        /// <returns> A new <see cref="Models.NatRulePortMapping"/> instance for mocking. </returns>
        public static NatRulePortMapping NatRulePortMapping(string inboundNatRuleName = null, int? frontendPort = null, int? backendPort = null)
        {
            return new NatRulePortMapping(inboundNatRuleName, frontendPort, backendPort, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.InboundNatRuleData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="frontendIPConfigurationId"> A reference to frontend IP addresses. </param>
        /// <param name="backendIPConfiguration"> A reference to a private IP address defined on a network interface of a VM. Traffic sent to the frontend port of each of the frontend IP configurations is forwarded to the backend IP. </param>
        /// <param name="protocol"> The reference to the transport protocol used by the load balancing rule. </param>
        /// <param name="frontendPort"> The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values range from 1 to 65534. </param>
        /// <param name="backendPort"> The port used for the internal endpoint. Acceptable values range from 1 to 65535. </param>
        /// <param name="idleTimeoutInMinutes"> The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP. </param>
        /// <param name="enableFloatingIP"> Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint. </param>
        /// <param name="enableTcpReset"> Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP. </param>
        /// <param name="frontendPortRangeStart"> The port range start for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeEnd. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534. </param>
        /// <param name="frontendPortRangeEnd"> The port range end for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeStart. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534. </param>
        /// <param name="backendAddressPoolId"> A reference to backendAddressPool resource. </param>
        /// <param name="provisioningState"> The provisioning state of the inbound NAT rule resource. </param>
        /// <returns> A new <see cref="Network.InboundNatRuleData"/> instance for mocking. </returns>
        public static InboundNatRuleData InboundNatRuleData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, ResourceIdentifier frontendIPConfigurationId = null, NetworkInterfaceIPConfigurationData backendIPConfiguration = null, LoadBalancingTransportProtocol? protocol = null, int? frontendPort = null, int? backendPort = null, int? idleTimeoutInMinutes = null, bool? enableFloatingIP = null, bool? enableTcpReset = null, int? frontendPortRangeStart = null, int? frontendPortRangeEnd = null, ResourceIdentifier backendAddressPoolId = null, NetworkProvisioningState? provisioningState = null)
        {
            return new InboundNatRuleData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                frontendIPConfigurationId != null ? ResourceManagerModelFactory.WritableSubResource(frontendIPConfigurationId) : null,
                backendIPConfiguration,
                protocol,
                frontendPort,
                backendPort,
                idleTimeoutInMinutes,
                enableFloatingIP,
                enableTcpReset,
                frontendPortRangeStart,
                frontendPortRangeEnd,
                backendAddressPoolId != null ? ResourceManagerModelFactory.WritableSubResource(backendAddressPoolId) : null,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkInterfaceIPConfigurationPrivateLinkConnectionProperties"/>. </summary>
        /// <param name="groupId"> The group ID for current private link connection. </param>
        /// <param name="requiredMemberName"> The required member name for current private link connection. </param>
        /// <param name="fqdns"> List of FQDNs for current private link connection. </param>
        /// <returns> A new <see cref="Models.NetworkInterfaceIPConfigurationPrivateLinkConnectionProperties"/> instance for mocking. </returns>
        public static NetworkInterfaceIPConfigurationPrivateLinkConnectionProperties NetworkInterfaceIPConfigurationPrivateLinkConnectionProperties(string groupId = null, string requiredMemberName = null, IEnumerable<string> fqdns = null)
        {
            fqdns ??= new List<string>();

            return new NetworkInterfaceIPConfigurationPrivateLinkConnectionProperties(groupId, requiredMemberName, fqdns?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewayBackendHttpSettings"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="port"> The destination port on the backend. </param>
        /// <param name="protocol"> The protocol used to communicate with the backend. </param>
        /// <param name="cookieBasedAffinity"> Cookie based affinity. </param>
        /// <param name="requestTimeoutInSeconds"> Request timeout in seconds. Application Gateway will fail the request if response is not received within RequestTimeout. Acceptable values are from 1 second to 86400 seconds. </param>
        /// <param name="probeId"> Probe resource of an application gateway. </param>
        /// <param name="authenticationCertificates"> Array of references to application gateway authentication certificates. </param>
        /// <param name="trustedRootCertificates"> Array of references to application gateway trusted root certificates. </param>
        /// <param name="connectionDraining"> Connection draining of the backend http settings resource. </param>
        /// <param name="hostName"> Host header to be sent to the backend servers. </param>
        /// <param name="pickHostNameFromBackendAddress"> Whether to pick host header should be picked from the host name of the backend server. Default value is false. </param>
        /// <param name="affinityCookieName"> Cookie name to use for the affinity cookie. </param>
        /// <param name="probeEnabled"> Whether the probe is enabled. Default value is false. </param>
        /// <param name="path"> Path which should be used as a prefix for all HTTP requests. Null means no path will be prefixed. Default value is null. </param>
        /// <param name="provisioningState"> The provisioning state of the backend HTTP settings resource. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewayBackendHttpSettings"/> instance for mocking. </returns>
        public static ApplicationGatewayBackendHttpSettings ApplicationGatewayBackendHttpSettings(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, int? port = null, ApplicationGatewayProtocol? protocol = null, ApplicationGatewayCookieBasedAffinity? cookieBasedAffinity = null, int? requestTimeoutInSeconds = null, ResourceIdentifier probeId = null, IEnumerable<WritableSubResource> authenticationCertificates = null, IEnumerable<WritableSubResource> trustedRootCertificates = null, ApplicationGatewayConnectionDraining connectionDraining = null, string hostName = null, bool? pickHostNameFromBackendAddress = null, string affinityCookieName = null, bool? probeEnabled = null, string path = null, NetworkProvisioningState? provisioningState = null)
        {
            authenticationCertificates ??= new List<WritableSubResource>();
            trustedRootCertificates ??= new List<WritableSubResource>();

            return new ApplicationGatewayBackendHttpSettings(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                port,
                protocol,
                cookieBasedAffinity,
                requestTimeoutInSeconds,
                probeId != null ? ResourceManagerModelFactory.WritableSubResource(probeId) : null,
                authenticationCertificates?.ToList(),
                trustedRootCertificates?.ToList(),
                connectionDraining,
                hostName,
                pickHostNameFromBackendAddress,
                affinityCookieName,
                probeEnabled,
                path,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewayBackendSettings"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="port"> The destination port on the backend. </param>
        /// <param name="protocol"> The protocol used to communicate with the backend. </param>
        /// <param name="timeoutInSeconds"> Connection timeout in seconds. Application Gateway will fail the request if response is not received within ConnectionTimeout. Acceptable values are from 1 second to 86400 seconds. </param>
        /// <param name="probeId"> Probe resource of an application gateway. </param>
        /// <param name="trustedRootCertificates"> Array of references to application gateway trusted root certificates. </param>
        /// <param name="hostName"> Server name indication to be sent to the backend servers for Tls protocol. </param>
        /// <param name="pickHostNameFromBackendAddress"> Whether to pick server name indication from the host name of the backend server for Tls protocol. Default value is false. </param>
        /// <param name="provisioningState"> The provisioning state of the backend HTTP settings resource. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewayBackendSettings"/> instance for mocking. </returns>
        public static ApplicationGatewayBackendSettings ApplicationGatewayBackendSettings(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, int? port = null, ApplicationGatewayProtocol? protocol = null, int? timeoutInSeconds = null, ResourceIdentifier probeId = null, IEnumerable<WritableSubResource> trustedRootCertificates = null, string hostName = null, bool? pickHostNameFromBackendAddress = null, NetworkProvisioningState? provisioningState = null)
        {
            trustedRootCertificates ??= new List<WritableSubResource>();

            return new ApplicationGatewayBackendSettings(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                port,
                protocol,
                timeoutInSeconds,
                probeId != null ? ResourceManagerModelFactory.WritableSubResource(probeId) : null,
                trustedRootCertificates?.ToList(),
                hostName,
                pickHostNameFromBackendAddress,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewayHttpListener"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="frontendIPConfigurationId"> Frontend IP configuration resource of an application gateway. </param>
        /// <param name="frontendPortId"> Frontend port resource of an application gateway. </param>
        /// <param name="protocol"> Protocol of the HTTP listener. </param>
        /// <param name="hostName"> Host name of HTTP listener. </param>
        /// <param name="sslCertificateId"> SSL certificate resource of an application gateway. </param>
        /// <param name="sslProfileId"> SSL profile resource of the application gateway. </param>
        /// <param name="requireServerNameIndication"> Applicable only if protocol is https. Enables SNI for multi-hosting. </param>
        /// <param name="provisioningState"> The provisioning state of the HTTP listener resource. </param>
        /// <param name="customErrorConfigurations"> Custom error configurations of the HTTP listener. </param>
        /// <param name="firewallPolicyId"> Reference to the FirewallPolicy resource. </param>
        /// <param name="hostNames"> List of Host names for HTTP Listener that allows special wildcard characters as well. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewayHttpListener"/> instance for mocking. </returns>
        public static ApplicationGatewayHttpListener ApplicationGatewayHttpListener(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, ResourceIdentifier frontendIPConfigurationId = null, ResourceIdentifier frontendPortId = null, ApplicationGatewayProtocol? protocol = null, string hostName = null, ResourceIdentifier sslCertificateId = null, ResourceIdentifier sslProfileId = null, bool? requireServerNameIndication = null, NetworkProvisioningState? provisioningState = null, IEnumerable<ApplicationGatewayCustomError> customErrorConfigurations = null, ResourceIdentifier firewallPolicyId = null, IEnumerable<string> hostNames = null)
        {
            customErrorConfigurations ??= new List<ApplicationGatewayCustomError>();
            hostNames ??= new List<string>();

            return new ApplicationGatewayHttpListener(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                frontendIPConfigurationId != null ? ResourceManagerModelFactory.WritableSubResource(frontendIPConfigurationId) : null,
                frontendPortId != null ? ResourceManagerModelFactory.WritableSubResource(frontendPortId) : null,
                protocol,
                hostName,
                sslCertificateId != null ? ResourceManagerModelFactory.WritableSubResource(sslCertificateId) : null,
                sslProfileId != null ? ResourceManagerModelFactory.WritableSubResource(sslProfileId) : null,
                requireServerNameIndication,
                provisioningState,
                customErrorConfigurations?.ToList(),
                firewallPolicyId != null ? ResourceManagerModelFactory.WritableSubResource(firewallPolicyId) : null,
                hostNames?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewayListener"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="frontendIPConfigurationId"> Frontend IP configuration resource of an application gateway. </param>
        /// <param name="frontendPortId"> Frontend port resource of an application gateway. </param>
        /// <param name="protocol"> Protocol of the listener. </param>
        /// <param name="sslCertificateId"> SSL certificate resource of an application gateway. </param>
        /// <param name="sslProfileId"> SSL profile resource of the application gateway. </param>
        /// <param name="provisioningState"> The provisioning state of the listener resource. </param>
        /// <param name="hostNames"> List of Server Name Indications(SNI) for TLS Multi-site Listener that allows special wildcard characters as well. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewayListener"/> instance for mocking. </returns>
        public static ApplicationGatewayListener ApplicationGatewayListener(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, ResourceIdentifier frontendIPConfigurationId = null, ResourceIdentifier frontendPortId = null, ApplicationGatewayProtocol? protocol = null, ResourceIdentifier sslCertificateId = null, ResourceIdentifier sslProfileId = null, NetworkProvisioningState? provisioningState = null, IEnumerable<string> hostNames = null)
        {
            hostNames ??= new List<string>();

            return new ApplicationGatewayListener(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                frontendIPConfigurationId != null ? ResourceManagerModelFactory.WritableSubResource(frontendIPConfigurationId) : null,
                frontendPortId != null ? ResourceManagerModelFactory.WritableSubResource(frontendPortId) : null,
                protocol,
                sslCertificateId != null ? ResourceManagerModelFactory.WritableSubResource(sslCertificateId) : null,
                sslProfileId != null ? ResourceManagerModelFactory.WritableSubResource(sslProfileId) : null,
                provisioningState,
                hostNames?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewaySslProfile"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="trustedClientCertificates"> Array of references to application gateway trusted client certificates. </param>
        /// <param name="sslPolicy"> SSL policy of the application gateway resource. </param>
        /// <param name="clientAuthConfiguration"> Client authentication configuration of the application gateway resource. </param>
        /// <param name="provisioningState"> The provisioning state of the HTTP listener resource. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewaySslProfile"/> instance for mocking. </returns>
        public static ApplicationGatewaySslProfile ApplicationGatewaySslProfile(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, IEnumerable<WritableSubResource> trustedClientCertificates = null, ApplicationGatewaySslPolicy sslPolicy = null, ApplicationGatewayClientAuthConfiguration clientAuthConfiguration = null, NetworkProvisioningState? provisioningState = null)
        {
            trustedClientCertificates ??= new List<WritableSubResource>();

            return new ApplicationGatewaySslProfile(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                trustedClientCertificates?.ToList(),
                sslPolicy,
                clientAuthConfiguration,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewayUrlPathMap"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="defaultBackendAddressPoolId"> Default backend address pool resource of URL path map. </param>
        /// <param name="defaultBackendHttpSettingsId"> Default backend http settings resource of URL path map. </param>
        /// <param name="defaultRewriteRuleSetId"> Default Rewrite rule set resource of URL path map. </param>
        /// <param name="defaultRedirectConfigurationId"> Default redirect configuration resource of URL path map. </param>
        /// <param name="defaultLoadDistributionPolicyId"> Default Load Distribution Policy resource of URL path map. </param>
        /// <param name="pathRules"> Path rule of URL path map resource. </param>
        /// <param name="provisioningState"> The provisioning state of the URL path map resource. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewayUrlPathMap"/> instance for mocking. </returns>
        public static ApplicationGatewayUrlPathMap ApplicationGatewayUrlPathMap(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, ResourceIdentifier defaultBackendAddressPoolId = null, ResourceIdentifier defaultBackendHttpSettingsId = null, ResourceIdentifier defaultRewriteRuleSetId = null, ResourceIdentifier defaultRedirectConfigurationId = null, ResourceIdentifier defaultLoadDistributionPolicyId = null, IEnumerable<ApplicationGatewayPathRule> pathRules = null, NetworkProvisioningState? provisioningState = null)
        {
            pathRules ??= new List<ApplicationGatewayPathRule>();

            return new ApplicationGatewayUrlPathMap(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                defaultBackendAddressPoolId != null ? ResourceManagerModelFactory.WritableSubResource(defaultBackendAddressPoolId) : null,
                defaultBackendHttpSettingsId != null ? ResourceManagerModelFactory.WritableSubResource(defaultBackendHttpSettingsId) : null,
                defaultRewriteRuleSetId != null ? ResourceManagerModelFactory.WritableSubResource(defaultRewriteRuleSetId) : null,
                defaultRedirectConfigurationId != null ? ResourceManagerModelFactory.WritableSubResource(defaultRedirectConfigurationId) : null,
                defaultLoadDistributionPolicyId != null ? ResourceManagerModelFactory.WritableSubResource(defaultLoadDistributionPolicyId) : null,
                pathRules?.ToList(),
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewayPathRule"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="paths"> Path rules of URL path map. </param>
        /// <param name="backendAddressPoolId"> Backend address pool resource of URL path map path rule. </param>
        /// <param name="backendHttpSettingsId"> Backend http settings resource of URL path map path rule. </param>
        /// <param name="redirectConfigurationId"> Redirect configuration resource of URL path map path rule. </param>
        /// <param name="rewriteRuleSetId"> Rewrite rule set resource of URL path map path rule. </param>
        /// <param name="loadDistributionPolicyId"> Load Distribution Policy resource of URL path map path rule. </param>
        /// <param name="provisioningState"> The provisioning state of the path rule resource. </param>
        /// <param name="firewallPolicyId"> Reference to the FirewallPolicy resource. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewayPathRule"/> instance for mocking. </returns>
        public static ApplicationGatewayPathRule ApplicationGatewayPathRule(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, IEnumerable<string> paths = null, ResourceIdentifier backendAddressPoolId = null, ResourceIdentifier backendHttpSettingsId = null, ResourceIdentifier redirectConfigurationId = null, ResourceIdentifier rewriteRuleSetId = null, ResourceIdentifier loadDistributionPolicyId = null, NetworkProvisioningState? provisioningState = null, ResourceIdentifier firewallPolicyId = null)
        {
            paths ??= new List<string>();

            return new ApplicationGatewayPathRule(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                paths?.ToList(),
                backendAddressPoolId != null ? ResourceManagerModelFactory.WritableSubResource(backendAddressPoolId) : null,
                backendHttpSettingsId != null ? ResourceManagerModelFactory.WritableSubResource(backendHttpSettingsId) : null,
                redirectConfigurationId != null ? ResourceManagerModelFactory.WritableSubResource(redirectConfigurationId) : null,
                rewriteRuleSetId != null ? ResourceManagerModelFactory.WritableSubResource(rewriteRuleSetId) : null,
                loadDistributionPolicyId != null ? ResourceManagerModelFactory.WritableSubResource(loadDistributionPolicyId) : null,
                provisioningState,
                firewallPolicyId != null ? ResourceManagerModelFactory.WritableSubResource(firewallPolicyId) : null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewayRequestRoutingRule"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="ruleType"> Rule type. </param>
        /// <param name="priority"> Priority of the request routing rule. </param>
        /// <param name="backendAddressPoolId"> Backend address pool resource of the application gateway. </param>
        /// <param name="backendHttpSettingsId"> Backend http settings resource of the application gateway. </param>
        /// <param name="httpListenerId"> Http listener resource of the application gateway. </param>
        /// <param name="urlPathMapId"> URL path map resource of the application gateway. </param>
        /// <param name="rewriteRuleSetId"> Rewrite Rule Set resource in Basic rule of the application gateway. </param>
        /// <param name="redirectConfigurationId"> Redirect configuration resource of the application gateway. </param>
        /// <param name="loadDistributionPolicyId"> Load Distribution Policy resource of the application gateway. </param>
        /// <param name="provisioningState"> The provisioning state of the request routing rule resource. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewayRequestRoutingRule"/> instance for mocking. </returns>
        public static ApplicationGatewayRequestRoutingRule ApplicationGatewayRequestRoutingRule(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, ApplicationGatewayRequestRoutingRuleType? ruleType = null, int? priority = null, ResourceIdentifier backendAddressPoolId = null, ResourceIdentifier backendHttpSettingsId = null, ResourceIdentifier httpListenerId = null, ResourceIdentifier urlPathMapId = null, ResourceIdentifier rewriteRuleSetId = null, ResourceIdentifier redirectConfigurationId = null, ResourceIdentifier loadDistributionPolicyId = null, NetworkProvisioningState? provisioningState = null)
        {
            return new ApplicationGatewayRequestRoutingRule(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                ruleType,
                priority,
                backendAddressPoolId != null ? ResourceManagerModelFactory.WritableSubResource(backendAddressPoolId) : null,
                backendHttpSettingsId != null ? ResourceManagerModelFactory.WritableSubResource(backendHttpSettingsId) : null,
                httpListenerId != null ? ResourceManagerModelFactory.WritableSubResource(httpListenerId) : null,
                urlPathMapId != null ? ResourceManagerModelFactory.WritableSubResource(urlPathMapId) : null,
                rewriteRuleSetId != null ? ResourceManagerModelFactory.WritableSubResource(rewriteRuleSetId) : null,
                redirectConfigurationId != null ? ResourceManagerModelFactory.WritableSubResource(redirectConfigurationId) : null,
                loadDistributionPolicyId != null ? ResourceManagerModelFactory.WritableSubResource(loadDistributionPolicyId) : null,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewayRoutingRule"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="ruleType"> Rule type. </param>
        /// <param name="priority"> Priority of the routing rule. </param>
        /// <param name="backendAddressPoolId"> Backend address pool resource of the application gateway. </param>
        /// <param name="backendSettingsId"> Backend settings resource of the application gateway. </param>
        /// <param name="listenerId"> Listener resource of the application gateway. </param>
        /// <param name="provisioningState"> The provisioning state of the request routing rule resource. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewayRoutingRule"/> instance for mocking. </returns>
        public static ApplicationGatewayRoutingRule ApplicationGatewayRoutingRule(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, ApplicationGatewayRequestRoutingRuleType? ruleType = null, int? priority = null, ResourceIdentifier backendAddressPoolId = null, ResourceIdentifier backendSettingsId = null, ResourceIdentifier listenerId = null, NetworkProvisioningState? provisioningState = null)
        {
            return new ApplicationGatewayRoutingRule(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                ruleType,
                priority,
                backendAddressPoolId != null ? ResourceManagerModelFactory.WritableSubResource(backendAddressPoolId) : null,
                backendSettingsId != null ? ResourceManagerModelFactory.WritableSubResource(backendSettingsId) : null,
                listenerId != null ? ResourceManagerModelFactory.WritableSubResource(listenerId) : null,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewayRewriteRuleSet"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="rewriteRules"> Rewrite rules in the rewrite rule set. </param>
        /// <param name="provisioningState"> The provisioning state of the rewrite rule set resource. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewayRewriteRuleSet"/> instance for mocking. </returns>
        public static ApplicationGatewayRewriteRuleSet ApplicationGatewayRewriteRuleSet(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, IEnumerable<ApplicationGatewayRewriteRule> rewriteRules = null, NetworkProvisioningState? provisioningState = null)
        {
            rewriteRules ??= new List<ApplicationGatewayRewriteRule>();

            return new ApplicationGatewayRewriteRuleSet(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                rewriteRules?.ToList(),
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewayRedirectConfiguration"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="redirectType"> HTTP redirection type. </param>
        /// <param name="targetListenerId"> Reference to a listener to redirect the request to. </param>
        /// <param name="targetUri"> Url to redirect the request to. </param>
        /// <param name="includePath"> Include path in the redirected url. </param>
        /// <param name="includeQueryString"> Include query string in the redirected url. </param>
        /// <param name="requestRoutingRules"> Request routing specifying redirect configuration. </param>
        /// <param name="urlPathMaps"> Url path maps specifying default redirect configuration. </param>
        /// <param name="pathRules"> Path rules specifying redirect configuration. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewayRedirectConfiguration"/> instance for mocking. </returns>
        public static ApplicationGatewayRedirectConfiguration ApplicationGatewayRedirectConfiguration(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, ApplicationGatewayRedirectType? redirectType = null, ResourceIdentifier targetListenerId = null, Uri targetUri = null, bool? includePath = null, bool? includeQueryString = null, IEnumerable<WritableSubResource> requestRoutingRules = null, IEnumerable<WritableSubResource> urlPathMaps = null, IEnumerable<WritableSubResource> pathRules = null)
        {
            requestRoutingRules ??= new List<WritableSubResource>();
            urlPathMaps ??= new List<WritableSubResource>();
            pathRules ??= new List<WritableSubResource>();

            return new ApplicationGatewayRedirectConfiguration(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                redirectType,
                targetListenerId != null ? ResourceManagerModelFactory.WritableSubResource(targetListenerId) : null,
                targetUri,
                includePath,
                includeQueryString,
                requestRoutingRules?.ToList(),
                urlPathMaps?.ToList(),
                pathRules?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewayPrivateLinkConfiguration"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="ipConfigurations"> An array of application gateway private link ip configurations. </param>
        /// <param name="provisioningState"> The provisioning state of the application gateway private link configuration. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewayPrivateLinkConfiguration"/> instance for mocking. </returns>
        public static ApplicationGatewayPrivateLinkConfiguration ApplicationGatewayPrivateLinkConfiguration(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, IEnumerable<ApplicationGatewayPrivateLinkIPConfiguration> ipConfigurations = null, NetworkProvisioningState? provisioningState = null)
        {
            ipConfigurations ??= new List<ApplicationGatewayPrivateLinkIPConfiguration>();

            return new ApplicationGatewayPrivateLinkConfiguration(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                ipConfigurations?.ToList(),
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewayPrivateLinkIPConfiguration"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="privateIPAddress"> The private IP address of the IP configuration. </param>
        /// <param name="privateIPAllocationMethod"> The private IP address allocation method. </param>
        /// <param name="subnetId"> Reference to the subnet resource. </param>
        /// <param name="isPrimary"> Whether the ip configuration is primary or not. </param>
        /// <param name="provisioningState"> The provisioning state of the application gateway private link IP configuration. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewayPrivateLinkIPConfiguration"/> instance for mocking. </returns>
        public static ApplicationGatewayPrivateLinkIPConfiguration ApplicationGatewayPrivateLinkIPConfiguration(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, string privateIPAddress = null, NetworkIPAllocationMethod? privateIPAllocationMethod = null, ResourceIdentifier subnetId = null, bool? isPrimary = null, NetworkProvisioningState? provisioningState = null)
        {
            return new ApplicationGatewayPrivateLinkIPConfiguration(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                privateIPAddress,
                privateIPAllocationMethod,
                subnetId != null ? ResourceManagerModelFactory.WritableSubResource(subnetId) : null,
                isPrimary,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Network.ApplicationGatewayPrivateEndpointConnectionData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="privateEndpoint"> The resource of private end point. </param>
        /// <param name="connectionState"> A collection of information about the state of the connection between service consumer and provider. </param>
        /// <param name="provisioningState"> The provisioning state of the application gateway private endpoint connection resource. </param>
        /// <param name="linkIdentifier"> The consumer link id. </param>
        /// <returns> A new <see cref="Network.ApplicationGatewayPrivateEndpointConnectionData"/> instance for mocking. </returns>
        public static ApplicationGatewayPrivateEndpointConnectionData ApplicationGatewayPrivateEndpointConnectionData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, PrivateEndpointData privateEndpoint = null, NetworkPrivateLinkServiceConnectionState connectionState = null, NetworkProvisioningState? provisioningState = null, string linkIdentifier = null)
        {
            return new ApplicationGatewayPrivateEndpointConnectionData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                privateEndpoint,
                connectionState,
                provisioningState,
                linkIdentifier);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewayLoadDistributionPolicy"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="loadDistributionTargets"> Load Distribution Targets resource of an application gateway. </param>
        /// <param name="loadDistributionAlgorithm"> Load Distribution Targets resource of an application gateway. </param>
        /// <param name="provisioningState"> The provisioning state of the Load Distribution Policy resource. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewayLoadDistributionPolicy"/> instance for mocking. </returns>
        public static ApplicationGatewayLoadDistributionPolicy ApplicationGatewayLoadDistributionPolicy(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, IEnumerable<ApplicationGatewayLoadDistributionTarget> loadDistributionTargets = null, ApplicationGatewayLoadDistributionAlgorithm? loadDistributionAlgorithm = null, NetworkProvisioningState? provisioningState = null)
        {
            loadDistributionTargets ??= new List<ApplicationGatewayLoadDistributionTarget>();

            return new ApplicationGatewayLoadDistributionPolicy(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                loadDistributionTargets?.ToList(),
                loadDistributionAlgorithm,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewayLoadDistributionTarget"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="weightPerServer"> Weight per server. Range between 1 and 100. </param>
        /// <param name="backendAddressPoolId"> Backend address pool resource of the application gateway. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewayLoadDistributionTarget"/> instance for mocking. </returns>
        public static ApplicationGatewayLoadDistributionTarget ApplicationGatewayLoadDistributionTarget(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, int? weightPerServer = null, ResourceIdentifier backendAddressPoolId = null)
        {
            return new ApplicationGatewayLoadDistributionTarget(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                weightPerServer,
                backendAddressPoolId != null ? ResourceManagerModelFactory.WritableSubResource(backendAddressPoolId) : null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewayBackendHealth"/>. </summary>
        /// <param name="backendAddressPools"> A list of ApplicationGatewayBackendHealthPool resources. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewayBackendHealth"/> instance for mocking. </returns>
        public static ApplicationGatewayBackendHealth ApplicationGatewayBackendHealth(IEnumerable<ApplicationGatewayBackendHealthPool> backendAddressPools = null)
        {
            backendAddressPools ??= new List<ApplicationGatewayBackendHealthPool>();

            return new ApplicationGatewayBackendHealth(backendAddressPools?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewayBackendHealthPool"/>. </summary>
        /// <param name="backendAddressPool"> Reference to an ApplicationGatewayBackendAddressPool resource. </param>
        /// <param name="backendHttpSettingsCollection"> List of ApplicationGatewayBackendHealthHttpSettings resources. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewayBackendHealthPool"/> instance for mocking. </returns>
        public static ApplicationGatewayBackendHealthPool ApplicationGatewayBackendHealthPool(ApplicationGatewayBackendAddressPool backendAddressPool = null, IEnumerable<ApplicationGatewayBackendHealthHttpSettings> backendHttpSettingsCollection = null)
        {
            backendHttpSettingsCollection ??= new List<ApplicationGatewayBackendHealthHttpSettings>();

            return new ApplicationGatewayBackendHealthPool(backendAddressPool, backendHttpSettingsCollection?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewayBackendHealthHttpSettings"/>. </summary>
        /// <param name="backendHttpSettings"> Reference to an ApplicationGatewayBackendHttpSettings resource. </param>
        /// <param name="servers"> List of ApplicationGatewayBackendHealthServer resources. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewayBackendHealthHttpSettings"/> instance for mocking. </returns>
        public static ApplicationGatewayBackendHealthHttpSettings ApplicationGatewayBackendHealthHttpSettings(ApplicationGatewayBackendHttpSettings backendHttpSettings = null, IEnumerable<ApplicationGatewayBackendHealthServer> servers = null)
        {
            servers ??= new List<ApplicationGatewayBackendHealthServer>();

            return new ApplicationGatewayBackendHealthHttpSettings(backendHttpSettings, servers?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewayBackendHealthServer"/>. </summary>
        /// <param name="address"> IP address or FQDN of backend server. </param>
        /// <param name="ipConfiguration"> Reference to IP configuration of backend server. </param>
        /// <param name="health"> Health of backend server. </param>
        /// <param name="healthProbeLog"> Health Probe Log. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewayBackendHealthServer"/> instance for mocking. </returns>
        public static ApplicationGatewayBackendHealthServer ApplicationGatewayBackendHealthServer(string address = null, NetworkInterfaceIPConfigurationData ipConfiguration = null, ApplicationGatewayBackendHealthServerHealth? health = null, string healthProbeLog = null)
        {
            return new ApplicationGatewayBackendHealthServer(address, ipConfiguration, health, healthProbeLog, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewayBackendHealthOnDemand"/>. </summary>
        /// <param name="backendAddressPool"> Reference to an ApplicationGatewayBackendAddressPool resource. </param>
        /// <param name="backendHealthHttpSettings"> Application gateway BackendHealthHttp settings. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewayBackendHealthOnDemand"/> instance for mocking. </returns>
        public static ApplicationGatewayBackendHealthOnDemand ApplicationGatewayBackendHealthOnDemand(ApplicationGatewayBackendAddressPool backendAddressPool = null, ApplicationGatewayBackendHealthHttpSettings backendHealthHttpSettings = null)
        {
            return new ApplicationGatewayBackendHealthOnDemand(backendAddressPool, backendHealthHttpSettings, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewayPrivateLinkResource"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="groupId"> Group identifier of private link resource. </param>
        /// <param name="requiredMembers"> Required member names of private link resource. </param>
        /// <param name="requiredZoneNames"> Required DNS zone names of the the private link resource. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewayPrivateLinkResource"/> instance for mocking. </returns>
        public static ApplicationGatewayPrivateLinkResource ApplicationGatewayPrivateLinkResource(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, string groupId = null, IEnumerable<string> requiredMembers = null, IEnumerable<string> requiredZoneNames = null)
        {
            requiredMembers ??= new List<string>();
            requiredZoneNames ??= new List<string>();

            return new ApplicationGatewayPrivateLinkResource(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                groupId,
                requiredMembers?.ToList(),
                requiredZoneNames?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewayFirewallRuleSet"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="provisioningState"> The provisioning state of the web application firewall rule set. </param>
        /// <param name="ruleSetType"> The type of the web application firewall rule set. </param>
        /// <param name="ruleSetVersion"> The version of the web application firewall rule set type. </param>
        /// <param name="ruleGroups"> The rule groups of the web application firewall rule set. </param>
        /// <param name="tiers"> Tier of an application gateway that support the rule set. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewayFirewallRuleSet"/> instance for mocking. </returns>
        public static ApplicationGatewayFirewallRuleSet ApplicationGatewayFirewallRuleSet(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, NetworkProvisioningState? provisioningState = null, string ruleSetType = null, string ruleSetVersion = null, IEnumerable<ApplicationGatewayFirewallRuleGroup> ruleGroups = null, IEnumerable<ApplicationGatewayTierType> tiers = null)
        {
            tags ??= new Dictionary<string, string>();
            ruleGroups ??= new List<ApplicationGatewayFirewallRuleGroup>();
            tiers ??= new List<ApplicationGatewayTierType>();

            return new ApplicationGatewayFirewallRuleSet(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                provisioningState,
                ruleSetType,
                ruleSetVersion,
                ruleGroups?.ToList(),
                tiers?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewayAvailableSslOptionsInfo"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="predefinedPolicies"> List of available Ssl predefined policy. </param>
        /// <param name="defaultPolicy"> Name of the Ssl predefined policy applied by default to application gateway. </param>
        /// <param name="availableCipherSuites"> List of available Ssl cipher suites. </param>
        /// <param name="availableProtocols"> List of available Ssl protocols. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewayAvailableSslOptionsInfo"/> instance for mocking. </returns>
        public static ApplicationGatewayAvailableSslOptionsInfo ApplicationGatewayAvailableSslOptionsInfo(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, IEnumerable<WritableSubResource> predefinedPolicies = null, ApplicationGatewaySslPolicyName? defaultPolicy = null, IEnumerable<ApplicationGatewaySslCipherSuite> availableCipherSuites = null, IEnumerable<ApplicationGatewaySslProtocol> availableProtocols = null)
        {
            tags ??= new Dictionary<string, string>();
            predefinedPolicies ??= new List<WritableSubResource>();
            availableCipherSuites ??= new List<ApplicationGatewaySslCipherSuite>();
            availableProtocols ??= new List<ApplicationGatewaySslProtocol>();

            return new ApplicationGatewayAvailableSslOptionsInfo(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                predefinedPolicies?.ToList(),
                defaultPolicy,
                availableCipherSuites?.ToList(),
                availableProtocols?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewaySslPredefinedPolicy"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="cipherSuites"> Ssl cipher suites to be enabled in the specified order for application gateway. </param>
        /// <param name="minProtocolVersion"> Minimum version of Ssl protocol to be supported on application gateway. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewaySslPredefinedPolicy"/> instance for mocking. </returns>
        public static ApplicationGatewaySslPredefinedPolicy ApplicationGatewaySslPredefinedPolicy(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, IEnumerable<ApplicationGatewaySslCipherSuite> cipherSuites = null, ApplicationGatewaySslProtocol? minProtocolVersion = null)
        {
            cipherSuites ??= new List<ApplicationGatewaySslCipherSuite>();

            return new ApplicationGatewaySslPredefinedPolicy(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                cipherSuites?.ToList(),
                minProtocolVersion);
        }

        /// <summary> Initializes a new instance of <see cref="Network.ApplicationGatewayWafDynamicManifestData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="availableRuleSets"> The available rulesets. </param>
        /// <param name="ruleSetType"> The type of the web application firewall rule set. </param>
        /// <param name="ruleSetVersion"> The version of the web application firewall rule set type. </param>
        /// <returns> A new <see cref="Network.ApplicationGatewayWafDynamicManifestData"/> instance for mocking. </returns>
        public static ApplicationGatewayWafDynamicManifestData ApplicationGatewayWafDynamicManifestData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IEnumerable<ApplicationGatewayFirewallManifestRuleSet> availableRuleSets = null, string ruleSetType = null, string ruleSetVersion = null)
        {
            availableRuleSets ??= new List<ApplicationGatewayFirewallManifestRuleSet>();

            return new ApplicationGatewayWafDynamicManifestData(
                id,
                name,
                resourceType,
                systemData,
                availableRuleSets?.ToList(),
                ruleSetType,
                ruleSetVersion,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationGatewayFirewallManifestRuleSet"/>. </summary>
        /// <param name="ruleSetType"> The type of the web application firewall rule set. </param>
        /// <param name="ruleSetVersion"> The version of the web application firewall rule set type. </param>
        /// <param name="status"> The rule set status. </param>
        /// <param name="tiers"> Tier of an application gateway that support the rule set. </param>
        /// <param name="ruleGroups"> The rule groups of the web application firewall rule set. </param>
        /// <returns> A new <see cref="Models.ApplicationGatewayFirewallManifestRuleSet"/> instance for mocking. </returns>
        public static ApplicationGatewayFirewallManifestRuleSet ApplicationGatewayFirewallManifestRuleSet(string ruleSetType = null, string ruleSetVersion = null, ApplicationGatewayRuleSetStatusOption? status = null, IEnumerable<ApplicationGatewayTierType> tiers = null, IEnumerable<ApplicationGatewayFirewallRuleGroup> ruleGroups = null)
        {
            tiers ??= new List<ApplicationGatewayTierType>();
            ruleGroups ??= new List<ApplicationGatewayFirewallRuleGroup>();

            return new ApplicationGatewayFirewallManifestRuleSet(
                ruleSetType,
                ruleSetVersion,
                status,
                tiers?.ToList(),
                ruleGroups?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AvailableDelegation"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="serviceName"> The name of the service and resource. </param>
        /// <param name="actions"> The actions permitted to the service upon delegation. </param>
        /// <returns> A new <see cref="Models.AvailableDelegation"/> instance for mocking. </returns>
        public static AvailableDelegation AvailableDelegation(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string serviceName = null, IEnumerable<string> actions = null)
        {
            actions ??= new List<string>();

            return new AvailableDelegation(
                id,
                name,
                resourceType,
                systemData,
                serviceName,
                actions?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AvailableServiceAlias"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="resourceName"> The resource name of the service alias. </param>
        /// <returns> A new <see cref="Models.AvailableServiceAlias"/> instance for mocking. </returns>
        public static AvailableServiceAlias AvailableServiceAlias(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string resourceName = null)
        {
            return new AvailableServiceAlias(
                id,
                name,
                resourceType,
                systemData,
                resourceName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.AzureFirewallData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="zones"> A list of availability zones denoting where the resource needs to come from. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="applicationRuleCollections"> Collection of application rule collections used by Azure Firewall. </param>
        /// <param name="natRuleCollections"> Collection of NAT rule collections used by Azure Firewall. </param>
        /// <param name="networkRuleCollections"> Collection of network rule collections used by Azure Firewall. </param>
        /// <param name="ipConfigurations"> IP configuration of the Azure Firewall resource. </param>
        /// <param name="managementIPConfiguration"> IP configuration of the Azure Firewall used for management traffic. </param>
        /// <param name="provisioningState"> The provisioning state of the Azure firewall resource. </param>
        /// <param name="threatIntelMode"> The operation mode for Threat Intelligence. </param>
        /// <param name="virtualHubId"> The virtualHub to which the firewall belongs. </param>
        /// <param name="firewallPolicyId"> The firewallPolicy associated with this azure firewall. </param>
        /// <param name="hubIPAddresses"> IP addresses associated with AzureFirewall. </param>
        /// <param name="ipGroups"> IpGroups associated with AzureFirewall. </param>
        /// <param name="sku"> The Azure Firewall Resource SKU. </param>
        /// <param name="additionalProperties"> The additional properties used to further config this azure firewall. </param>
        /// <param name="autoscaleConfiguration"> Properties to provide a custom autoscale configuration to this azure firewall. </param>
        /// <returns> A new <see cref="Network.AzureFirewallData"/> instance for mocking. </returns>
        public static AzureFirewallData AzureFirewallData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, IEnumerable<string> zones = null, ETag? etag = null, IEnumerable<AzureFirewallApplicationRuleCollectionData> applicationRuleCollections = null, IEnumerable<AzureFirewallNatRuleCollectionData> natRuleCollections = null, IEnumerable<AzureFirewallNetworkRuleCollectionData> networkRuleCollections = null, IEnumerable<AzureFirewallIPConfiguration> ipConfigurations = null, AzureFirewallIPConfiguration managementIPConfiguration = null, NetworkProvisioningState? provisioningState = null, AzureFirewallThreatIntelMode? threatIntelMode = null, ResourceIdentifier virtualHubId = null, ResourceIdentifier firewallPolicyId = null, HubIPAddresses hubIPAddresses = null, IEnumerable<AzureFirewallIPGroups> ipGroups = null, AzureFirewallSku sku = null, IDictionary<string, string> additionalProperties = null, AzureFirewallAutoscaleConfiguration autoscaleConfiguration = null)
        {
            tags ??= new Dictionary<string, string>();
            zones ??= new List<string>();
            applicationRuleCollections ??= new List<AzureFirewallApplicationRuleCollectionData>();
            natRuleCollections ??= new List<AzureFirewallNatRuleCollectionData>();
            networkRuleCollections ??= new List<AzureFirewallNetworkRuleCollectionData>();
            ipConfigurations ??= new List<AzureFirewallIPConfiguration>();
            ipGroups ??= new List<AzureFirewallIPGroups>();
            additionalProperties ??= new Dictionary<string, string>();

            return new AzureFirewallData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                zones?.ToList(),
                etag,
                applicationRuleCollections?.ToList(),
                natRuleCollections?.ToList(),
                networkRuleCollections?.ToList(),
                ipConfigurations?.ToList(),
                managementIPConfiguration,
                provisioningState,
                threatIntelMode,
                virtualHubId != null ? ResourceManagerModelFactory.WritableSubResource(virtualHubId) : null,
                firewallPolicyId != null ? ResourceManagerModelFactory.WritableSubResource(firewallPolicyId) : null,
                hubIPAddresses,
                ipGroups?.ToList(),
                sku,
                additionalProperties,
                autoscaleConfiguration);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AzureFirewallApplicationRuleCollectionData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="priority"> Priority of the application rule collection resource. </param>
        /// <param name="actionType"> The action type of a rule collection. </param>
        /// <param name="rules"> Collection of rules used by a application rule collection. </param>
        /// <param name="provisioningState"> The provisioning state of the application rule collection resource. </param>
        /// <returns> A new <see cref="Models.AzureFirewallApplicationRuleCollectionData"/> instance for mocking. </returns>
        public static AzureFirewallApplicationRuleCollectionData AzureFirewallApplicationRuleCollectionData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, int? priority = null, AzureFirewallRCActionType? actionType = null, IEnumerable<AzureFirewallApplicationRule> rules = null, NetworkProvisioningState? provisioningState = null)
        {
            rules ??= new List<AzureFirewallApplicationRule>();

            return new AzureFirewallApplicationRuleCollectionData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                priority,
                actionType != null ? new AzureFirewallRCAction(actionType, serializedAdditionalRawData: null) : null,
                rules?.ToList(),
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AzureFirewallNatRuleCollectionData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="priority"> Priority of the NAT rule collection resource. </param>
        /// <param name="actionType"> The action type of a NAT rule collection. </param>
        /// <param name="rules"> Collection of rules used by a NAT rule collection. </param>
        /// <param name="provisioningState"> The provisioning state of the NAT rule collection resource. </param>
        /// <returns> A new <see cref="Models.AzureFirewallNatRuleCollectionData"/> instance for mocking. </returns>
        public static AzureFirewallNatRuleCollectionData AzureFirewallNatRuleCollectionData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, int? priority = null, AzureFirewallNatRCActionType? actionType = null, IEnumerable<AzureFirewallNatRule> rules = null, NetworkProvisioningState? provisioningState = null)
        {
            rules ??= new List<AzureFirewallNatRule>();

            return new AzureFirewallNatRuleCollectionData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                priority,
                actionType != null ? new AzureFirewallNatRCAction(actionType, serializedAdditionalRawData: null) : null,
                rules?.ToList(),
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AzureFirewallNetworkRuleCollectionData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="priority"> Priority of the network rule collection resource. </param>
        /// <param name="actionType"> The action type of a rule collection. </param>
        /// <param name="rules"> Collection of rules used by a network rule collection. </param>
        /// <param name="provisioningState"> The provisioning state of the network rule collection resource. </param>
        /// <returns> A new <see cref="Models.AzureFirewallNetworkRuleCollectionData"/> instance for mocking. </returns>
        public static AzureFirewallNetworkRuleCollectionData AzureFirewallNetworkRuleCollectionData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, int? priority = null, AzureFirewallRCActionType? actionType = null, IEnumerable<AzureFirewallNetworkRule> rules = null, NetworkProvisioningState? provisioningState = null)
        {
            rules ??= new List<AzureFirewallNetworkRule>();

            return new AzureFirewallNetworkRuleCollectionData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                priority,
                actionType != null ? new AzureFirewallRCAction(actionType, serializedAdditionalRawData: null) : null,
                rules?.ToList(),
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AzureFirewallIPConfiguration"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="privateIPAddress"> The Firewall Internal Load Balancer IP to be used as the next hop in User Defined Routes. </param>
        /// <param name="subnetId"> Reference to the subnet resource. This resource must be named 'AzureFirewallSubnet' or 'AzureFirewallManagementSubnet'. </param>
        /// <param name="publicIPAddressId"> Reference to the PublicIP resource. This field is a mandatory input if subnet is not null. </param>
        /// <param name="provisioningState"> The provisioning state of the Azure firewall IP configuration resource. </param>
        /// <returns> A new <see cref="Models.AzureFirewallIPConfiguration"/> instance for mocking. </returns>
        public static AzureFirewallIPConfiguration AzureFirewallIPConfiguration(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, string privateIPAddress = null, ResourceIdentifier subnetId = null, ResourceIdentifier publicIPAddressId = null, NetworkProvisioningState? provisioningState = null)
        {
            return new AzureFirewallIPConfiguration(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                privateIPAddress,
                subnetId != null ? ResourceManagerModelFactory.WritableSubResource(subnetId) : null,
                publicIPAddressId != null ? ResourceManagerModelFactory.WritableSubResource(publicIPAddressId) : null,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AzureFirewallIPGroups"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="changeNumber"> The iteration number. </param>
        /// <returns> A new <see cref="Models.AzureFirewallIPGroups"/> instance for mocking. </returns>
        public static AzureFirewallIPGroups AzureFirewallIPGroups(ResourceIdentifier id = null, string changeNumber = null)
        {
            return new AzureFirewallIPGroups(id, changeNumber, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LearnedIPPrefixesListResult"/>. </summary>
        /// <param name="ipPrefixes"> IP Prefix value. </param>
        /// <returns> A new <see cref="Models.LearnedIPPrefixesListResult"/> instance for mocking. </returns>
        public static LearnedIPPrefixesListResult LearnedIPPrefixesListResult(IEnumerable<string> ipPrefixes = null)
        {
            ipPrefixes ??= new List<string>();

            return new LearnedIPPrefixesListResult(ipPrefixes?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AzureFirewallFqdnTag"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="provisioningState"> The provisioning state of the Azure firewall FQDN tag resource. </param>
        /// <param name="fqdnTagName"> The name of this FQDN Tag. </param>
        /// <returns> A new <see cref="Models.AzureFirewallFqdnTag"/> instance for mocking. </returns>
        public static AzureFirewallFqdnTag AzureFirewallFqdnTag(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, NetworkProvisioningState? provisioningState = null, string fqdnTagName = null)
        {
            tags ??= new Dictionary<string, string>();

            return new AzureFirewallFqdnTag(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                provisioningState,
                fqdnTagName);
        }

        /// <summary> Initializes a new instance of <see cref="Network.AzureWebCategoryData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="group"> The name of the group that the category belongs to. </param>
        /// <returns> A new <see cref="Network.AzureWebCategoryData"/> instance for mocking. </returns>
        public static AzureWebCategoryData AzureWebCategoryData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ETag? etag = null, string group = null)
        {
            return new AzureWebCategoryData(
                id,
                name,
                resourceType,
                systemData,
                etag,
                group,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.BastionHostData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="zones"> A list of availability zones denoting where the resource needs to come from. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="skuName"> The sku of this Bastion Host. </param>
        /// <param name="ipConfigurations"> IP configuration of the Bastion Host resource. </param>
        /// <param name="dnsName"> FQDN for the endpoint on which bastion host is accessible. </param>
        /// <param name="virtualNetworkId"> Reference to an existing virtual network required for Developer Bastion Host only. </param>
        /// <param name="networkAclsIPRules"></param>
        /// <param name="provisioningState"> The provisioning state of the bastion host resource. </param>
        /// <param name="scaleUnits"> The scale units for the Bastion Host resource. </param>
        /// <param name="disableCopyPaste"> Enable/Disable Copy/Paste feature of the Bastion Host resource. </param>
        /// <param name="enableFileCopy"> Enable/Disable File Copy feature of the Bastion Host resource. </param>
        /// <param name="enableIPConnect"> Enable/Disable IP Connect feature of the Bastion Host resource. </param>
        /// <param name="enableShareableLink"> Enable/Disable Shareable Link of the Bastion Host resource. </param>
        /// <param name="enableTunneling"> Enable/Disable Tunneling feature of the Bastion Host resource. </param>
        /// <param name="enableKerberos"> Enable/Disable Kerberos feature of the Bastion Host resource. </param>
        /// <param name="enableSessionRecording"> Enable/Disable Session Recording feature of the Bastion Host resource. </param>
        /// <returns> A new <see cref="Network.BastionHostData"/> instance for mocking. </returns>
        public static BastionHostData BastionHostData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, IEnumerable<string> zones = null, ETag? etag = null, BastionHostSkuName? skuName = null, IEnumerable<BastionHostIPConfiguration> ipConfigurations = null, string dnsName = null, ResourceIdentifier virtualNetworkId = null, IEnumerable<BastionHostIPRule> networkAclsIPRules = null, NetworkProvisioningState? provisioningState = null, int? scaleUnits = null, bool? disableCopyPaste = null, bool? enableFileCopy = null, bool? enableIPConnect = null, bool? enableShareableLink = null, bool? enableTunneling = null, bool? enableKerberos = null, bool? enableSessionRecording = null)
        {
            tags ??= new Dictionary<string, string>();
            zones ??= new List<string>();
            ipConfigurations ??= new List<BastionHostIPConfiguration>();
            networkAclsIPRules ??= new List<BastionHostIPRule>();

            return new BastionHostData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                zones?.ToList(),
                etag,
                skuName != null ? new NetworkSku(skuName, serializedAdditionalRawData: null) : null,
                ipConfigurations?.ToList(),
                dnsName,
                virtualNetworkId != null ? ResourceManagerModelFactory.WritableSubResource(virtualNetworkId) : null,
                networkAclsIPRules != null ? new BastionHostPropertiesFormatNetworkAcls(networkAclsIPRules?.ToList(), serializedAdditionalRawData: null) : null,
                provisioningState,
                scaleUnits,
                disableCopyPaste,
                enableFileCopy,
                enableIPConnect,
                enableShareableLink,
                enableTunneling,
                enableKerberos,
                enableSessionRecording);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BastionHostIPConfiguration"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="subnetId"> Reference of the subnet resource. </param>
        /// <param name="publicIPAddressId"> Reference of the PublicIP resource. </param>
        /// <param name="provisioningState"> The provisioning state of the bastion host IP configuration resource. </param>
        /// <param name="privateIPAllocationMethod"> Private IP allocation method. </param>
        /// <returns> A new <see cref="Models.BastionHostIPConfiguration"/> instance for mocking. </returns>
        public static BastionHostIPConfiguration BastionHostIPConfiguration(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, ResourceIdentifier subnetId = null, ResourceIdentifier publicIPAddressId = null, NetworkProvisioningState? provisioningState = null, NetworkIPAllocationMethod? privateIPAllocationMethod = null)
        {
            return new BastionHostIPConfiguration(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                subnetId != null ? ResourceManagerModelFactory.WritableSubResource(subnetId) : null,
                publicIPAddressId != null ? ResourceManagerModelFactory.WritableSubResource(publicIPAddressId) : null,
                provisioningState,
                privateIPAllocationMethod);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DnsNameAvailabilityResult"/>. </summary>
        /// <param name="available"> Domain availability (True/False). </param>
        /// <returns> A new <see cref="Models.DnsNameAvailabilityResult"/> instance for mocking. </returns>
        public static DnsNameAvailabilityResult DnsNameAvailabilityResult(bool? available = null)
        {
            return new DnsNameAvailabilityResult(available, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.CloudServiceSwapData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="cloudServiceSwapSlotType"> Swap resource properties. </param>
        /// <returns> A new <see cref="Network.CloudServiceSwapData"/> instance for mocking. </returns>
        public static CloudServiceSwapData CloudServiceSwapData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SwapSlotType? cloudServiceSwapSlotType = null)
        {
            return new CloudServiceSwapData(
                id,
                name,
                resourceType,
                systemData,
                cloudServiceSwapSlotType != null ? new CloudServiceSwapProperties(cloudServiceSwapSlotType, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.CustomIPPrefixData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="extendedLocation"> The extended location of the custom IP prefix. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="zones"> A list of availability zones denoting the IP allocated for the resource needs to come from. </param>
        /// <param name="asn"> The ASN for CIDR advertising. Should be an integer as string. </param>
        /// <param name="cidr"> The prefix range in CIDR notation. Should include the start address and the prefix length. </param>
        /// <param name="signedMessage"> Signed message for WAN validation. </param>
        /// <param name="authorizationMessage"> Authorization message for WAN validation. </param>
        /// <param name="parentCustomIPPrefixId"> The Parent CustomIpPrefix for IPv6 /64 CustomIpPrefix. </param>
        /// <param name="childCustomIPPrefixList"> The list of all Children for IPv6 /48 CustomIpPrefix. </param>
        /// <param name="commissionedState"> The commissioned state of the Custom IP Prefix. </param>
        /// <param name="expressRouteAdvertise"> Whether to do express route advertise. </param>
        /// <param name="geo"> The Geo for CIDR advertising. Should be an Geo code. </param>
        /// <param name="noInternetAdvertise"> Whether to Advertise the range to Internet. </param>
        /// <param name="prefixType"> Type of custom IP prefix. Should be Singular, Parent, or Child. </param>
        /// <param name="publicIPPrefixes"> The list of all referenced PublicIpPrefixes. </param>
        /// <param name="resourceGuid"> The resource GUID property of the custom IP prefix resource. </param>
        /// <param name="failedReason"> The reason why resource is in failed state. </param>
        /// <param name="provisioningState"> The provisioning state of the custom IP prefix resource. </param>
        /// <returns> A new <see cref="Network.CustomIPPrefixData"/> instance for mocking. </returns>
        public static CustomIPPrefixData CustomIPPrefixData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ExtendedLocation extendedLocation = null, ETag? etag = null, IEnumerable<string> zones = null, string asn = null, string cidr = null, string signedMessage = null, string authorizationMessage = null, ResourceIdentifier parentCustomIPPrefixId = null, IEnumerable<WritableSubResource> childCustomIPPrefixList = null, CommissionedState? commissionedState = null, bool? expressRouteAdvertise = null, CidrAdvertisingGeoCode? geo = null, bool? noInternetAdvertise = null, CustomIPPrefixType? prefixType = null, IEnumerable<WritableSubResource> publicIPPrefixes = null, Guid? resourceGuid = null, string failedReason = null, NetworkProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            zones ??= new List<string>();
            childCustomIPPrefixList ??= new List<WritableSubResource>();
            publicIPPrefixes ??= new List<WritableSubResource>();

            return new CustomIPPrefixData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                extendedLocation,
                etag,
                zones?.ToList(),
                asn,
                cidr,
                signedMessage,
                authorizationMessage,
                parentCustomIPPrefixId != null ? ResourceManagerModelFactory.WritableSubResource(parentCustomIPPrefixId) : null,
                childCustomIPPrefixList?.ToList(),
                commissionedState,
                expressRouteAdvertise,
                geo,
                noInternetAdvertise,
                prefixType,
                publicIPPrefixes?.ToList(),
                resourceGuid,
                failedReason,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Network.DdosCustomPolicyData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="resourceGuid"> The resource GUID property of the DDoS custom policy resource. It uniquely identifies the resource, even if the user changes its name or migrate the resource across subscriptions or resource groups. </param>
        /// <param name="provisioningState"> The provisioning state of the DDoS custom policy resource. </param>
        /// <returns> A new <see cref="Network.DdosCustomPolicyData"/> instance for mocking. </returns>
        public static DdosCustomPolicyData DdosCustomPolicyData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, Guid? resourceGuid = null, NetworkProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();

            return new DdosCustomPolicyData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                resourceGuid,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Network.DdosProtectionPlanData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="resourceGuid"> The resource GUID property of the DDoS protection plan resource. It uniquely identifies the resource, even if the user changes its name or migrate the resource across subscriptions or resource groups. </param>
        /// <param name="provisioningState"> The provisioning state of the DDoS protection plan resource. </param>
        /// <param name="publicIPAddresses"> The list of public IPs associated with the DDoS protection plan resource. This list is read-only. </param>
        /// <param name="virtualNetworks"> The list of virtual networks associated with the DDoS protection plan resource. This list is read-only. </param>
        /// <returns> A new <see cref="Network.DdosProtectionPlanData"/> instance for mocking. </returns>
        public static DdosProtectionPlanData DdosProtectionPlanData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ETag? etag = null, Guid? resourceGuid = null, NetworkProvisioningState? provisioningState = null, IEnumerable<WritableSubResource> publicIPAddresses = null, IEnumerable<WritableSubResource> virtualNetworks = null)
        {
            tags ??= new Dictionary<string, string>();
            publicIPAddresses ??= new List<WritableSubResource>();
            virtualNetworks ??= new List<WritableSubResource>();

            return new DdosProtectionPlanData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                etag,
                resourceGuid,
                provisioningState,
                publicIPAddresses?.ToList(),
                virtualNetworks?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.DscpConfigurationData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="markings"> List of markings to be used in the configuration. </param>
        /// <param name="sourceIPRanges"> Source IP ranges. </param>
        /// <param name="destinationIPRanges"> Destination IP ranges. </param>
        /// <param name="sourcePortRanges"> Sources port ranges. </param>
        /// <param name="destinationPortRanges"> Destination port ranges. </param>
        /// <param name="protocol"> RNM supported protocol types. </param>
        /// <param name="qosDefinitionCollection"> QoS object definitions. </param>
        /// <param name="qosCollectionId"> Qos Collection ID generated by RNM. </param>
        /// <param name="associatedNetworkInterfaces"> Associated Network Interfaces to the DSCP Configuration. </param>
        /// <param name="resourceGuid"> The resource GUID property of the DSCP Configuration resource. </param>
        /// <param name="provisioningState"> The provisioning state of the DSCP Configuration resource. </param>
        /// <returns> A new <see cref="Network.DscpConfigurationData"/> instance for mocking. </returns>
        public static DscpConfigurationData DscpConfigurationData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, IEnumerable<int> markings = null, IEnumerable<QosIPRange> sourceIPRanges = null, IEnumerable<QosIPRange> destinationIPRanges = null, IEnumerable<QosPortRange> sourcePortRanges = null, IEnumerable<QosPortRange> destinationPortRanges = null, ProtocolType? protocol = null, IEnumerable<DscpQosDefinition> qosDefinitionCollection = null, string qosCollectionId = null, IEnumerable<NetworkInterfaceData> associatedNetworkInterfaces = null, Guid? resourceGuid = null, NetworkProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            markings ??= new List<int>();
            sourceIPRanges ??= new List<QosIPRange>();
            destinationIPRanges ??= new List<QosIPRange>();
            sourcePortRanges ??= new List<QosPortRange>();
            destinationPortRanges ??= new List<QosPortRange>();
            qosDefinitionCollection ??= new List<DscpQosDefinition>();
            associatedNetworkInterfaces ??= new List<NetworkInterfaceData>();

            return new DscpConfigurationData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                markings?.ToList(),
                sourceIPRanges?.ToList(),
                destinationIPRanges?.ToList(),
                sourcePortRanges?.ToList(),
                destinationPortRanges?.ToList(),
                protocol,
                qosDefinitionCollection?.ToList(),
                qosCollectionId,
                associatedNetworkInterfaces?.ToList(),
                resourceGuid,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EndpointServiceResult"/>. </summary>
        /// <param name="name"> Name of the endpoint service. </param>
        /// <param name="resourceType"> Type of the endpoint service. </param>
        /// <param name="id"> Resource ID. </param>
        /// <returns> A new <see cref="Models.EndpointServiceResult"/> instance for mocking. </returns>
        public static EndpointServiceResult EndpointServiceResult(string name = null, ResourceType? resourceType = null, ResourceIdentifier id = null)
        {
            return new EndpointServiceResult(name, resourceType, id, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.ExpressRouteCircuitAuthorizationData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="authorizationKey"> The authorization key. </param>
        /// <param name="authorizationUseStatus"> The authorization use status. </param>
        /// <param name="connectionResourceUri"> The reference to the ExpressRoute connection resource using the authorization. </param>
        /// <param name="provisioningState"> The provisioning state of the authorization resource. </param>
        /// <returns> A new <see cref="Network.ExpressRouteCircuitAuthorizationData"/> instance for mocking. </returns>
        public static ExpressRouteCircuitAuthorizationData ExpressRouteCircuitAuthorizationData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, string authorizationKey = null, AuthorizationUseStatus? authorizationUseStatus = null, Uri connectionResourceUri = null, NetworkProvisioningState? provisioningState = null)
        {
            return new ExpressRouteCircuitAuthorizationData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                authorizationKey,
                authorizationUseStatus,
                connectionResourceUri,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Network.ExpressRouteCircuitPeeringData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="peeringType"> The peering type. </param>
        /// <param name="state"> The peering state. </param>
        /// <param name="azureASN"> The Azure ASN. </param>
        /// <param name="peerASN"> The peer ASN. </param>
        /// <param name="primaryPeerAddressPrefix"> The primary address prefix. </param>
        /// <param name="secondaryPeerAddressPrefix"> The secondary address prefix. </param>
        /// <param name="primaryAzurePort"> The primary port. </param>
        /// <param name="secondaryAzurePort"> The secondary port. </param>
        /// <param name="sharedKey"> The shared key. </param>
        /// <param name="vlanId"> The VLAN ID. </param>
        /// <param name="microsoftPeeringConfig"> The Microsoft peering configuration. </param>
        /// <param name="stats"> The peering stats of express route circuit. </param>
        /// <param name="provisioningState"> The provisioning state of the express route circuit peering resource. </param>
        /// <param name="gatewayManagerETag"> The GatewayManager Etag. </param>
        /// <param name="lastModifiedBy"> Who was the last to modify the peering. </param>
        /// <param name="routeFilterId"> The reference to the RouteFilter resource. </param>
        /// <param name="ipv6PeeringConfig"> The IPv6 peering configuration. </param>
        /// <param name="expressRouteConnectionId"> The ExpressRoute connection. </param>
        /// <param name="connections"> The list of circuit connections associated with Azure Private Peering for this circuit. </param>
        /// <param name="peeredConnections"> The list of peered circuit connections associated with Azure Private Peering for this circuit. </param>
        /// <returns> A new <see cref="Network.ExpressRouteCircuitPeeringData"/> instance for mocking. </returns>
        public static ExpressRouteCircuitPeeringData ExpressRouteCircuitPeeringData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, ExpressRoutePeeringType? peeringType = null, ExpressRoutePeeringState? state = null, int? azureASN = null, long? peerASN = null, string primaryPeerAddressPrefix = null, string secondaryPeerAddressPrefix = null, string primaryAzurePort = null, string secondaryAzurePort = null, string sharedKey = null, int? vlanId = null, ExpressRouteCircuitPeeringConfig microsoftPeeringConfig = null, ExpressRouteCircuitStats stats = null, NetworkProvisioningState? provisioningState = null, string gatewayManagerETag = null, string lastModifiedBy = null, ResourceIdentifier routeFilterId = null, IPv6ExpressRouteCircuitPeeringConfig ipv6PeeringConfig = null, ResourceIdentifier expressRouteConnectionId = null, IEnumerable<ExpressRouteCircuitConnectionData> connections = null, IEnumerable<PeerExpressRouteCircuitConnectionData> peeredConnections = null)
        {
            connections ??= new List<ExpressRouteCircuitConnectionData>();
            peeredConnections ??= new List<PeerExpressRouteCircuitConnectionData>();

            return new ExpressRouteCircuitPeeringData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                peeringType,
                state,
                azureASN,
                peerASN,
                primaryPeerAddressPrefix,
                secondaryPeerAddressPrefix,
                primaryAzurePort,
                secondaryAzurePort,
                sharedKey,
                vlanId,
                microsoftPeeringConfig,
                stats,
                provisioningState,
                gatewayManagerETag,
                lastModifiedBy,
                routeFilterId != null ? ResourceManagerModelFactory.WritableSubResource(routeFilterId) : null,
                ipv6PeeringConfig,
                expressRouteConnectionId != null ? ResourceManagerModelFactory.SubResource(expressRouteConnectionId) : null,
                connections?.ToList(),
                peeredConnections?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExpressRouteCircuitPeeringConfig"/>. </summary>
        /// <param name="advertisedPublicPrefixes"> The reference to AdvertisedPublicPrefixes. </param>
        /// <param name="advertisedCommunities"> The communities of bgp peering. Specified for microsoft peering. </param>
        /// <param name="advertisedPublicPrefixesState"> The advertised public prefix state of the Peering resource. </param>
        /// <param name="legacyMode"> The legacy mode of the peering. </param>
        /// <param name="customerASN"> The CustomerASN of the peering. </param>
        /// <param name="routingRegistryName"> The RoutingRegistryName of the configuration. </param>
        /// <returns> A new <see cref="Models.ExpressRouteCircuitPeeringConfig"/> instance for mocking. </returns>
        public static ExpressRouteCircuitPeeringConfig ExpressRouteCircuitPeeringConfig(IEnumerable<string> advertisedPublicPrefixes = null, IEnumerable<string> advertisedCommunities = null, ExpressRouteCircuitPeeringAdvertisedPublicPrefixState? advertisedPublicPrefixesState = null, int? legacyMode = null, int? customerASN = null, string routingRegistryName = null)
        {
            advertisedPublicPrefixes ??= new List<string>();
            advertisedCommunities ??= new List<string>();

            return new ExpressRouteCircuitPeeringConfig(
                advertisedPublicPrefixes?.ToList(),
                advertisedCommunities?.ToList(),
                advertisedPublicPrefixesState,
                legacyMode,
                customerASN,
                routingRegistryName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.ExpressRouteCircuitConnectionData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="expressRouteCircuitPeeringId"> Reference to Express Route Circuit Private Peering Resource of the circuit initiating connection. </param>
        /// <param name="peerExpressRouteCircuitPeeringId"> Reference to Express Route Circuit Private Peering Resource of the peered circuit. </param>
        /// <param name="addressPrefix"> /29 IP address space to carve out Customer addresses for tunnels. </param>
        /// <param name="authorizationKey"> The authorization key. </param>
        /// <param name="ipv6CircuitConnectionConfig"> IPv6 Address PrefixProperties of the express route circuit connection. </param>
        /// <param name="circuitConnectionStatus"> Express Route Circuit connection state. </param>
        /// <param name="provisioningState"> The provisioning state of the express route circuit connection resource. </param>
        /// <returns> A new <see cref="Network.ExpressRouteCircuitConnectionData"/> instance for mocking. </returns>
        public static ExpressRouteCircuitConnectionData ExpressRouteCircuitConnectionData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, ResourceIdentifier expressRouteCircuitPeeringId = null, ResourceIdentifier peerExpressRouteCircuitPeeringId = null, string addressPrefix = null, string authorizationKey = null, IPv6CircuitConnectionConfig ipv6CircuitConnectionConfig = null, CircuitConnectionStatus? circuitConnectionStatus = null, NetworkProvisioningState? provisioningState = null)
        {
            return new ExpressRouteCircuitConnectionData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                expressRouteCircuitPeeringId != null ? ResourceManagerModelFactory.WritableSubResource(expressRouteCircuitPeeringId) : null,
                peerExpressRouteCircuitPeeringId != null ? ResourceManagerModelFactory.WritableSubResource(peerExpressRouteCircuitPeeringId) : null,
                addressPrefix,
                authorizationKey,
                ipv6CircuitConnectionConfig,
                circuitConnectionStatus,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IPv6CircuitConnectionConfig"/>. </summary>
        /// <param name="addressPrefix"> /125 IP address space to carve out customer addresses for global reach. </param>
        /// <param name="circuitConnectionStatus"> Express Route Circuit connection state. </param>
        /// <returns> A new <see cref="Models.IPv6CircuitConnectionConfig"/> instance for mocking. </returns>
        public static IPv6CircuitConnectionConfig IPv6CircuitConnectionConfig(string addressPrefix = null, CircuitConnectionStatus? circuitConnectionStatus = null)
        {
            return new IPv6CircuitConnectionConfig(addressPrefix, circuitConnectionStatus, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.PeerExpressRouteCircuitConnectionData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="expressRouteCircuitPeeringId"> Reference to Express Route Circuit Private Peering Resource of the circuit. </param>
        /// <param name="peerExpressRouteCircuitPeeringId"> Reference to Express Route Circuit Private Peering Resource of the peered circuit. </param>
        /// <param name="addressPrefix"> /29 IP address space to carve out Customer addresses for tunnels. </param>
        /// <param name="circuitConnectionStatus"> Express Route Circuit connection state. </param>
        /// <param name="connectionName"> The name of the express route circuit connection resource. </param>
        /// <param name="authResourceGuid"> The resource guid of the authorization used for the express route circuit connection. </param>
        /// <param name="provisioningState"> The provisioning state of the peer express route circuit connection resource. </param>
        /// <returns> A new <see cref="Network.PeerExpressRouteCircuitConnectionData"/> instance for mocking. </returns>
        public static PeerExpressRouteCircuitConnectionData PeerExpressRouteCircuitConnectionData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, ResourceIdentifier expressRouteCircuitPeeringId = null, ResourceIdentifier peerExpressRouteCircuitPeeringId = null, string addressPrefix = null, CircuitConnectionStatus? circuitConnectionStatus = null, string connectionName = null, Guid? authResourceGuid = null, NetworkProvisioningState? provisioningState = null)
        {
            return new PeerExpressRouteCircuitConnectionData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                expressRouteCircuitPeeringId != null ? ResourceManagerModelFactory.WritableSubResource(expressRouteCircuitPeeringId) : null,
                peerExpressRouteCircuitPeeringId != null ? ResourceManagerModelFactory.WritableSubResource(peerExpressRouteCircuitPeeringId) : null,
                addressPrefix,
                circuitConnectionStatus,
                connectionName,
                authResourceGuid,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Network.ExpressRouteCircuitData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="sku"> The SKU. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="allowClassicOperations"> Allow classic operations. </param>
        /// <param name="circuitProvisioningState"> The CircuitProvisioningState state of the resource. </param>
        /// <param name="serviceProviderProvisioningState"> The ServiceProviderProvisioningState state of the resource. </param>
        /// <param name="authorizations"> The list of authorizations. </param>
        /// <param name="peerings"> The list of peerings. </param>
        /// <param name="serviceKey"> The ServiceKey. </param>
        /// <param name="serviceProviderNotes"> The ServiceProviderNotes. </param>
        /// <param name="serviceProviderProperties"> The ServiceProviderProperties. </param>
        /// <param name="expressRoutePortId"> The reference to the ExpressRoutePort resource when the circuit is provisioned on an ExpressRoutePort resource. </param>
        /// <param name="bandwidthInGbps"> The bandwidth of the circuit when the circuit is provisioned on an ExpressRoutePort resource. </param>
        /// <param name="stag"> The identifier of the circuit traffic. Outer tag for QinQ encapsulation. </param>
        /// <param name="provisioningState"> The provisioning state of the express route circuit resource. </param>
        /// <param name="gatewayManagerETag"> The GatewayManager Etag. </param>
        /// <param name="globalReachEnabled"> Flag denoting global reach status. </param>
        /// <param name="authorizationKey"> The authorizationKey. </param>
        /// <param name="authorizationStatus"> The authorization status of the Circuit. </param>
        /// <param name="enableDirectPortRateLimit"> Flag denoting rate-limiting status of the ExpressRoute direct-port circuit. </param>
        /// <returns> A new <see cref="Network.ExpressRouteCircuitData"/> instance for mocking. </returns>
        public static ExpressRouteCircuitData ExpressRouteCircuitData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ExpressRouteCircuitSku sku = null, ETag? etag = null, bool? allowClassicOperations = null, string circuitProvisioningState = null, ServiceProviderProvisioningState? serviceProviderProvisioningState = null, IEnumerable<ExpressRouteCircuitAuthorizationData> authorizations = null, IEnumerable<ExpressRouteCircuitPeeringData> peerings = null, string serviceKey = null, string serviceProviderNotes = null, ExpressRouteCircuitServiceProviderProperties serviceProviderProperties = null, ResourceIdentifier expressRoutePortId = null, float? bandwidthInGbps = null, int? stag = null, NetworkProvisioningState? provisioningState = null, string gatewayManagerETag = null, bool? globalReachEnabled = null, string authorizationKey = null, string authorizationStatus = null, bool? enableDirectPortRateLimit = null)
        {
            tags ??= new Dictionary<string, string>();
            authorizations ??= new List<ExpressRouteCircuitAuthorizationData>();
            peerings ??= new List<ExpressRouteCircuitPeeringData>();

            return new ExpressRouteCircuitData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                sku,
                etag,
                allowClassicOperations,
                circuitProvisioningState,
                serviceProviderProvisioningState,
                authorizations?.ToList(),
                peerings?.ToList(),
                serviceKey,
                serviceProviderNotes,
                serviceProviderProperties,
                expressRoutePortId != null ? ResourceManagerModelFactory.WritableSubResource(expressRoutePortId) : null,
                bandwidthInGbps,
                stag,
                provisioningState,
                gatewayManagerETag,
                globalReachEnabled,
                authorizationKey,
                authorizationStatus,
                enableDirectPortRateLimit);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExpressRouteCircuitsArpTableListResult"/>. </summary>
        /// <param name="value"> A list of the ARP tables. </param>
        /// <param name="nextLink"> The URL to get the next set of results. </param>
        /// <returns> A new <see cref="Models.ExpressRouteCircuitsArpTableListResult"/> instance for mocking. </returns>
        public static ExpressRouteCircuitsArpTableListResult ExpressRouteCircuitsArpTableListResult(IEnumerable<ExpressRouteCircuitArpTable> value = null, string nextLink = null)
        {
            value ??= new List<ExpressRouteCircuitArpTable>();

            return new ExpressRouteCircuitsArpTableListResult(value?.ToList(), nextLink, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExpressRouteCircuitArpTable"/>. </summary>
        /// <param name="age"> Entry age in minutes. </param>
        /// <param name="interface"> Interface address. </param>
        /// <param name="ipAddress"> The IP address. </param>
        /// <param name="macAddress"> The MAC address. </param>
        /// <returns> A new <see cref="Models.ExpressRouteCircuitArpTable"/> instance for mocking. </returns>
        public static ExpressRouteCircuitArpTable ExpressRouteCircuitArpTable(int? age = null, string @interface = null, string ipAddress = null, string macAddress = null)
        {
            return new ExpressRouteCircuitArpTable(age, @interface, ipAddress, macAddress, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExpressRouteCircuitsRoutesTableListResult"/>. </summary>
        /// <param name="value"> The list of routes table. </param>
        /// <param name="nextLink"> The URL to get the next set of results. </param>
        /// <returns> A new <see cref="Models.ExpressRouteCircuitsRoutesTableListResult"/> instance for mocking. </returns>
        public static ExpressRouteCircuitsRoutesTableListResult ExpressRouteCircuitsRoutesTableListResult(IEnumerable<ExpressRouteCircuitRoutesTable> value = null, string nextLink = null)
        {
            value ??= new List<ExpressRouteCircuitRoutesTable>();

            return new ExpressRouteCircuitsRoutesTableListResult(value?.ToList(), nextLink, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExpressRouteCircuitRoutesTable"/>. </summary>
        /// <param name="network"> IP address of a network entity. </param>
        /// <param name="nextHop"> NextHop address. </param>
        /// <param name="locPrf"> Local preference value as set with the set local-preference route-map configuration command. </param>
        /// <param name="weight"> Route Weight. </param>
        /// <param name="path"> Autonomous system paths to the destination network. </param>
        /// <returns> A new <see cref="Models.ExpressRouteCircuitRoutesTable"/> instance for mocking. </returns>
        public static ExpressRouteCircuitRoutesTable ExpressRouteCircuitRoutesTable(string network = null, string nextHop = null, string locPrf = null, int? weight = null, string path = null)
        {
            return new ExpressRouteCircuitRoutesTable(
                network,
                nextHop,
                locPrf,
                weight,
                path,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExpressRouteCircuitsRoutesTableSummaryListResult"/>. </summary>
        /// <param name="value"> A list of the routes table. </param>
        /// <param name="nextLink"> The URL to get the next set of results. </param>
        /// <returns> A new <see cref="Models.ExpressRouteCircuitsRoutesTableSummaryListResult"/> instance for mocking. </returns>
        public static ExpressRouteCircuitsRoutesTableSummaryListResult ExpressRouteCircuitsRoutesTableSummaryListResult(IEnumerable<ExpressRouteCircuitRoutesTableSummary> value = null, string nextLink = null)
        {
            value ??= new List<ExpressRouteCircuitRoutesTableSummary>();

            return new ExpressRouteCircuitsRoutesTableSummaryListResult(value?.ToList(), nextLink, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExpressRouteCircuitRoutesTableSummary"/>. </summary>
        /// <param name="neighbor"> IP address of the neighbor. </param>
        /// <param name="v"> BGP version number spoken to the neighbor. </param>
        /// <param name="as"> Autonomous system number. </param>
        /// <param name="upDown"> The length of time that the BGP session has been in the Established state, or the current status if not in the Established state. </param>
        /// <param name="statePfxRcd"> Current state of the BGP session, and the number of prefixes that have been received from a neighbor or peer group. </param>
        /// <returns> A new <see cref="Models.ExpressRouteCircuitRoutesTableSummary"/> instance for mocking. </returns>
        public static ExpressRouteCircuitRoutesTableSummary ExpressRouteCircuitRoutesTableSummary(string neighbor = null, int? v = null, int? @as = null, string upDown = null, string statePfxRcd = null)
        {
            return new ExpressRouteCircuitRoutesTableSummary(
                neighbor,
                v,
                @as,
                upDown,
                statePfxRcd,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExpressRouteServiceProvider"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="peeringLocations"> A list of peering locations. </param>
        /// <param name="bandwidthsOffered"> A list of bandwidths offered. </param>
        /// <param name="provisioningState"> The provisioning state of the express route service provider resource. </param>
        /// <returns> A new <see cref="Models.ExpressRouteServiceProvider"/> instance for mocking. </returns>
        public static ExpressRouteServiceProvider ExpressRouteServiceProvider(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, IEnumerable<string> peeringLocations = null, IEnumerable<ExpressRouteServiceProviderBandwidthsOffered> bandwidthsOffered = null, NetworkProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            peeringLocations ??= new List<string>();
            bandwidthsOffered ??= new List<ExpressRouteServiceProviderBandwidthsOffered>();

            return new ExpressRouteServiceProvider(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                peeringLocations?.ToList(),
                bandwidthsOffered?.ToList(),
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Network.ExpressRouteCrossConnectionData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="primaryAzurePort"> The name of the primary port. </param>
        /// <param name="secondaryAzurePort"> The name of the secondary port. </param>
        /// <param name="stag"> The identifier of the circuit traffic. </param>
        /// <param name="peeringLocation"> The peering location of the ExpressRoute circuit. </param>
        /// <param name="bandwidthInMbps"> The circuit bandwidth In Mbps. </param>
        /// <param name="expressRouteCircuitId"> The ExpressRouteCircuit. </param>
        /// <param name="serviceProviderProvisioningState"> The provisioning state of the circuit in the connectivity provider system. </param>
        /// <param name="serviceProviderNotes"> Additional read only notes set by the connectivity provider. </param>
        /// <param name="provisioningState"> The provisioning state of the express route cross connection resource. </param>
        /// <param name="peerings"> The list of peerings. </param>
        /// <returns> A new <see cref="Network.ExpressRouteCrossConnectionData"/> instance for mocking. </returns>
        public static ExpressRouteCrossConnectionData ExpressRouteCrossConnectionData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, string primaryAzurePort = null, string secondaryAzurePort = null, int? stag = null, string peeringLocation = null, int? bandwidthInMbps = null, ResourceIdentifier expressRouteCircuitId = null, ServiceProviderProvisioningState? serviceProviderProvisioningState = null, string serviceProviderNotes = null, NetworkProvisioningState? provisioningState = null, IEnumerable<ExpressRouteCrossConnectionPeeringData> peerings = null)
        {
            tags ??= new Dictionary<string, string>();
            peerings ??= new List<ExpressRouteCrossConnectionPeeringData>();

            return new ExpressRouteCrossConnectionData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                primaryAzurePort,
                secondaryAzurePort,
                stag,
                peeringLocation,
                bandwidthInMbps,
                expressRouteCircuitId != null ? ResourceManagerModelFactory.WritableSubResource(expressRouteCircuitId) : null,
                serviceProviderProvisioningState,
                serviceProviderNotes,
                provisioningState,
                peerings?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Network.ExpressRouteCrossConnectionPeeringData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="peeringType"> The peering type. </param>
        /// <param name="state"> The peering state. </param>
        /// <param name="azureASN"> The Azure ASN. </param>
        /// <param name="peerASN"> The peer ASN. </param>
        /// <param name="primaryPeerAddressPrefix"> The primary address prefix. </param>
        /// <param name="secondaryPeerAddressPrefix"> The secondary address prefix. </param>
        /// <param name="primaryAzurePort"> The primary port. </param>
        /// <param name="secondaryAzurePort"> The secondary port. </param>
        /// <param name="sharedKey"> The shared key. </param>
        /// <param name="vlanId"> The VLAN ID. </param>
        /// <param name="microsoftPeeringConfig"> The Microsoft peering configuration. </param>
        /// <param name="provisioningState"> The provisioning state of the express route cross connection peering resource. </param>
        /// <param name="gatewayManagerETag"> The GatewayManager Etag. </param>
        /// <param name="lastModifiedBy"> Who was the last to modify the peering. </param>
        /// <param name="ipv6PeeringConfig"> The IPv6 peering configuration. </param>
        /// <returns> A new <see cref="Network.ExpressRouteCrossConnectionPeeringData"/> instance for mocking. </returns>
        public static ExpressRouteCrossConnectionPeeringData ExpressRouteCrossConnectionPeeringData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, ExpressRoutePeeringType? peeringType = null, ExpressRoutePeeringState? state = null, int? azureASN = null, long? peerASN = null, string primaryPeerAddressPrefix = null, string secondaryPeerAddressPrefix = null, string primaryAzurePort = null, string secondaryAzurePort = null, string sharedKey = null, int? vlanId = null, ExpressRouteCircuitPeeringConfig microsoftPeeringConfig = null, NetworkProvisioningState? provisioningState = null, string gatewayManagerETag = null, string lastModifiedBy = null, IPv6ExpressRouteCircuitPeeringConfig ipv6PeeringConfig = null)
        {
            return new ExpressRouteCrossConnectionPeeringData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                peeringType,
                state,
                azureASN,
                peerASN,
                primaryPeerAddressPrefix,
                secondaryPeerAddressPrefix,
                primaryAzurePort,
                secondaryAzurePort,
                sharedKey,
                vlanId,
                microsoftPeeringConfig,
                provisioningState,
                gatewayManagerETag,
                lastModifiedBy,
                ipv6PeeringConfig);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExpressRouteCrossConnectionsRoutesTableSummaryListResult"/>. </summary>
        /// <param name="value"> A list of the routes table. </param>
        /// <param name="nextLink"> The URL to get the next set of results. </param>
        /// <returns> A new <see cref="Models.ExpressRouteCrossConnectionsRoutesTableSummaryListResult"/> instance for mocking. </returns>
        public static ExpressRouteCrossConnectionsRoutesTableSummaryListResult ExpressRouteCrossConnectionsRoutesTableSummaryListResult(IEnumerable<ExpressRouteCrossConnectionRoutesTableSummary> value = null, string nextLink = null)
        {
            value ??= new List<ExpressRouteCrossConnectionRoutesTableSummary>();

            return new ExpressRouteCrossConnectionsRoutesTableSummaryListResult(value?.ToList(), nextLink, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExpressRouteCrossConnectionRoutesTableSummary"/>. </summary>
        /// <param name="neighbor"> IP address of Neighbor router. </param>
        /// <param name="asn"> Autonomous system number. </param>
        /// <param name="upDown"> The length of time that the BGP session has been in the Established state, or the current status if not in the Established state. </param>
        /// <param name="stateOrPrefixesReceived"> Current state of the BGP session, and the number of prefixes that have been received from a neighbor or peer group. </param>
        /// <returns> A new <see cref="Models.ExpressRouteCrossConnectionRoutesTableSummary"/> instance for mocking. </returns>
        public static ExpressRouteCrossConnectionRoutesTableSummary ExpressRouteCrossConnectionRoutesTableSummary(string neighbor = null, int? asn = null, string upDown = null, string stateOrPrefixesReceived = null)
        {
            return new ExpressRouteCrossConnectionRoutesTableSummary(neighbor, asn, upDown, stateOrPrefixesReceived, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.ExpressRoutePortsLocationData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="address"> Address of peering location. </param>
        /// <param name="contact"> Contact details of peering locations. </param>
        /// <param name="availableBandwidths"> The inventory of available ExpressRoutePort bandwidths. </param>
        /// <param name="provisioningState"> The provisioning state of the express route port location resource. </param>
        /// <returns> A new <see cref="Network.ExpressRoutePortsLocationData"/> instance for mocking. </returns>
        public static ExpressRoutePortsLocationData ExpressRoutePortsLocationData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, string address = null, string contact = null, IEnumerable<ExpressRoutePortsLocationBandwidths> availableBandwidths = null, NetworkProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            availableBandwidths ??= new List<ExpressRoutePortsLocationBandwidths>();

            return new ExpressRoutePortsLocationData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                address,
                contact,
                availableBandwidths?.ToList(),
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExpressRoutePortsLocationBandwidths"/>. </summary>
        /// <param name="offerName"> Bandwidth descriptive name. </param>
        /// <param name="valueInGbps"> Bandwidth value in Gbps. </param>
        /// <returns> A new <see cref="Models.ExpressRoutePortsLocationBandwidths"/> instance for mocking. </returns>
        public static ExpressRoutePortsLocationBandwidths ExpressRoutePortsLocationBandwidths(string offerName = null, int? valueInGbps = null)
        {
            return new ExpressRoutePortsLocationBandwidths(offerName, valueInGbps, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.ExpressRoutePortData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="identity"> The identity of ExpressRoutePort, if configured. </param>
        /// <param name="peeringLocation"> The name of the peering location that the ExpressRoutePort is mapped to physically. </param>
        /// <param name="bandwidthInGbps"> Bandwidth of procured ports in Gbps. </param>
        /// <param name="provisionedBandwidthInGbps"> Aggregate Gbps of associated circuit bandwidths. </param>
        /// <param name="mtu"> Maximum transmission unit of the physical port pair(s). </param>
        /// <param name="encapsulation"> Encapsulation method on physical ports. </param>
        /// <param name="etherType"> Ether type of the physical port. </param>
        /// <param name="allocationDate"> Date of the physical port allocation to be used in Letter of Authorization. </param>
        /// <param name="links"> The set of physical links of the ExpressRoutePort resource. </param>
        /// <param name="circuits"> Reference the ExpressRoute circuit(s) that are provisioned on this ExpressRoutePort resource. </param>
        /// <param name="provisioningState"> The provisioning state of the express route port resource. </param>
        /// <param name="resourceGuid"> The resource GUID property of the express route port resource. </param>
        /// <param name="billingType"> The billing type of the ExpressRoutePort resource. </param>
        /// <returns> A new <see cref="Network.ExpressRoutePortData"/> instance for mocking. </returns>
        public static ExpressRoutePortData ExpressRoutePortData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, ManagedServiceIdentity identity = null, string peeringLocation = null, int? bandwidthInGbps = null, float? provisionedBandwidthInGbps = null, string mtu = null, ExpressRoutePortsEncapsulation? encapsulation = null, string etherType = null, string allocationDate = null, IEnumerable<ExpressRouteLinkData> links = null, IEnumerable<WritableSubResource> circuits = null, NetworkProvisioningState? provisioningState = null, Guid? resourceGuid = null, ExpressRoutePortsBillingType? billingType = null)
        {
            tags ??= new Dictionary<string, string>();
            links ??= new List<ExpressRouteLinkData>();
            circuits ??= new List<WritableSubResource>();

            return new ExpressRoutePortData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                identity,
                peeringLocation,
                bandwidthInGbps,
                provisionedBandwidthInGbps,
                mtu,
                encapsulation,
                etherType,
                allocationDate,
                links?.ToList(),
                circuits?.ToList(),
                provisioningState,
                resourceGuid,
                billingType);
        }

        /// <summary> Initializes a new instance of <see cref="Network.ExpressRouteLinkData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="routerName"> Name of Azure router associated with physical port. </param>
        /// <param name="interfaceName"> Name of Azure router interface. </param>
        /// <param name="patchPanelId"> Mapping between physical port to patch panel port. </param>
        /// <param name="rackId"> Mapping of physical patch panel to rack. </param>
        /// <param name="coloLocation"> Cololocation for ExpressRoute Hybrid Direct. </param>
        /// <param name="connectorType"> Physical fiber port type. </param>
        /// <param name="adminState"> Administrative state of the physical port. </param>
        /// <param name="provisioningState"> The provisioning state of the express route link resource. </param>
        /// <param name="macSecConfig"> MacSec configuration. </param>
        /// <returns> A new <see cref="Network.ExpressRouteLinkData"/> instance for mocking. </returns>
        public static ExpressRouteLinkData ExpressRouteLinkData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, string routerName = null, string interfaceName = null, string patchPanelId = null, string rackId = null, string coloLocation = null, ExpressRouteLinkConnectorType? connectorType = null, ExpressRouteLinkAdminState? adminState = null, NetworkProvisioningState? provisioningState = null, ExpressRouteLinkMacSecConfig macSecConfig = null)
        {
            return new ExpressRouteLinkData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                routerName,
                interfaceName,
                patchPanelId,
                rackId,
                coloLocation,
                connectorType,
                adminState,
                provisioningState,
                macSecConfig);
        }

        /// <summary> Initializes a new instance of <see cref="Models.GenerateExpressRoutePortsLoaResult"/>. </summary>
        /// <param name="encodedContent"> The content as a base64 encoded string. </param>
        /// <returns> A new <see cref="Models.GenerateExpressRoutePortsLoaResult"/> instance for mocking. </returns>
        public static GenerateExpressRoutePortsLoaResult GenerateExpressRoutePortsLoaResult(string encodedContent = null)
        {
            return new GenerateExpressRoutePortsLoaResult(encodedContent, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.ExpressRoutePortAuthorizationData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="authorizationKey"> The authorization key. </param>
        /// <param name="authorizationUseStatus"> The authorization use status. </param>
        /// <param name="circuitResourceUri"> The reference to the ExpressRoute circuit resource using the authorization. </param>
        /// <param name="provisioningState"> The provisioning state of the authorization resource. </param>
        /// <returns> A new <see cref="Network.ExpressRoutePortAuthorizationData"/> instance for mocking. </returns>
        public static ExpressRoutePortAuthorizationData ExpressRoutePortAuthorizationData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, string authorizationKey = null, ExpressRoutePortAuthorizationUseStatus? authorizationUseStatus = null, Uri circuitResourceUri = null, NetworkProvisioningState? provisioningState = null)
        {
            return new ExpressRoutePortAuthorizationData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                authorizationKey,
                authorizationUseStatus,
                circuitResourceUri,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Network.ExpressRouteProviderPortData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="portPairDescriptor"> The name of the port pair. </param>
        /// <param name="primaryAzurePort"> The name of the primary port. </param>
        /// <param name="secondaryAzurePort"> The name of the secondary port. </param>
        /// <param name="peeringLocation"> The peering location of the port pair. </param>
        /// <param name="overprovisionFactor"> Overprovisioning factor for the port pair. </param>
        /// <param name="portBandwidthInMbps"> Bandwidth of the port in Mbps. </param>
        /// <param name="usedBandwidthInMbps"> Used Bandwidth of the port in Mbps. </param>
        /// <param name="remainingBandwidthInMbps"> Remaining Bandwidth of the port in Mbps. </param>
        /// <returns> A new <see cref="Network.ExpressRouteProviderPortData"/> instance for mocking. </returns>
        public static ExpressRouteProviderPortData ExpressRouteProviderPortData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ETag? etag = null, string portPairDescriptor = null, string primaryAzurePort = null, string secondaryAzurePort = null, string peeringLocation = null, int? overprovisionFactor = null, int? portBandwidthInMbps = null, int? usedBandwidthInMbps = null, int? remainingBandwidthInMbps = null)
        {
            tags ??= new Dictionary<string, string>();

            return new ExpressRouteProviderPortData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                etag,
                portPairDescriptor,
                primaryAzurePort,
                secondaryAzurePort,
                peeringLocation,
                overprovisionFactor,
                portBandwidthInMbps,
                usedBandwidthInMbps,
                remainingBandwidthInMbps,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.FirewallPolicyData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="identity"> The identity of the firewall policy. </param>
        /// <param name="size"> A read-only string that represents the size of the FirewallPolicyPropertiesFormat in MB. (ex 0.5MB). </param>
        /// <param name="ruleCollectionGroups"> List of references to FirewallPolicyRuleCollectionGroups. </param>
        /// <param name="provisioningState"> The provisioning state of the firewall policy resource. </param>
        /// <param name="basePolicyId"> The parent firewall policy from which rules are inherited. </param>
        /// <param name="firewalls"> List of references to Azure Firewalls that this Firewall Policy is associated with. </param>
        /// <param name="childPolicies"> List of references to Child Firewall Policies. </param>
        /// <param name="threatIntelMode"> The operation mode for Threat Intelligence. </param>
        /// <param name="threatIntelWhitelist"> ThreatIntel Whitelist for Firewall Policy. </param>
        /// <param name="insights"> Insights on Firewall Policy. </param>
        /// <param name="snat"> The private IP addresses/IP ranges to which traffic will not be SNAT. </param>
        /// <param name="allowSqlRedirect"> SQL Settings definition. </param>
        /// <param name="dnsSettings"> DNS Proxy Settings definition. </param>
        /// <param name="explicitProxy"> Explicit Proxy Settings definition. </param>
        /// <param name="intrusionDetection"> The configuration for Intrusion detection. </param>
        /// <param name="transportSecurityCertificateAuthority"> TLS Configuration definition. </param>
        /// <param name="skuTier"> The Firewall Policy SKU. </param>
        /// <returns> A new <see cref="Network.FirewallPolicyData"/> instance for mocking. </returns>
        public static FirewallPolicyData FirewallPolicyData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, ManagedServiceIdentity identity = null, string size = null, IEnumerable<WritableSubResource> ruleCollectionGroups = null, NetworkProvisioningState? provisioningState = null, ResourceIdentifier basePolicyId = null, IEnumerable<WritableSubResource> firewalls = null, IEnumerable<WritableSubResource> childPolicies = null, AzureFirewallThreatIntelMode? threatIntelMode = null, FirewallPolicyThreatIntelWhitelist threatIntelWhitelist = null, FirewallPolicyInsights insights = null, FirewallPolicySnat snat = null, bool? allowSqlRedirect = null, DnsSettings dnsSettings = null, FirewallPolicyExplicitProxy explicitProxy = null, FirewallPolicyIntrusionDetection intrusionDetection = null, FirewallPolicyCertificateAuthority transportSecurityCertificateAuthority = null, FirewallPolicySkuTier? skuTier = null)
        {
            tags ??= new Dictionary<string, string>();
            ruleCollectionGroups ??= new List<WritableSubResource>();
            firewalls ??= new List<WritableSubResource>();
            childPolicies ??= new List<WritableSubResource>();

            return new FirewallPolicyData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                identity,
                size,
                ruleCollectionGroups?.ToList(),
                provisioningState,
                basePolicyId != null ? ResourceManagerModelFactory.WritableSubResource(basePolicyId) : null,
                firewalls?.ToList(),
                childPolicies?.ToList(),
                threatIntelMode,
                threatIntelWhitelist,
                insights,
                snat,
                allowSqlRedirect != null ? new FirewallPolicySQL(allowSqlRedirect, serializedAdditionalRawData: null) : null,
                dnsSettings,
                explicitProxy,
                intrusionDetection,
                transportSecurityCertificateAuthority != null ? new FirewallPolicyTransportSecurity(transportSecurityCertificateAuthority, serializedAdditionalRawData: null) : null,
                skuTier != null ? new FirewallPolicySku(skuTier, serializedAdditionalRawData: null) : null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.FirewallPolicyRuleCollectionGroupData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="size"> A read-only string that represents the size of the FirewallPolicyRuleCollectionGroupProperties in MB. (ex 1.2MB). </param>
        /// <param name="priority"> Priority of the Firewall Policy Rule Collection Group resource. </param>
        /// <param name="ruleCollections">
        /// Group of Firewall Policy rule collections.
        /// Please note <see cref="FirewallPolicyRuleCollectionInfo"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="FirewallPolicyFilterRuleCollectionInfo"/> and <see cref="FirewallPolicyNatRuleCollectionInfo"/>.
        /// </param>
        /// <param name="provisioningState"> The provisioning state of the firewall policy rule collection group resource. </param>
        /// <returns> A new <see cref="Network.FirewallPolicyRuleCollectionGroupData"/> instance for mocking. </returns>
        public static FirewallPolicyRuleCollectionGroupData FirewallPolicyRuleCollectionGroupData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, string size = null, int? priority = null, IEnumerable<FirewallPolicyRuleCollectionInfo> ruleCollections = null, NetworkProvisioningState? provisioningState = null)
        {
            ruleCollections ??= new List<FirewallPolicyRuleCollectionInfo>();

            return new FirewallPolicyRuleCollectionGroupData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                size,
                priority,
                ruleCollections?.ToList(),
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IdpsSignatureListResult"/>. </summary>
        /// <param name="matchingRecordsCount"> Number of total records matching the query. </param>
        /// <param name="signatures"> Array containing the results of the query. </param>
        /// <returns> A new <see cref="Models.IdpsSignatureListResult"/> instance for mocking. </returns>
        public static IdpsSignatureListResult IdpsSignatureListResult(long? matchingRecordsCount = null, IEnumerable<IdpsSignatureResult> signatures = null)
        {
            signatures ??= new List<IdpsSignatureResult>();

            return new IdpsSignatureListResult(matchingRecordsCount, signatures?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IdpsSignatureResult"/>. </summary>
        /// <param name="signatureId"> The ID of the signature. </param>
        /// <param name="mode"> The current mode enforced, 0 - Disabled, 1 - Alert, 2 -Deny. </param>
        /// <param name="severity"> Describes the severity of signature: 1 - High, 2 - Medium, 3 - Low. </param>
        /// <param name="direction"> Describes in which direction signature is being enforced: 0 - OutBound, 1 - InBound, 2 - Any, 3 - Internal, 4 - InternalOutbound. </param>
        /// <param name="group"> Describes the groups the signature belongs to. </param>
        /// <param name="description"> Describes what is the signature enforces. </param>
        /// <param name="protocol"> Describes the protocol the signatures is being enforced in. </param>
        /// <param name="sourcePorts"> Describes the list of source ports related to this signature. </param>
        /// <param name="destinationPorts"> Describes the list of destination ports related to this signature. </param>
        /// <param name="lastUpdated"> Describes the last updated time of the signature (provided from 3rd party vendor). </param>
        /// <param name="inheritedFromParentPolicy"> Describes if this override is inherited from base policy or not. </param>
        /// <returns> A new <see cref="Models.IdpsSignatureResult"/> instance for mocking. </returns>
        public static IdpsSignatureResult IdpsSignatureResult(int? signatureId = null, FirewallPolicyIdpsSignatureMode? mode = null, FirewallPolicyIdpsSignatureSeverity? severity = null, FirewallPolicyIdpsSignatureDirection? direction = null, string group = null, string description = null, string protocol = null, IEnumerable<string> sourcePorts = null, IEnumerable<string> destinationPorts = null, string lastUpdated = null, bool? inheritedFromParentPolicy = null)
        {
            sourcePorts ??= new List<string>();
            destinationPorts ??= new List<string>();

            return new IdpsSignatureResult(
                signatureId,
                mode,
                severity,
                direction,
                group,
                description,
                protocol,
                sourcePorts?.ToList(),
                destinationPorts?.ToList(),
                lastUpdated,
                inheritedFromParentPolicy,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SignatureOverridesFilterValuesResult"/>. </summary>
        /// <param name="filterValues"> Describes the possible values. </param>
        /// <returns> A new <see cref="Models.SignatureOverridesFilterValuesResult"/> instance for mocking. </returns>
        public static SignatureOverridesFilterValuesResult SignatureOverridesFilterValuesResult(IEnumerable<string> filterValues = null)
        {
            filterValues ??= new List<string>();

            return new SignatureOverridesFilterValuesResult(filterValues?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.FirewallPolicyDraftData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="basePolicyId"> The parent firewall policy from which rules are inherited. </param>
        /// <param name="threatIntelMode"> The operation mode for Threat Intelligence. </param>
        /// <param name="threatIntelWhitelist"> ThreatIntel Whitelist for Firewall Policy. </param>
        /// <param name="insights"> Insights on Firewall Policy. </param>
        /// <param name="snat"> The private IP addresses/IP ranges to which traffic will not be SNAT. </param>
        /// <param name="allowSqlRedirect"> SQL Settings definition. </param>
        /// <param name="dnsSettings"> DNS Proxy Settings definition. </param>
        /// <param name="explicitProxy"> Explicit Proxy Settings definition. </param>
        /// <param name="intrusionDetection"> The configuration for Intrusion detection. </param>
        /// <returns> A new <see cref="Network.FirewallPolicyDraftData"/> instance for mocking. </returns>
        public static FirewallPolicyDraftData FirewallPolicyDraftData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ResourceIdentifier basePolicyId = null, AzureFirewallThreatIntelMode? threatIntelMode = null, FirewallPolicyThreatIntelWhitelist threatIntelWhitelist = null, FirewallPolicyInsights insights = null, FirewallPolicySnat snat = null, bool? allowSqlRedirect = null, DnsSettings dnsSettings = null, FirewallPolicyExplicitProxy explicitProxy = null, FirewallPolicyIntrusionDetection intrusionDetection = null)
        {
            tags ??= new Dictionary<string, string>();

            return new FirewallPolicyDraftData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                basePolicyId != null ? ResourceManagerModelFactory.WritableSubResource(basePolicyId) : null,
                threatIntelMode,
                threatIntelWhitelist,
                insights,
                snat,
                allowSqlRedirect != null ? new FirewallPolicySQL(allowSqlRedirect, serializedAdditionalRawData: null) : null,
                dnsSettings,
                explicitProxy,
                intrusionDetection);
        }

        /// <summary> Initializes a new instance of <see cref="Network.FirewallPolicyRuleCollectionGroupDraftData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="size"> A read-only string that represents the size of the FirewallPolicyRuleCollectionGroupProperties in MB. (ex 1.2MB). </param>
        /// <param name="priority"> Priority of the Firewall Policy Rule Collection Group resource. </param>
        /// <param name="ruleCollections">
        /// Group of Firewall Policy rule collections.
        /// Please note <see cref="FirewallPolicyRuleCollectionInfo"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="FirewallPolicyFilterRuleCollectionInfo"/> and <see cref="FirewallPolicyNatRuleCollectionInfo"/>.
        /// </param>
        /// <returns> A new <see cref="Network.FirewallPolicyRuleCollectionGroupDraftData"/> instance for mocking. </returns>
        public static FirewallPolicyRuleCollectionGroupDraftData FirewallPolicyRuleCollectionGroupDraftData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, string size = null, int? priority = null, IEnumerable<FirewallPolicyRuleCollectionInfo> ruleCollections = null)
        {
            ruleCollections ??= new List<FirewallPolicyRuleCollectionInfo>();

            return new FirewallPolicyRuleCollectionGroupDraftData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                size,
                priority,
                ruleCollections?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Network.IPAllocationData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="subnetId"> The Subnet that using the prefix of this IpAllocation resource. </param>
        /// <param name="virtualNetworkId"> The VirtualNetwork that using the prefix of this IpAllocation resource. </param>
        /// <param name="ipAllocationType"> The type for the IpAllocation. </param>
        /// <param name="prefix"> The address prefix for the IpAllocation. </param>
        /// <param name="prefixLength"> The address prefix length for the IpAllocation. </param>
        /// <param name="prefixType"> The address prefix Type for the IpAllocation. </param>
        /// <param name="ipamAllocationId"> The IPAM allocation ID. </param>
        /// <param name="allocationTags"> IpAllocation tags. </param>
        /// <returns> A new <see cref="Network.IPAllocationData"/> instance for mocking. </returns>
        public static IPAllocationData IPAllocationData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, ResourceIdentifier subnetId = null, ResourceIdentifier virtualNetworkId = null, NetworkIPAllocationType? ipAllocationType = null, string prefix = null, int? prefixLength = null, NetworkIPVersion? prefixType = null, string ipamAllocationId = null, IDictionary<string, string> allocationTags = null)
        {
            tags ??= new Dictionary<string, string>();
            allocationTags ??= new Dictionary<string, string>();

            return new IPAllocationData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                subnetId != null ? ResourceManagerModelFactory.WritableSubResource(subnetId) : null,
                virtualNetworkId != null ? ResourceManagerModelFactory.WritableSubResource(virtualNetworkId) : null,
                ipAllocationType,
                prefix,
                prefixLength,
                prefixType,
                ipamAllocationId,
                allocationTags);
        }

        /// <summary> Initializes a new instance of <see cref="Network.IPGroupData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="provisioningState"> The provisioning state of the IpGroups resource. </param>
        /// <param name="ipAddresses"> IpAddresses/IpAddressPrefixes in the IpGroups resource. </param>
        /// <param name="firewalls"> List of references to Firewall resources that this IpGroups is associated with. </param>
        /// <param name="firewallPolicies"> List of references to Firewall Policies resources that this IpGroups is associated with. </param>
        /// <returns> A new <see cref="Network.IPGroupData"/> instance for mocking. </returns>
        public static IPGroupData IPGroupData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, NetworkProvisioningState? provisioningState = null, IEnumerable<string> ipAddresses = null, IEnumerable<WritableSubResource> firewalls = null, IEnumerable<WritableSubResource> firewallPolicies = null)
        {
            tags ??= new Dictionary<string, string>();
            ipAddresses ??= new List<string>();
            firewalls ??= new List<WritableSubResource>();
            firewallPolicies ??= new List<WritableSubResource>();

            return new IPGroupData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                provisioningState,
                ipAddresses?.ToList(),
                firewalls?.ToList(),
                firewallPolicies?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Network.LoadBalancerData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="extendedLocation"> The extended location of the load balancer. </param>
        /// <param name="sku"> The load balancer SKU. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="frontendIPConfigurations"> Object representing the frontend IPs to be used for the load balancer. </param>
        /// <param name="backendAddressPools"> Collection of backend address pools used by a load balancer. </param>
        /// <param name="loadBalancingRules"> Object collection representing the load balancing rules Gets the provisioning. </param>
        /// <param name="probes"> Collection of probe objects used in the load balancer. </param>
        /// <param name="inboundNatRules"> Collection of inbound NAT Rules used by a load balancer. Defining inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an Inbound NAT pool. They have to reference individual inbound NAT rules. </param>
        /// <param name="inboundNatPools"> Defines an external port range for inbound NAT to a single backend port on NICs associated with a load balancer. Inbound NAT rules are created automatically for each NIC associated with the Load Balancer using an external port from this range. Defining an Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound NAT rules. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an inbound NAT pool. They have to reference individual inbound NAT rules. </param>
        /// <param name="outboundRules"> The outbound rules. </param>
        /// <param name="resourceGuid"> The resource GUID property of the load balancer resource. </param>
        /// <param name="provisioningState"> The provisioning state of the load balancer resource. </param>
        /// <returns> A new <see cref="Network.LoadBalancerData"/> instance for mocking. </returns>
        public static LoadBalancerData LoadBalancerData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ExtendedLocation extendedLocation = null, LoadBalancerSku sku = null, ETag? etag = null, IEnumerable<FrontendIPConfigurationData> frontendIPConfigurations = null, IEnumerable<BackendAddressPoolData> backendAddressPools = null, IEnumerable<LoadBalancingRuleData> loadBalancingRules = null, IEnumerable<ProbeData> probes = null, IEnumerable<InboundNatRuleData> inboundNatRules = null, IEnumerable<LoadBalancerInboundNatPool> inboundNatPools = null, IEnumerable<OutboundRuleData> outboundRules = null, Guid? resourceGuid = null, NetworkProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            frontendIPConfigurations ??= new List<FrontendIPConfigurationData>();
            backendAddressPools ??= new List<BackendAddressPoolData>();
            loadBalancingRules ??= new List<LoadBalancingRuleData>();
            probes ??= new List<ProbeData>();
            inboundNatRules ??= new List<InboundNatRuleData>();
            inboundNatPools ??= new List<LoadBalancerInboundNatPool>();
            outboundRules ??= new List<OutboundRuleData>();

            return new LoadBalancerData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                extendedLocation,
                sku,
                etag,
                frontendIPConfigurations?.ToList(),
                backendAddressPools?.ToList(),
                loadBalancingRules?.ToList(),
                probes?.ToList(),
                inboundNatRules?.ToList(),
                inboundNatPools?.ToList(),
                outboundRules?.ToList(),
                resourceGuid,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Network.LoadBalancingRuleData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="frontendIPConfigurationId"> A reference to frontend IP addresses. </param>
        /// <param name="backendAddressPoolId"> A reference to a pool of DIPs. Inbound traffic is randomly load balanced across IPs in the backend IPs. </param>
        /// <param name="backendAddressPools"> An array of references to pool of DIPs. </param>
        /// <param name="probeId"> The reference to the load balancer probe used by the load balancing rule. </param>
        /// <param name="protocol"> The reference to the transport protocol used by the load balancing rule. </param>
        /// <param name="loadDistribution"> The load distribution policy for this rule. </param>
        /// <param name="frontendPort"> The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 0 and 65534. Note that value 0 enables "Any Port". </param>
        /// <param name="backendPort"> The port used for internal connections on the endpoint. Acceptable values are between 0 and 65535. Note that value 0 enables "Any Port". </param>
        /// <param name="idleTimeoutInMinutes"> The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP. </param>
        /// <param name="enableFloatingIP"> Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint. </param>
        /// <param name="enableTcpReset"> Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP. </param>
        /// <param name="disableOutboundSnat"> Configures SNAT for the VMs in the backend pool to use the publicIP address specified in the frontend of the load balancing rule. </param>
        /// <param name="provisioningState"> The provisioning state of the load balancing rule resource. </param>
        /// <returns> A new <see cref="Network.LoadBalancingRuleData"/> instance for mocking. </returns>
        public static LoadBalancingRuleData LoadBalancingRuleData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, ResourceIdentifier frontendIPConfigurationId = null, ResourceIdentifier backendAddressPoolId = null, IEnumerable<WritableSubResource> backendAddressPools = null, ResourceIdentifier probeId = null, LoadBalancingTransportProtocol? protocol = null, LoadDistribution? loadDistribution = null, int? frontendPort = null, int? backendPort = null, int? idleTimeoutInMinutes = null, bool? enableFloatingIP = null, bool? enableTcpReset = null, bool? disableOutboundSnat = null, NetworkProvisioningState? provisioningState = null)
        {
            backendAddressPools ??= new List<WritableSubResource>();

            return new LoadBalancingRuleData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                frontendIPConfigurationId != null ? ResourceManagerModelFactory.WritableSubResource(frontendIPConfigurationId) : null,
                backendAddressPoolId != null ? ResourceManagerModelFactory.WritableSubResource(backendAddressPoolId) : null,
                backendAddressPools?.ToList(),
                probeId != null ? ResourceManagerModelFactory.WritableSubResource(probeId) : null,
                protocol,
                loadDistribution,
                frontendPort,
                backendPort,
                idleTimeoutInMinutes,
                enableFloatingIP,
                enableTcpReset,
                disableOutboundSnat,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Network.ProbeData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="loadBalancingRules"> The load balancer rules that use this probe. </param>
        /// <param name="protocol"> The protocol of the end point. If 'Tcp' is specified, a received ACK is required for the probe to be successful. If 'Http' or 'Https' is specified, a 200 OK response from the specifies URI is required for the probe to be successful. </param>
        /// <param name="port"> The port for communicating the probe. Possible values range from 1 to 65535, inclusive. </param>
        /// <param name="intervalInSeconds"> The interval, in seconds, for how frequently to probe the endpoint for health status. Typically, the interval is slightly less than half the allocated timeout period (in seconds) which allows two full probes before taking the instance out of rotation. The default value is 15, the minimum value is 5. </param>
        /// <param name="noHealthyBackendsBehavior"> Determines how new connections are handled by the load balancer when all backend instances are probed down. </param>
        /// <param name="numberOfProbes"> The number of probes where if no response, will result in stopping further traffic from being delivered to the endpoint. This values allows endpoints to be taken out of rotation faster or slower than the typical times used in Azure. </param>
        /// <param name="probeThreshold"> The number of consecutive successful or failed probes in order to allow or deny traffic from being delivered to this endpoint. After failing the number of consecutive probes equal to this value, the endpoint will be taken out of rotation and require the same number of successful consecutive probes to be placed back in rotation. </param>
        /// <param name="requestPath"> The URI used for requesting health status from the VM. Path is required if a protocol is set to http. Otherwise, it is not allowed. There is no default value. </param>
        /// <param name="provisioningState"> The provisioning state of the probe resource. </param>
        /// <returns> A new <see cref="Network.ProbeData"/> instance for mocking. </returns>
        public static ProbeData ProbeData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, IEnumerable<WritableSubResource> loadBalancingRules = null, ProbeProtocol? protocol = null, int? port = null, int? intervalInSeconds = null, ProbeNoHealthyBackendsBehavior? noHealthyBackendsBehavior = null, int? numberOfProbes = null, int? probeThreshold = null, string requestPath = null, NetworkProvisioningState? provisioningState = null)
        {
            loadBalancingRules ??= new List<WritableSubResource>();

            return new ProbeData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                loadBalancingRules?.ToList(),
                protocol,
                port,
                intervalInSeconds,
                noHealthyBackendsBehavior,
                numberOfProbes,
                probeThreshold,
                requestPath,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LoadBalancerInboundNatPool"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="frontendIPConfigurationId"> A reference to frontend IP addresses. </param>
        /// <param name="protocol"> The reference to the transport protocol used by the inbound NAT pool. </param>
        /// <param name="frontendPortRangeStart"> The first port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65534. </param>
        /// <param name="frontendPortRangeEnd"> The last port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65535. </param>
        /// <param name="backendPort"> The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535. </param>
        /// <param name="idleTimeoutInMinutes"> The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP. </param>
        /// <param name="enableFloatingIP"> Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint. </param>
        /// <param name="enableTcpReset"> Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP. </param>
        /// <param name="provisioningState"> The provisioning state of the inbound NAT pool resource. </param>
        /// <returns> A new <see cref="Models.LoadBalancerInboundNatPool"/> instance for mocking. </returns>
        public static LoadBalancerInboundNatPool LoadBalancerInboundNatPool(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, ResourceIdentifier frontendIPConfigurationId = null, LoadBalancingTransportProtocol? protocol = null, int? frontendPortRangeStart = null, int? frontendPortRangeEnd = null, int? backendPort = null, int? idleTimeoutInMinutes = null, bool? enableFloatingIP = null, bool? enableTcpReset = null, NetworkProvisioningState? provisioningState = null)
        {
            return new LoadBalancerInboundNatPool(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                frontendIPConfigurationId != null ? ResourceManagerModelFactory.WritableSubResource(frontendIPConfigurationId) : null,
                protocol,
                frontendPortRangeStart,
                frontendPortRangeEnd,
                backendPort,
                idleTimeoutInMinutes,
                enableFloatingIP,
                enableTcpReset,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Network.OutboundRuleData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="allocatedOutboundPorts"> The number of outbound ports to be used for NAT. </param>
        /// <param name="frontendIPConfigurations"> The Frontend IP addresses of the load balancer. </param>
        /// <param name="backendAddressPoolId"> A reference to a pool of DIPs. Outbound traffic is randomly load balanced across IPs in the backend IPs. </param>
        /// <param name="provisioningState"> The provisioning state of the outbound rule resource. </param>
        /// <param name="protocol"> The protocol for the outbound rule in load balancer. </param>
        /// <param name="enableTcpReset"> Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP. </param>
        /// <param name="idleTimeoutInMinutes"> The timeout for the TCP idle connection. </param>
        /// <returns> A new <see cref="Network.OutboundRuleData"/> instance for mocking. </returns>
        public static OutboundRuleData OutboundRuleData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, int? allocatedOutboundPorts = null, IEnumerable<WritableSubResource> frontendIPConfigurations = null, ResourceIdentifier backendAddressPoolId = null, NetworkProvisioningState? provisioningState = null, LoadBalancerOutboundRuleProtocol? protocol = null, bool? enableTcpReset = null, int? idleTimeoutInMinutes = null)
        {
            frontendIPConfigurations ??= new List<WritableSubResource>();

            return new OutboundRuleData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                allocatedOutboundPorts,
                frontendIPConfigurations?.ToList(),
                backendAddressPoolId != null ? ResourceManagerModelFactory.WritableSubResource(backendAddressPoolId) : null,
                provisioningState,
                protocol,
                enableTcpReset,
                idleTimeoutInMinutes);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BackendAddressInboundNatRulePortMappings"/>. </summary>
        /// <param name="inboundNatRulePortMappings"> Collection of inbound NAT rule port mappings. </param>
        /// <returns> A new <see cref="Models.BackendAddressInboundNatRulePortMappings"/> instance for mocking. </returns>
        public static BackendAddressInboundNatRulePortMappings BackendAddressInboundNatRulePortMappings(IEnumerable<InboundNatRulePortMapping> inboundNatRulePortMappings = null)
        {
            inboundNatRulePortMappings ??= new List<InboundNatRulePortMapping>();

            return new BackendAddressInboundNatRulePortMappings(inboundNatRulePortMappings?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InboundNatRulePortMapping"/>. </summary>
        /// <param name="inboundNatRuleName"> Name of inbound NAT rule. </param>
        /// <param name="protocol"> The reference to the transport protocol used by the inbound NAT rule. </param>
        /// <param name="frontendPort"> Frontend port. </param>
        /// <param name="backendPort"> Backend port. </param>
        /// <returns> A new <see cref="Models.InboundNatRulePortMapping"/> instance for mocking. </returns>
        public static InboundNatRulePortMapping InboundNatRulePortMapping(string inboundNatRuleName = null, LoadBalancingTransportProtocol? protocol = null, int? frontendPort = null, int? backendPort = null)
        {
            return new InboundNatRulePortMapping(inboundNatRuleName, protocol, frontendPort, backendPort, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateLoadBalancerToIPBasedResult"/>. </summary>
        /// <param name="migratedPools"> A list of pools migrated from Nic based to IP based pool. </param>
        /// <returns> A new <see cref="Models.MigrateLoadBalancerToIPBasedResult"/> instance for mocking. </returns>
        public static MigrateLoadBalancerToIPBasedResult MigrateLoadBalancerToIPBasedResult(IEnumerable<string> migratedPools = null)
        {
            migratedPools ??= new List<string>();

            return new MigrateLoadBalancerToIPBasedResult(migratedPools?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EffectiveRouteListResult"/>. </summary>
        /// <param name="value"> A list of effective routes. </param>
        /// <param name="nextLink"> The URL to get the next set of results. </param>
        /// <returns> A new <see cref="Models.EffectiveRouteListResult"/> instance for mocking. </returns>
        public static EffectiveRouteListResult EffectiveRouteListResult(IEnumerable<EffectiveRoute> value = null, string nextLink = null)
        {
            value ??= new List<EffectiveRoute>();

            return new EffectiveRouteListResult(value?.ToList(), nextLink, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EffectiveRoute"/>. </summary>
        /// <param name="name"> The name of the user defined route. This is optional. </param>
        /// <param name="disableBgpRoutePropagation"> If true, on-premises routes are not propagated to the network interfaces in the subnet. </param>
        /// <param name="source"> Who created the route. </param>
        /// <param name="state"> The value of effective route. </param>
        /// <param name="addressPrefix"> The address prefixes of the effective routes in CIDR notation. </param>
        /// <param name="nextHopIPAddress"> The IP address of the next hop of the effective route. </param>
        /// <param name="nextHopType"> The type of Azure hop the packet should be sent to. </param>
        /// <returns> A new <see cref="Models.EffectiveRoute"/> instance for mocking. </returns>
        public static EffectiveRoute EffectiveRoute(string name = null, bool? disableBgpRoutePropagation = null, EffectiveRouteSource? source = null, EffectiveRouteState? state = null, IEnumerable<string> addressPrefix = null, IEnumerable<string> nextHopIPAddress = null, RouteNextHopType? nextHopType = null)
        {
            addressPrefix ??= new List<string>();
            nextHopIPAddress ??= new List<string>();

            return new EffectiveRoute(
                name,
                disableBgpRoutePropagation,
                source,
                state,
                addressPrefix?.ToList(),
                nextHopIPAddress?.ToList(),
                nextHopType,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EffectiveNetworkSecurityGroupListResult"/>. </summary>
        /// <param name="value"> A list of effective network security groups. </param>
        /// <param name="nextLink"> The URL to get the next set of results. </param>
        /// <returns> A new <see cref="Models.EffectiveNetworkSecurityGroupListResult"/> instance for mocking. </returns>
        public static EffectiveNetworkSecurityGroupListResult EffectiveNetworkSecurityGroupListResult(IEnumerable<EffectiveNetworkSecurityGroup> value = null, string nextLink = null)
        {
            value ??= new List<EffectiveNetworkSecurityGroup>();

            return new EffectiveNetworkSecurityGroupListResult(value?.ToList(), nextLink, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EffectiveNetworkSecurityGroup"/>. </summary>
        /// <param name="networkSecurityGroupId"> The ID of network security group that is applied. </param>
        /// <param name="association"> Associated resources. </param>
        /// <param name="effectiveSecurityRules"> A collection of effective security rules. </param>
        /// <param name="tagToIPAddresses"> Mapping of tags to list of IP Addresses included within the tag. </param>
        /// <returns> A new <see cref="Models.EffectiveNetworkSecurityGroup"/> instance for mocking. </returns>
        public static EffectiveNetworkSecurityGroup EffectiveNetworkSecurityGroup(ResourceIdentifier networkSecurityGroupId = null, EffectiveNetworkSecurityGroupAssociation association = null, IEnumerable<EffectiveNetworkSecurityRule> effectiveSecurityRules = null, IReadOnlyDictionary<string, IList<string>> tagToIPAddresses = null)
        {
            effectiveSecurityRules ??= new List<EffectiveNetworkSecurityRule>();
            tagToIPAddresses ??= new Dictionary<string, IList<string>>();

            return new EffectiveNetworkSecurityGroup(networkSecurityGroupId != null ? ResourceManagerModelFactory.WritableSubResource(networkSecurityGroupId) : null, association, effectiveSecurityRules?.ToList(), tagToIPAddresses, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EffectiveNetworkSecurityGroupAssociation"/>. </summary>
        /// <param name="networkManagerId"> The ID of the Azure network manager if assigned. </param>
        /// <param name="subnetId"> The ID of the subnet if assigned. </param>
        /// <param name="networkInterfaceId"> The ID of the network interface if assigned. </param>
        /// <returns> A new <see cref="Models.EffectiveNetworkSecurityGroupAssociation"/> instance for mocking. </returns>
        public static EffectiveNetworkSecurityGroupAssociation EffectiveNetworkSecurityGroupAssociation(ResourceIdentifier networkManagerId = null, ResourceIdentifier subnetId = null, ResourceIdentifier networkInterfaceId = null)
        {
            return new EffectiveNetworkSecurityGroupAssociation(networkManagerId != null ? ResourceManagerModelFactory.WritableSubResource(networkManagerId) : null, subnetId != null ? ResourceManagerModelFactory.WritableSubResource(subnetId) : null, networkInterfaceId != null ? ResourceManagerModelFactory.WritableSubResource(networkInterfaceId) : null, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EffectiveNetworkSecurityRule"/>. </summary>
        /// <param name="name"> The name of the security rule specified by the user (if created by the user). </param>
        /// <param name="protocol"> The network protocol this rule applies to. </param>
        /// <param name="sourcePortRange"> The source port or range. </param>
        /// <param name="destinationPortRange"> The destination port or range. </param>
        /// <param name="sourcePortRanges"> The source port ranges. Expected values include a single integer between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*). </param>
        /// <param name="destinationPortRanges"> The destination port ranges. Expected values include a single integer between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*). </param>
        /// <param name="sourceAddressPrefix"> The source address prefix. </param>
        /// <param name="destinationAddressPrefix"> The destination address prefix. </param>
        /// <param name="sourceAddressPrefixes"> The source address prefixes. Expected values include CIDR IP ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System Tags, and the asterisk (*). </param>
        /// <param name="destinationAddressPrefixes"> The destination address prefixes. Expected values include CIDR IP ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System Tags, and the asterisk (*). </param>
        /// <param name="expandedSourceAddressPrefix"> The expanded source address prefix. </param>
        /// <param name="expandedDestinationAddressPrefix"> Expanded destination address prefix. </param>
        /// <param name="access"> Whether network traffic is allowed or denied. </param>
        /// <param name="priority"> The priority of the rule. </param>
        /// <param name="direction"> The direction of the rule. </param>
        /// <returns> A new <see cref="Models.EffectiveNetworkSecurityRule"/> instance for mocking. </returns>
        public static EffectiveNetworkSecurityRule EffectiveNetworkSecurityRule(string name = null, EffectiveSecurityRuleProtocol? protocol = null, string sourcePortRange = null, string destinationPortRange = null, IEnumerable<string> sourcePortRanges = null, IEnumerable<string> destinationPortRanges = null, string sourceAddressPrefix = null, string destinationAddressPrefix = null, IEnumerable<string> sourceAddressPrefixes = null, IEnumerable<string> destinationAddressPrefixes = null, IEnumerable<string> expandedSourceAddressPrefix = null, IEnumerable<string> expandedDestinationAddressPrefix = null, SecurityRuleAccess? access = null, int? priority = null, SecurityRuleDirection? direction = null)
        {
            sourcePortRanges ??= new List<string>();
            destinationPortRanges ??= new List<string>();
            sourceAddressPrefixes ??= new List<string>();
            destinationAddressPrefixes ??= new List<string>();
            expandedSourceAddressPrefix ??= new List<string>();
            expandedDestinationAddressPrefix ??= new List<string>();

            return new EffectiveNetworkSecurityRule(
                name,
                protocol,
                sourcePortRange,
                destinationPortRange,
                sourcePortRanges?.ToList(),
                destinationPortRanges?.ToList(),
                sourceAddressPrefix,
                destinationAddressPrefix,
                sourceAddressPrefixes?.ToList(),
                destinationAddressPrefixes?.ToList(),
                expandedSourceAddressPrefix?.ToList(),
                expandedDestinationAddressPrefix?.ToList(),
                access,
                priority,
                direction,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.NetworkManagerData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="systemData"> The system metadata related to this resource. </param>
        /// <param name="description"> A description of the network manager. </param>
        /// <param name="networkManagerScopes"> Scope of Network Manager. </param>
        /// <param name="networkManagerScopeAccesses"> Scope Access. </param>
        /// <param name="provisioningState"> The provisioning state of the network manager resource. </param>
        /// <param name="resourceGuid"> Unique identifier for this resource. </param>
        /// <returns> A new <see cref="Network.NetworkManagerData"/> instance for mocking. </returns>
        public static NetworkManagerData NetworkManagerData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, SystemData systemData = null, string description = null, NetworkManagerPropertiesNetworkManagerScopes networkManagerScopes = null, IEnumerable<NetworkConfigurationDeploymentType> networkManagerScopeAccesses = null, NetworkProvisioningState? provisioningState = null, Guid? resourceGuid = null)
        {
            tags ??= new Dictionary<string, string>();
            networkManagerScopeAccesses ??= new List<NetworkConfigurationDeploymentType>();

            return new NetworkManagerData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                systemData,
                description,
                networkManagerScopes,
                networkManagerScopeAccesses?.ToList(),
                provisioningState,
                resourceGuid);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkManagerPropertiesNetworkManagerScopes"/>. </summary>
        /// <param name="managementGroups"> List of management groups. </param>
        /// <param name="subscriptions"> List of subscriptions. </param>
        /// <param name="crossTenantScopes"> List of cross tenant scopes. </param>
        /// <returns> A new <see cref="Models.NetworkManagerPropertiesNetworkManagerScopes"/> instance for mocking. </returns>
        public static NetworkManagerPropertiesNetworkManagerScopes NetworkManagerPropertiesNetworkManagerScopes(IEnumerable<string> managementGroups = null, IEnumerable<string> subscriptions = null, IEnumerable<CrossTenantScopes> crossTenantScopes = null)
        {
            managementGroups ??= new List<string>();
            subscriptions ??= new List<string>();
            crossTenantScopes ??= new List<CrossTenantScopes>();

            return new NetworkManagerPropertiesNetworkManagerScopes(managementGroups?.ToList(), subscriptions?.ToList(), crossTenantScopes?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CrossTenantScopes"/>. </summary>
        /// <param name="tenantId"> Tenant ID. </param>
        /// <param name="managementGroups"> List of management groups. </param>
        /// <param name="subscriptions"> List of subscriptions. </param>
        /// <returns> A new <see cref="Models.CrossTenantScopes"/> instance for mocking. </returns>
        public static CrossTenantScopes CrossTenantScopes(Guid? tenantId = null, IEnumerable<string> managementGroups = null, IEnumerable<string> subscriptions = null)
        {
            managementGroups ??= new List<string>();
            subscriptions ??= new List<string>();

            return new CrossTenantScopes(tenantId, managementGroups?.ToList(), subscriptions?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkManagerCommit"/>. </summary>
        /// <param name="commitId"> Commit Id. </param>
        /// <param name="targetLocations"> List of target locations. </param>
        /// <param name="configurationIds"> List of configuration ids. </param>
        /// <param name="commitType"> Commit Type. </param>
        /// <returns> A new <see cref="Models.NetworkManagerCommit"/> instance for mocking. </returns>
        public static NetworkManagerCommit NetworkManagerCommit(string commitId = null, IEnumerable<string> targetLocations = null, IEnumerable<string> configurationIds = null, NetworkConfigurationDeploymentType commitType = default)
        {
            targetLocations ??= new List<string>();
            configurationIds ??= new List<string>();

            return new NetworkManagerCommit(commitId, targetLocations?.ToList(), configurationIds?.ToList(), commitType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkManagerDeploymentStatus"/>. </summary>
        /// <param name="commitOn"> Commit Time. </param>
        /// <param name="region"> Region Name. </param>
        /// <param name="deploymentState"> Deployment Status. </param>
        /// <param name="configurationIds"> List of configuration ids. </param>
        /// <param name="deploymentType"> Configuration Deployment Type. </param>
        /// <param name="errorMessage"> Error Message. </param>
        /// <returns> A new <see cref="Models.NetworkManagerDeploymentStatus"/> instance for mocking. </returns>
        public static NetworkManagerDeploymentStatus NetworkManagerDeploymentStatus(DateTimeOffset? commitOn = null, string region = null, NetworkManagerDeploymentState? deploymentState = null, IEnumerable<string> configurationIds = null, NetworkConfigurationDeploymentType? deploymentType = null, string errorMessage = null)
        {
            configurationIds ??= new List<string>();

            return new NetworkManagerDeploymentStatus(
                commitOn,
                region,
                deploymentState,
                configurationIds?.ToList(),
                deploymentType,
                errorMessage,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ActiveConnectivityConfiguration"/>. </summary>
        /// <param name="id"> Connectivity configuration ID. </param>
        /// <param name="configurationGroups"> Effective configuration groups. </param>
        /// <param name="description"> A description of the connectivity configuration. </param>
        /// <param name="connectivityTopology"> Connectivity topology type. </param>
        /// <param name="hubs"> List of hubItems. </param>
        /// <param name="isGlobal"> Flag if global mesh is supported. </param>
        /// <param name="appliesToGroups"> Groups for configuration. </param>
        /// <param name="provisioningState"> The provisioning state of the connectivity configuration resource. </param>
        /// <param name="deleteExistingPeering"> Flag if need to remove current existing peerings. </param>
        /// <param name="resourceGuid"> Unique identifier for this resource. </param>
        /// <param name="committedOn"> Deployment time string. </param>
        /// <param name="region"> Deployment region. </param>
        /// <returns> A new <see cref="Models.ActiveConnectivityConfiguration"/> instance for mocking. </returns>
        public static ActiveConnectivityConfiguration ActiveConnectivityConfiguration(string id = null, IEnumerable<NetworkConfigurationGroup> configurationGroups = null, string description = null, ConnectivityTopology? connectivityTopology = null, IEnumerable<ConnectivityHub> hubs = null, GlobalMeshSupportFlag? isGlobal = null, IEnumerable<ConnectivityGroupItem> appliesToGroups = null, NetworkProvisioningState? provisioningState = null, DeleteExistingPeering? deleteExistingPeering = null, Guid? resourceGuid = null, DateTimeOffset? committedOn = null, AzureLocation? region = null)
        {
            configurationGroups ??= new List<NetworkConfigurationGroup>();
            hubs ??= new List<ConnectivityHub>();
            appliesToGroups ??= new List<ConnectivityGroupItem>();

            return new ActiveConnectivityConfiguration(
                id,
                configurationGroups?.ToList(),
                description,
                connectivityTopology,
                hubs?.ToList(),
                isGlobal,
                appliesToGroups?.ToList(),
                provisioningState,
                deleteExistingPeering,
                resourceGuid,
                serializedAdditionalRawData: null,
                committedOn,
                region);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EffectiveConnectivityConfiguration"/>. </summary>
        /// <param name="id"> Connectivity configuration ID. </param>
        /// <param name="configurationGroups"> Effective configuration groups. </param>
        /// <param name="description"> A description of the connectivity configuration. </param>
        /// <param name="connectivityTopology"> Connectivity topology type. </param>
        /// <param name="hubs"> List of hubItems. </param>
        /// <param name="isGlobal"> Flag if global mesh is supported. </param>
        /// <param name="appliesToGroups"> Groups for configuration. </param>
        /// <param name="provisioningState"> The provisioning state of the connectivity configuration resource. </param>
        /// <param name="deleteExistingPeering"> Flag if need to remove current existing peerings. </param>
        /// <param name="resourceGuid"> Unique identifier for this resource. </param>
        /// <returns> A new <see cref="Models.EffectiveConnectivityConfiguration"/> instance for mocking. </returns>
        public static EffectiveConnectivityConfiguration EffectiveConnectivityConfiguration(string id = null, IEnumerable<NetworkConfigurationGroup> configurationGroups = null, string description = null, ConnectivityTopology? connectivityTopology = null, IEnumerable<ConnectivityHub> hubs = null, GlobalMeshSupportFlag? isGlobal = null, IEnumerable<ConnectivityGroupItem> appliesToGroups = null, NetworkProvisioningState? provisioningState = null, DeleteExistingPeering? deleteExistingPeering = null, Guid? resourceGuid = null)
        {
            configurationGroups ??= new List<NetworkConfigurationGroup>();
            hubs ??= new List<ConnectivityHub>();
            appliesToGroups ??= new List<ConnectivityGroupItem>();

            return new EffectiveConnectivityConfiguration(
                id,
                configurationGroups?.ToList(),
                description,
                connectivityTopology,
                hubs?.ToList(),
                isGlobal,
                appliesToGroups?.ToList(),
                provisioningState,
                deleteExistingPeering,
                resourceGuid,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkConfigurationGroup"/>. </summary>
        /// <param name="id"> Network group ID. </param>
        /// <param name="description"> A description of the network group. </param>
        /// <param name="memberType"> The type of the group member. </param>
        /// <param name="provisioningState"> The provisioning state of the scope assignment resource. </param>
        /// <param name="resourceGuid"> Unique identifier for this resource. </param>
        /// <returns> A new <see cref="Models.NetworkConfigurationGroup"/> instance for mocking. </returns>
        public static NetworkConfigurationGroup NetworkConfigurationGroup(string id = null, string description = null, NetworkGroupMemberType? memberType = null, NetworkProvisioningState? provisioningState = null, Guid? resourceGuid = null)
        {
            return new NetworkConfigurationGroup(
                id,
                description,
                memberType,
                provisioningState,
                resourceGuid,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ActiveBaseSecurityAdminRule"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="commitOn"> Deployment time string. </param>
        /// <param name="region"> Deployment region. </param>
        /// <param name="configurationDescription"> A description of the security admin configuration. </param>
        /// <param name="ruleCollectionDescription"> A description of the rule collection. </param>
        /// <param name="ruleCollectionAppliesToGroups"> Groups for rule collection. </param>
        /// <param name="ruleGroups"> Effective configuration groups. </param>
        /// <param name="kind"> Whether the rule is custom or default. </param>
        /// <returns> A new <see cref="Models.ActiveBaseSecurityAdminRule"/> instance for mocking. </returns>
        public static ActiveBaseSecurityAdminRule ActiveBaseSecurityAdminRule(string id = null, DateTimeOffset? commitOn = null, string region = null, string configurationDescription = null, string ruleCollectionDescription = null, IEnumerable<NetworkManagerSecurityGroupItem> ruleCollectionAppliesToGroups = null, IEnumerable<NetworkConfigurationGroup> ruleGroups = null, string kind = null)
        {
            ruleCollectionAppliesToGroups ??= new List<NetworkManagerSecurityGroupItem>();
            ruleGroups ??= new List<NetworkConfigurationGroup>();

            return new UnknownActiveBaseSecurityAdminRule(
                id,
                commitOn,
                region,
                configurationDescription,
                ruleCollectionDescription,
                ruleCollectionAppliesToGroups?.ToList(),
                ruleGroups?.ToList(),
                kind == null ? default : new EffectiveAdminRuleKind(kind),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.NetworkManagerConnectionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="networkManagerId"> Network Manager Id. </param>
        /// <param name="connectionState"> Connection state. </param>
        /// <param name="description"> A description of the network manager connection. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <returns> A new <see cref="Network.NetworkManagerConnectionData"/> instance for mocking. </returns>
        public static NetworkManagerConnectionData NetworkManagerConnectionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ResourceIdentifier networkManagerId = null, ScopeConnectionState? connectionState = null, string description = null, ETag? etag = null)
        {
            return new NetworkManagerConnectionData(
                id,
                name,
                resourceType,
                systemData,
                networkManagerId,
                connectionState,
                description,
                etag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.ConnectivityConfigurationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> A description of the connectivity configuration. </param>
        /// <param name="connectivityTopology"> Connectivity topology type. </param>
        /// <param name="hubs"> List of hubItems. </param>
        /// <param name="isGlobal"> Flag if global mesh is supported. </param>
        /// <param name="appliesToGroups"> Groups for configuration. </param>
        /// <param name="provisioningState"> The provisioning state of the connectivity configuration resource. </param>
        /// <param name="deleteExistingPeering"> Flag if need to remove current existing peerings. </param>
        /// <param name="resourceGuid"> Unique identifier for this resource. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <returns> A new <see cref="Network.ConnectivityConfigurationData"/> instance for mocking. </returns>
        public static ConnectivityConfigurationData ConnectivityConfigurationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string description = null, ConnectivityTopology? connectivityTopology = null, IEnumerable<ConnectivityHub> hubs = null, GlobalMeshSupportFlag? isGlobal = null, IEnumerable<ConnectivityGroupItem> appliesToGroups = null, NetworkProvisioningState? provisioningState = null, DeleteExistingPeering? deleteExistingPeering = null, Guid? resourceGuid = null, ETag? etag = null)
        {
            hubs ??= new List<ConnectivityHub>();
            appliesToGroups ??= new List<ConnectivityGroupItem>();

            return new ConnectivityConfigurationData(
                id,
                name,
                resourceType,
                systemData,
                description,
                connectivityTopology,
                hubs?.ToList(),
                isGlobal,
                appliesToGroups?.ToList(),
                provisioningState,
                deleteExistingPeering,
                resourceGuid,
                etag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EffectiveBaseSecurityAdminRule"/>. </summary>
        /// <param name="resourceId"> Resource ID. </param>
        /// <param name="configurationDescription"> A description of the security admin configuration. </param>
        /// <param name="ruleCollectionDescription"> A description of the rule collection. </param>
        /// <param name="ruleCollectionAppliesToGroups"> Groups for rule collection. </param>
        /// <param name="ruleGroups"> Effective configuration groups. </param>
        /// <param name="kind"> Whether the rule is custom or default. </param>
        /// <returns> A new <see cref="Models.EffectiveBaseSecurityAdminRule"/> instance for mocking. </returns>
        public static EffectiveBaseSecurityAdminRule EffectiveBaseSecurityAdminRule(ResourceIdentifier resourceId = null, string configurationDescription = null, string ruleCollectionDescription = null, IEnumerable<NetworkManagerSecurityGroupItem> ruleCollectionAppliesToGroups = null, IEnumerable<NetworkConfigurationGroup> ruleGroups = null, string kind = null)
        {
            ruleCollectionAppliesToGroups ??= new List<NetworkManagerSecurityGroupItem>();
            ruleGroups ??= new List<NetworkConfigurationGroup>();

            return new UnknownEffectiveBaseSecurityAdminRule(
                resourceId,
                configurationDescription,
                ruleCollectionDescription,
                ruleCollectionAppliesToGroups?.ToList(),
                ruleGroups?.ToList(),
                kind == null ? default : new EffectiveAdminRuleKind(kind),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.NetworkGroupData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> A description of the network group. </param>
        /// <param name="memberType"> The type of the group member. </param>
        /// <param name="provisioningState"> The provisioning state of the scope assignment resource. </param>
        /// <param name="resourceGuid"> Unique identifier for this resource. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <returns> A new <see cref="Network.NetworkGroupData"/> instance for mocking. </returns>
        public static NetworkGroupData NetworkGroupData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string description = null, NetworkGroupMemberType? memberType = null, NetworkProvisioningState? provisioningState = null, Guid? resourceGuid = null, ETag? etag = null)
        {
            return new NetworkGroupData(
                id,
                name,
                resourceType,
                systemData,
                description,
                memberType,
                provisioningState,
                resourceGuid,
                etag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.NetworkGroupStaticMemberData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="resourceId"> Resource Id. </param>
        /// <param name="region"> Resource region. </param>
        /// <param name="provisioningState"> The provisioning state of the scope assignment resource. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <returns> A new <see cref="Network.NetworkGroupStaticMemberData"/> instance for mocking. </returns>
        public static NetworkGroupStaticMemberData NetworkGroupStaticMemberData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ResourceIdentifier resourceId = null, string region = null, NetworkProvisioningState? provisioningState = null, ETag? etag = null)
        {
            return new NetworkGroupStaticMemberData(
                id,
                name,
                resourceType,
                systemData,
                resourceId,
                region,
                provisioningState,
                etag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.ScopeConnectionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tenantId"> Tenant ID. </param>
        /// <param name="resourceId"> Resource ID. </param>
        /// <param name="connectionState"> Connection State. </param>
        /// <param name="description"> A description of the scope connection. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <returns> A new <see cref="Network.ScopeConnectionData"/> instance for mocking. </returns>
        public static ScopeConnectionData ScopeConnectionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, Guid? tenantId = null, ResourceIdentifier resourceId = null, ScopeConnectionState? connectionState = null, string description = null, ETag? etag = null)
        {
            return new ScopeConnectionData(
                id,
                name,
                resourceType,
                systemData,
                tenantId,
                resourceId,
                connectionState,
                description,
                etag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.SecurityAdminConfigurationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> A description of the security configuration. </param>
        /// <param name="applyOnNetworkIntentPolicyBasedServices"> Enum list of network intent policy based services. </param>
        /// <param name="provisioningState"> The provisioning state of the resource. </param>
        /// <param name="resourceGuid"> Unique identifier for this resource. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <returns> A new <see cref="Network.SecurityAdminConfigurationData"/> instance for mocking. </returns>
        public static SecurityAdminConfigurationData SecurityAdminConfigurationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string description = null, IEnumerable<NetworkIntentPolicyBasedService> applyOnNetworkIntentPolicyBasedServices = null, NetworkProvisioningState? provisioningState = null, Guid? resourceGuid = null, ETag? etag = null)
        {
            applyOnNetworkIntentPolicyBasedServices ??= new List<NetworkIntentPolicyBasedService>();

            return new SecurityAdminConfigurationData(
                id,
                name,
                resourceType,
                systemData,
                description,
                applyOnNetworkIntentPolicyBasedServices?.ToList(),
                provisioningState,
                resourceGuid,
                etag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.AdminRuleGroupData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> A description of the admin rule collection. </param>
        /// <param name="appliesToGroups"> Groups for configuration. </param>
        /// <param name="provisioningState"> The provisioning state of the resource. </param>
        /// <param name="resourceGuid"> Unique identifier for this resource. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <returns> A new <see cref="Network.AdminRuleGroupData"/> instance for mocking. </returns>
        public static AdminRuleGroupData AdminRuleGroupData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string description = null, IEnumerable<NetworkManagerSecurityGroupItem> appliesToGroups = null, NetworkProvisioningState? provisioningState = null, Guid? resourceGuid = null, ETag? etag = null)
        {
            appliesToGroups ??= new List<NetworkManagerSecurityGroupItem>();

            return new AdminRuleGroupData(
                id,
                name,
                resourceType,
                systemData,
                description,
                appliesToGroups?.ToList(),
                provisioningState,
                resourceGuid,
                etag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.BaseAdminRuleData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> Whether the rule is custom or default. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <returns> A new <see cref="Network.BaseAdminRuleData"/> instance for mocking. </returns>
        public static BaseAdminRuleData BaseAdminRuleData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string kind = null, ETag? etag = null)
        {
            return new BaseAdminRuleData(
                id,
                name,
                resourceType,
                systemData,
                kind == null ? default : new AdminRuleKind(kind),
                etag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.NetworkManagerSecurityUserConfigurationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> A description of the security user configuration. </param>
        /// <param name="provisioningState"> The provisioning state of the resource. </param>
        /// <param name="resourceGuid"> Unique identifier for this resource. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <returns> A new <see cref="Network.NetworkManagerSecurityUserConfigurationData"/> instance for mocking. </returns>
        public static NetworkManagerSecurityUserConfigurationData NetworkManagerSecurityUserConfigurationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string description = null, NetworkProvisioningState? provisioningState = null, Guid? resourceGuid = null, ETag? etag = null)
        {
            return new NetworkManagerSecurityUserConfigurationData(
                id,
                name,
                resourceType,
                systemData,
                description,
                provisioningState,
                resourceGuid,
                etag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.NetworkManagerSecurityUserRulesData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> A description of the security user rule collection. </param>
        /// <param name="appliesToGroups"> Groups for configuration. </param>
        /// <param name="provisioningState"> The provisioning state of the resource. </param>
        /// <param name="resourceGuid"> Unique identifier for this resource. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <returns> A new <see cref="Network.NetworkManagerSecurityUserRulesData"/> instance for mocking. </returns>
        public static NetworkManagerSecurityUserRulesData NetworkManagerSecurityUserRulesData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string description = null, IEnumerable<SecurityUserGroupItem> appliesToGroups = null, NetworkProvisioningState? provisioningState = null, Guid? resourceGuid = null, ETag? etag = null)
        {
            appliesToGroups ??= new List<SecurityUserGroupItem>();

            return new NetworkManagerSecurityUserRulesData(
                id,
                name,
                resourceType,
                systemData,
                description,
                appliesToGroups?.ToList(),
                provisioningState,
                resourceGuid,
                etag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.NetworkManagerSecurityUserRuleData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> A description for this rule. </param>
        /// <param name="protocol"> Network protocol this rule applies to. </param>
        /// <param name="sources"> The CIDR or source IP ranges. </param>
        /// <param name="destinations"> The destination address prefixes. CIDR or destination IP ranges. </param>
        /// <param name="sourcePortRanges"> The source port ranges. </param>
        /// <param name="destinationPortRanges"> The destination port ranges. </param>
        /// <param name="direction"> Indicates if the traffic matched against the rule in inbound or outbound. </param>
        /// <param name="provisioningState"> The provisioning state of the security configuration user rule resource. </param>
        /// <param name="resourceGuid"> Unique identifier for this resource. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <returns> A new <see cref="Network.NetworkManagerSecurityUserRuleData"/> instance for mocking. </returns>
        public static NetworkManagerSecurityUserRuleData NetworkManagerSecurityUserRuleData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string description = null, SecurityConfigurationRuleProtocol? protocol = null, IEnumerable<AddressPrefixItem> sources = null, IEnumerable<AddressPrefixItem> destinations = null, IEnumerable<string> sourcePortRanges = null, IEnumerable<string> destinationPortRanges = null, SecurityConfigurationRuleDirection? direction = null, NetworkProvisioningState? provisioningState = null, Guid? resourceGuid = null, ETag? etag = null)
        {
            sources ??= new List<AddressPrefixItem>();
            destinations ??= new List<AddressPrefixItem>();
            sourcePortRanges ??= new List<string>();
            destinationPortRanges ??= new List<string>();

            return new NetworkManagerSecurityUserRuleData(
                id,
                name,
                resourceType,
                systemData,
                description,
                protocol,
                sources?.ToList(),
                destinations?.ToList(),
                sourcePortRanges?.ToList(),
                destinationPortRanges?.ToList(),
                direction,
                provisioningState,
                resourceGuid,
                etag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.NetworkManagerRoutingConfigurationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> A description of the routing configuration. </param>
        /// <param name="provisioningState"> The provisioning state of the resource. </param>
        /// <param name="resourceGuid"> Unique identifier for this resource. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <returns> A new <see cref="Network.NetworkManagerRoutingConfigurationData"/> instance for mocking. </returns>
        public static NetworkManagerRoutingConfigurationData NetworkManagerRoutingConfigurationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string description = null, NetworkProvisioningState? provisioningState = null, Guid? resourceGuid = null, ETag? etag = null)
        {
            return new NetworkManagerRoutingConfigurationData(
                id,
                name,
                resourceType,
                systemData,
                description,
                provisioningState,
                resourceGuid,
                etag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.NetworkManagerRoutingRulesData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> A description of the routing rule collection. </param>
        /// <param name="provisioningState"> The provisioning state of the resource. </param>
        /// <param name="resourceGuid"> Unique identifier for this resource. </param>
        /// <param name="appliesTo"> Groups for configuration. </param>
        /// <param name="disableBgpRoutePropagation"> Determines whether BGP route propagation is enabled. Defaults to true. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <returns> A new <see cref="Network.NetworkManagerRoutingRulesData"/> instance for mocking. </returns>
        public static NetworkManagerRoutingRulesData NetworkManagerRoutingRulesData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string description = null, NetworkProvisioningState? provisioningState = null, Guid? resourceGuid = null, IEnumerable<NetworkManagerRoutingGroupItem> appliesTo = null, DisableBgpRoutePropagation? disableBgpRoutePropagation = null, ETag? etag = null)
        {
            appliesTo ??= new List<NetworkManagerRoutingGroupItem>();

            return new NetworkManagerRoutingRulesData(
                id,
                name,
                resourceType,
                systemData,
                description,
                provisioningState,
                resourceGuid,
                appliesTo?.ToList(),
                disableBgpRoutePropagation,
                etag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.NetworkManagerRoutingRuleData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> A description for this rule. </param>
        /// <param name="provisioningState"> The provisioning state of the resource. </param>
        /// <param name="resourceGuid"> Unique identifier for this resource. </param>
        /// <param name="destination"> Indicates the destination for this particular rule. </param>
        /// <param name="nextHop"> Indicates the next hop for this particular rule. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <returns> A new <see cref="Network.NetworkManagerRoutingRuleData"/> instance for mocking. </returns>
        public static NetworkManagerRoutingRuleData NetworkManagerRoutingRuleData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string description = null, NetworkProvisioningState? provisioningState = null, Guid? resourceGuid = null, RoutingRuleRouteDestination destination = null, RoutingRuleNextHop nextHop = null, ETag? etag = null)
        {
            return new NetworkManagerRoutingRuleData(
                id,
                name,
                resourceType,
                systemData,
                description,
                provisioningState,
                resourceGuid,
                destination,
                nextHop,
                etag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.NetworkProfileData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="containerNetworkInterfaces"> List of child container network interfaces. </param>
        /// <param name="containerNetworkInterfaceConfigurations"> List of chid container network interface configurations. </param>
        /// <param name="resourceGuid"> The resource GUID property of the network profile resource. </param>
        /// <param name="provisioningState"> The provisioning state of the network profile resource. </param>
        /// <returns> A new <see cref="Network.NetworkProfileData"/> instance for mocking. </returns>
        public static NetworkProfileData NetworkProfileData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, IEnumerable<ContainerNetworkInterface> containerNetworkInterfaces = null, IEnumerable<ContainerNetworkInterfaceConfiguration> containerNetworkInterfaceConfigurations = null, Guid? resourceGuid = null, NetworkProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            containerNetworkInterfaces ??= new List<ContainerNetworkInterface>();
            containerNetworkInterfaceConfigurations ??= new List<ContainerNetworkInterfaceConfiguration>();

            return new NetworkProfileData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                containerNetworkInterfaces?.ToList(),
                containerNetworkInterfaceConfigurations?.ToList(),
                resourceGuid,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ContainerNetworkInterface"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="containerNetworkInterfaceConfiguration"> Container network interface configuration from which this container network interface is created. </param>
        /// <param name="containerId"> Reference to the container to which this container network interface is attached. </param>
        /// <param name="ipConfigurations"> Reference to the ip configuration on this container nic. </param>
        /// <param name="provisioningState"> The provisioning state of the container network interface resource. </param>
        /// <returns> A new <see cref="Models.ContainerNetworkInterface"/> instance for mocking. </returns>
        public static ContainerNetworkInterface ContainerNetworkInterface(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, ContainerNetworkInterfaceConfiguration containerNetworkInterfaceConfiguration = null, ResourceIdentifier containerId = null, IEnumerable<ContainerNetworkInterfaceIPConfiguration> ipConfigurations = null, NetworkProvisioningState? provisioningState = null)
        {
            ipConfigurations ??= new List<ContainerNetworkInterfaceIPConfiguration>();

            return new ContainerNetworkInterface(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                containerNetworkInterfaceConfiguration,
                containerId != null ? ResourceManagerModelFactory.WritableSubResource(containerId) : null,
                ipConfigurations?.ToList(),
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ContainerNetworkInterfaceConfiguration"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="ipConfigurations"> A list of ip configurations of the container network interface configuration. </param>
        /// <param name="containerNetworkInterfaces"> A list of container network interfaces created from this container network interface configuration. </param>
        /// <param name="provisioningState"> The provisioning state of the container network interface configuration resource. </param>
        /// <returns> A new <see cref="Models.ContainerNetworkInterfaceConfiguration"/> instance for mocking. </returns>
        public static ContainerNetworkInterfaceConfiguration ContainerNetworkInterfaceConfiguration(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, IEnumerable<NetworkIPConfigurationProfile> ipConfigurations = null, IEnumerable<WritableSubResource> containerNetworkInterfaces = null, NetworkProvisioningState? provisioningState = null)
        {
            ipConfigurations ??= new List<NetworkIPConfigurationProfile>();
            containerNetworkInterfaces ??= new List<WritableSubResource>();

            return new ContainerNetworkInterfaceConfiguration(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                ipConfigurations?.ToList(),
                containerNetworkInterfaces?.ToList(),
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ContainerNetworkInterfaceIPConfiguration"/>. </summary>
        /// <param name="name"> The name of the resource. This name can be used to access the resource. </param>
        /// <param name="containerNetworkInterfaceIPConfigurationType"> Sub Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="provisioningState"> The provisioning state of the container network interface IP configuration resource. </param>
        /// <returns> A new <see cref="Models.ContainerNetworkInterfaceIPConfiguration"/> instance for mocking. </returns>
        public static ContainerNetworkInterfaceIPConfiguration ContainerNetworkInterfaceIPConfiguration(string name = null, string containerNetworkInterfaceIPConfigurationType = null, ETag? etag = null, NetworkProvisioningState? provisioningState = null)
        {
            return new ContainerNetworkInterfaceIPConfiguration(name, containerNetworkInterfaceIPConfigurationType, etag, provisioningState, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.NetworkVirtualApplianceData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="identity"> The service principal that has read access to cloud-init and config blob. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="nvaSku"> Network Virtual Appliance SKU. </param>
        /// <param name="addressPrefix"> Address Prefix. </param>
        /// <param name="bootStrapConfigurationBlobs"> BootStrapConfigurationBlobs storage URLs. </param>
        /// <param name="virtualHubId"> The Virtual Hub where Network Virtual Appliance is being deployed. </param>
        /// <param name="cloudInitConfigurationBlobs"> CloudInitConfigurationBlob storage URLs. </param>
        /// <param name="cloudInitConfiguration"> CloudInitConfiguration string in plain text. </param>
        /// <param name="virtualApplianceAsn"> VirtualAppliance ASN. Microsoft private, public and IANA reserved ASN are not supported. </param>
        /// <param name="sshPublicKey"> Public key for SSH login. </param>
        /// <param name="virtualApplianceNics"> List of Virtual Appliance Network Interfaces. </param>
        /// <param name="networkInterfaceConfigurations"> Network Profile containing configurations for Public and Private NIC. </param>
        /// <param name="additionalNics"> Details required for Additional Network Interface. </param>
        /// <param name="internetIngressPublicIPs"> List of Resource Uri of Public IPs for Internet Ingress Scenario. </param>
        /// <param name="virtualApplianceSites"> List of references to VirtualApplianceSite. </param>
        /// <param name="virtualApplianceConnections"> List of references to VirtualApplianceConnections. </param>
        /// <param name="inboundSecurityRules"> List of references to InboundSecurityRules. </param>
        /// <param name="provisioningState"> The provisioning state of the resource. </param>
        /// <param name="deploymentType"> The deployment type. PartnerManaged for the SaaS NVA. </param>
        /// <param name="delegation"> The delegation for the Virtual Appliance. </param>
        /// <param name="partnerManagedResource"> The delegation for the Virtual Appliance. </param>
        /// <returns> A new <see cref="Network.NetworkVirtualApplianceData"/> instance for mocking. </returns>
        public static NetworkVirtualApplianceData NetworkVirtualApplianceData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ManagedServiceIdentity identity = null, ETag? etag = null, VirtualApplianceSkuProperties nvaSku = null, string addressPrefix = null, IEnumerable<string> bootStrapConfigurationBlobs = null, ResourceIdentifier virtualHubId = null, IEnumerable<string> cloudInitConfigurationBlobs = null, string cloudInitConfiguration = null, long? virtualApplianceAsn = null, string sshPublicKey = null, IEnumerable<VirtualApplianceNicProperties> virtualApplianceNics = null, IEnumerable<VirtualApplianceNetworkInterfaceConfiguration> networkInterfaceConfigurations = null, IEnumerable<VirtualApplianceAdditionalNicProperties> additionalNics = null, IEnumerable<WritableSubResource> internetIngressPublicIPs = null, IEnumerable<WritableSubResource> virtualApplianceSites = null, IEnumerable<WritableSubResource> virtualApplianceConnections = null, IEnumerable<WritableSubResource> inboundSecurityRules = null, NetworkProvisioningState? provisioningState = null, string deploymentType = null, VirtualApplianceDelegationProperties delegation = null, PartnerManagedResourceProperties partnerManagedResource = null)
        {
            tags ??= new Dictionary<string, string>();
            bootStrapConfigurationBlobs ??= new List<string>();
            cloudInitConfigurationBlobs ??= new List<string>();
            virtualApplianceNics ??= new List<VirtualApplianceNicProperties>();
            networkInterfaceConfigurations ??= new List<VirtualApplianceNetworkInterfaceConfiguration>();
            additionalNics ??= new List<VirtualApplianceAdditionalNicProperties>();
            internetIngressPublicIPs ??= new List<WritableSubResource>();
            virtualApplianceSites ??= new List<WritableSubResource>();
            virtualApplianceConnections ??= new List<WritableSubResource>();
            inboundSecurityRules ??= new List<WritableSubResource>();

            return new NetworkVirtualApplianceData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                identity,
                etag,
                nvaSku,
                addressPrefix,
                bootStrapConfigurationBlobs?.ToList(),
                virtualHubId != null ? ResourceManagerModelFactory.WritableSubResource(virtualHubId) : null,
                cloudInitConfigurationBlobs?.ToList(),
                cloudInitConfiguration,
                virtualApplianceAsn,
                sshPublicKey,
                virtualApplianceNics?.ToList(),
                networkInterfaceConfigurations != null ? new NetworkVirtualAppliancePropertiesFormatNetworkProfile(networkInterfaceConfigurations?.ToList(), serializedAdditionalRawData: null) : null,
                additionalNics?.ToList(),
                internetIngressPublicIPs?.ToList(),
                virtualApplianceSites?.ToList(),
                virtualApplianceConnections?.ToList(),
                inboundSecurityRules?.ToList(),
                provisioningState,
                deploymentType,
                delegation,
                partnerManagedResource);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VirtualApplianceNicProperties"/>. </summary>
        /// <param name="nicType"> NIC type - PublicNic, PrivateNic, or AdditionalNic. </param>
        /// <param name="name"> NIC name. </param>
        /// <param name="publicIPAddress"> Public IP address. </param>
        /// <param name="privateIPAddress"> Private IP address. </param>
        /// <param name="instanceName"> Instance on which nic is attached. </param>
        /// <returns> A new <see cref="Models.VirtualApplianceNicProperties"/> instance for mocking. </returns>
        public static VirtualApplianceNicProperties VirtualApplianceNicProperties(NicTypeInResponse? nicType = null, string name = null, string publicIPAddress = null, string privateIPAddress = null, string instanceName = null)
        {
            return new VirtualApplianceNicProperties(
                nicType,
                name,
                publicIPAddress,
                privateIPAddress,
                instanceName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VirtualApplianceDelegationProperties"/>. </summary>
        /// <param name="serviceName"> The service name to which the NVA is delegated. </param>
        /// <param name="provisioningState"> The current provisioning state. </param>
        /// <returns> A new <see cref="Models.VirtualApplianceDelegationProperties"/> instance for mocking. </returns>
        public static VirtualApplianceDelegationProperties VirtualApplianceDelegationProperties(string serviceName = null, NetworkProvisioningState? provisioningState = null)
        {
            return new VirtualApplianceDelegationProperties(serviceName, provisioningState, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PartnerManagedResourceProperties"/>. </summary>
        /// <param name="id"> The partner managed resource id. </param>
        /// <param name="internalLoadBalancerId"> The partner managed ILB resource id. </param>
        /// <param name="standardLoadBalancerId"> The partner managed SLB resource id. </param>
        /// <returns> A new <see cref="Models.PartnerManagedResourceProperties"/> instance for mocking. </returns>
        public static PartnerManagedResourceProperties PartnerManagedResourceProperties(ResourceIdentifier id = null, ResourceIdentifier internalLoadBalancerId = null, ResourceIdentifier standardLoadBalancerId = null)
        {
            return new PartnerManagedResourceProperties(id, internalLoadBalancerId, standardLoadBalancerId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.VirtualApplianceSiteData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="addressPrefix"> Address Prefix. </param>
        /// <param name="o365BreakOutCategories"> Office 365 Policy. </param>
        /// <param name="provisioningState"> The provisioning state of the resource. </param>
        /// <returns> A new <see cref="Network.VirtualApplianceSiteData"/> instance for mocking. </returns>
        public static VirtualApplianceSiteData VirtualApplianceSiteData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, string addressPrefix = null, BreakOutCategoryPolicies o365BreakOutCategories = null, NetworkProvisioningState? provisioningState = null)
        {
            return new VirtualApplianceSiteData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                addressPrefix,
                o365BreakOutCategories != null ? new Office365PolicyProperties(o365BreakOutCategories, serializedAdditionalRawData: null) : null,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Network.NetworkVirtualApplianceSkuData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="vendor"> Network Virtual Appliance Sku vendor. </param>
        /// <param name="availableVersions"> Available Network Virtual Appliance versions. </param>
        /// <param name="availableScaleUnits"> The list of scale units available. </param>
        /// <returns> A new <see cref="Network.NetworkVirtualApplianceSkuData"/> instance for mocking. </returns>
        public static NetworkVirtualApplianceSkuData NetworkVirtualApplianceSkuData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, string vendor = null, IEnumerable<string> availableVersions = null, IEnumerable<NetworkVirtualApplianceSkuInstances> availableScaleUnits = null)
        {
            tags ??= new Dictionary<string, string>();
            availableVersions ??= new List<string>();
            availableScaleUnits ??= new List<NetworkVirtualApplianceSkuInstances>();

            return new NetworkVirtualApplianceSkuData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                vendor,
                availableVersions?.ToList(),
                availableScaleUnits?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkVirtualApplianceSkuInstances"/>. </summary>
        /// <param name="scaleUnit"> Scale Unit. </param>
        /// <param name="instanceCount"> Instance Count. </param>
        /// <returns> A new <see cref="Models.NetworkVirtualApplianceSkuInstances"/> instance for mocking. </returns>
        public static NetworkVirtualApplianceSkuInstances NetworkVirtualApplianceSkuInstances(string scaleUnit = null, int? instanceCount = null)
        {
            return new NetworkVirtualApplianceSkuInstances(scaleUnit, instanceCount, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.InboundSecurityRuleData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="ruleType"> Rule Type. This should be either AutoExpire or Permanent. Auto Expire Rule only creates NSG rules. Permanent Rule creates NSG rule and SLB LB Rule. </param>
        /// <param name="rules"> List of allowed rules. </param>
        /// <param name="provisioningState"> The provisioning state of the resource. </param>
        /// <returns> A new <see cref="Network.InboundSecurityRuleData"/> instance for mocking. </returns>
        public static InboundSecurityRuleData InboundSecurityRuleData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, InboundSecurityRuleType? ruleType = null, IEnumerable<InboundSecurityRules> rules = null, NetworkProvisioningState? provisioningState = null)
        {
            rules ??= new List<InboundSecurityRules>();

            return new InboundSecurityRuleData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                ruleType,
                rules?.ToList(),
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Network.NetworkWatcherData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="provisioningState"> The provisioning state of the network watcher resource. </param>
        /// <returns> A new <see cref="Network.NetworkWatcherData"/> instance for mocking. </returns>
        public static NetworkWatcherData NetworkWatcherData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, NetworkProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();

            return new NetworkWatcherData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkTopology"/>. </summary>
        /// <param name="id"> GUID representing the operation id. </param>
        /// <param name="createdOn"> The datetime when the topology was initially created for the resource group. </param>
        /// <param name="lastModified"> The datetime when the topology was last modified. </param>
        /// <param name="resources"> A list of topology resources. </param>
        /// <returns> A new <see cref="Models.NetworkTopology"/> instance for mocking. </returns>
        public static NetworkTopology NetworkTopology(string id = null, DateTimeOffset? createdOn = null, DateTimeOffset? lastModified = null, IEnumerable<TopologyResourceInfo> resources = null)
        {
            resources ??= new List<TopologyResourceInfo>();

            return new NetworkTopology(id, createdOn, lastModified, resources?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TopologyResourceInfo"/>. </summary>
        /// <param name="name"> Name of the resource. </param>
        /// <param name="id"> ID of the resource. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="associations"> Holds the associations the resource has with other resources in the resource group. </param>
        /// <returns> A new <see cref="Models.TopologyResourceInfo"/> instance for mocking. </returns>
        public static TopologyResourceInfo TopologyResourceInfo(string name = null, string id = null, AzureLocation? location = null, IEnumerable<TopologyAssociation> associations = null)
        {
            associations ??= new List<TopologyAssociation>();

            return new TopologyResourceInfo(name, id, location, associations?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TopologyAssociation"/>. </summary>
        /// <param name="name"> The name of the resource that is associated with the parent resource. </param>
        /// <param name="resourceId"> The ID of the resource that is associated with the parent resource. </param>
        /// <param name="associationType"> The association type of the child resource to the parent resource. </param>
        /// <returns> A new <see cref="Models.TopologyAssociation"/> instance for mocking. </returns>
        public static TopologyAssociation TopologyAssociation(string name = null, ResourceIdentifier resourceId = null, AssociationType? associationType = null)
        {
            return new TopologyAssociation(name, resourceId, associationType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VerificationIPFlowContent"/>. </summary>
        /// <param name="targetResourceId"> The ID of the target resource to perform next-hop on. </param>
        /// <param name="direction"> The direction of the packet represented as a 5-tuple. </param>
        /// <param name="protocol"> Protocol to be verified on. </param>
        /// <param name="localPort"> The local port. Acceptable values are a single integer in the range (0-65535). Support for * for the source port, which depends on the direction. </param>
        /// <param name="remotePort"> The remote port. Acceptable values are a single integer in the range (0-65535). Support for * for the source port, which depends on the direction. </param>
        /// <param name="localIPAddress"> The local IP address. Acceptable values are valid IPv4 addresses. </param>
        /// <param name="remoteIPAddress"> The remote IP address. Acceptable values are valid IPv4 addresses. </param>
        /// <param name="targetNicResourceId"> The NIC ID. (If VM has multiple NICs and IP forwarding is enabled on any of them, then this parameter must be specified. Otherwise optional). </param>
        /// <returns> A new <see cref="Models.VerificationIPFlowContent"/> instance for mocking. </returns>
        public static VerificationIPFlowContent VerificationIPFlowContent(ResourceIdentifier targetResourceId = null, NetworkTrafficDirection direction = default, IPFlowProtocol protocol = default, string localPort = null, string remotePort = null, string localIPAddress = null, string remoteIPAddress = null, ResourceIdentifier targetNicResourceId = null)
        {
            return new VerificationIPFlowContent(
                targetResourceId,
                direction,
                protocol,
                localPort,
                remotePort,
                localIPAddress,
                remoteIPAddress,
                targetNicResourceId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VerificationIPFlowResult"/>. </summary>
        /// <param name="access"> Indicates whether the traffic is allowed or denied. </param>
        /// <param name="ruleName"> Name of the rule. If input is not matched against any security rule, it is not displayed. </param>
        /// <returns> A new <see cref="Models.VerificationIPFlowResult"/> instance for mocking. </returns>
        public static VerificationIPFlowResult VerificationIPFlowResult(NetworkAccess? access = null, string ruleName = null)
        {
            return new VerificationIPFlowResult(access, ruleName, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NextHopContent"/>. </summary>
        /// <param name="targetResourceId"> The resource identifier of the target resource against which the action is to be performed. </param>
        /// <param name="sourceIPAddress"> The source IP address. </param>
        /// <param name="destinationIPAddress"> The destination IP address. </param>
        /// <param name="targetNicResourceId"> The NIC ID. (If VM has multiple NICs and IP forwarding is enabled on any of the nics, then this parameter must be specified. Otherwise optional). </param>
        /// <returns> A new <see cref="Models.NextHopContent"/> instance for mocking. </returns>
        public static NextHopContent NextHopContent(ResourceIdentifier targetResourceId = null, string sourceIPAddress = null, string destinationIPAddress = null, ResourceIdentifier targetNicResourceId = null)
        {
            return new NextHopContent(targetResourceId, sourceIPAddress, destinationIPAddress, targetNicResourceId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NextHopResult"/>. </summary>
        /// <param name="nextHopType"> Next hop type. </param>
        /// <param name="nextHopIPAddress"> Next hop IP Address. </param>
        /// <param name="routeTableId"> The resource identifier for the route table associated with the route being returned. If the route being returned does not correspond to any user created routes then this field will be the string 'System Route'. </param>
        /// <returns> A new <see cref="Models.NextHopResult"/> instance for mocking. </returns>
        public static NextHopResult NextHopResult(NextHopType? nextHopType = null, string nextHopIPAddress = null, ResourceIdentifier routeTableId = null)
        {
            return new NextHopResult(nextHopType, nextHopIPAddress, routeTableId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SecurityGroupViewResult"/>. </summary>
        /// <param name="networkInterfaces"> List of network interfaces on the specified VM. </param>
        /// <returns> A new <see cref="Models.SecurityGroupViewResult"/> instance for mocking. </returns>
        public static SecurityGroupViewResult SecurityGroupViewResult(IEnumerable<SecurityGroupNetworkInterface> networkInterfaces = null)
        {
            networkInterfaces ??= new List<SecurityGroupNetworkInterface>();

            return new SecurityGroupViewResult(networkInterfaces?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SecurityGroupNetworkInterface"/>. </summary>
        /// <param name="id"> ID of the network interface. </param>
        /// <param name="securityRuleAssociations"> All security rules associated with the network interface. </param>
        /// <returns> A new <see cref="Models.SecurityGroupNetworkInterface"/> instance for mocking. </returns>
        public static SecurityGroupNetworkInterface SecurityGroupNetworkInterface(string id = null, SecurityRuleAssociations securityRuleAssociations = null)
        {
            return new SecurityGroupNetworkInterface(id, securityRuleAssociations, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SecurityRuleAssociations"/>. </summary>
        /// <param name="networkInterfaceAssociation"> Network interface and it's custom security rules. </param>
        /// <param name="subnetAssociation"> Subnet and it's custom security rules. </param>
        /// <param name="defaultSecurityRules"> Collection of default security rules of the network security group. </param>
        /// <param name="effectiveSecurityRules"> Collection of effective security rules. </param>
        /// <returns> A new <see cref="Models.SecurityRuleAssociations"/> instance for mocking. </returns>
        public static SecurityRuleAssociations SecurityRuleAssociations(NetworkInterfaceAssociation networkInterfaceAssociation = null, SubnetAssociation subnetAssociation = null, IEnumerable<SecurityRuleData> defaultSecurityRules = null, IEnumerable<EffectiveNetworkSecurityRule> effectiveSecurityRules = null)
        {
            defaultSecurityRules ??= new List<SecurityRuleData>();
            effectiveSecurityRules ??= new List<EffectiveNetworkSecurityRule>();

            return new SecurityRuleAssociations(networkInterfaceAssociation, subnetAssociation, defaultSecurityRules?.ToList(), effectiveSecurityRules?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkInterfaceAssociation"/>. </summary>
        /// <param name="id"> Network interface ID. </param>
        /// <param name="securityRules"> Collection of custom security rules. </param>
        /// <returns> A new <see cref="Models.NetworkInterfaceAssociation"/> instance for mocking. </returns>
        public static NetworkInterfaceAssociation NetworkInterfaceAssociation(ResourceIdentifier id = null, IEnumerable<SecurityRuleData> securityRules = null)
        {
            securityRules ??= new List<SecurityRuleData>();

            return new NetworkInterfaceAssociation(id, securityRules?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SubnetAssociation"/>. </summary>
        /// <param name="id"> Subnet ID. </param>
        /// <param name="securityRules"> Collection of custom security rules. </param>
        /// <returns> A new <see cref="Models.SubnetAssociation"/> instance for mocking. </returns>
        public static SubnetAssociation SubnetAssociation(ResourceIdentifier id = null, IEnumerable<SecurityRuleData> securityRules = null)
        {
            securityRules ??= new List<SecurityRuleData>();

            return new SubnetAssociation(id, securityRules?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PacketCaptureCreateOrUpdateContent"/>. </summary>
        /// <param name="target"> The ID of the targeted resource, only AzureVM and AzureVMSS as target type are currently supported. </param>
        /// <param name="scope"> A list of AzureVMSS instances which can be included or excluded to run packet capture. If both included and excluded are empty, then the packet capture will run on all instances of AzureVMSS. </param>
        /// <param name="targetType"> Target type of the resource provided. </param>
        /// <param name="bytesToCapturePerPacket"> Number of bytes captured per packet, the remaining bytes are truncated. </param>
        /// <param name="totalBytesPerSession"> Maximum size of the capture output. </param>
        /// <param name="timeLimitInSeconds"> Maximum duration of the capture session in seconds. </param>
        /// <param name="storageLocation"> The storage location for a packet capture session. </param>
        /// <param name="filters"> A list of packet capture filters. </param>
        /// <param name="isContinuousCapture"> This continuous capture is a nullable boolean, which can hold 'null', 'true' or 'false' value. If we do not pass this parameter, it would be consider as 'null', default value is 'null'. </param>
        /// <param name="captureSettings"> The capture setting holds the 'FileCount', 'FileSizeInBytes', 'SessionTimeLimitInSeconds' values. </param>
        /// <returns> A new <see cref="Models.PacketCaptureCreateOrUpdateContent"/> instance for mocking. </returns>
        public static PacketCaptureCreateOrUpdateContent PacketCaptureCreateOrUpdateContent(string target = null, PacketCaptureMachineScope scope = null, PacketCaptureTargetType? targetType = null, long? bytesToCapturePerPacket = null, long? totalBytesPerSession = null, int? timeLimitInSeconds = null, PacketCaptureStorageLocation storageLocation = null, IEnumerable<PacketCaptureFilter> filters = null, bool? isContinuousCapture = null, PacketCaptureSettings captureSettings = null)
        {
            filters ??= new List<PacketCaptureFilter>();

            return new PacketCaptureCreateOrUpdateContent(
                target,
                scope,
                targetType,
                bytesToCapturePerPacket,
                totalBytesPerSession,
                timeLimitInSeconds,
                storageLocation,
                filters?.ToList(),
                isContinuousCapture,
                captureSettings,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.PacketCaptureData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="target"> The ID of the targeted resource, only AzureVM and AzureVMSS as target type are currently supported. </param>
        /// <param name="scope"> A list of AzureVMSS instances which can be included or excluded to run packet capture. If both included and excluded are empty, then the packet capture will run on all instances of AzureVMSS. </param>
        /// <param name="targetType"> Target type of the resource provided. </param>
        /// <param name="bytesToCapturePerPacket"> Number of bytes captured per packet, the remaining bytes are truncated. </param>
        /// <param name="totalBytesPerSession"> Maximum size of the capture output. </param>
        /// <param name="timeLimitInSeconds"> Maximum duration of the capture session in seconds. </param>
        /// <param name="storageLocation"> The storage location for a packet capture session. </param>
        /// <param name="filters"> A list of packet capture filters. </param>
        /// <param name="isContinuousCapture"> This continuous capture is a nullable boolean, which can hold 'null', 'true' or 'false' value. If we do not pass this parameter, it would be consider as 'null', default value is 'null'. </param>
        /// <param name="captureSettings"> The capture setting holds the 'FileCount', 'FileSizeInBytes', 'SessionTimeLimitInSeconds' values. </param>
        /// <param name="provisioningState"> The provisioning state of the packet capture session. </param>
        /// <returns> A new <see cref="Network.PacketCaptureData"/> instance for mocking. </returns>
        public static PacketCaptureData PacketCaptureData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ETag? etag = null, string target = null, PacketCaptureMachineScope scope = null, PacketCaptureTargetType? targetType = null, long? bytesToCapturePerPacket = null, long? totalBytesPerSession = null, int? timeLimitInSeconds = null, PacketCaptureStorageLocation storageLocation = null, IEnumerable<PacketCaptureFilter> filters = null, bool? isContinuousCapture = null, PacketCaptureSettings captureSettings = null, NetworkProvisioningState? provisioningState = null)
        {
            filters ??= new List<PacketCaptureFilter>();

            return new PacketCaptureData(
                id,
                name,
                resourceType,
                systemData,
                etag,
                target,
                scope,
                targetType,
                bytesToCapturePerPacket,
                totalBytesPerSession,
                timeLimitInSeconds,
                storageLocation,
                filters?.ToList(),
                isContinuousCapture,
                captureSettings,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PacketCaptureQueryStatusResult"/>. </summary>
        /// <param name="name"> The name of the packet capture resource. </param>
        /// <param name="id"> The ID of the packet capture resource. </param>
        /// <param name="captureStartOn"> The start time of the packet capture session. </param>
        /// <param name="packetCaptureStatus"> The status of the packet capture session. </param>
        /// <param name="stopReason"> The reason the current packet capture session was stopped. </param>
        /// <param name="packetCaptureError"> List of errors of packet capture session. </param>
        /// <returns> A new <see cref="Models.PacketCaptureQueryStatusResult"/> instance for mocking. </returns>
        public static PacketCaptureQueryStatusResult PacketCaptureQueryStatusResult(string name = null, string id = null, DateTimeOffset? captureStartOn = null, PcStatus? packetCaptureStatus = null, string stopReason = null, IEnumerable<PcError> packetCaptureError = null)
        {
            packetCaptureError ??= new List<PcError>();

            return new PacketCaptureQueryStatusResult(
                name,
                id,
                captureStartOn,
                packetCaptureStatus,
                stopReason,
                packetCaptureError?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TroubleshootingResult"/>. </summary>
        /// <param name="startOn"> The start time of the troubleshooting. </param>
        /// <param name="endOn"> The end time of the troubleshooting. </param>
        /// <param name="code"> The result code of the troubleshooting. </param>
        /// <param name="results"> Information from troubleshooting. </param>
        /// <returns> A new <see cref="Models.TroubleshootingResult"/> instance for mocking. </returns>
        public static TroubleshootingResult TroubleshootingResult(DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, string code = null, IEnumerable<TroubleshootingDetails> results = null)
        {
            results ??= new List<TroubleshootingDetails>();

            return new TroubleshootingResult(startOn, endOn, code, results?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TroubleshootingDetails"/>. </summary>
        /// <param name="id"> The id of the get troubleshoot operation. </param>
        /// <param name="reasonType"> Reason type of failure. </param>
        /// <param name="summary"> A summary of troubleshooting. </param>
        /// <param name="detail"> Details on troubleshooting results. </param>
        /// <param name="recommendedActions"> List of recommended actions. </param>
        /// <returns> A new <see cref="Models.TroubleshootingDetails"/> instance for mocking. </returns>
        public static TroubleshootingDetails TroubleshootingDetails(string id = null, string reasonType = null, string summary = null, string detail = null, IEnumerable<TroubleshootingRecommendedActions> recommendedActions = null)
        {
            recommendedActions ??= new List<TroubleshootingRecommendedActions>();

            return new TroubleshootingDetails(
                id,
                reasonType,
                summary,
                detail,
                recommendedActions?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TroubleshootingRecommendedActions"/>. </summary>
        /// <param name="actionId"> ID of the recommended action. </param>
        /// <param name="actionText"> Description of recommended actions. </param>
        /// <param name="actionUri"> The uri linking to a documentation for the recommended troubleshooting actions. </param>
        /// <param name="actionUriText"> The information from the URI for the recommended troubleshooting actions. </param>
        /// <returns> A new <see cref="Models.TroubleshootingRecommendedActions"/> instance for mocking. </returns>
        public static TroubleshootingRecommendedActions TroubleshootingRecommendedActions(string actionId = null, string actionText = null, Uri actionUri = null, string actionUriText = null)
        {
            return new TroubleshootingRecommendedActions(actionId, actionText, actionUri, actionUriText, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectivityContent"/>. </summary>
        /// <param name="source"> The source of the connection. </param>
        /// <param name="destination"> The destination of connection. </param>
        /// <param name="protocol"> Network protocol. </param>
        /// <param name="httpProtocolConfiguration"> Configuration of the protocol. </param>
        /// <param name="preferredIPVersion"> Preferred IP version of the connection. </param>
        /// <returns> A new <see cref="Models.ConnectivityContent"/> instance for mocking. </returns>
        public static ConnectivityContent ConnectivityContent(ConnectivitySource source = null, ConnectivityDestination destination = null, NetworkWatcherProtocol? protocol = null, NetworkHttpConfiguration httpProtocolConfiguration = null, NetworkIPVersion? preferredIPVersion = null)
        {
            return new ConnectivityContent(
                source,
                destination,
                protocol,
                httpProtocolConfiguration != null ? new ProtocolConfiguration(httpProtocolConfiguration, serializedAdditionalRawData: null) : null,
                preferredIPVersion,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectivitySource"/>. </summary>
        /// <param name="resourceId"> The ID of the resource from which a connectivity check will be initiated. </param>
        /// <param name="port"> The source port from which a connectivity check will be performed. </param>
        /// <returns> A new <see cref="Models.ConnectivitySource"/> instance for mocking. </returns>
        public static ConnectivitySource ConnectivitySource(ResourceIdentifier resourceId = null, int? port = null)
        {
            return new ConnectivitySource(resourceId, port, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectivityInformation"/>. </summary>
        /// <param name="hops"> List of hops between the source and the destination. </param>
        /// <param name="networkConnectionStatus"> The connection status. </param>
        /// <param name="avgLatencyInMs"> Average latency in milliseconds. </param>
        /// <param name="minLatencyInMs"> Minimum latency in milliseconds. </param>
        /// <param name="maxLatencyInMs"> Maximum latency in milliseconds. </param>
        /// <param name="probesSent"> Total number of probes sent. </param>
        /// <param name="probesFailed"> Number of failed probes. </param>
        /// <returns> A new <see cref="Models.ConnectivityInformation"/> instance for mocking. </returns>
        public static ConnectivityInformation ConnectivityInformation(IEnumerable<ConnectivityHopInfo> hops = null, NetworkConnectionStatus? networkConnectionStatus = null, int? avgLatencyInMs = null, int? minLatencyInMs = null, int? maxLatencyInMs = null, int? probesSent = null, int? probesFailed = null)
        {
            hops ??= new List<ConnectivityHopInfo>();

            return new ConnectivityInformation(
                hops?.ToList(),
                networkConnectionStatus,
                avgLatencyInMs,
                minLatencyInMs,
                maxLatencyInMs,
                probesSent,
                probesFailed,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectivityHopInfo"/>. </summary>
        /// <param name="connectivityHopType"> The type of the hop. </param>
        /// <param name="id"> The ID of the hop. </param>
        /// <param name="address"> The IP address of the hop. </param>
        /// <param name="resourceId"> The ID of the resource corresponding to this hop. </param>
        /// <param name="nextHopIds"> List of next hop identifiers. </param>
        /// <param name="previousHopIds"> List of previous hop identifiers. </param>
        /// <param name="links"> List of hop links. </param>
        /// <param name="previousLinks"> List of previous hop links. </param>
        /// <param name="issues"> List of issues. </param>
        /// <returns> A new <see cref="Models.ConnectivityHopInfo"/> instance for mocking. </returns>
        public static ConnectivityHopInfo ConnectivityHopInfo(string connectivityHopType = null, string id = null, string address = null, ResourceIdentifier resourceId = null, IEnumerable<string> nextHopIds = null, IEnumerable<string> previousHopIds = null, IEnumerable<HopLink> links = null, IEnumerable<HopLink> previousLinks = null, IEnumerable<ConnectivityIssueInfo> issues = null)
        {
            nextHopIds ??= new List<string>();
            previousHopIds ??= new List<string>();
            links ??= new List<HopLink>();
            previousLinks ??= new List<HopLink>();
            issues ??= new List<ConnectivityIssueInfo>();

            return new ConnectivityHopInfo(
                connectivityHopType,
                id,
                address,
                resourceId,
                nextHopIds?.ToList(),
                previousHopIds?.ToList(),
                links?.ToList(),
                previousLinks?.ToList(),
                issues?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HopLink"/>. </summary>
        /// <param name="nextHopId"> The ID of the next hop. </param>
        /// <param name="linkType"> Link type. </param>
        /// <param name="issues"> List of issues. </param>
        /// <param name="context"> Provides additional context on links. </param>
        /// <param name="resourceId"> Resource ID. </param>
        /// <param name="roundTripTimeMin"> Minimum roundtrip time in milliseconds. </param>
        /// <param name="roundTripTimeAvg"> Average roundtrip time in milliseconds. </param>
        /// <param name="roundTripTimeMax"> Maximum roundtrip time in milliseconds. </param>
        /// <returns> A new <see cref="Models.HopLink"/> instance for mocking. </returns>
        public static HopLink HopLink(string nextHopId = null, string linkType = null, IEnumerable<ConnectivityIssueInfo> issues = null, IReadOnlyDictionary<string, string> context = null, ResourceIdentifier resourceId = null, long? roundTripTimeMin = null, long? roundTripTimeAvg = null, long? roundTripTimeMax = null)
        {
            issues ??= new List<ConnectivityIssueInfo>();
            context ??= new Dictionary<string, string>();

            return new HopLink(
                nextHopId,
                linkType,
                issues?.ToList(),
                context,
                resourceId,
                roundTripTimeMin,
                roundTripTimeAvg,
                roundTripTimeMax,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectivityIssueInfo"/>. </summary>
        /// <param name="origin"> The origin of the issue. </param>
        /// <param name="severity"> The severity of the issue. </param>
        /// <param name="connectivityIssueType"> The type of issue. </param>
        /// <param name="contexts"> Provides additional context on the issue. </param>
        /// <returns> A new <see cref="Models.ConnectivityIssueInfo"/> instance for mocking. </returns>
        public static ConnectivityIssueInfo ConnectivityIssueInfo(IssueOrigin? origin = null, IssueSeverity? severity = null, ConnectivityIssueType? connectivityIssueType = null, IEnumerable<IDictionary<string, string>> contexts = null)
        {
            contexts ??= new List<IDictionary<string, string>>();

            return new ConnectivityIssueInfo(origin, severity, connectivityIssueType, contexts?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AzureReachabilityReportContent"/>. </summary>
        /// <param name="providerLocation"> Parameters that define a geographic location. </param>
        /// <param name="providers"> List of Internet service providers. </param>
        /// <param name="azureLocations"> Optional Azure regions to scope the query to. </param>
        /// <param name="startOn"> The start time for the Azure reachability report. </param>
        /// <param name="endOn"> The end time for the Azure reachability report. </param>
        /// <returns> A new <see cref="Models.AzureReachabilityReportContent"/> instance for mocking. </returns>
        public static AzureReachabilityReportContent AzureReachabilityReportContent(AzureReachabilityReportLocation providerLocation = null, IEnumerable<string> providers = null, IEnumerable<AzureLocation> azureLocations = null, DateTimeOffset startOn = default, DateTimeOffset endOn = default)
        {
            providers ??= new List<string>();
            azureLocations ??= new List<AzureLocation>();

            return new AzureReachabilityReportContent(
                providerLocation,
                providers?.ToList(),
                azureLocations?.ToList(),
                startOn,
                endOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AzureReachabilityReport"/>. </summary>
        /// <param name="aggregationLevel"> The aggregation level of Azure reachability report. Can be Country, State or City. </param>
        /// <param name="providerLocation"> Parameters that define a geographic location. </param>
        /// <param name="reachabilityReport"> List of Azure reachability report items. </param>
        /// <returns> A new <see cref="Models.AzureReachabilityReport"/> instance for mocking. </returns>
        public static AzureReachabilityReport AzureReachabilityReport(string aggregationLevel = null, AzureReachabilityReportLocation providerLocation = null, IEnumerable<AzureReachabilityReportItem> reachabilityReport = null)
        {
            reachabilityReport ??= new List<AzureReachabilityReportItem>();

            return new AzureReachabilityReport(aggregationLevel, providerLocation, reachabilityReport?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AzureReachabilityReportItem"/>. </summary>
        /// <param name="provider"> The Internet service provider. </param>
        /// <param name="azureLocation"> The Azure region. </param>
        /// <param name="latencies"> List of latency details for each of the time series. </param>
        /// <returns> A new <see cref="Models.AzureReachabilityReportItem"/> instance for mocking. </returns>
        public static AzureReachabilityReportItem AzureReachabilityReportItem(string provider = null, AzureLocation? azureLocation = null, IEnumerable<AzureReachabilityReportLatencyInfo> latencies = null)
        {
            latencies ??= new List<AzureReachabilityReportLatencyInfo>();

            return new AzureReachabilityReportItem(provider, azureLocation, latencies?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AzureReachabilityReportLatencyInfo"/>. </summary>
        /// <param name="timeStamp"> The time stamp. </param>
        /// <param name="score"> The relative latency score between 1 and 100, higher values indicating a faster connection. </param>
        /// <returns> A new <see cref="Models.AzureReachabilityReportLatencyInfo"/> instance for mocking. </returns>
        public static AzureReachabilityReportLatencyInfo AzureReachabilityReportLatencyInfo(DateTimeOffset? timeStamp = null, int? score = null)
        {
            return new AzureReachabilityReportLatencyInfo(timeStamp, score, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AvailableProvidersList"/>. </summary>
        /// <param name="countries"> List of available countries. </param>
        /// <returns> A new <see cref="Models.AvailableProvidersList"/> instance for mocking. </returns>
        public static AvailableProvidersList AvailableProvidersList(IEnumerable<AvailableProvidersListCountry> countries = null)
        {
            countries ??= new List<AvailableProvidersListCountry>();

            return new AvailableProvidersList(countries?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AvailableProvidersListCountry"/>. </summary>
        /// <param name="countryName"> The country name. </param>
        /// <param name="providers"> A list of Internet service providers. </param>
        /// <param name="states"> List of available states in the country. </param>
        /// <returns> A new <see cref="Models.AvailableProvidersListCountry"/> instance for mocking. </returns>
        public static AvailableProvidersListCountry AvailableProvidersListCountry(string countryName = null, IEnumerable<string> providers = null, IEnumerable<AvailableProvidersListState> states = null)
        {
            providers ??= new List<string>();
            states ??= new List<AvailableProvidersListState>();

            return new AvailableProvidersListCountry(countryName, providers?.ToList(), states?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AvailableProvidersListState"/>. </summary>
        /// <param name="stateName"> The state name. </param>
        /// <param name="providers"> A list of Internet service providers. </param>
        /// <param name="cities"> List of available cities or towns in the state. </param>
        /// <returns> A new <see cref="Models.AvailableProvidersListState"/> instance for mocking. </returns>
        public static AvailableProvidersListState AvailableProvidersListState(string stateName = null, IEnumerable<string> providers = null, IEnumerable<AvailableProvidersListCity> cities = null)
        {
            providers ??= new List<string>();
            cities ??= new List<AvailableProvidersListCity>();

            return new AvailableProvidersListState(stateName, providers?.ToList(), cities?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AvailableProvidersListCity"/>. </summary>
        /// <param name="cityName"> The city or town name. </param>
        /// <param name="providers"> A list of Internet service providers. </param>
        /// <returns> A new <see cref="Models.AvailableProvidersListCity"/> instance for mocking. </returns>
        public static AvailableProvidersListCity AvailableProvidersListCity(string cityName = null, IEnumerable<string> providers = null)
        {
            providers ??= new List<string>();

            return new AvailableProvidersListCity(cityName, providers?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkConfigurationDiagnosticContent"/>. </summary>
        /// <param name="targetResourceId"> The ID of the target resource to perform network configuration diagnostic. Valid options are VM, NetworkInterface, VMSS/NetworkInterface and Application Gateway. </param>
        /// <param name="verbosityLevel"> Verbosity level. </param>
        /// <param name="profiles"> List of network configuration diagnostic profiles. </param>
        /// <returns> A new <see cref="Models.NetworkConfigurationDiagnosticContent"/> instance for mocking. </returns>
        public static NetworkConfigurationDiagnosticContent NetworkConfigurationDiagnosticContent(ResourceIdentifier targetResourceId = null, VerbosityLevel? verbosityLevel = null, IEnumerable<NetworkConfigurationDiagnosticProfile> profiles = null)
        {
            profiles ??= new List<NetworkConfigurationDiagnosticProfile>();

            return new NetworkConfigurationDiagnosticContent(targetResourceId, verbosityLevel, profiles?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkConfigurationDiagnosticResponse"/>. </summary>
        /// <param name="results"> List of network configuration diagnostic results. </param>
        /// <returns> A new <see cref="Models.NetworkConfigurationDiagnosticResponse"/> instance for mocking. </returns>
        public static NetworkConfigurationDiagnosticResponse NetworkConfigurationDiagnosticResponse(IEnumerable<NetworkConfigurationDiagnosticResult> results = null)
        {
            results ??= new List<NetworkConfigurationDiagnosticResult>();

            return new NetworkConfigurationDiagnosticResponse(results?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkConfigurationDiagnosticResult"/>. </summary>
        /// <param name="profile"> Network configuration diagnostic profile. </param>
        /// <param name="networkSecurityGroupResult"> Network security group result. </param>
        /// <returns> A new <see cref="Models.NetworkConfigurationDiagnosticResult"/> instance for mocking. </returns>
        public static NetworkConfigurationDiagnosticResult NetworkConfigurationDiagnosticResult(NetworkConfigurationDiagnosticProfile profile = null, NetworkSecurityGroupResult networkSecurityGroupResult = null)
        {
            return new NetworkConfigurationDiagnosticResult(profile, networkSecurityGroupResult, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkSecurityGroupResult"/>. </summary>
        /// <param name="securityRuleAccessResult"> The network traffic is allowed or denied. </param>
        /// <param name="evaluatedNetworkSecurityGroups"> List of results network security groups diagnostic. </param>
        /// <returns> A new <see cref="Models.NetworkSecurityGroupResult"/> instance for mocking. </returns>
        public static NetworkSecurityGroupResult NetworkSecurityGroupResult(SecurityRuleAccess? securityRuleAccessResult = null, IEnumerable<EvaluatedNetworkSecurityGroup> evaluatedNetworkSecurityGroups = null)
        {
            evaluatedNetworkSecurityGroups ??= new List<EvaluatedNetworkSecurityGroup>();

            return new NetworkSecurityGroupResult(securityRuleAccessResult, evaluatedNetworkSecurityGroups?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EvaluatedNetworkSecurityGroup"/>. </summary>
        /// <param name="networkSecurityGroupId"> Network security group ID. </param>
        /// <param name="appliedTo"> Resource ID of nic or subnet to which network security group is applied. </param>
        /// <param name="matchedRule"> Matched network security rule. </param>
        /// <param name="rulesEvaluationResult"> List of network security rules evaluation results. </param>
        /// <returns> A new <see cref="Models.EvaluatedNetworkSecurityGroup"/> instance for mocking. </returns>
        public static EvaluatedNetworkSecurityGroup EvaluatedNetworkSecurityGroup(ResourceIdentifier networkSecurityGroupId = null, string appliedTo = null, MatchedRule matchedRule = null, IEnumerable<NetworkSecurityRulesEvaluationResult> rulesEvaluationResult = null)
        {
            rulesEvaluationResult ??= new List<NetworkSecurityRulesEvaluationResult>();

            return new EvaluatedNetworkSecurityGroup(networkSecurityGroupId, appliedTo, matchedRule, rulesEvaluationResult?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MatchedRule"/>. </summary>
        /// <param name="ruleName"> Name of the matched network security rule. </param>
        /// <param name="action"> The network traffic is allowed or denied. Possible values are 'Allow' and 'Deny'. </param>
        /// <returns> A new <see cref="Models.MatchedRule"/> instance for mocking. </returns>
        public static MatchedRule MatchedRule(string ruleName = null, string action = null)
        {
            return new MatchedRule(ruleName, action, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkSecurityRulesEvaluationResult"/>. </summary>
        /// <param name="name"> Name of the network security rule. </param>
        /// <param name="protocolMatched"> Value indicating whether protocol is matched. </param>
        /// <param name="sourceMatched"> Value indicating whether source is matched. </param>
        /// <param name="sourcePortMatched"> Value indicating whether source port is matched. </param>
        /// <param name="destinationMatched"> Value indicating whether destination is matched. </param>
        /// <param name="destinationPortMatched"> Value indicating whether destination port is matched. </param>
        /// <returns> A new <see cref="Models.NetworkSecurityRulesEvaluationResult"/> instance for mocking. </returns>
        public static NetworkSecurityRulesEvaluationResult NetworkSecurityRulesEvaluationResult(string name = null, bool? protocolMatched = null, bool? sourceMatched = null, bool? sourcePortMatched = null, bool? destinationMatched = null, bool? destinationPortMatched = null)
        {
            return new NetworkSecurityRulesEvaluationResult(
                name,
                protocolMatched,
                sourceMatched,
                sourcePortMatched,
                destinationMatched,
                destinationPortMatched,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.ConnectionMonitorData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="location"> Connection monitor location. </param>
        /// <param name="tags"> Connection monitor tags. </param>
        /// <param name="source"> Describes the source of connection monitor. </param>
        /// <param name="destination"> Describes the destination of connection monitor. </param>
        /// <param name="autoStart"> Determines if the connection monitor will start automatically once created. </param>
        /// <param name="monitoringIntervalInSeconds"> Monitoring interval in seconds. </param>
        /// <param name="endpoints"> List of connection monitor endpoints. </param>
        /// <param name="testConfigurations"> List of connection monitor test configurations. </param>
        /// <param name="testGroups"> List of connection monitor test groups. </param>
        /// <param name="outputs"> List of connection monitor outputs. </param>
        /// <param name="notes"> Optional notes to be associated with the connection monitor. </param>
        /// <param name="provisioningState"> The provisioning state of the connection monitor. </param>
        /// <param name="startOn"> The date and time when the connection monitor was started. </param>
        /// <param name="monitoringStatus"> The monitoring status of the connection monitor. </param>
        /// <param name="connectionMonitorType"> Type of connection monitor. </param>
        /// <returns> A new <see cref="Network.ConnectionMonitorData"/> instance for mocking. </returns>
        public static ConnectionMonitorData ConnectionMonitorData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ETag? etag = null, AzureLocation? location = null, IReadOnlyDictionary<string, string> tags = null, ConnectionMonitorSource source = null, ConnectionMonitorDestination destination = null, bool? autoStart = null, int? monitoringIntervalInSeconds = null, IEnumerable<ConnectionMonitorEndpoint> endpoints = null, IEnumerable<ConnectionMonitorTestConfiguration> testConfigurations = null, IEnumerable<ConnectionMonitorTestGroup> testGroups = null, IEnumerable<ConnectionMonitorOutput> outputs = null, string notes = null, NetworkProvisioningState? provisioningState = null, DateTimeOffset? startOn = null, string monitoringStatus = null, ConnectionMonitorType? connectionMonitorType = null)
        {
            tags ??= new Dictionary<string, string>();
            endpoints ??= new List<ConnectionMonitorEndpoint>();
            testConfigurations ??= new List<ConnectionMonitorTestConfiguration>();
            testGroups ??= new List<ConnectionMonitorTestGroup>();
            outputs ??= new List<ConnectionMonitorOutput>();

            return new ConnectionMonitorData(
                id,
                name,
                resourceType,
                systemData,
                etag,
                location,
                tags,
                source,
                destination,
                autoStart,
                monitoringIntervalInSeconds,
                endpoints?.ToList(),
                testConfigurations?.ToList(),
                testGroups?.ToList(),
                outputs?.ToList(),
                notes,
                provisioningState,
                startOn,
                monitoringStatus,
                connectionMonitorType,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectionMonitorQueryResult"/>. </summary>
        /// <param name="sourceStatus"> Status of connection monitor source. </param>
        /// <param name="states"> Information about connection states. </param>
        /// <returns> A new <see cref="Models.ConnectionMonitorQueryResult"/> instance for mocking. </returns>
        public static ConnectionMonitorQueryResult ConnectionMonitorQueryResult(ConnectionMonitorSourceStatus? sourceStatus = null, IEnumerable<ConnectionStateSnapshot> states = null)
        {
            states ??= new List<ConnectionStateSnapshot>();

            return new ConnectionMonitorQueryResult(sourceStatus, states?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectionStateSnapshot"/>. </summary>
        /// <param name="networkConnectionState"> The connection state. </param>
        /// <param name="startOn"> The start time of the connection snapshot. </param>
        /// <param name="endOn"> The end time of the connection snapshot. </param>
        /// <param name="evaluationState"> Connectivity analysis evaluation state. </param>
        /// <param name="avgLatencyInMs"> Average latency in ms. </param>
        /// <param name="minLatencyInMs"> Minimum latency in ms. </param>
        /// <param name="maxLatencyInMs"> Maximum latency in ms. </param>
        /// <param name="probesSent"> The number of sent probes. </param>
        /// <param name="probesFailed"> The number of failed probes. </param>
        /// <param name="hops"> List of hops between the source and the destination. </param>
        /// <returns> A new <see cref="Models.ConnectionStateSnapshot"/> instance for mocking. </returns>
        public static ConnectionStateSnapshot ConnectionStateSnapshot(NetworkConnectionState? networkConnectionState = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, EvaluationState? evaluationState = null, long? avgLatencyInMs = null, long? minLatencyInMs = null, long? maxLatencyInMs = null, long? probesSent = null, long? probesFailed = null, IEnumerable<ConnectivityHopInfo> hops = null)
        {
            hops ??= new List<ConnectivityHopInfo>();

            return new ConnectionStateSnapshot(
                networkConnectionState,
                startOn,
                endOn,
                evaluationState,
                avgLatencyInMs,
                minLatencyInMs,
                maxLatencyInMs,
                probesSent,
                probesFailed,
                hops?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AvailablePrivateEndpointType"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="resourceName"> The name of the service and resource. </param>
        /// <param name="displayName"> Display name of the resource. </param>
        /// <returns> A new <see cref="Models.AvailablePrivateEndpointType"/> instance for mocking. </returns>
        public static AvailablePrivateEndpointType AvailablePrivateEndpointType(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string resourceName = null, string displayName = null)
        {
            return new AvailablePrivateEndpointType(
                id,
                name,
                resourceType,
                systemData,
                resourceName,
                displayName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.PrivateDnsZoneGroupData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="provisioningState"> The provisioning state of the private dns zone group resource. </param>
        /// <param name="privateDnsZoneConfigs"> A collection of private dns zone configurations of the private dns zone group. </param>
        /// <returns> A new <see cref="Network.PrivateDnsZoneGroupData"/> instance for mocking. </returns>
        public static PrivateDnsZoneGroupData PrivateDnsZoneGroupData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, NetworkProvisioningState? provisioningState = null, IEnumerable<PrivateDnsZoneConfig> privateDnsZoneConfigs = null)
        {
            privateDnsZoneConfigs ??= new List<PrivateDnsZoneConfig>();

            return new PrivateDnsZoneGroupData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                provisioningState,
                privateDnsZoneConfigs?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.PrivateDnsZoneConfig"/>. </summary>
        /// <param name="name"> Name of the resource that is unique within a resource group. This name can be used to access the resource. </param>
        /// <param name="privateDnsZoneId"> The resource id of the private dns zone. </param>
        /// <param name="recordSets"> A collection of information regarding a recordSet, holding information to identify private resources. </param>
        /// <returns> A new <see cref="Models.PrivateDnsZoneConfig"/> instance for mocking. </returns>
        public static PrivateDnsZoneConfig PrivateDnsZoneConfig(string name = null, string privateDnsZoneId = null, IEnumerable<RecordSet> recordSets = null)
        {
            recordSets ??= new List<RecordSet>();

            return new PrivateDnsZoneConfig(name, privateDnsZoneId, recordSets?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RecordSet"/>. </summary>
        /// <param name="recordType"> Resource record type. </param>
        /// <param name="recordSetName"> Recordset name. </param>
        /// <param name="fqdn"> Fqdn that resolves to private endpoint ip address. </param>
        /// <param name="provisioningState"> The provisioning state of the recordset. </param>
        /// <param name="ttl"> Recordset time to live. </param>
        /// <param name="ipAddresses"> The private ip address of the private endpoint. </param>
        /// <returns> A new <see cref="Models.RecordSet"/> instance for mocking. </returns>
        public static RecordSet RecordSet(string recordType = null, string recordSetName = null, string fqdn = null, NetworkProvisioningState? provisioningState = null, int? ttl = null, IEnumerable<string> ipAddresses = null)
        {
            ipAddresses ??= new List<string>();

            return new RecordSet(
                recordType,
                recordSetName,
                fqdn,
                provisioningState,
                ttl,
                ipAddresses?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PrivateLinkServiceVisibility"/>. </summary>
        /// <param name="visible"> Private Link Service Visibility (True/False). </param>
        /// <returns> A new <see cref="Models.PrivateLinkServiceVisibility"/> instance for mocking. </returns>
        public static PrivateLinkServiceVisibility PrivateLinkServiceVisibility(bool? visible = null)
        {
            return new PrivateLinkServiceVisibility(visible, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AutoApprovedPrivateLinkService"/>. </summary>
        /// <param name="privateLinkService"> The id of the private link service resource. </param>
        /// <returns> A new <see cref="Models.AutoApprovedPrivateLinkService"/> instance for mocking. </returns>
        public static AutoApprovedPrivateLinkService AutoApprovedPrivateLinkService(string privateLinkService = null)
        {
            return new AutoApprovedPrivateLinkService(privateLinkService, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PublicIPDdosProtectionStatusResult"/>. </summary>
        /// <param name="publicIPAddressId"> Public IP ARM resource ID. </param>
        /// <param name="publicIPAddress"> IP Address of the Public IP Resource. </param>
        /// <param name="isWorkloadProtected"> Value indicating whether the IP address is DDoS workload protected or not. </param>
        /// <param name="ddosProtectionPlanId"> DDoS protection plan Resource Id of a if IP address is protected through a plan. </param>
        /// <returns> A new <see cref="Models.PublicIPDdosProtectionStatusResult"/> instance for mocking. </returns>
        public static PublicIPDdosProtectionStatusResult PublicIPDdosProtectionStatusResult(ResourceIdentifier publicIPAddressId = null, IPAddress publicIPAddress = null, WorkloadProtectedFlag? isWorkloadProtected = null, ResourceIdentifier ddosProtectionPlanId = null)
        {
            return new PublicIPDdosProtectionStatusResult(publicIPAddressId, publicIPAddress, isWorkloadProtected, ddosProtectionPlanId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.PublicIPPrefixData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="extendedLocation"> The extended location of the public ip address. </param>
        /// <param name="sku"> The public IP prefix SKU. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="zones"> A list of availability zones denoting the IP allocated for the resource needs to come from. </param>
        /// <param name="publicIPAddressVersion"> The public IP address version. </param>
        /// <param name="ipTags"> The list of tags associated with the public IP prefix. </param>
        /// <param name="prefixLength"> The Length of the Public IP Prefix. </param>
        /// <param name="ipPrefix"> The allocated Prefix. </param>
        /// <param name="publicIPAddresses"> The list of all referenced PublicIPAddresses. </param>
        /// <param name="loadBalancerFrontendIPConfigurationId"> The reference to load balancer frontend IP configuration associated with the public IP prefix. </param>
        /// <param name="customIPPrefixId"> The customIpPrefix that this prefix is associated with. </param>
        /// <param name="resourceGuid"> The resource GUID property of the public IP prefix resource. </param>
        /// <param name="provisioningState"> The provisioning state of the public IP prefix resource. </param>
        /// <param name="natGateway"> NatGateway of Public IP Prefix. </param>
        /// <returns> A new <see cref="Network.PublicIPPrefixData"/> instance for mocking. </returns>
        public static PublicIPPrefixData PublicIPPrefixData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ExtendedLocation extendedLocation = null, PublicIPPrefixSku sku = null, ETag? etag = null, IEnumerable<string> zones = null, NetworkIPVersion? publicIPAddressVersion = null, IEnumerable<IPTag> ipTags = null, int? prefixLength = null, string ipPrefix = null, IEnumerable<SubResource> publicIPAddresses = null, ResourceIdentifier loadBalancerFrontendIPConfigurationId = null, ResourceIdentifier customIPPrefixId = null, Guid? resourceGuid = null, NetworkProvisioningState? provisioningState = null, NatGatewayData natGateway = null)
        {
            tags ??= new Dictionary<string, string>();
            zones ??= new List<string>();
            ipTags ??= new List<IPTag>();
            publicIPAddresses ??= new List<SubResource>();

            return new PublicIPPrefixData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                extendedLocation,
                sku,
                etag,
                zones?.ToList(),
                publicIPAddressVersion,
                ipTags?.ToList(),
                prefixLength,
                ipPrefix,
                publicIPAddresses?.ToList(),
                loadBalancerFrontendIPConfigurationId != null ? ResourceManagerModelFactory.WritableSubResource(loadBalancerFrontendIPConfigurationId) : null,
                customIPPrefixId != null ? ResourceManagerModelFactory.WritableSubResource(customIPPrefixId) : null,
                resourceGuid,
                provisioningState,
                natGateway);
        }

        /// <summary> Initializes a new instance of <see cref="Network.RouteFilterData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="rules"> Collection of RouteFilterRules contained within a route filter. </param>
        /// <param name="peerings"> A collection of references to express route circuit peerings. </param>
        /// <param name="ipv6Peerings"> A collection of references to express route circuit ipv6 peerings. </param>
        /// <param name="provisioningState"> The provisioning state of the route filter resource. </param>
        /// <returns> A new <see cref="Network.RouteFilterData"/> instance for mocking. </returns>
        public static RouteFilterData RouteFilterData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, IEnumerable<RouteFilterRuleData> rules = null, IEnumerable<ExpressRouteCircuitPeeringData> peerings = null, IEnumerable<ExpressRouteCircuitPeeringData> ipv6Peerings = null, NetworkProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            rules ??= new List<RouteFilterRuleData>();
            peerings ??= new List<ExpressRouteCircuitPeeringData>();
            ipv6Peerings ??= new List<ExpressRouteCircuitPeeringData>();

            return new RouteFilterData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                rules?.ToList(),
                peerings?.ToList(),
                ipv6Peerings?.ToList(),
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Network.RouteFilterRuleData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="access"> The access type of the rule. </param>
        /// <param name="routeFilterRuleType"> The rule type of the rule. </param>
        /// <param name="communities"> The collection for bgp community values to filter on. e.g. ['12076:5010','12076:5020']. </param>
        /// <param name="provisioningState"> The provisioning state of the route filter rule resource. </param>
        /// <returns> A new <see cref="Network.RouteFilterRuleData"/> instance for mocking. </returns>
        public static RouteFilterRuleData RouteFilterRuleData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, ETag? etag = null, NetworkAccess? access = null, RouteFilterRuleType? routeFilterRuleType = null, IEnumerable<string> communities = null, NetworkProvisioningState? provisioningState = null)
        {
            communities ??= new List<string>();

            return new RouteFilterRuleData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                location,
                etag,
                access,
                routeFilterRuleType,
                communities?.ToList(),
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Network.SecurityPartnerProviderData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="provisioningState"> The provisioning state of the Security Partner Provider resource. </param>
        /// <param name="securityProviderName"> The security provider name. </param>
        /// <param name="connectionStatus"> The connection status with the Security Partner Provider. </param>
        /// <param name="virtualHubId"> The virtualHub to which the Security Partner Provider belongs. </param>
        /// <returns> A new <see cref="Network.SecurityPartnerProviderData"/> instance for mocking. </returns>
        public static SecurityPartnerProviderData SecurityPartnerProviderData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, NetworkProvisioningState? provisioningState = null, SecurityProviderName? securityProviderName = null, SecurityPartnerProviderConnectionStatus? connectionStatus = null, ResourceIdentifier virtualHubId = null)
        {
            tags ??= new Dictionary<string, string>();

            return new SecurityPartnerProviderData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                provisioningState,
                securityProviderName,
                connectionStatus,
                virtualHubId != null ? ResourceManagerModelFactory.WritableSubResource(virtualHubId) : null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BgpServiceCommunity"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="serviceName"> The name of the bgp community. e.g. Skype. </param>
        /// <param name="bgpCommunities"> A list of bgp communities. </param>
        /// <returns> A new <see cref="Models.BgpServiceCommunity"/> instance for mocking. </returns>
        public static BgpServiceCommunity BgpServiceCommunity(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, string serviceName = null, IEnumerable<BgpCommunity> bgpCommunities = null)
        {
            tags ??= new Dictionary<string, string>();
            bgpCommunities ??= new List<BgpCommunity>();

            return new BgpServiceCommunity(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                serviceName,
                bgpCommunities?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServiceTagsListResult"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="changeNumber"> The iteration number. </param>
        /// <param name="cloud"> The name of the cloud. </param>
        /// <param name="values"> The list of service tag information resources. </param>
        /// <param name="nextLink"> The URL to get next page of service tag information resources. </param>
        /// <returns> A new <see cref="Models.ServiceTagsListResult"/> instance for mocking. </returns>
        public static ServiceTagsListResult ServiceTagsListResult(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string changeNumber = null, string cloud = null, IEnumerable<ServiceTagInformation> values = null, string nextLink = null)
        {
            values ??= new List<ServiceTagInformation>();

            return new ServiceTagsListResult(
                id,
                name,
                resourceType,
                systemData,
                changeNumber,
                cloud,
                values?.ToList(),
                nextLink,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServiceTagInformation"/>. </summary>
        /// <param name="properties"> Properties of the service tag information. </param>
        /// <param name="name"> The name of service tag. </param>
        /// <param name="id"> The ID of service tag. </param>
        /// <param name="serviceTagChangeNumber"> The iteration number of service tag object for region. </param>
        /// <returns> A new <see cref="Models.ServiceTagInformation"/> instance for mocking. </returns>
        public static ServiceTagInformation ServiceTagInformation(ServiceTagInformationPropertiesFormat properties = null, string name = null, string id = null, string serviceTagChangeNumber = null)
        {
            return new ServiceTagInformation(properties, name, id, serviceTagChangeNumber, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServiceTagInformationPropertiesFormat"/>. </summary>
        /// <param name="changeNumber"> The iteration number of service tag. </param>
        /// <param name="region"> The region of service tag. </param>
        /// <param name="systemService"> The name of system service. </param>
        /// <param name="addressPrefixes"> The list of IP address prefixes. </param>
        /// <param name="state"> The state of the service tag. </param>
        /// <returns> A new <see cref="Models.ServiceTagInformationPropertiesFormat"/> instance for mocking. </returns>
        public static ServiceTagInformationPropertiesFormat ServiceTagInformationPropertiesFormat(string changeNumber = null, string region = null, string systemService = null, IEnumerable<string> addressPrefixes = null, string state = null)
        {
            addressPrefixes ??= new List<string>();

            return new ServiceTagInformationPropertiesFormat(
                changeNumber,
                region,
                systemService,
                addressPrefixes?.ToList(),
                state,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkUsage"/>. </summary>
        /// <param name="id"> Resource identifier. </param>
        /// <param name="unit"> An enum describing the unit of measurement. </param>
        /// <param name="currentValue"> The current value of the usage. </param>
        /// <param name="limit"> The limit of usage. </param>
        /// <param name="name"> The name of the type of usage. </param>
        /// <returns> A new <see cref="Models.NetworkUsage"/> instance for mocking. </returns>
        public static NetworkUsage NetworkUsage(ResourceIdentifier id = null, NetworkUsageUnit unit = default, long currentValue = default, long limit = default, NetworkUsageName name = null)
        {
            return new NetworkUsage(
                id,
                unit,
                currentValue,
                limit,
                name,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkUsageName"/>. </summary>
        /// <param name="value"> A string describing the resource name. </param>
        /// <param name="localizedValue"> A localized string describing the resource name. </param>
        /// <returns> A new <see cref="Models.NetworkUsageName"/> instance for mocking. </returns>
        public static NetworkUsageName NetworkUsageName(string value = null, string localizedValue = null)
        {
            return new NetworkUsageName(value, localizedValue, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.VirtualNetworkData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="extendedLocation"> The extended location of the virtual network. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="addressPrefixes"> The AddressSpace that contains an array of IP address ranges that can be used by subnets. </param>
        /// <param name="dhcpOptionsDnsServers"> The dhcpOptions that contains an array of DNS servers available to VMs deployed in the virtual network. </param>
        /// <param name="flowTimeoutInMinutes"> The FlowTimeout value (in minutes) for the Virtual Network. </param>
        /// <param name="subnets"> A list of subnets in a Virtual Network. </param>
        /// <param name="virtualNetworkPeerings"> A list of peerings in a Virtual Network. </param>
        /// <param name="resourceGuid"> The resourceGuid property of the Virtual Network resource. </param>
        /// <param name="provisioningState"> The provisioning state of the virtual network resource. </param>
        /// <param name="enableDdosProtection"> Indicates if DDoS protection is enabled for all the protected resources in the virtual network. It requires a DDoS protection plan associated with the resource. </param>
        /// <param name="enableVmProtection"> Indicates if VM protection is enabled for all the subnets in the virtual network. </param>
        /// <param name="ddosProtectionPlanId"> The DDoS protection plan associated with the virtual network. </param>
        /// <param name="bgpCommunities"> Bgp Communities sent over ExpressRoute with each route corresponding to a prefix in this VNET. </param>
        /// <param name="encryption"> Indicates if encryption is enabled on virtual network and if VM without encryption is allowed in encrypted VNet. </param>
        /// <param name="ipAllocations"> Array of IpAllocation which reference this VNET. </param>
        /// <param name="flowLogs"> A collection of references to flow log resources. </param>
        /// <param name="privateEndpointVnetPolicy"> Private Endpoint VNet Policies. </param>
        /// <returns> A new <see cref="Network.VirtualNetworkData"/> instance for mocking. </returns>
        public static VirtualNetworkData VirtualNetworkData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ExtendedLocation extendedLocation = null, ETag? etag = null, IEnumerable<string> addressPrefixes = null, IEnumerable<string> dhcpOptionsDnsServers = null, int? flowTimeoutInMinutes = null, IEnumerable<SubnetData> subnets = null, IEnumerable<VirtualNetworkPeeringData> virtualNetworkPeerings = null, Guid? resourceGuid = null, NetworkProvisioningState? provisioningState = null, bool? enableDdosProtection = null, bool? enableVmProtection = null, ResourceIdentifier ddosProtectionPlanId = null, VirtualNetworkBgpCommunities bgpCommunities = null, VirtualNetworkEncryption encryption = null, IEnumerable<WritableSubResource> ipAllocations = null, IEnumerable<FlowLogData> flowLogs = null, PrivateEndpointVnetPolicy? privateEndpointVnetPolicy = null)
        {
            tags ??= new Dictionary<string, string>();
            addressPrefixes ??= new List<string>();
            dhcpOptionsDnsServers ??= new List<string>();
            subnets ??= new List<SubnetData>();
            virtualNetworkPeerings ??= new List<VirtualNetworkPeeringData>();
            ipAllocations ??= new List<WritableSubResource>();
            flowLogs ??= new List<FlowLogData>();

            return new VirtualNetworkData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                extendedLocation,
                etag,
                addressPrefixes != null ? new AddressSpace(addressPrefixes?.ToList(), serializedAdditionalRawData: null) : null,
                dhcpOptionsDnsServers != null ? new DhcpOptions(dhcpOptionsDnsServers?.ToList(), serializedAdditionalRawData: null) : null,
                flowTimeoutInMinutes,
                subnets?.ToList(),
                virtualNetworkPeerings?.ToList(),
                resourceGuid,
                provisioningState,
                enableDdosProtection,
                enableVmProtection,
                ddosProtectionPlanId != null ? ResourceManagerModelFactory.WritableSubResource(ddosProtectionPlanId) : null,
                bgpCommunities,
                encryption,
                ipAllocations?.ToList(),
                flowLogs?.ToList(),
                privateEndpointVnetPolicy);
        }

        /// <summary> Initializes a new instance of <see cref="Network.VirtualNetworkPeeringData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="allowVirtualNetworkAccess"> Whether the VMs in the local virtual network space would be able to access the VMs in remote virtual network space. </param>
        /// <param name="allowForwardedTraffic"> Whether the forwarded traffic from the VMs in the local virtual network will be allowed/disallowed in remote virtual network. </param>
        /// <param name="allowGatewayTransit"> If gateway links can be used in remote virtual networking to link to this virtual network. </param>
        /// <param name="useRemoteGateways"> If remote gateways can be used on this virtual network. If the flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to true. This flag cannot be set if virtual network already has a gateway. </param>
        /// <param name="remoteVirtualNetworkId"> The reference to the remote virtual network. The remote virtual network can be in the same or different region (preview). See here to register for the preview and learn more (https://docs.microsoft.com/en-us/azure/virtual-network/virtual-network-create-peering). </param>
        /// <param name="localAddressPrefixes"> The local address space of the local virtual network that is peered. </param>
        /// <param name="localVirtualNetworkAddressPrefixes"> The current local address space of the local virtual network that is peered. </param>
        /// <param name="remoteAddressPrefixes"> The reference to the address space peered with the remote virtual network. </param>
        /// <param name="remoteVirtualNetworkAddressPrefixes"> The reference to the current address space of the remote virtual network. </param>
        /// <param name="remoteBgpCommunities"> The reference to the remote virtual network's Bgp Communities. </param>
        /// <param name="remoteVirtualNetworkEncryption"> The reference to the remote virtual network's encryption. </param>
        /// <param name="peeringState"> The status of the virtual network peering. </param>
        /// <param name="peeringSyncLevel"> The peering sync status of the virtual network peering. </param>
        /// <param name="provisioningState"> The provisioning state of the virtual network peering resource. </param>
        /// <param name="doNotVerifyRemoteGateways"> If we need to verify the provisioning state of the remote gateway. </param>
        /// <param name="resourceGuid"> The resourceGuid property of the Virtual Network peering resource. </param>
        /// <param name="areCompleteVnetsPeered"> Whether complete virtual network address space is peered. </param>
        /// <param name="enableOnlyIPv6Peering"> Whether only Ipv6 address space is peered for subnet peering. </param>
        /// <param name="localSubnetNames"> List of local subnet names that are subnet peered with remote virtual network. </param>
        /// <param name="remoteSubnetNames"> List of remote subnet names from remote virtual network that are subnet peered. </param>
        /// <returns> A new <see cref="Network.VirtualNetworkPeeringData"/> instance for mocking. </returns>
        public static VirtualNetworkPeeringData VirtualNetworkPeeringData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, bool? allowVirtualNetworkAccess = null, bool? allowForwardedTraffic = null, bool? allowGatewayTransit = null, bool? useRemoteGateways = null, ResourceIdentifier remoteVirtualNetworkId = null, IEnumerable<string> localAddressPrefixes = null, IEnumerable<string> localVirtualNetworkAddressPrefixes = null, IEnumerable<string> remoteAddressPrefixes = null, IEnumerable<string> remoteVirtualNetworkAddressPrefixes = null, VirtualNetworkBgpCommunities remoteBgpCommunities = null, VirtualNetworkEncryption remoteVirtualNetworkEncryption = null, VirtualNetworkPeeringState? peeringState = null, VirtualNetworkPeeringLevel? peeringSyncLevel = null, NetworkProvisioningState? provisioningState = null, bool? doNotVerifyRemoteGateways = null, Guid? resourceGuid = null, bool? areCompleteVnetsPeered = null, bool? enableOnlyIPv6Peering = null, IEnumerable<string> localSubnetNames = null, IEnumerable<string> remoteSubnetNames = null)
        {
            localAddressPrefixes ??= new List<string>();
            localVirtualNetworkAddressPrefixes ??= new List<string>();
            remoteAddressPrefixes ??= new List<string>();
            remoteVirtualNetworkAddressPrefixes ??= new List<string>();
            localSubnetNames ??= new List<string>();
            remoteSubnetNames ??= new List<string>();

            return new VirtualNetworkPeeringData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                allowVirtualNetworkAccess,
                allowForwardedTraffic,
                allowGatewayTransit,
                useRemoteGateways,
                remoteVirtualNetworkId != null ? ResourceManagerModelFactory.WritableSubResource(remoteVirtualNetworkId) : null,
                localAddressPrefixes != null ? new AddressSpace(localAddressPrefixes?.ToList(), serializedAdditionalRawData: null) : null,
                localVirtualNetworkAddressPrefixes != null ? new AddressSpace(localVirtualNetworkAddressPrefixes?.ToList(), serializedAdditionalRawData: null) : null,
                remoteAddressPrefixes != null ? new AddressSpace(remoteAddressPrefixes?.ToList(), serializedAdditionalRawData: null) : null,
                remoteVirtualNetworkAddressPrefixes != null ? new AddressSpace(remoteVirtualNetworkAddressPrefixes?.ToList(), serializedAdditionalRawData: null) : null,
                remoteBgpCommunities,
                remoteVirtualNetworkEncryption,
                peeringState,
                peeringSyncLevel,
                provisioningState,
                doNotVerifyRemoteGateways,
                resourceGuid,
                areCompleteVnetsPeered,
                enableOnlyIPv6Peering,
                localSubnetNames?.ToList(),
                remoteSubnetNames?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.VirtualNetworkBgpCommunities"/>. </summary>
        /// <param name="virtualNetworkCommunity"> The BGP community associated with the virtual network. </param>
        /// <param name="regionalCommunity"> The BGP community associated with the region of the virtual network. </param>
        /// <returns> A new <see cref="Models.VirtualNetworkBgpCommunities"/> instance for mocking. </returns>
        public static VirtualNetworkBgpCommunities VirtualNetworkBgpCommunities(string virtualNetworkCommunity = null, string regionalCommunity = null)
        {
            return new VirtualNetworkBgpCommunities(virtualNetworkCommunity, regionalCommunity, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkIntentPolicy"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <returns> A new <see cref="Models.NetworkIntentPolicy"/> instance for mocking. </returns>
        public static NetworkIntentPolicy NetworkIntentPolicy(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null)
        {
            tags ??= new Dictionary<string, string>();

            return new NetworkIntentPolicy(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IPAddressAvailabilityResult"/>. </summary>
        /// <param name="available"> Private IP address availability. </param>
        /// <param name="availableIPAddresses"> Contains other available private IP addresses if the asked for address is taken. </param>
        /// <param name="isPlatformReserved"> Private IP address platform reserved. </param>
        /// <returns> A new <see cref="Models.IPAddressAvailabilityResult"/> instance for mocking. </returns>
        public static IPAddressAvailabilityResult IPAddressAvailabilityResult(bool? available = null, IEnumerable<string> availableIPAddresses = null, bool? isPlatformReserved = null)
        {
            availableIPAddresses ??= new List<string>();

            return new IPAddressAvailabilityResult(available, availableIPAddresses?.ToList(), isPlatformReserved, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VirtualNetworkUsage"/>. </summary>
        /// <param name="currentValue"> Indicates number of IPs used from the Subnet. </param>
        /// <param name="id"> Subnet identifier. </param>
        /// <param name="limit"> Indicates the size of the subnet. </param>
        /// <param name="name"> The name containing common and localized value for usage. </param>
        /// <param name="unit"> Usage units. Returns 'Count'. </param>
        /// <returns> A new <see cref="Models.VirtualNetworkUsage"/> instance for mocking. </returns>
        public static VirtualNetworkUsage VirtualNetworkUsage(double? currentValue = null, ResourceIdentifier id = null, double? limit = null, VirtualNetworkUsageName name = null, string unit = null)
        {
            return new VirtualNetworkUsage(
                currentValue,
                id,
                limit,
                name,
                unit,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VirtualNetworkUsageName"/>. </summary>
        /// <param name="localizedValue"> Localized subnet size and usage string. </param>
        /// <param name="value"> Subnet size and usage string. </param>
        /// <returns> A new <see cref="Models.VirtualNetworkUsageName"/> instance for mocking. </returns>
        public static VirtualNetworkUsageName VirtualNetworkUsageName(string localizedValue = null, string value = null)
        {
            return new VirtualNetworkUsageName(localizedValue, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.VirtualNetworkGatewayData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="extendedLocation"> The extended location of type local virtual network gateway. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="identity"> The identity of the virtual network gateway, if configured. </param>
        /// <param name="autoScaleBounds"> Autoscale configuration for virutal network gateway. </param>
        /// <param name="ipConfigurations"> IP configurations for virtual network gateway. </param>
        /// <param name="gatewayType"> The type of this virtual network gateway. </param>
        /// <param name="vpnType"> The type of this virtual network gateway. </param>
        /// <param name="vpnGatewayGeneration"> The generation for this VirtualNetworkGateway. Must be None if gatewayType is not VPN. </param>
        /// <param name="enableBgp"> Whether BGP is enabled for this virtual network gateway or not. </param>
        /// <param name="enablePrivateIPAddress"> Whether private IP needs to be enabled on this gateway for connections or not. </param>
        /// <param name="active"> ActiveActive flag. </param>
        /// <param name="disableIPSecReplayProtection"> disableIPSecReplayProtection flag. </param>
        /// <param name="gatewayDefaultSiteId"> The reference to the LocalNetworkGateway resource which represents local network site having default routes. Assign Null value in case of removing existing default site setting. </param>
        /// <param name="sku"> The reference to the VirtualNetworkGatewaySku resource which represents the SKU selected for Virtual network gateway. </param>
        /// <param name="vpnClientConfiguration"> The reference to the VpnClientConfiguration resource which represents the P2S VpnClient configurations. </param>
        /// <param name="virtualNetworkGatewayPolicyGroups"> The reference to the VirtualNetworkGatewayPolicyGroup resource which represents the available VirtualNetworkGatewayPolicyGroup for the gateway. </param>
        /// <param name="bgpSettings"> Virtual network gateway's BGP speaker settings. </param>
        /// <param name="customRoutesAddressPrefixes"> The reference to the address space resource which represents the custom routes address space specified by the customer for virtual network gateway and VpnClient. </param>
        /// <param name="resourceGuid"> The resource GUID property of the virtual network gateway resource. </param>
        /// <param name="provisioningState"> The provisioning state of the virtual network gateway resource. </param>
        /// <param name="enableDnsForwarding"> Whether dns forwarding is enabled or not. </param>
        /// <param name="inboundDnsForwardingEndpoint"> The IP address allocated by the gateway to which dns requests can be sent. </param>
        /// <param name="vNetExtendedLocationResourceId"> Customer vnet resource id. VirtualNetworkGateway of type local gateway is associated with the customer vnet. </param>
        /// <param name="natRules"> NatRules for virtual network gateway. </param>
        /// <param name="enableBgpRouteTranslationForNat"> EnableBgpRouteTranslationForNat flag. </param>
        /// <param name="allowVirtualWanTraffic"> Configures this gateway to accept traffic from remote Virtual WAN networks. </param>
        /// <param name="allowRemoteVnetTraffic"> Configure this gateway to accept traffic from other Azure Virtual Networks. This configuration does not support connectivity to Azure Virtual WAN. </param>
        /// <param name="adminState"> Property to indicate if the Express Route Gateway serves traffic when there are multiple Express Route Gateways in the vnet. </param>
        /// <param name="resiliencyModel"> Property to indicate if the Express Route Gateway has resiliency model of MultiHomed or SingleHomed. </param>
        /// <returns> A new <see cref="Network.VirtualNetworkGatewayData"/> instance for mocking. </returns>
        public static VirtualNetworkGatewayData VirtualNetworkGatewayData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ExtendedLocation extendedLocation = null, ETag? etag = null, ManagedServiceIdentity identity = null, VirtualNetworkGatewayAutoScaleBounds autoScaleBounds = null, IEnumerable<VirtualNetworkGatewayIPConfiguration> ipConfigurations = null, VirtualNetworkGatewayType? gatewayType = null, VpnType? vpnType = null, VpnGatewayGeneration? vpnGatewayGeneration = null, bool? enableBgp = null, bool? enablePrivateIPAddress = null, bool? active = null, bool? disableIPSecReplayProtection = null, ResourceIdentifier gatewayDefaultSiteId = null, VirtualNetworkGatewaySku sku = null, VpnClientConfiguration vpnClientConfiguration = null, IEnumerable<VirtualNetworkGatewayPolicyGroup> virtualNetworkGatewayPolicyGroups = null, BgpSettings bgpSettings = null, IEnumerable<string> customRoutesAddressPrefixes = null, Guid? resourceGuid = null, NetworkProvisioningState? provisioningState = null, bool? enableDnsForwarding = null, string inboundDnsForwardingEndpoint = null, ResourceIdentifier vNetExtendedLocationResourceId = null, IEnumerable<VirtualNetworkGatewayNatRuleData> natRules = null, bool? enableBgpRouteTranslationForNat = null, bool? allowVirtualWanTraffic = null, bool? allowRemoteVnetTraffic = null, ExpressRouteGatewayAdminState? adminState = null, ExpressRouteGatewayResiliencyModel? resiliencyModel = null)
        {
            tags ??= new Dictionary<string, string>();
            ipConfigurations ??= new List<VirtualNetworkGatewayIPConfiguration>();
            virtualNetworkGatewayPolicyGroups ??= new List<VirtualNetworkGatewayPolicyGroup>();
            customRoutesAddressPrefixes ??= new List<string>();
            natRules ??= new List<VirtualNetworkGatewayNatRuleData>();

            return new VirtualNetworkGatewayData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                extendedLocation,
                etag,
                identity,
                autoScaleBounds != null ? new VirtualNetworkGatewayAutoScaleConfiguration(autoScaleBounds, serializedAdditionalRawData: null) : null,
                ipConfigurations?.ToList(),
                gatewayType,
                vpnType,
                vpnGatewayGeneration,
                enableBgp,
                enablePrivateIPAddress,
                active,
                disableIPSecReplayProtection,
                gatewayDefaultSiteId != null ? ResourceManagerModelFactory.WritableSubResource(gatewayDefaultSiteId) : null,
                sku,
                vpnClientConfiguration,
                virtualNetworkGatewayPolicyGroups?.ToList(),
                bgpSettings,
                customRoutesAddressPrefixes != null ? new AddressSpace(customRoutesAddressPrefixes?.ToList(), serializedAdditionalRawData: null) : null,
                resourceGuid,
                provisioningState,
                enableDnsForwarding,
                inboundDnsForwardingEndpoint,
                vNetExtendedLocationResourceId,
                natRules?.ToList(),
                enableBgpRouteTranslationForNat,
                allowVirtualWanTraffic,
                allowRemoteVnetTraffic,
                adminState,
                resiliencyModel);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VirtualNetworkGatewayIPConfiguration"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="privateIPAllocationMethod"> The private IP address allocation method. </param>
        /// <param name="subnetId"> The reference to the subnet resource. </param>
        /// <param name="publicIPAddressId"> The reference to the public IP resource. </param>
        /// <param name="privateIPAddress"> Private IP Address for this gateway. </param>
        /// <param name="provisioningState"> The provisioning state of the virtual network gateway IP configuration resource. </param>
        /// <returns> A new <see cref="Models.VirtualNetworkGatewayIPConfiguration"/> instance for mocking. </returns>
        public static VirtualNetworkGatewayIPConfiguration VirtualNetworkGatewayIPConfiguration(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, NetworkIPAllocationMethod? privateIPAllocationMethod = null, ResourceIdentifier subnetId = null, ResourceIdentifier publicIPAddressId = null, string privateIPAddress = null, NetworkProvisioningState? provisioningState = null)
        {
            return new VirtualNetworkGatewayIPConfiguration(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                privateIPAllocationMethod,
                subnetId != null ? ResourceManagerModelFactory.WritableSubResource(subnetId) : null,
                publicIPAddressId != null ? ResourceManagerModelFactory.WritableSubResource(publicIPAddressId) : null,
                privateIPAddress,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VirtualNetworkGatewaySku"/>. </summary>
        /// <param name="name"> Gateway SKU name. </param>
        /// <param name="tier"> Gateway SKU tier. </param>
        /// <param name="capacity"> The capacity. </param>
        /// <returns> A new <see cref="Models.VirtualNetworkGatewaySku"/> instance for mocking. </returns>
        public static VirtualNetworkGatewaySku VirtualNetworkGatewaySku(VirtualNetworkGatewaySkuName? name = null, VirtualNetworkGatewaySkuTier? tier = null, int? capacity = null)
        {
            return new VirtualNetworkGatewaySku(name, tier, capacity, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VpnClientRootCertificate"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="publicCertData"> The certificate public data. </param>
        /// <param name="provisioningState"> The provisioning state of the VPN client root certificate resource. </param>
        /// <returns> A new <see cref="Models.VpnClientRootCertificate"/> instance for mocking. </returns>
        public static VpnClientRootCertificate VpnClientRootCertificate(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, BinaryData publicCertData = null, NetworkProvisioningState? provisioningState = null)
        {
            return new VpnClientRootCertificate(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                publicCertData,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VpnClientRevokedCertificate"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="thumbprint"> The revoked VPN client certificate thumbprint. </param>
        /// <param name="provisioningState"> The provisioning state of the VPN client revoked certificate resource. </param>
        /// <returns> A new <see cref="Models.VpnClientRevokedCertificate"/> instance for mocking. </returns>
        public static VpnClientRevokedCertificate VpnClientRevokedCertificate(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, string thumbprint = null, NetworkProvisioningState? provisioningState = null)
        {
            return new VpnClientRevokedCertificate(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                thumbprint,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VngClientConnectionConfiguration"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="vpnClientAddressPrefixes"> The reference to the address space resource which represents Address space for P2S VpnClient. </param>
        /// <param name="virtualNetworkGatewayPolicyGroups"> List of references to virtualNetworkGatewayPolicyGroups. </param>
        /// <param name="provisioningState"> The provisioning state of the VngClientConnectionConfiguration resource. </param>
        /// <returns> A new <see cref="Models.VngClientConnectionConfiguration"/> instance for mocking. </returns>
        public static VngClientConnectionConfiguration VngClientConnectionConfiguration(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, IEnumerable<string> vpnClientAddressPrefixes = null, IEnumerable<WritableSubResource> virtualNetworkGatewayPolicyGroups = null, NetworkProvisioningState? provisioningState = null)
        {
            vpnClientAddressPrefixes ??= new List<string>();
            virtualNetworkGatewayPolicyGroups ??= new List<WritableSubResource>();

            return new VngClientConnectionConfiguration(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                vpnClientAddressPrefixes != null ? new AddressSpace(vpnClientAddressPrefixes?.ToList(), serializedAdditionalRawData: null) : null,
                virtualNetworkGatewayPolicyGroups?.ToList(),
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VirtualNetworkGatewayPolicyGroup"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="isDefault"> Shows if this is a Default VirtualNetworkGatewayPolicyGroup or not. </param>
        /// <param name="priority"> Priority for VirtualNetworkGatewayPolicyGroup. </param>
        /// <param name="policyMembers"> Multiple PolicyMembers for VirtualNetworkGatewayPolicyGroup. </param>
        /// <param name="vngClientConnectionConfigurations"> List of references to vngClientConnectionConfigurations. </param>
        /// <param name="provisioningState"> The provisioning state of the VirtualNetworkGatewayPolicyGroup resource. </param>
        /// <returns> A new <see cref="Models.VirtualNetworkGatewayPolicyGroup"/> instance for mocking. </returns>
        public static VirtualNetworkGatewayPolicyGroup VirtualNetworkGatewayPolicyGroup(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, bool? isDefault = null, int? priority = null, IEnumerable<VirtualNetworkGatewayPolicyGroupMember> policyMembers = null, IEnumerable<WritableSubResource> vngClientConnectionConfigurations = null, NetworkProvisioningState? provisioningState = null)
        {
            policyMembers ??= new List<VirtualNetworkGatewayPolicyGroupMember>();
            vngClientConnectionConfigurations ??= new List<WritableSubResource>();

            return new VirtualNetworkGatewayPolicyGroup(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                isDefault,
                priority,
                policyMembers?.ToList(),
                vngClientConnectionConfigurations?.ToList(),
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkIPConfigurationBgpPeeringAddress"/>. </summary>
        /// <param name="ipConfigurationId"> The ID of IP configuration which belongs to gateway. </param>
        /// <param name="defaultBgpIPAddresses"> The list of default BGP peering addresses which belong to IP configuration. </param>
        /// <param name="customBgpIPAddresses"> The list of custom BGP peering addresses which belong to IP configuration. </param>
        /// <param name="tunnelIPAddresses"> The list of tunnel public IP addresses which belong to IP configuration. </param>
        /// <returns> A new <see cref="Models.NetworkIPConfigurationBgpPeeringAddress"/> instance for mocking. </returns>
        public static NetworkIPConfigurationBgpPeeringAddress NetworkIPConfigurationBgpPeeringAddress(string ipConfigurationId = null, IEnumerable<string> defaultBgpIPAddresses = null, IEnumerable<string> customBgpIPAddresses = null, IEnumerable<string> tunnelIPAddresses = null)
        {
            defaultBgpIPAddresses ??= new List<string>();
            customBgpIPAddresses ??= new List<string>();
            tunnelIPAddresses ??= new List<string>();

            return new NetworkIPConfigurationBgpPeeringAddress(ipConfigurationId, defaultBgpIPAddresses?.ToList(), customBgpIPAddresses?.ToList(), tunnelIPAddresses?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.VirtualNetworkGatewayNatRuleData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="provisioningState"> The provisioning state of the NAT Rule resource. </param>
        /// <param name="vpnNatRuleType"> The type of NAT rule for VPN NAT. </param>
        /// <param name="mode"> The Source NAT direction of a VPN NAT. </param>
        /// <param name="internalMappings"> The private IP address internal mapping for NAT. </param>
        /// <param name="externalMappings"> The private IP address external mapping for NAT. </param>
        /// <param name="ipConfigurationId"> The IP Configuration ID this NAT rule applies to. </param>
        /// <returns> A new <see cref="Network.VirtualNetworkGatewayNatRuleData"/> instance for mocking. </returns>
        public static VirtualNetworkGatewayNatRuleData VirtualNetworkGatewayNatRuleData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, NetworkProvisioningState? provisioningState = null, VpnNatRuleType? vpnNatRuleType = null, VpnNatRuleMode? mode = null, IEnumerable<VpnNatRuleMapping> internalMappings = null, IEnumerable<VpnNatRuleMapping> externalMappings = null, string ipConfigurationId = null)
        {
            internalMappings ??= new List<VpnNatRuleMapping>();
            externalMappings ??= new List<VpnNatRuleMapping>();

            return new VirtualNetworkGatewayNatRuleData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                provisioningState,
                vpnNatRuleType,
                mode,
                internalMappings?.ToList(),
                externalMappings?.ToList(),
                ipConfigurationId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VirtualNetworkGatewayConnectionListEntity"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="authorizationKey"> The authorizationKey. </param>
        /// <param name="virtualNetworkGateway1Id"> The reference to virtual network gateway resource. </param>
        /// <param name="virtualNetworkGateway2Id"> The reference to virtual network gateway resource. </param>
        /// <param name="localNetworkGateway2Id"> The reference to local network gateway resource. </param>
        /// <param name="connectionType"> Gateway connection type. </param>
        /// <param name="connectionProtocol"> Connection protocol used for this connection. </param>
        /// <param name="routingWeight"> The routing weight. </param>
        /// <param name="connectionMode"> The connection mode for this connection. </param>
        /// <param name="sharedKey"> The IPSec shared key. </param>
        /// <param name="connectionStatus"> Virtual Network Gateway connection status. </param>
        /// <param name="tunnelConnectionStatus"> Collection of all tunnels' connection health status. </param>
        /// <param name="egressBytesTransferred"> The egress bytes transferred in this connection. </param>
        /// <param name="ingressBytesTransferred"> The ingress bytes transferred in this connection. </param>
        /// <param name="peerId"> The reference to peerings resource. </param>
        /// <param name="enableBgp"> EnableBgp flag. </param>
        /// <param name="gatewayCustomBgpIPAddresses"> GatewayCustomBgpIpAddresses to be used for virtual network gateway Connection. </param>
        /// <param name="usePolicyBasedTrafficSelectors"> Enable policy-based traffic selectors. </param>
        /// <param name="ipsecPolicies"> The IPSec Policies to be considered by this connection. </param>
        /// <param name="trafficSelectorPolicies"> The Traffic Selector Policies to be considered by this connection. </param>
        /// <param name="resourceGuid"> The resource GUID property of the virtual network gateway connection resource. </param>
        /// <param name="provisioningState"> The provisioning state of the virtual network gateway connection resource. </param>
        /// <param name="expressRouteGatewayBypass"> Bypass ExpressRoute Gateway for data forwarding. </param>
        /// <param name="enablePrivateLinkFastPath"> Bypass the ExpressRoute gateway when accessing private-links. ExpressRoute FastPath (expressRouteGatewayBypass) must be enabled. </param>
        /// <returns> A new <see cref="Models.VirtualNetworkGatewayConnectionListEntity"/> instance for mocking. </returns>
        public static VirtualNetworkGatewayConnectionListEntity VirtualNetworkGatewayConnectionListEntity(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, string authorizationKey = null, ResourceIdentifier virtualNetworkGateway1Id = null, ResourceIdentifier virtualNetworkGateway2Id = null, ResourceIdentifier localNetworkGateway2Id = null, VirtualNetworkGatewayConnectionType connectionType = default, VirtualNetworkGatewayConnectionProtocol? connectionProtocol = null, int? routingWeight = null, VirtualNetworkGatewayConnectionMode? connectionMode = null, string sharedKey = null, VirtualNetworkGatewayConnectionStatus? connectionStatus = null, IEnumerable<TunnelConnectionHealth> tunnelConnectionStatus = null, long? egressBytesTransferred = null, long? ingressBytesTransferred = null, ResourceIdentifier peerId = null, bool? enableBgp = null, IEnumerable<GatewayCustomBgpIPAddressIPConfiguration> gatewayCustomBgpIPAddresses = null, bool? usePolicyBasedTrafficSelectors = null, IEnumerable<IPsecPolicy> ipsecPolicies = null, IEnumerable<TrafficSelectorPolicy> trafficSelectorPolicies = null, Guid? resourceGuid = null, NetworkProvisioningState? provisioningState = null, bool? expressRouteGatewayBypass = null, bool? enablePrivateLinkFastPath = null)
        {
            tags ??= new Dictionary<string, string>();
            tunnelConnectionStatus ??= new List<TunnelConnectionHealth>();
            gatewayCustomBgpIPAddresses ??= new List<GatewayCustomBgpIPAddressIPConfiguration>();
            ipsecPolicies ??= new List<IPsecPolicy>();
            trafficSelectorPolicies ??= new List<TrafficSelectorPolicy>();

            return new VirtualNetworkGatewayConnectionListEntity(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                authorizationKey,
                virtualNetworkGateway1Id != null ? ResourceManagerModelFactory.WritableSubResource(virtualNetworkGateway1Id) : null,
                virtualNetworkGateway2Id != null ? ResourceManagerModelFactory.WritableSubResource(virtualNetworkGateway2Id) : null,
                localNetworkGateway2Id != null ? ResourceManagerModelFactory.WritableSubResource(localNetworkGateway2Id) : null,
                connectionType,
                connectionProtocol,
                routingWeight,
                connectionMode,
                sharedKey,
                connectionStatus,
                tunnelConnectionStatus?.ToList(),
                egressBytesTransferred,
                ingressBytesTransferred,
                peerId != null ? ResourceManagerModelFactory.WritableSubResource(peerId) : null,
                enableBgp,
                gatewayCustomBgpIPAddresses?.ToList(),
                usePolicyBasedTrafficSelectors,
                ipsecPolicies?.ToList(),
                trafficSelectorPolicies?.ToList(),
                resourceGuid,
                provisioningState,
                expressRouteGatewayBypass,
                enablePrivateLinkFastPath);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TunnelConnectionHealth"/>. </summary>
        /// <param name="tunnel"> Tunnel name. </param>
        /// <param name="connectionStatus"> Virtual Network Gateway connection status. </param>
        /// <param name="ingressBytesTransferred"> The Ingress Bytes Transferred in this connection. </param>
        /// <param name="egressBytesTransferred"> The Egress Bytes Transferred in this connection. </param>
        /// <param name="lastConnectionEstablishedOn"> The time at which connection was established in Utc format. </param>
        /// <returns> A new <see cref="Models.TunnelConnectionHealth"/> instance for mocking. </returns>
        public static TunnelConnectionHealth TunnelConnectionHealth(string tunnel = null, VirtualNetworkGatewayConnectionStatus? connectionStatus = null, long? ingressBytesTransferred = null, long? egressBytesTransferred = null, string lastConnectionEstablishedOn = null)
        {
            return new TunnelConnectionHealth(
                tunnel,
                connectionStatus,
                ingressBytesTransferred,
                egressBytesTransferred,
                lastConnectionEstablishedOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BgpPeerStatusListResult"/>. </summary>
        /// <param name="value"> List of BGP peers. </param>
        /// <returns> A new <see cref="Models.BgpPeerStatusListResult"/> instance for mocking. </returns>
        public static BgpPeerStatusListResult BgpPeerStatusListResult(IEnumerable<BgpPeerStatus> value = null)
        {
            value ??= new List<BgpPeerStatus>();

            return new BgpPeerStatusListResult(value?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BgpPeerStatus"/>. </summary>
        /// <param name="localAddress"> The virtual network gateway's local address. </param>
        /// <param name="neighbor"> The remote BGP peer. </param>
        /// <param name="asn"> The autonomous system number of the remote BGP peer. </param>
        /// <param name="state"> The BGP peer state. </param>
        /// <param name="connectedDuration"> For how long the peering has been up. </param>
        /// <param name="routesReceived"> The number of routes learned from this peer. </param>
        /// <param name="messagesSent"> The number of BGP messages sent. </param>
        /// <param name="messagesReceived"> The number of BGP messages received. </param>
        /// <returns> A new <see cref="Models.BgpPeerStatus"/> instance for mocking. </returns>
        public static BgpPeerStatus BgpPeerStatus(string localAddress = null, string neighbor = null, long? asn = null, BgpPeerState? state = null, TimeSpan? connectedDuration = null, long? routesReceived = null, long? messagesSent = null, long? messagesReceived = null)
        {
            return new BgpPeerStatus(
                localAddress,
                neighbor,
                asn,
                state,
                connectedDuration,
                routesReceived,
                messagesSent,
                messagesReceived,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.GatewayRouteListResult"/>. </summary>
        /// <param name="value"> List of gateway routes. </param>
        /// <returns> A new <see cref="Models.GatewayRouteListResult"/> instance for mocking. </returns>
        public static GatewayRouteListResult GatewayRouteListResult(IEnumerable<GatewayRoute> value = null)
        {
            value ??= new List<GatewayRoute>();

            return new GatewayRouteListResult(value?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.GatewayRoute"/>. </summary>
        /// <param name="localAddress"> The gateway's local address. </param>
        /// <param name="network"> The route's network prefix. </param>
        /// <param name="nextHop"> The route's next hop. </param>
        /// <param name="sourcePeer"> The peer this route was learned from. </param>
        /// <param name="origin"> The source this route was learned from. </param>
        /// <param name="asPath"> The route's AS path sequence. </param>
        /// <param name="weight"> The route's weight. </param>
        /// <returns> A new <see cref="Models.GatewayRoute"/> instance for mocking. </returns>
        public static GatewayRoute GatewayRoute(string localAddress = null, string network = null, string nextHop = null, string sourcePeer = null, string origin = null, string asPath = null, int? weight = null)
        {
            return new GatewayRoute(
                localAddress,
                network,
                nextHop,
                sourcePeer,
                origin,
                asPath,
                weight,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.VirtualNetworkGatewayConnectionData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="authorizationKey"> The authorizationKey. </param>
        /// <param name="virtualNetworkGateway1"> The reference to virtual network gateway resource. </param>
        /// <param name="virtualNetworkGateway2"> The reference to virtual network gateway resource. </param>
        /// <param name="localNetworkGateway2"> The reference to local network gateway resource. </param>
        /// <param name="ingressNatRules"> List of ingress NatRules. </param>
        /// <param name="egressNatRules"> List of egress NatRules. </param>
        /// <param name="connectionType"> Gateway connection type. </param>
        /// <param name="connectionProtocol"> Connection protocol used for this connection. </param>
        /// <param name="routingWeight"> The routing weight. </param>
        /// <param name="dpdTimeoutSeconds"> The dead peer detection timeout of this connection in seconds. </param>
        /// <param name="connectionMode"> The connection mode for this connection. </param>
        /// <param name="sharedKey"> The IPSec shared key. </param>
        /// <param name="connectionStatus"> Virtual Network Gateway connection status. </param>
        /// <param name="tunnelConnectionStatus"> Collection of all tunnels' connection health status. </param>
        /// <param name="egressBytesTransferred"> The egress bytes transferred in this connection. </param>
        /// <param name="ingressBytesTransferred"> The ingress bytes transferred in this connection. </param>
        /// <param name="peerId"> The reference to peerings resource. </param>
        /// <param name="enableBgp"> EnableBgp flag. </param>
        /// <param name="gatewayCustomBgpIPAddresses"> GatewayCustomBgpIpAddresses to be used for virtual network gateway Connection. </param>
        /// <param name="useLocalAzureIPAddress"> Use private local Azure IP for the connection. </param>
        /// <param name="usePolicyBasedTrafficSelectors"> Enable policy-based traffic selectors. </param>
        /// <param name="ipsecPolicies"> The IPSec Policies to be considered by this connection. </param>
        /// <param name="trafficSelectorPolicies"> The Traffic Selector Policies to be considered by this connection. </param>
        /// <param name="resourceGuid"> The resource GUID property of the virtual network gateway connection resource. </param>
        /// <param name="provisioningState"> The provisioning state of the virtual network gateway connection resource. </param>
        /// <param name="expressRouteGatewayBypass"> Bypass ExpressRoute Gateway for data forwarding. </param>
        /// <param name="enablePrivateLinkFastPath"> Bypass the ExpressRoute gateway when accessing private-links. ExpressRoute FastPath (expressRouteGatewayBypass) must be enabled. </param>
        /// <returns> A new <see cref="Network.VirtualNetworkGatewayConnectionData"/> instance for mocking. </returns>
        public static VirtualNetworkGatewayConnectionData VirtualNetworkGatewayConnectionData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, string authorizationKey = null, VirtualNetworkGatewayData virtualNetworkGateway1 = null, VirtualNetworkGatewayData virtualNetworkGateway2 = null, LocalNetworkGatewayData localNetworkGateway2 = null, IEnumerable<WritableSubResource> ingressNatRules = null, IEnumerable<WritableSubResource> egressNatRules = null, VirtualNetworkGatewayConnectionType connectionType = default, VirtualNetworkGatewayConnectionProtocol? connectionProtocol = null, int? routingWeight = null, int? dpdTimeoutSeconds = null, VirtualNetworkGatewayConnectionMode? connectionMode = null, string sharedKey = null, VirtualNetworkGatewayConnectionStatus? connectionStatus = null, IEnumerable<TunnelConnectionHealth> tunnelConnectionStatus = null, long? egressBytesTransferred = null, long? ingressBytesTransferred = null, ResourceIdentifier peerId = null, bool? enableBgp = null, IEnumerable<GatewayCustomBgpIPAddressIPConfiguration> gatewayCustomBgpIPAddresses = null, bool? useLocalAzureIPAddress = null, bool? usePolicyBasedTrafficSelectors = null, IEnumerable<IPsecPolicy> ipsecPolicies = null, IEnumerable<TrafficSelectorPolicy> trafficSelectorPolicies = null, Guid? resourceGuid = null, NetworkProvisioningState? provisioningState = null, bool? expressRouteGatewayBypass = null, bool? enablePrivateLinkFastPath = null)
        {
            tags ??= new Dictionary<string, string>();
            ingressNatRules ??= new List<WritableSubResource>();
            egressNatRules ??= new List<WritableSubResource>();
            tunnelConnectionStatus ??= new List<TunnelConnectionHealth>();
            gatewayCustomBgpIPAddresses ??= new List<GatewayCustomBgpIPAddressIPConfiguration>();
            ipsecPolicies ??= new List<IPsecPolicy>();
            trafficSelectorPolicies ??= new List<TrafficSelectorPolicy>();

            return new VirtualNetworkGatewayConnectionData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                authorizationKey,
                virtualNetworkGateway1,
                virtualNetworkGateway2,
                localNetworkGateway2,
                ingressNatRules?.ToList(),
                egressNatRules?.ToList(),
                connectionType,
                connectionProtocol,
                routingWeight,
                dpdTimeoutSeconds,
                connectionMode,
                sharedKey,
                connectionStatus,
                tunnelConnectionStatus?.ToList(),
                egressBytesTransferred,
                ingressBytesTransferred,
                peerId != null ? ResourceManagerModelFactory.WritableSubResource(peerId) : null,
                enableBgp,
                gatewayCustomBgpIPAddresses?.ToList(),
                useLocalAzureIPAddress,
                usePolicyBasedTrafficSelectors,
                ipsecPolicies?.ToList(),
                trafficSelectorPolicies?.ToList(),
                resourceGuid,
                provisioningState,
                expressRouteGatewayBypass,
                enablePrivateLinkFastPath);
        }

        /// <summary> Initializes a new instance of <see cref="Network.LocalNetworkGatewayData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="localNetworkAddressPrefixes"> Local network site address space. </param>
        /// <param name="gatewayIPAddress"> IP address of local network gateway. </param>
        /// <param name="fqdn"> FQDN of local network gateway. </param>
        /// <param name="bgpSettings"> Local network gateway's BGP speaker settings. </param>
        /// <param name="resourceGuid"> The resource GUID property of the local network gateway resource. </param>
        /// <param name="provisioningState"> The provisioning state of the local network gateway resource. </param>
        /// <returns> A new <see cref="Network.LocalNetworkGatewayData"/> instance for mocking. </returns>
        public static LocalNetworkGatewayData LocalNetworkGatewayData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, IEnumerable<string> localNetworkAddressPrefixes = null, string gatewayIPAddress = null, string fqdn = null, BgpSettings bgpSettings = null, Guid? resourceGuid = null, NetworkProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            localNetworkAddressPrefixes ??= new List<string>();

            return new LocalNetworkGatewayData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                localNetworkAddressPrefixes != null ? new AddressSpace(localNetworkAddressPrefixes?.ToList(), serializedAdditionalRawData: null) : null,
                gatewayIPAddress,
                fqdn,
                bgpSettings,
                resourceGuid,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VpnClientConnectionHealthDetailListResult"/>. </summary>
        /// <param name="value"> List of vpn client connection health. </param>
        /// <returns> A new <see cref="Models.VpnClientConnectionHealthDetailListResult"/> instance for mocking. </returns>
        public static VpnClientConnectionHealthDetailListResult VpnClientConnectionHealthDetailListResult(IEnumerable<VpnClientConnectionHealthDetail> value = null)
        {
            value ??= new List<VpnClientConnectionHealthDetail>();

            return new VpnClientConnectionHealthDetailListResult(value?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VpnClientConnectionHealthDetail"/>. </summary>
        /// <param name="vpnConnectionId"> The vpn client Id. </param>
        /// <param name="vpnConnectionDurationInSeconds"> The duration time of a connected vpn client. </param>
        /// <param name="vpnConnectionOn"> The start time of a connected vpn client. </param>
        /// <param name="publicIPAddress"> The public Ip of a connected vpn client. </param>
        /// <param name="privateIPAddress"> The assigned private Ip of a connected vpn client. </param>
        /// <param name="vpnUserName"> The user name of a connected vpn client. </param>
        /// <param name="maxBandwidth"> The max band width. </param>
        /// <param name="egressPacketsTransferred"> The egress packets per second. </param>
        /// <param name="egressBytesTransferred"> The egress bytes per second. </param>
        /// <param name="ingressPacketsTransferred"> The ingress packets per second. </param>
        /// <param name="ingressBytesTransferred"> The ingress bytes per second. </param>
        /// <param name="maxPacketsPerSecond"> The max packets transferred per second. </param>
        /// <returns> A new <see cref="Models.VpnClientConnectionHealthDetail"/> instance for mocking. </returns>
        public static VpnClientConnectionHealthDetail VpnClientConnectionHealthDetail(string vpnConnectionId = null, long? vpnConnectionDurationInSeconds = null, DateTimeOffset? vpnConnectionOn = null, string publicIPAddress = null, string privateIPAddress = null, string vpnUserName = null, long? maxBandwidth = null, long? egressPacketsTransferred = null, long? egressBytesTransferred = null, long? ingressPacketsTransferred = null, long? ingressBytesTransferred = null, long? maxPacketsPerSecond = null)
        {
            return new VpnClientConnectionHealthDetail(
                vpnConnectionId,
                vpnConnectionDurationInSeconds,
                vpnConnectionOn,
                publicIPAddress,
                privateIPAddress,
                vpnUserName,
                maxBandwidth,
                egressPacketsTransferred,
                egressBytesTransferred,
                ingressPacketsTransferred,
                ingressBytesTransferred,
                maxPacketsPerSecond,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.VirtualRouterData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="virtualRouterAsn"> VirtualRouter ASN. </param>
        /// <param name="virtualRouterIPs"> VirtualRouter IPs. </param>
        /// <param name="hostedSubnetId"> The Subnet on which VirtualRouter is hosted. </param>
        /// <param name="hostedGatewayId"> The Gateway on which VirtualRouter is hosted. </param>
        /// <param name="peerings"> List of references to VirtualRouterPeerings. </param>
        /// <param name="provisioningState"> The provisioning state of the resource. </param>
        /// <returns> A new <see cref="Network.VirtualRouterData"/> instance for mocking. </returns>
        public static VirtualRouterData VirtualRouterData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, long? virtualRouterAsn = null, IEnumerable<string> virtualRouterIPs = null, ResourceIdentifier hostedSubnetId = null, ResourceIdentifier hostedGatewayId = null, IEnumerable<WritableSubResource> peerings = null, NetworkProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            virtualRouterIPs ??= new List<string>();
            peerings ??= new List<WritableSubResource>();

            return new VirtualRouterData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                virtualRouterAsn,
                virtualRouterIPs?.ToList(),
                hostedSubnetId != null ? ResourceManagerModelFactory.WritableSubResource(hostedSubnetId) : null,
                hostedGatewayId != null ? ResourceManagerModelFactory.WritableSubResource(hostedGatewayId) : null,
                peerings?.ToList(),
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Network.VirtualRouterPeeringData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="peerAsn"> Peer ASN. </param>
        /// <param name="peerIP"> Peer IP. </param>
        /// <param name="provisioningState"> The provisioning state of the resource. </param>
        /// <returns> A new <see cref="Network.VirtualRouterPeeringData"/> instance for mocking. </returns>
        public static VirtualRouterPeeringData VirtualRouterPeeringData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, long? peerAsn = null, string peerIP = null, NetworkProvisioningState? provisioningState = null)
        {
            return new VirtualRouterPeeringData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                peerAsn,
                peerIP,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Network.VirtualWanData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="disableVpnEncryption"> Vpn encryption to be disabled or not. </param>
        /// <param name="virtualHubs"> List of VirtualHubs in the VirtualWAN. </param>
        /// <param name="vpnSites"> List of VpnSites in the VirtualWAN. </param>
        /// <param name="allowBranchToBranchTraffic"> True if branch to branch traffic is allowed. </param>
        /// <param name="allowVnetToVnetTraffic"> True if Vnet to Vnet traffic is allowed. </param>
        /// <param name="office365LocalBreakoutCategory"> The office local breakout category. </param>
        /// <param name="provisioningState"> The provisioning state of the virtual WAN resource. </param>
        /// <param name="virtualWanType"> The type of the VirtualWAN. </param>
        /// <returns> A new <see cref="Network.VirtualWanData"/> instance for mocking. </returns>
        public static VirtualWanData VirtualWanData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, bool? disableVpnEncryption = null, IEnumerable<WritableSubResource> virtualHubs = null, IEnumerable<WritableSubResource> vpnSites = null, bool? allowBranchToBranchTraffic = null, bool? allowVnetToVnetTraffic = null, OfficeTrafficCategory? office365LocalBreakoutCategory = null, NetworkProvisioningState? provisioningState = null, string virtualWanType = null)
        {
            tags ??= new Dictionary<string, string>();
            virtualHubs ??= new List<WritableSubResource>();
            vpnSites ??= new List<WritableSubResource>();

            return new VirtualWanData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                disableVpnEncryption,
                virtualHubs?.ToList(),
                vpnSites?.ToList(),
                allowBranchToBranchTraffic,
                allowVnetToVnetTraffic,
                office365LocalBreakoutCategory,
                provisioningState,
                virtualWanType);
        }

        /// <summary> Initializes a new instance of <see cref="Network.VpnSiteData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="virtualWanId"> The VirtualWAN to which the vpnSite belongs. </param>
        /// <param name="deviceProperties"> The device properties. </param>
        /// <param name="ipAddress"> The ip-address for the vpn-site. </param>
        /// <param name="siteKey"> The key for vpn-site that can be used for connections. </param>
        /// <param name="addressPrefixes"> The AddressSpace that contains an array of IP address ranges. </param>
        /// <param name="bgpProperties"> The set of bgp properties. </param>
        /// <param name="provisioningState"> The provisioning state of the VPN site resource. </param>
        /// <param name="isSecuritySite"> IsSecuritySite flag. </param>
        /// <param name="vpnSiteLinks"> List of all vpn site links. </param>
        /// <param name="o365BreakOutCategories"> Office365 Policy. </param>
        /// <returns> A new <see cref="Network.VpnSiteData"/> instance for mocking. </returns>
        public static VpnSiteData VpnSiteData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, ResourceIdentifier virtualWanId = null, DeviceProperties deviceProperties = null, string ipAddress = null, string siteKey = null, IEnumerable<string> addressPrefixes = null, BgpSettings bgpProperties = null, NetworkProvisioningState? provisioningState = null, bool? isSecuritySite = null, IEnumerable<VpnSiteLinkData> vpnSiteLinks = null, O365BreakOutCategoryPolicies o365BreakOutCategories = null)
        {
            tags ??= new Dictionary<string, string>();
            addressPrefixes ??= new List<string>();
            vpnSiteLinks ??= new List<VpnSiteLinkData>();

            return new VpnSiteData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                virtualWanId != null ? ResourceManagerModelFactory.WritableSubResource(virtualWanId) : null,
                deviceProperties,
                ipAddress,
                siteKey,
                addressPrefixes != null ? new AddressSpace(addressPrefixes?.ToList(), serializedAdditionalRawData: null) : null,
                bgpProperties,
                provisioningState,
                isSecuritySite,
                vpnSiteLinks?.ToList(),
                o365BreakOutCategories != null ? new O365PolicyProperties(o365BreakOutCategories, serializedAdditionalRawData: null) : null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.VpnSiteLinkData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="linkProperties"> The link provider properties. </param>
        /// <param name="ipAddress"> The ip-address for the vpn-site-link. </param>
        /// <param name="fqdn"> FQDN of vpn-site-link. </param>
        /// <param name="bgpProperties"> The set of bgp properties. </param>
        /// <param name="provisioningState"> The provisioning state of the VPN site link resource. </param>
        /// <returns> A new <see cref="Network.VpnSiteLinkData"/> instance for mocking. </returns>
        public static VpnSiteLinkData VpnSiteLinkData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, VpnLinkProviderProperties linkProperties = null, string ipAddress = null, string fqdn = null, VpnLinkBgpSettings bgpProperties = null, NetworkProvisioningState? provisioningState = null)
        {
            return new VpnSiteLinkData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                linkProperties,
                ipAddress,
                fqdn,
                bgpProperties,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.GetVpnSitesConfigurationContent"/>. </summary>
        /// <param name="vpnSites"> List of resource-ids of the vpn-sites for which config is to be downloaded. </param>
        /// <param name="outputBlobSasUri"> The sas-url to download the configurations for vpn-sites. </param>
        /// <returns> A new <see cref="Models.GetVpnSitesConfigurationContent"/> instance for mocking. </returns>
        public static GetVpnSitesConfigurationContent GetVpnSitesConfigurationContent(IEnumerable<string> vpnSites = null, Uri outputBlobSasUri = null)
        {
            vpnSites ??= new List<string>();

            return new GetVpnSitesConfigurationContent(vpnSites?.ToList(), outputBlobSasUri, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VirtualWanSecurityProviders"/>. </summary>
        /// <param name="supportedProviders"> List of VirtualWAN security providers. </param>
        /// <returns> A new <see cref="Models.VirtualWanSecurityProviders"/> instance for mocking. </returns>
        public static VirtualWanSecurityProviders VirtualWanSecurityProviders(IEnumerable<VirtualWanSecurityProvider> supportedProviders = null)
        {
            supportedProviders ??= new List<VirtualWanSecurityProvider>();

            return new VirtualWanSecurityProviders(supportedProviders?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VirtualWanSecurityProvider"/>. </summary>
        /// <param name="name"> Name of the security provider. </param>
        /// <param name="uri"> Url of the security provider. </param>
        /// <param name="providerType"> Name of the security provider. </param>
        /// <returns> A new <see cref="Models.VirtualWanSecurityProvider"/> instance for mocking. </returns>
        public static VirtualWanSecurityProvider VirtualWanSecurityProvider(string name = null, Uri uri = null, VirtualWanSecurityProviderType? providerType = null)
        {
            return new VirtualWanSecurityProvider(name, uri, providerType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.VpnServerConfigurationData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="vpnProtocols"> VPN protocols for the VpnServerConfiguration. </param>
        /// <param name="vpnAuthenticationTypes"> VPN authentication types for the VpnServerConfiguration. </param>
        /// <param name="vpnClientRootCertificates"> VPN client root certificate of VpnServerConfiguration. </param>
        /// <param name="vpnClientRevokedCertificates"> VPN client revoked certificate of VpnServerConfiguration. </param>
        /// <param name="radiusServerRootCertificates"> Radius Server root certificate of VpnServerConfiguration. </param>
        /// <param name="radiusClientRootCertificates"> Radius client root certificate of VpnServerConfiguration. </param>
        /// <param name="vpnClientIPsecPolicies"> VpnClientIpsecPolicies for VpnServerConfiguration. </param>
        /// <param name="radiusServerAddress"> The radius server address property of the VpnServerConfiguration resource for point to site client connection. </param>
        /// <param name="radiusServerSecret"> The radius secret property of the VpnServerConfiguration resource for point to site client connection. </param>
        /// <param name="radiusServers"> Multiple Radius Server configuration for VpnServerConfiguration. </param>
        /// <param name="aadAuthenticationParameters"> The set of aad vpn authentication parameters. </param>
        /// <param name="provisioningState"> The provisioning state of the VpnServerConfiguration resource. Possible values are: 'Updating', 'Deleting', and 'Failed'. </param>
        /// <param name="p2sVpnGateways"> List of references to P2SVpnGateways. </param>
        /// <param name="configurationPolicyGroups"> List of all VpnServerConfigurationPolicyGroups. </param>
        /// <returns> A new <see cref="Network.VpnServerConfigurationData"/> instance for mocking. </returns>
        public static VpnServerConfigurationData VpnServerConfigurationData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, IEnumerable<VpnGatewayTunnelingProtocol> vpnProtocols = null, IEnumerable<VpnAuthenticationType> vpnAuthenticationTypes = null, IEnumerable<VpnServerConfigVpnClientRootCertificate> vpnClientRootCertificates = null, IEnumerable<VpnServerConfigVpnClientRevokedCertificate> vpnClientRevokedCertificates = null, IEnumerable<VpnServerConfigRadiusServerRootCertificate> radiusServerRootCertificates = null, IEnumerable<VpnServerConfigRadiusClientRootCertificate> radiusClientRootCertificates = null, IEnumerable<IPsecPolicy> vpnClientIPsecPolicies = null, string radiusServerAddress = null, string radiusServerSecret = null, IEnumerable<RadiusServer> radiusServers = null, AadAuthenticationParameters aadAuthenticationParameters = null, string provisioningState = null, IEnumerable<P2SVpnGatewayData> p2sVpnGateways = null, IEnumerable<VpnServerConfigurationPolicyGroupData> configurationPolicyGroups = null)
        {
            tags ??= new Dictionary<string, string>();
            vpnProtocols ??= new List<VpnGatewayTunnelingProtocol>();
            vpnAuthenticationTypes ??= new List<VpnAuthenticationType>();
            vpnClientRootCertificates ??= new List<VpnServerConfigVpnClientRootCertificate>();
            vpnClientRevokedCertificates ??= new List<VpnServerConfigVpnClientRevokedCertificate>();
            radiusServerRootCertificates ??= new List<VpnServerConfigRadiusServerRootCertificate>();
            radiusClientRootCertificates ??= new List<VpnServerConfigRadiusClientRootCertificate>();
            vpnClientIPsecPolicies ??= new List<IPsecPolicy>();
            radiusServers ??= new List<RadiusServer>();
            p2sVpnGateways ??= new List<P2SVpnGatewayData>();
            configurationPolicyGroups ??= new List<VpnServerConfigurationPolicyGroupData>();

            return new VpnServerConfigurationData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                vpnProtocols?.ToList(),
                vpnAuthenticationTypes?.ToList(),
                vpnClientRootCertificates?.ToList(),
                vpnClientRevokedCertificates?.ToList(),
                radiusServerRootCertificates?.ToList(),
                radiusClientRootCertificates?.ToList(),
                vpnClientIPsecPolicies?.ToList(),
                radiusServerAddress,
                radiusServerSecret,
                radiusServers?.ToList(),
                aadAuthenticationParameters,
                provisioningState,
                p2sVpnGateways?.ToList(),
                configurationPolicyGroups?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Network.P2SVpnGatewayData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="virtualHubId"> The VirtualHub to which the gateway belongs. </param>
        /// <param name="p2sConnectionConfigurations"> List of all p2s connection configurations of the gateway. </param>
        /// <param name="provisioningState"> The provisioning state of the P2S VPN gateway resource. </param>
        /// <param name="vpnGatewayScaleUnit"> The scale unit for this p2s vpn gateway. </param>
        /// <param name="vpnServerConfigurationId"> The VpnServerConfiguration to which the p2sVpnGateway is attached to. </param>
        /// <param name="vpnClientConnectionHealth"> All P2S VPN clients' connection health status. </param>
        /// <param name="customDnsServers"> List of all customer specified DNS servers IP addresses. </param>
        /// <param name="isRoutingPreferenceInternet"> Enable Routing Preference property for the Public IP Interface of the P2SVpnGateway. </param>
        /// <returns> A new <see cref="Network.P2SVpnGatewayData"/> instance for mocking. </returns>
        public static P2SVpnGatewayData P2SVpnGatewayData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, ResourceIdentifier virtualHubId = null, IEnumerable<P2SConnectionConfiguration> p2sConnectionConfigurations = null, NetworkProvisioningState? provisioningState = null, int? vpnGatewayScaleUnit = null, ResourceIdentifier vpnServerConfigurationId = null, VpnClientConnectionHealth vpnClientConnectionHealth = null, IEnumerable<string> customDnsServers = null, bool? isRoutingPreferenceInternet = null)
        {
            tags ??= new Dictionary<string, string>();
            p2sConnectionConfigurations ??= new List<P2SConnectionConfiguration>();
            customDnsServers ??= new List<string>();

            return new P2SVpnGatewayData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                virtualHubId != null ? ResourceManagerModelFactory.WritableSubResource(virtualHubId) : null,
                p2sConnectionConfigurations?.ToList(),
                provisioningState,
                vpnGatewayScaleUnit,
                vpnServerConfigurationId != null ? ResourceManagerModelFactory.WritableSubResource(vpnServerConfigurationId) : null,
                vpnClientConnectionHealth,
                customDnsServers?.ToList(),
                isRoutingPreferenceInternet);
        }

        /// <summary> Initializes a new instance of <see cref="Models.P2SConnectionConfiguration"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="vpnClientAddressPrefixes"> The reference to the address space resource which represents Address space for P2S VpnClient. </param>
        /// <param name="routingConfiguration"> The Routing Configuration indicating the associated and propagated route tables on this connection. </param>
        /// <param name="enableInternetSecurity"> Flag indicating whether the enable internet security flag is turned on for the P2S Connections or not. </param>
        /// <param name="configurationPolicyGroupAssociations"> List of Configuration Policy Groups that this P2SConnectionConfiguration is attached to. </param>
        /// <param name="previousConfigurationPolicyGroupAssociations"> List of previous Configuration Policy Groups that this P2SConnectionConfiguration was attached to. </param>
        /// <param name="provisioningState"> The provisioning state of the P2SConnectionConfiguration resource. </param>
        /// <returns> A new <see cref="Models.P2SConnectionConfiguration"/> instance for mocking. </returns>
        public static P2SConnectionConfiguration P2SConnectionConfiguration(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, IEnumerable<string> vpnClientAddressPrefixes = null, RoutingConfiguration routingConfiguration = null, bool? enableInternetSecurity = null, IEnumerable<WritableSubResource> configurationPolicyGroupAssociations = null, IEnumerable<VpnServerConfigurationPolicyGroupData> previousConfigurationPolicyGroupAssociations = null, NetworkProvisioningState? provisioningState = null)
        {
            vpnClientAddressPrefixes ??= new List<string>();
            configurationPolicyGroupAssociations ??= new List<WritableSubResource>();
            previousConfigurationPolicyGroupAssociations ??= new List<VpnServerConfigurationPolicyGroupData>();

            return new P2SConnectionConfiguration(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                vpnClientAddressPrefixes != null ? new AddressSpace(vpnClientAddressPrefixes?.ToList(), serializedAdditionalRawData: null) : null,
                routingConfiguration,
                enableInternetSecurity,
                configurationPolicyGroupAssociations?.ToList(),
                previousConfigurationPolicyGroupAssociations?.ToList(),
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VnetRoute"/>. </summary>
        /// <param name="staticRoutesConfig"> Configuration for static routes on this HubVnetConnection. </param>
        /// <param name="staticRoutes"> List of all Static Routes. </param>
        /// <param name="bgpConnections"> The list of references to HubBgpConnection objects. </param>
        /// <returns> A new <see cref="Models.VnetRoute"/> instance for mocking. </returns>
        public static VnetRoute VnetRoute(StaticRoutesConfig staticRoutesConfig = null, IEnumerable<StaticRoute> staticRoutes = null, IEnumerable<WritableSubResource> bgpConnections = null)
        {
            staticRoutes ??= new List<StaticRoute>();
            bgpConnections ??= new List<WritableSubResource>();

            return new VnetRoute(staticRoutesConfig, staticRoutes?.ToList(), bgpConnections?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StaticRoutesConfig"/>. </summary>
        /// <param name="propagateStaticRoutes"> Boolean indicating whether static routes on this connection are automatically propagate to route tables which this connection propagates to. </param>
        /// <param name="vnetLocalRouteOverrideCriteria"> Parameter determining whether NVA in spoke vnet is bypassed for traffic with destination in spoke. </param>
        /// <returns> A new <see cref="Models.StaticRoutesConfig"/> instance for mocking. </returns>
        public static StaticRoutesConfig StaticRoutesConfig(bool? propagateStaticRoutes = null, VnetLocalRouteOverrideCriterion? vnetLocalRouteOverrideCriteria = null)
        {
            return new StaticRoutesConfig(propagateStaticRoutes, vnetLocalRouteOverrideCriteria, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.VpnServerConfigurationPolicyGroupData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="isDefault"> Shows if this is a Default VpnServerConfigurationPolicyGroup or not. </param>
        /// <param name="priority"> Priority for VpnServerConfigurationPolicyGroup. </param>
        /// <param name="policyMembers"> Multiple PolicyMembers for VpnServerConfigurationPolicyGroup. </param>
        /// <param name="p2sConnectionConfigurations"> List of references to P2SConnectionConfigurations. </param>
        /// <param name="provisioningState"> The provisioning state of the VpnServerConfigurationPolicyGroup resource. </param>
        /// <returns> A new <see cref="Network.VpnServerConfigurationPolicyGroupData"/> instance for mocking. </returns>
        public static VpnServerConfigurationPolicyGroupData VpnServerConfigurationPolicyGroupData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, bool? isDefault = null, int? priority = null, IEnumerable<VpnServerConfigurationPolicyGroupMember> policyMembers = null, IEnumerable<WritableSubResource> p2sConnectionConfigurations = null, NetworkProvisioningState? provisioningState = null)
        {
            policyMembers ??= new List<VpnServerConfigurationPolicyGroupMember>();
            p2sConnectionConfigurations ??= new List<WritableSubResource>();

            return new VpnServerConfigurationPolicyGroupData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                isDefault,
                priority,
                policyMembers?.ToList(),
                p2sConnectionConfigurations?.ToList(),
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VpnClientConnectionHealth"/>. </summary>
        /// <param name="totalIngressBytesTransferred"> Total of the Ingress Bytes Transferred in this P2S Vpn connection. </param>
        /// <param name="totalEgressBytesTransferred"> Total of the Egress Bytes Transferred in this connection. </param>
        /// <param name="vpnClientConnectionsCount"> The total of p2s vpn clients connected at this time to this P2SVpnGateway. </param>
        /// <param name="allocatedIPAddresses"> List of allocated ip addresses to the connected p2s vpn clients. </param>
        /// <returns> A new <see cref="Models.VpnClientConnectionHealth"/> instance for mocking. </returns>
        public static VpnClientConnectionHealth VpnClientConnectionHealth(long? totalIngressBytesTransferred = null, long? totalEgressBytesTransferred = null, int? vpnClientConnectionsCount = null, IEnumerable<string> allocatedIPAddresses = null)
        {
            allocatedIPAddresses ??= new List<string>();

            return new VpnClientConnectionHealth(totalIngressBytesTransferred, totalEgressBytesTransferred, vpnClientConnectionsCount, allocatedIPAddresses?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.VirtualHubData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="kind"> Kind of service virtual hub. This is metadata used for the Azure portal experience for Route Server. </param>
        /// <param name="virtualWanId"> The VirtualWAN to which the VirtualHub belongs. </param>
        /// <param name="vpnGatewayId"> The VpnGateway associated with this VirtualHub. </param>
        /// <param name="p2sVpnGatewayId"> The P2SVpnGateway associated with this VirtualHub. </param>
        /// <param name="expressRouteGatewayId"> The expressRouteGateway associated with this VirtualHub. </param>
        /// <param name="azureFirewallId"> The azureFirewall associated with this VirtualHub. </param>
        /// <param name="securityPartnerProviderId"> The securityPartnerProvider associated with this VirtualHub. </param>
        /// <param name="addressPrefix"> Address-prefix for this VirtualHub. </param>
        /// <param name="routes"> The routeTable associated with this virtual hub. </param>
        /// <param name="provisioningState"> The provisioning state of the virtual hub resource. </param>
        /// <param name="securityProviderName"> The Security Provider name. </param>
        /// <param name="virtualHubRouteTableV2S"> List of all virtual hub route table v2s associated with this VirtualHub. </param>
        /// <param name="sku"> The sku of this VirtualHub. </param>
        /// <param name="routingState"> The routing state. </param>
        /// <param name="bgpConnections"> List of references to Bgp Connections. </param>
        /// <param name="ipConfigurations"> List of references to IpConfigurations. </param>
        /// <param name="routeMaps"> List of references to RouteMaps. </param>
        /// <param name="virtualRouterAsn"> VirtualRouter ASN. </param>
        /// <param name="virtualRouterIPs"> VirtualRouter IPs. </param>
        /// <param name="allowBranchToBranchTraffic"> Flag to control transit for VirtualRouter hub. </param>
        /// <param name="preferredRoutingGateway"> The preferred gateway to route on-prem traffic. </param>
        /// <param name="hubRoutingPreference"> The hubRoutingPreference of this VirtualHub. </param>
        /// <param name="virtualRouterAutoScaleMinCapacity"> The VirtualHub Router autoscale configuration. </param>
        /// <returns> A new <see cref="Network.VirtualHubData"/> instance for mocking. </returns>
        public static VirtualHubData VirtualHubData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, string kind = null, ResourceIdentifier virtualWanId = null, ResourceIdentifier vpnGatewayId = null, ResourceIdentifier p2sVpnGatewayId = null, ResourceIdentifier expressRouteGatewayId = null, ResourceIdentifier azureFirewallId = null, ResourceIdentifier securityPartnerProviderId = null, string addressPrefix = null, IEnumerable<VirtualHubRoute> routes = null, NetworkProvisioningState? provisioningState = null, string securityProviderName = null, IEnumerable<VirtualHubRouteTableV2Data> virtualHubRouteTableV2S = null, string sku = null, RoutingState? routingState = null, IEnumerable<WritableSubResource> bgpConnections = null, IEnumerable<WritableSubResource> ipConfigurations = null, IEnumerable<WritableSubResource> routeMaps = null, long? virtualRouterAsn = null, IEnumerable<string> virtualRouterIPs = null, bool? allowBranchToBranchTraffic = null, PreferredRoutingGateway? preferredRoutingGateway = null, HubRoutingPreference? hubRoutingPreference = null, int? virtualRouterAutoScaleMinCapacity = null)
        {
            tags ??= new Dictionary<string, string>();
            routes ??= new List<VirtualHubRoute>();
            virtualHubRouteTableV2S ??= new List<VirtualHubRouteTableV2Data>();
            bgpConnections ??= new List<WritableSubResource>();
            ipConfigurations ??= new List<WritableSubResource>();
            routeMaps ??= new List<WritableSubResource>();
            virtualRouterIPs ??= new List<string>();

            return new VirtualHubData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                kind,
                virtualWanId != null ? ResourceManagerModelFactory.WritableSubResource(virtualWanId) : null,
                vpnGatewayId != null ? ResourceManagerModelFactory.WritableSubResource(vpnGatewayId) : null,
                p2sVpnGatewayId != null ? ResourceManagerModelFactory.WritableSubResource(p2sVpnGatewayId) : null,
                expressRouteGatewayId != null ? ResourceManagerModelFactory.WritableSubResource(expressRouteGatewayId) : null,
                azureFirewallId != null ? ResourceManagerModelFactory.WritableSubResource(azureFirewallId) : null,
                securityPartnerProviderId != null ? ResourceManagerModelFactory.WritableSubResource(securityPartnerProviderId) : null,
                addressPrefix,
                routes != null ? new VirtualHubRouteTable(routes?.ToList(), serializedAdditionalRawData: null) : null,
                provisioningState,
                securityProviderName,
                virtualHubRouteTableV2S?.ToList(),
                sku,
                routingState,
                bgpConnections?.ToList(),
                ipConfigurations?.ToList(),
                routeMaps?.ToList(),
                virtualRouterAsn,
                virtualRouterIPs?.ToList(),
                allowBranchToBranchTraffic,
                preferredRoutingGateway,
                hubRoutingPreference,
                virtualRouterAutoScaleMinCapacity != null ? new VirtualRouterAutoScaleConfiguration(virtualRouterAutoScaleMinCapacity, serializedAdditionalRawData: null) : null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.VirtualHubRouteTableV2Data"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="routes"> List of all routes. </param>
        /// <param name="attachedConnections"> List of all connections attached to this route table v2. </param>
        /// <param name="provisioningState"> The provisioning state of the virtual hub route table v2 resource. </param>
        /// <returns> A new <see cref="Network.VirtualHubRouteTableV2Data"/> instance for mocking. </returns>
        public static VirtualHubRouteTableV2Data VirtualHubRouteTableV2Data(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, IEnumerable<VirtualHubRouteV2> routes = null, IEnumerable<string> attachedConnections = null, NetworkProvisioningState? provisioningState = null)
        {
            routes ??= new List<VirtualHubRouteV2>();
            attachedConnections ??= new List<string>();

            return new VirtualHubRouteTableV2Data(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                routes?.ToList(),
                attachedConnections?.ToList(),
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Network.RouteMapData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="associatedInboundConnections"> List of connections which have this RoutMap associated for inbound traffic. </param>
        /// <param name="associatedOutboundConnections"> List of connections which have this RoutMap associated for outbound traffic. </param>
        /// <param name="rules"> List of RouteMap rules to be applied. </param>
        /// <param name="provisioningState"> The provisioning state of the RouteMap resource. </param>
        /// <returns> A new <see cref="Network.RouteMapData"/> instance for mocking. </returns>
        public static RouteMapData RouteMapData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ETag? etag = null, IEnumerable<string> associatedInboundConnections = null, IEnumerable<string> associatedOutboundConnections = null, IEnumerable<RouteMapRule> rules = null, NetworkProvisioningState? provisioningState = null)
        {
            associatedInboundConnections ??= new List<string>();
            associatedOutboundConnections ??= new List<string>();
            rules ??= new List<RouteMapRule>();

            return new RouteMapData(
                id,
                name,
                resourceType,
                systemData,
                etag,
                associatedInboundConnections?.ToList(),
                associatedOutboundConnections?.ToList(),
                rules?.ToList(),
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.HubVirtualNetworkConnectionData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="remoteVirtualNetworkId"> Reference to the remote virtual network. </param>
        /// <param name="allowHubToRemoteVnetTransit"> Deprecated: VirtualHub to RemoteVnet transit to enabled or not. </param>
        /// <param name="allowRemoteVnetToUseHubVnetGateways"> Deprecated: Allow RemoteVnet to use Virtual Hub's gateways. </param>
        /// <param name="enableInternetSecurity"> Enable internet security. </param>
        /// <param name="routingConfiguration"> The Routing Configuration indicating the associated and propagated route tables on this connection. </param>
        /// <param name="provisioningState"> The provisioning state of the hub virtual network connection resource. </param>
        /// <returns> A new <see cref="Network.HubVirtualNetworkConnectionData"/> instance for mocking. </returns>
        public static HubVirtualNetworkConnectionData HubVirtualNetworkConnectionData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, ResourceIdentifier remoteVirtualNetworkId = null, bool? allowHubToRemoteVnetTransit = null, bool? allowRemoteVnetToUseHubVnetGateways = null, bool? enableInternetSecurity = null, RoutingConfiguration routingConfiguration = null, NetworkProvisioningState? provisioningState = null)
        {
            return new HubVirtualNetworkConnectionData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                remoteVirtualNetworkId != null ? ResourceManagerModelFactory.WritableSubResource(remoteVirtualNetworkId) : null,
                allowHubToRemoteVnetTransit,
                allowRemoteVnetToUseHubVnetGateways,
                enableInternetSecurity,
                routingConfiguration,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Network.VpnGatewayData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="virtualHubId"> The VirtualHub to which the gateway belongs. </param>
        /// <param name="connections"> List of all vpn connections to the gateway. </param>
        /// <param name="bgpSettings"> Local network gateway's BGP speaker settings. </param>
        /// <param name="provisioningState"> The provisioning state of the VPN gateway resource. </param>
        /// <param name="vpnGatewayScaleUnit"> The scale unit for this vpn gateway. </param>
        /// <param name="ipConfigurations"> List of all IPs configured on the gateway. </param>
        /// <param name="enableBgpRouteTranslationForNat"> Enable BGP routes translation for NAT on this VpnGateway. </param>
        /// <param name="isRoutingPreferenceInternet"> Enable Routing Preference property for the Public IP Interface of the VpnGateway. </param>
        /// <param name="natRules"> List of all the nat Rules associated with the gateway. </param>
        /// <returns> A new <see cref="Network.VpnGatewayData"/> instance for mocking. </returns>
        public static VpnGatewayData VpnGatewayData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, ResourceIdentifier virtualHubId = null, IEnumerable<VpnConnectionData> connections = null, BgpSettings bgpSettings = null, NetworkProvisioningState? provisioningState = null, int? vpnGatewayScaleUnit = null, IEnumerable<VpnGatewayIPConfiguration> ipConfigurations = null, bool? enableBgpRouteTranslationForNat = null, bool? isRoutingPreferenceInternet = null, IEnumerable<VpnGatewayNatRuleData> natRules = null)
        {
            tags ??= new Dictionary<string, string>();
            connections ??= new List<VpnConnectionData>();
            ipConfigurations ??= new List<VpnGatewayIPConfiguration>();
            natRules ??= new List<VpnGatewayNatRuleData>();

            return new VpnGatewayData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                virtualHubId != null ? ResourceManagerModelFactory.WritableSubResource(virtualHubId) : null,
                connections?.ToList(),
                bgpSettings,
                provisioningState,
                vpnGatewayScaleUnit,
                ipConfigurations?.ToList(),
                enableBgpRouteTranslationForNat,
                isRoutingPreferenceInternet,
                natRules?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Network.VpnConnectionData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="remoteVpnSiteId"> Id of the connected vpn site. </param>
        /// <param name="routingWeight"> Routing weight for vpn connection. </param>
        /// <param name="dpdTimeoutSeconds"> DPD timeout in seconds for vpn connection. </param>
        /// <param name="connectionStatus"> The connection status. </param>
        /// <param name="vpnConnectionProtocolType"> Connection protocol used for this connection. </param>
        /// <param name="ingressBytesTransferred"> Ingress bytes transferred. </param>
        /// <param name="egressBytesTransferred"> Egress bytes transferred. </param>
        /// <param name="connectionBandwidth"> Expected bandwidth in MBPS. </param>
        /// <param name="sharedKey"> SharedKey for the vpn connection. </param>
        /// <param name="enableBgp"> EnableBgp flag. </param>
        /// <param name="usePolicyBasedTrafficSelectors"> Enable policy-based traffic selectors. </param>
        /// <param name="ipsecPolicies"> The IPSec Policies to be considered by this connection. </param>
        /// <param name="trafficSelectorPolicies"> The Traffic Selector Policies to be considered by this connection. </param>
        /// <param name="enableRateLimiting"> EnableBgp flag. </param>
        /// <param name="enableInternetSecurity"> Enable internet security. </param>
        /// <param name="useLocalAzureIPAddress"> Use local azure ip to initiate connection. </param>
        /// <param name="provisioningState"> The provisioning state of the VPN connection resource. </param>
        /// <param name="vpnLinkConnections"> List of all vpn site link connections to the gateway. </param>
        /// <param name="routingConfiguration"> The Routing Configuration indicating the associated and propagated route tables on this connection. </param>
        /// <returns> A new <see cref="Network.VpnConnectionData"/> instance for mocking. </returns>
        public static VpnConnectionData VpnConnectionData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, ResourceIdentifier remoteVpnSiteId = null, int? routingWeight = null, int? dpdTimeoutSeconds = null, VpnConnectionStatus? connectionStatus = null, VirtualNetworkGatewayConnectionProtocol? vpnConnectionProtocolType = null, long? ingressBytesTransferred = null, long? egressBytesTransferred = null, int? connectionBandwidth = null, string sharedKey = null, bool? enableBgp = null, bool? usePolicyBasedTrafficSelectors = null, IEnumerable<IPsecPolicy> ipsecPolicies = null, IEnumerable<TrafficSelectorPolicy> trafficSelectorPolicies = null, bool? enableRateLimiting = null, bool? enableInternetSecurity = null, bool? useLocalAzureIPAddress = null, NetworkProvisioningState? provisioningState = null, IEnumerable<VpnSiteLinkConnectionData> vpnLinkConnections = null, RoutingConfiguration routingConfiguration = null)
        {
            ipsecPolicies ??= new List<IPsecPolicy>();
            trafficSelectorPolicies ??= new List<TrafficSelectorPolicy>();
            vpnLinkConnections ??= new List<VpnSiteLinkConnectionData>();

            return new VpnConnectionData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                remoteVpnSiteId != null ? ResourceManagerModelFactory.WritableSubResource(remoteVpnSiteId) : null,
                routingWeight,
                dpdTimeoutSeconds,
                connectionStatus,
                vpnConnectionProtocolType,
                ingressBytesTransferred,
                egressBytesTransferred,
                connectionBandwidth,
                sharedKey,
                enableBgp,
                usePolicyBasedTrafficSelectors,
                ipsecPolicies?.ToList(),
                trafficSelectorPolicies?.ToList(),
                enableRateLimiting,
                enableInternetSecurity,
                useLocalAzureIPAddress,
                provisioningState,
                vpnLinkConnections?.ToList(),
                routingConfiguration);
        }

        /// <summary> Initializes a new instance of <see cref="Network.VpnSiteLinkConnectionData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="vpnSiteLinkId"> Id of the connected vpn site link. </param>
        /// <param name="routingWeight"> Routing weight for vpn connection. </param>
        /// <param name="vpnLinkConnectionMode"> Vpn link connection mode. </param>
        /// <param name="connectionStatus"> The connection status. </param>
        /// <param name="vpnConnectionProtocolType"> Connection protocol used for this connection. </param>
        /// <param name="ingressBytesTransferred"> Ingress bytes transferred. </param>
        /// <param name="egressBytesTransferred"> Egress bytes transferred. </param>
        /// <param name="connectionBandwidth"> Expected bandwidth in MBPS. </param>
        /// <param name="sharedKey"> SharedKey for the vpn connection. </param>
        /// <param name="enableBgp"> EnableBgp flag. </param>
        /// <param name="vpnGatewayCustomBgpAddresses"> vpnGatewayCustomBgpAddresses used by this connection. </param>
        /// <param name="usePolicyBasedTrafficSelectors"> Enable policy-based traffic selectors. </param>
        /// <param name="ipsecPolicies"> The IPSec Policies to be considered by this connection. </param>
        /// <param name="enableRateLimiting"> EnableBgp flag. </param>
        /// <param name="useLocalAzureIPAddress"> Use local azure ip to initiate connection. </param>
        /// <param name="provisioningState"> The provisioning state of the VPN site link connection resource. </param>
        /// <param name="ingressNatRules"> List of ingress NatRules. </param>
        /// <param name="egressNatRules"> List of egress NatRules. </param>
        /// <param name="dpdTimeoutSeconds"> Dead Peer Detection timeout in seconds for VpnLink connection. </param>
        /// <returns> A new <see cref="Network.VpnSiteLinkConnectionData"/> instance for mocking. </returns>
        public static VpnSiteLinkConnectionData VpnSiteLinkConnectionData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, ResourceIdentifier vpnSiteLinkId = null, int? routingWeight = null, VpnLinkConnectionMode? vpnLinkConnectionMode = null, VpnConnectionStatus? connectionStatus = null, VirtualNetworkGatewayConnectionProtocol? vpnConnectionProtocolType = null, long? ingressBytesTransferred = null, long? egressBytesTransferred = null, int? connectionBandwidth = null, string sharedKey = null, bool? enableBgp = null, IEnumerable<GatewayCustomBgpIPAddressIPConfiguration> vpnGatewayCustomBgpAddresses = null, bool? usePolicyBasedTrafficSelectors = null, IEnumerable<IPsecPolicy> ipsecPolicies = null, bool? enableRateLimiting = null, bool? useLocalAzureIPAddress = null, NetworkProvisioningState? provisioningState = null, IEnumerable<WritableSubResource> ingressNatRules = null, IEnumerable<WritableSubResource> egressNatRules = null, int? dpdTimeoutSeconds = null)
        {
            vpnGatewayCustomBgpAddresses ??= new List<GatewayCustomBgpIPAddressIPConfiguration>();
            ipsecPolicies ??= new List<IPsecPolicy>();
            ingressNatRules ??= new List<WritableSubResource>();
            egressNatRules ??= new List<WritableSubResource>();

            return new VpnSiteLinkConnectionData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                vpnSiteLinkId != null ? ResourceManagerModelFactory.WritableSubResource(vpnSiteLinkId) : null,
                routingWeight,
                vpnLinkConnectionMode,
                connectionStatus,
                vpnConnectionProtocolType,
                ingressBytesTransferred,
                egressBytesTransferred,
                connectionBandwidth,
                sharedKey,
                enableBgp,
                vpnGatewayCustomBgpAddresses?.ToList(),
                usePolicyBasedTrafficSelectors,
                ipsecPolicies?.ToList(),
                enableRateLimiting,
                useLocalAzureIPAddress,
                provisioningState,
                ingressNatRules?.ToList(),
                egressNatRules?.ToList(),
                dpdTimeoutSeconds);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VpnGatewayIPConfiguration"/>. </summary>
        /// <param name="id"> The identifier of the IP configuration for a VPN Gateway. </param>
        /// <param name="publicIPAddress"> The public IP address of this IP configuration. </param>
        /// <param name="privateIPAddress"> The private IP address of this IP configuration. </param>
        /// <returns> A new <see cref="Models.VpnGatewayIPConfiguration"/> instance for mocking. </returns>
        public static VpnGatewayIPConfiguration VpnGatewayIPConfiguration(ResourceIdentifier id = null, string publicIPAddress = null, string privateIPAddress = null)
        {
            return new VpnGatewayIPConfiguration(id, publicIPAddress, privateIPAddress, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.VpnGatewayNatRuleData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="provisioningState"> The provisioning state of the NAT Rule resource. </param>
        /// <param name="vpnNatRuleType"> The type of NAT rule for VPN NAT. </param>
        /// <param name="mode"> The Source NAT direction of a VPN NAT. </param>
        /// <param name="internalMappings"> The private IP address internal mapping for NAT. </param>
        /// <param name="externalMappings"> The private IP address external mapping for NAT. </param>
        /// <param name="ipConfigurationId"> The IP Configuration ID this NAT rule applies to. </param>
        /// <param name="egressVpnSiteLinkConnections"> List of egress VpnSiteLinkConnections. </param>
        /// <param name="ingressVpnSiteLinkConnections"> List of ingress VpnSiteLinkConnections. </param>
        /// <returns> A new <see cref="Network.VpnGatewayNatRuleData"/> instance for mocking. </returns>
        public static VpnGatewayNatRuleData VpnGatewayNatRuleData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, NetworkProvisioningState? provisioningState = null, VpnNatRuleType? vpnNatRuleType = null, VpnNatRuleMode? mode = null, IEnumerable<VpnNatRuleMapping> internalMappings = null, IEnumerable<VpnNatRuleMapping> externalMappings = null, string ipConfigurationId = null, IEnumerable<WritableSubResource> egressVpnSiteLinkConnections = null, IEnumerable<WritableSubResource> ingressVpnSiteLinkConnections = null)
        {
            internalMappings ??= new List<VpnNatRuleMapping>();
            externalMappings ??= new List<VpnNatRuleMapping>();
            egressVpnSiteLinkConnections ??= new List<WritableSubResource>();
            ingressVpnSiteLinkConnections ??= new List<WritableSubResource>();

            return new VpnGatewayNatRuleData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                provisioningState,
                vpnNatRuleType,
                mode,
                internalMappings?.ToList(),
                externalMappings?.ToList(),
                ipConfigurationId,
                egressVpnSiteLinkConnections?.ToList(),
                ingressVpnSiteLinkConnections?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Network.VpnLinkConnectionSharedKeyData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="properties"> Properties of the shared key. </param>
        /// <returns> A new <see cref="Network.VpnLinkConnectionSharedKeyData"/> instance for mocking. </returns>
        public static VpnLinkConnectionSharedKeyData VpnLinkConnectionSharedKeyData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, VpnLinkConnectionSharedKeyProperties properties = null)
        {
            return new VpnLinkConnectionSharedKeyData(id, name, resourceType, serializedAdditionalRawData: null, properties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VpnLinkConnectionSharedKeyProperties"/>. </summary>
        /// <param name="sharedKey"> The value of the shared key for the vpn link connection. </param>
        /// <param name="sharedKeyLength"> The length of the shared key for the vpn link connection. </param>
        /// <param name="provisioningState"> The provisioning state of the SharedKey resource. </param>
        /// <returns> A new <see cref="Models.VpnLinkConnectionSharedKeyProperties"/> instance for mocking. </returns>
        public static VpnLinkConnectionSharedKeyProperties VpnLinkConnectionSharedKeyProperties(string sharedKey = null, int? sharedKeyLength = null, NetworkProvisioningState? provisioningState = null)
        {
            return new VpnLinkConnectionSharedKeyProperties(sharedKey, sharedKeyLength, provisioningState, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VpnProfileResponse"/>. </summary>
        /// <param name="profileUri"> URL to the VPN profile. </param>
        /// <returns> A new <see cref="Models.VpnProfileResponse"/> instance for mocking. </returns>
        public static VpnProfileResponse VpnProfileResponse(Uri profileUri = null)
        {
            return new VpnProfileResponse(profileUri, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.P2SVpnConnectionHealth"/>. </summary>
        /// <param name="sasUri"> Returned sas url of the blob to which the p2s vpn connection detailed health will be written. </param>
        /// <returns> A new <see cref="Models.P2SVpnConnectionHealth"/> instance for mocking. </returns>
        public static P2SVpnConnectionHealth P2SVpnConnectionHealth(Uri sasUri = null)
        {
            return new P2SVpnConnectionHealth(sasUri, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VpnServerConfigurationsResponse"/>. </summary>
        /// <param name="vpnServerConfigurationResourceIds"> List of VpnServerConfigurations associated with VirtualWan. </param>
        /// <returns> A new <see cref="Models.VpnServerConfigurationsResponse"/> instance for mocking. </returns>
        public static VpnServerConfigurationsResponse VpnServerConfigurationsResponse(IEnumerable<string> vpnServerConfigurationResourceIds = null)
        {
            vpnServerConfigurationResourceIds ??= new List<string>();

            return new VpnServerConfigurationsResponse(vpnServerConfigurationResourceIds?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.ExpressRouteGatewayData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="autoScaleBounds"> Configuration for auto scaling. </param>
        /// <param name="expressRouteConnectionList"> List of ExpressRoute connections to the ExpressRoute gateway. </param>
        /// <param name="provisioningState"> The provisioning state of the express route gateway resource. </param>
        /// <param name="virtualHubId"> The Virtual Hub where the ExpressRoute gateway is or will be deployed. </param>
        /// <param name="allowNonVirtualWanTraffic"> Configures this gateway to accept traffic from non Virtual WAN networks. </param>
        /// <returns> A new <see cref="Network.ExpressRouteGatewayData"/> instance for mocking. </returns>
        public static ExpressRouteGatewayData ExpressRouteGatewayData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds autoScaleBounds = null, IEnumerable<ExpressRouteConnectionData> expressRouteConnectionList = null, NetworkProvisioningState? provisioningState = null, ResourceIdentifier virtualHubId = null, bool? allowNonVirtualWanTraffic = null)
        {
            tags ??= new Dictionary<string, string>();
            expressRouteConnectionList ??= new List<ExpressRouteConnectionData>();

            return new ExpressRouteGatewayData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                autoScaleBounds != null ? new ExpressRouteGatewayPropertiesAutoScaleConfiguration(autoScaleBounds, serializedAdditionalRawData: null) : null,
                expressRouteConnectionList?.ToList(),
                provisioningState,
                virtualHubId != null ? ResourceManagerModelFactory.WritableSubResource(virtualHubId) : null,
                allowNonVirtualWanTraffic);
        }

        /// <summary> Initializes a new instance of <see cref="Network.ExpressRouteConnectionData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="provisioningState"> The provisioning state of the express route connection resource. </param>
        /// <param name="expressRouteCircuitPeeringId"> The ExpressRoute circuit peering. </param>
        /// <param name="authorizationKey"> Authorization key to establish the connection. </param>
        /// <param name="routingWeight"> The routing weight associated to the connection. </param>
        /// <param name="enableInternetSecurity"> Enable internet security. </param>
        /// <param name="expressRouteGatewayBypass"> Enable FastPath to vWan Firewall hub. </param>
        /// <param name="enablePrivateLinkFastPath"> Bypass the ExpressRoute gateway when accessing private-links. ExpressRoute FastPath (expressRouteGatewayBypass) must be enabled. </param>
        /// <param name="routingConfiguration"> The Routing Configuration indicating the associated and propagated route tables on this connection. </param>
        /// <returns> A new <see cref="Network.ExpressRouteConnectionData"/> instance for mocking. </returns>
        public static ExpressRouteConnectionData ExpressRouteConnectionData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, NetworkProvisioningState? provisioningState = null, ResourceIdentifier expressRouteCircuitPeeringId = null, string authorizationKey = null, int? routingWeight = null, bool? enableInternetSecurity = null, bool? expressRouteGatewayBypass = null, bool? enablePrivateLinkFastPath = null, RoutingConfiguration routingConfiguration = null)
        {
            return new ExpressRouteConnectionData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                provisioningState,
                expressRouteCircuitPeeringId != null ? ResourceManagerModelFactory.WritableSubResource(expressRouteCircuitPeeringId) : null,
                authorizationKey,
                routingWeight,
                enableInternetSecurity,
                expressRouteGatewayBypass,
                enablePrivateLinkFastPath,
                routingConfiguration);
        }

        /// <summary> Initializes a new instance of <see cref="Network.NetworkVirtualApplianceConnectionData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="namePropertiesName"> The name of the resource. </param>
        /// <param name="provisioningState"> The provisioning state of the NetworkVirtualApplianceConnection resource. </param>
        /// <param name="asn"> Network Virtual Appliance ASN. </param>
        /// <param name="tunnelIdentifier"> Unique identifier for the connection. </param>
        /// <param name="bgpPeerAddress"> List of bgpPeerAddresses for the NVA instances. </param>
        /// <param name="enableInternetSecurity"> Enable internet security. </param>
        /// <param name="connectionRoutingConfiguration"> The Routing Configuration indicating the associated and propagated route tables on this connection. </param>
        /// <returns> A new <see cref="Network.NetworkVirtualApplianceConnectionData"/> instance for mocking. </returns>
        public static NetworkVirtualApplianceConnectionData NetworkVirtualApplianceConnectionData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, string namePropertiesName = null, NetworkProvisioningState? provisioningState = null, long? asn = null, long? tunnelIdentifier = null, IEnumerable<string> bgpPeerAddress = null, bool? enableInternetSecurity = null, RoutingConfiguration connectionRoutingConfiguration = null)
        {
            bgpPeerAddress ??= new List<string>();

            return new NetworkVirtualApplianceConnectionData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                namePropertiesName,
                provisioningState,
                asn,
                tunnelIdentifier,
                bgpPeerAddress?.ToList(),
                enableInternetSecurity,
                connectionRoutingConfiguration);
        }

        /// <summary> Initializes a new instance of <see cref="Network.BgpConnectionData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="peerAsn"> Peer ASN. </param>
        /// <param name="peerIP"> Peer IP. </param>
        /// <param name="hubVirtualNetworkConnectionId"> The reference to the HubVirtualNetworkConnection resource. </param>
        /// <param name="provisioningState"> The provisioning state of the resource. </param>
        /// <param name="connectionState"> The current state of the VirtualHub to Peer. </param>
        /// <returns> A new <see cref="Network.BgpConnectionData"/> instance for mocking. </returns>
        public static BgpConnectionData BgpConnectionData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, long? peerAsn = null, string peerIP = null, ResourceIdentifier hubVirtualNetworkConnectionId = null, NetworkProvisioningState? provisioningState = null, HubBgpConnectionStatus? connectionState = null)
        {
            return new BgpConnectionData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                peerAsn,
                peerIP,
                hubVirtualNetworkConnectionId != null ? ResourceManagerModelFactory.WritableSubResource(hubVirtualNetworkConnectionId) : null,
                provisioningState,
                connectionState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PeerRoute"/>. </summary>
        /// <param name="localAddress"> The peer's local address. </param>
        /// <param name="network"> The route's network prefix. </param>
        /// <param name="nextHop"> The route's next hop. </param>
        /// <param name="sourcePeer"> The peer this route was learned from. </param>
        /// <param name="origin"> The source this route was learned from. </param>
        /// <param name="asPath"> The route's AS path sequence. </param>
        /// <param name="weight"> The route's weight. </param>
        /// <returns> A new <see cref="Models.PeerRoute"/> instance for mocking. </returns>
        public static PeerRoute PeerRoute(string localAddress = null, string network = null, string nextHop = null, string sourcePeer = null, string origin = null, string asPath = null, int? weight = null)
        {
            return new PeerRoute(
                localAddress,
                network,
                nextHop,
                sourcePeer,
                origin,
                asPath,
                weight,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.HubIPConfigurationData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="privateIPAddress"> The private IP address of the IP configuration. </param>
        /// <param name="privateIPAllocationMethod"> The private IP address allocation method. </param>
        /// <param name="subnet"> The reference to the subnet resource. </param>
        /// <param name="publicIPAddress"> The reference to the public IP resource. </param>
        /// <param name="provisioningState"> The provisioning state of the IP configuration resource. </param>
        /// <returns> A new <see cref="Network.HubIPConfigurationData"/> instance for mocking. </returns>
        public static HubIPConfigurationData HubIPConfigurationData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, string privateIPAddress = null, NetworkIPAllocationMethod? privateIPAllocationMethod = null, SubnetData subnet = null, PublicIPAddressData publicIPAddress = null, NetworkProvisioningState? provisioningState = null)
        {
            return new HubIPConfigurationData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                privateIPAddress,
                privateIPAllocationMethod,
                subnet,
                publicIPAddress,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Network.HubRouteTableData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="routes"> List of all routes. </param>
        /// <param name="labels"> List of labels associated with this route table. </param>
        /// <param name="associatedConnections"> List of all connections associated with this route table. </param>
        /// <param name="propagatingConnections"> List of all connections that advertise to this route table. </param>
        /// <param name="provisioningState"> The provisioning state of the RouteTable resource. </param>
        /// <returns> A new <see cref="Network.HubRouteTableData"/> instance for mocking. </returns>
        public static HubRouteTableData HubRouteTableData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, IEnumerable<HubRoute> routes = null, IEnumerable<string> labels = null, IEnumerable<string> associatedConnections = null, IEnumerable<string> propagatingConnections = null, NetworkProvisioningState? provisioningState = null)
        {
            routes ??= new List<HubRoute>();
            labels ??= new List<string>();
            associatedConnections ??= new List<string>();
            propagatingConnections ??= new List<string>();

            return new HubRouteTableData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                routes?.ToList(),
                labels?.ToList(),
                associatedConnections?.ToList(),
                propagatingConnections?.ToList(),
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VirtualHubEffectiveRouteList"/>. </summary>
        /// <param name="value"> The list of effective routes configured on the virtual hub or the specified resource. </param>
        /// <returns> A new <see cref="Models.VirtualHubEffectiveRouteList"/> instance for mocking. </returns>
        public static VirtualHubEffectiveRouteList VirtualHubEffectiveRouteList(IEnumerable<VirtualHubEffectiveRoute> value = null)
        {
            value ??= new List<VirtualHubEffectiveRoute>();

            return new VirtualHubEffectiveRouteList(value?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VirtualHubEffectiveRoute"/>. </summary>
        /// <param name="addressPrefixes"> The list of address prefixes. </param>
        /// <param name="nextHops"> The list of next hops. </param>
        /// <param name="nextHopType"> The type of the next hop. </param>
        /// <param name="asPath"> The ASPath of this route. </param>
        /// <param name="routeOrigin"> The origin of this route. </param>
        /// <returns> A new <see cref="Models.VirtualHubEffectiveRoute"/> instance for mocking. </returns>
        public static VirtualHubEffectiveRoute VirtualHubEffectiveRoute(IEnumerable<string> addressPrefixes = null, IEnumerable<string> nextHops = null, string nextHopType = null, string asPath = null, string routeOrigin = null)
        {
            addressPrefixes ??= new List<string>();
            nextHops ??= new List<string>();

            return new VirtualHubEffectiveRoute(
                addressPrefixes?.ToList(),
                nextHops?.ToList(),
                nextHopType,
                asPath,
                routeOrigin,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EffectiveRouteMapRouteList"/>. </summary>
        /// <param name="value"> The list of Effective RouteMap Routes configured on the connection resource. </param>
        /// <returns> A new <see cref="Models.EffectiveRouteMapRouteList"/> instance for mocking. </returns>
        public static EffectiveRouteMapRouteList EffectiveRouteMapRouteList(IEnumerable<EffectiveRouteMapRoute> value = null)
        {
            value ??= new List<EffectiveRouteMapRoute>();

            return new EffectiveRouteMapRouteList(value?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EffectiveRouteMapRoute"/>. </summary>
        /// <param name="prefix"> The address prefix of the route. </param>
        /// <param name="bgpCommunities"> BGP communities of the route. </param>
        /// <param name="asPath"> The ASPath of this route. </param>
        /// <returns> A new <see cref="Models.EffectiveRouteMapRoute"/> instance for mocking. </returns>
        public static EffectiveRouteMapRoute EffectiveRouteMapRoute(string prefix = null, string bgpCommunities = null, string asPath = null)
        {
            return new EffectiveRouteMapRoute(prefix, bgpCommunities, asPath, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Network.RoutingIntentData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="routingPolicies"> List of routing policies. </param>
        /// <param name="provisioningState"> The provisioning state of the RoutingIntent resource. </param>
        /// <returns> A new <see cref="Network.RoutingIntentData"/> instance for mocking. </returns>
        public static RoutingIntentData RoutingIntentData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, ETag? etag = null, IEnumerable<RoutingPolicy> routingPolicies = null, NetworkProvisioningState? provisioningState = null)
        {
            routingPolicies ??= new List<RoutingPolicy>();

            return new RoutingIntentData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                etag,
                routingPolicies?.ToList(),
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Network.WebApplicationFirewallPolicyData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="policySettings"> The PolicySettings for policy. </param>
        /// <param name="customRules"> The custom rules inside the policy. </param>
        /// <param name="applicationGateways"> A collection of references to application gateways. </param>
        /// <param name="provisioningState"> The provisioning state of the web application firewall policy resource. </param>
        /// <param name="resourceState"> Resource status of the policy. </param>
        /// <param name="managedRules"> Describes the managedRules structure. </param>
        /// <param name="httpListeners"> A collection of references to application gateway http listeners. </param>
        /// <param name="pathBasedRules"> A collection of references to application gateway path rules. </param>
        /// <param name="applicationGatewayForContainers"> A collection of references to application gateway for containers. </param>
        /// <returns> A new <see cref="Network.WebApplicationFirewallPolicyData"/> instance for mocking. </returns>
        public static WebApplicationFirewallPolicyData WebApplicationFirewallPolicyData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, AzureLocation? location = null, IDictionary<string, string> tags = null, ETag? etag = null, PolicySettings policySettings = null, IEnumerable<WebApplicationFirewallCustomRule> customRules = null, IEnumerable<ApplicationGatewayData> applicationGateways = null, NetworkProvisioningState? provisioningState = null, WebApplicationFirewallPolicyResourceState? resourceState = null, ManagedRulesDefinition managedRules = null, IEnumerable<WritableSubResource> httpListeners = null, IEnumerable<WritableSubResource> pathBasedRules = null, IEnumerable<SubResource> applicationGatewayForContainers = null)
        {
            tags ??= new Dictionary<string, string>();
            customRules ??= new List<WebApplicationFirewallCustomRule>();
            applicationGateways ??= new List<ApplicationGatewayData>();
            httpListeners ??= new List<WritableSubResource>();
            pathBasedRules ??= new List<WritableSubResource>();
            applicationGatewayForContainers ??= new List<SubResource>();

            return new WebApplicationFirewallPolicyData(
                id,
                name,
                resourceType,
                location,
                tags,
                serializedAdditionalRawData: null,
                etag,
                policySettings,
                customRules?.ToList(),
                applicationGateways?.ToList(),
                provisioningState,
                resourceState,
                managedRules,
                httpListeners?.ToList(),
                pathBasedRules?.ToList(),
                applicationGatewayForContainers?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.WebApplicationFirewallCustomRule"/>. </summary>
        /// <param name="name"> The name of the resource that is unique within a policy. This name can be used to access the resource. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="priority"> Priority of the rule. Rules with a lower value will be evaluated before rules with a higher value. </param>
        /// <param name="state"> Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified. </param>
        /// <param name="rateLimitDuration"> Duration over which Rate Limit policy will be applied. Applies only when ruleType is RateLimitRule. </param>
        /// <param name="rateLimitThreshold"> Rate Limit threshold to apply in case ruleType is RateLimitRule. Must be greater than or equal to 1. </param>
        /// <param name="ruleType"> The rule type. </param>
        /// <param name="matchConditions"> List of match conditions. </param>
        /// <param name="groupByUserSession"> List of user session identifier group by clauses. </param>
        /// <param name="action"> Type of Actions. </param>
        /// <returns> A new <see cref="Models.WebApplicationFirewallCustomRule"/> instance for mocking. </returns>
        public static WebApplicationFirewallCustomRule WebApplicationFirewallCustomRule(string name = null, ETag? etag = null, int priority = default, WebApplicationFirewallState? state = null, ApplicationGatewayFirewallRateLimitDuration? rateLimitDuration = null, int? rateLimitThreshold = null, WebApplicationFirewallRuleType ruleType = default, IEnumerable<MatchCondition> matchConditions = null, IEnumerable<GroupByUserSession> groupByUserSession = null, WebApplicationFirewallAction action = default)
        {
            matchConditions ??= new List<MatchCondition>();
            groupByUserSession ??= new List<GroupByUserSession>();

            return new WebApplicationFirewallCustomRule(
                name,
                etag,
                priority,
                state,
                rateLimitDuration,
                rateLimitThreshold,
                ruleType,
                matchConditions?.ToList(),
                groupByUserSession?.ToList(),
                action,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ActiveSecurityAdminRule"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="commitOn"> Deployment time string. </param>
        /// <param name="region"> Deployment region. </param>
        /// <param name="configurationDescription"> A description of the security admin configuration. </param>
        /// <param name="ruleCollectionDescription"> A description of the rule collection. </param>
        /// <param name="ruleCollectionAppliesToGroups"> Groups for rule collection. </param>
        /// <param name="ruleGroups"> Effective configuration groups. </param>
        /// <param name="description"> A description for this rule. Restricted to 140 chars. </param>
        /// <param name="protocol"> Network protocol this rule applies to. </param>
        /// <param name="sources"> The CIDR or source IP ranges. </param>
        /// <param name="destinations"> The destination address prefixes. CIDR or destination IP ranges. </param>
        /// <param name="sourcePortRanges"> The source port ranges. </param>
        /// <param name="destinationPortRanges"> The destination port ranges. </param>
        /// <param name="access"> Indicates the access allowed for this particular rule. </param>
        /// <param name="priority"> The priority of the rule. The value can be between 1 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule. </param>
        /// <param name="direction"> Indicates if the traffic matched against the rule in inbound or outbound. </param>
        /// <param name="provisioningState"> The provisioning state of the resource. </param>
        /// <param name="resourceGuid"> Unique identifier for this resource. </param>
        /// <returns> A new <see cref="Models.ActiveSecurityAdminRule"/> instance for mocking. </returns>
        public static ActiveSecurityAdminRule ActiveSecurityAdminRule(string id = null, DateTimeOffset? commitOn = null, string region = null, string configurationDescription = null, string ruleCollectionDescription = null, IEnumerable<NetworkManagerSecurityGroupItem> ruleCollectionAppliesToGroups = null, IEnumerable<NetworkConfigurationGroup> ruleGroups = null, string description = null, SecurityConfigurationRuleProtocol? protocol = null, IEnumerable<AddressPrefixItem> sources = null, IEnumerable<AddressPrefixItem> destinations = null, IEnumerable<string> sourcePortRanges = null, IEnumerable<string> destinationPortRanges = null, SecurityConfigurationRuleAccess? access = null, int? priority = null, SecurityConfigurationRuleDirection? direction = null, NetworkProvisioningState? provisioningState = null, Guid? resourceGuid = null)
        {
            ruleCollectionAppliesToGroups ??= new List<NetworkManagerSecurityGroupItem>();
            ruleGroups ??= new List<NetworkConfigurationGroup>();
            sources ??= new List<AddressPrefixItem>();
            destinations ??= new List<AddressPrefixItem>();
            sourcePortRanges ??= new List<string>();
            destinationPortRanges ??= new List<string>();

            return new ActiveSecurityAdminRule(
                id,
                commitOn,
                region,
                configurationDescription,
                ruleCollectionDescription,
                ruleCollectionAppliesToGroups?.ToList(),
                ruleGroups?.ToList(),
                EffectiveAdminRuleKind.Custom,
                serializedAdditionalRawData: null,
                description,
                protocol,
                sources?.ToList(),
                destinations?.ToList(),
                sourcePortRanges?.ToList(),
                destinationPortRanges?.ToList(),
                access,
                priority,
                direction,
                provisioningState,
                resourceGuid);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ActiveDefaultSecurityAdminRule"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="commitOn"> Deployment time string. </param>
        /// <param name="region"> Deployment region. </param>
        /// <param name="configurationDescription"> A description of the security admin configuration. </param>
        /// <param name="ruleCollectionDescription"> A description of the rule collection. </param>
        /// <param name="ruleCollectionAppliesToGroups"> Groups for rule collection. </param>
        /// <param name="ruleGroups"> Effective configuration groups. </param>
        /// <param name="description"> A description for this rule. Restricted to 140 chars. </param>
        /// <param name="flag"> Default rule flag. </param>
        /// <param name="protocol"> Network protocol this rule applies to. </param>
        /// <param name="sources"> The CIDR or source IP ranges. </param>
        /// <param name="destinations"> The destination address prefixes. CIDR or destination IP ranges. </param>
        /// <param name="sourcePortRanges"> The source port ranges. </param>
        /// <param name="destinationPortRanges"> The destination port ranges. </param>
        /// <param name="access"> Indicates the access allowed for this particular rule. </param>
        /// <param name="priority"> The priority of the rule. The value can be between 1 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule. </param>
        /// <param name="direction"> Indicates if the traffic matched against the rule in inbound or outbound. </param>
        /// <param name="provisioningState"> The provisioning state of the resource. </param>
        /// <param name="resourceGuid"> Unique identifier for this resource. </param>
        /// <returns> A new <see cref="Models.ActiveDefaultSecurityAdminRule"/> instance for mocking. </returns>
        public static ActiveDefaultSecurityAdminRule ActiveDefaultSecurityAdminRule(string id = null, DateTimeOffset? commitOn = null, string region = null, string configurationDescription = null, string ruleCollectionDescription = null, IEnumerable<NetworkManagerSecurityGroupItem> ruleCollectionAppliesToGroups = null, IEnumerable<NetworkConfigurationGroup> ruleGroups = null, string description = null, string flag = null, SecurityConfigurationRuleProtocol? protocol = null, IEnumerable<AddressPrefixItem> sources = null, IEnumerable<AddressPrefixItem> destinations = null, IEnumerable<string> sourcePortRanges = null, IEnumerable<string> destinationPortRanges = null, SecurityConfigurationRuleAccess? access = null, int? priority = null, SecurityConfigurationRuleDirection? direction = null, NetworkProvisioningState? provisioningState = null, Guid? resourceGuid = null)
        {
            ruleCollectionAppliesToGroups ??= new List<NetworkManagerSecurityGroupItem>();
            ruleGroups ??= new List<NetworkConfigurationGroup>();
            sources ??= new List<AddressPrefixItem>();
            destinations ??= new List<AddressPrefixItem>();
            sourcePortRanges ??= new List<string>();
            destinationPortRanges ??= new List<string>();

            return new ActiveDefaultSecurityAdminRule(
                id,
                commitOn,
                region,
                configurationDescription,
                ruleCollectionDescription,
                ruleCollectionAppliesToGroups?.ToList(),
                ruleGroups?.ToList(),
                EffectiveAdminRuleKind.Default,
                serializedAdditionalRawData: null,
                description,
                flag,
                protocol,
                sources?.ToList(),
                destinations?.ToList(),
                sourcePortRanges?.ToList(),
                destinationPortRanges?.ToList(),
                access,
                priority,
                direction,
                provisioningState,
                resourceGuid);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EffectiveSecurityAdminRule"/>. </summary>
        /// <param name="resourceId"> Resource ID. </param>
        /// <param name="configurationDescription"> A description of the security admin configuration. </param>
        /// <param name="ruleCollectionDescription"> A description of the rule collection. </param>
        /// <param name="ruleCollectionAppliesToGroups"> Groups for rule collection. </param>
        /// <param name="ruleGroups"> Effective configuration groups. </param>
        /// <param name="description"> A description for this rule. Restricted to 140 chars. </param>
        /// <param name="protocol"> Network protocol this rule applies to. </param>
        /// <param name="sources"> The CIDR or source IP ranges. </param>
        /// <param name="destinations"> The destination address prefixes. CIDR or destination IP ranges. </param>
        /// <param name="sourcePortRanges"> The source port ranges. </param>
        /// <param name="destinationPortRanges"> The destination port ranges. </param>
        /// <param name="access"> Indicates the access allowed for this particular rule. </param>
        /// <param name="priority"> The priority of the rule. The value can be between 1 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule. </param>
        /// <param name="direction"> Indicates if the traffic matched against the rule in inbound or outbound. </param>
        /// <param name="provisioningState"> The provisioning state of the resource. </param>
        /// <param name="resourceGuid"> Unique identifier for this resource. </param>
        /// <returns> A new <see cref="Models.EffectiveSecurityAdminRule"/> instance for mocking. </returns>
        public static EffectiveSecurityAdminRule EffectiveSecurityAdminRule(ResourceIdentifier resourceId = null, string configurationDescription = null, string ruleCollectionDescription = null, IEnumerable<NetworkManagerSecurityGroupItem> ruleCollectionAppliesToGroups = null, IEnumerable<NetworkConfigurationGroup> ruleGroups = null, string description = null, SecurityConfigurationRuleProtocol? protocol = null, IEnumerable<AddressPrefixItem> sources = null, IEnumerable<AddressPrefixItem> destinations = null, IEnumerable<string> sourcePortRanges = null, IEnumerable<string> destinationPortRanges = null, SecurityConfigurationRuleAccess? access = null, int? priority = null, SecurityConfigurationRuleDirection? direction = null, NetworkProvisioningState? provisioningState = null, Guid? resourceGuid = null)
        {
            ruleCollectionAppliesToGroups ??= new List<NetworkManagerSecurityGroupItem>();
            ruleGroups ??= new List<NetworkConfigurationGroup>();
            sources ??= new List<AddressPrefixItem>();
            destinations ??= new List<AddressPrefixItem>();
            sourcePortRanges ??= new List<string>();
            destinationPortRanges ??= new List<string>();

            return new EffectiveSecurityAdminRule(
                resourceId,
                configurationDescription,
                ruleCollectionDescription,
                ruleCollectionAppliesToGroups?.ToList(),
                ruleGroups?.ToList(),
                EffectiveAdminRuleKind.Custom,
                serializedAdditionalRawData: null,
                description,
                protocol,
                sources?.ToList(),
                destinations?.ToList(),
                sourcePortRanges?.ToList(),
                destinationPortRanges?.ToList(),
                access,
                priority,
                direction,
                provisioningState,
                resourceGuid);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EffectiveDefaultSecurityAdminRule"/>. </summary>
        /// <param name="resourceId"> Resource ID. </param>
        /// <param name="configurationDescription"> A description of the security admin configuration. </param>
        /// <param name="ruleCollectionDescription"> A description of the rule collection. </param>
        /// <param name="ruleCollectionAppliesToGroups"> Groups for rule collection. </param>
        /// <param name="ruleGroups"> Effective configuration groups. </param>
        /// <param name="description"> A description for this rule. Restricted to 140 chars. </param>
        /// <param name="flag"> Default rule flag. </param>
        /// <param name="protocol"> Network protocol this rule applies to. </param>
        /// <param name="sources"> The CIDR or source IP ranges. </param>
        /// <param name="destinations"> The destination address prefixes. CIDR or destination IP ranges. </param>
        /// <param name="sourcePortRanges"> The source port ranges. </param>
        /// <param name="destinationPortRanges"> The destination port ranges. </param>
        /// <param name="access"> Indicates the access allowed for this particular rule. </param>
        /// <param name="priority"> The priority of the rule. The value can be between 1 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule. </param>
        /// <param name="direction"> Indicates if the traffic matched against the rule in inbound or outbound. </param>
        /// <param name="provisioningState"> The provisioning state of the resource. </param>
        /// <param name="resourceGuid"> Unique identifier for this resource. </param>
        /// <returns> A new <see cref="Models.EffectiveDefaultSecurityAdminRule"/> instance for mocking. </returns>
        public static EffectiveDefaultSecurityAdminRule EffectiveDefaultSecurityAdminRule(ResourceIdentifier resourceId = null, string configurationDescription = null, string ruleCollectionDescription = null, IEnumerable<NetworkManagerSecurityGroupItem> ruleCollectionAppliesToGroups = null, IEnumerable<NetworkConfigurationGroup> ruleGroups = null, string description = null, string flag = null, SecurityConfigurationRuleProtocol? protocol = null, IEnumerable<AddressPrefixItem> sources = null, IEnumerable<AddressPrefixItem> destinations = null, IEnumerable<string> sourcePortRanges = null, IEnumerable<string> destinationPortRanges = null, SecurityConfigurationRuleAccess? access = null, int? priority = null, SecurityConfigurationRuleDirection? direction = null, NetworkProvisioningState? provisioningState = null, Guid? resourceGuid = null)
        {
            ruleCollectionAppliesToGroups ??= new List<NetworkManagerSecurityGroupItem>();
            ruleGroups ??= new List<NetworkConfigurationGroup>();
            sources ??= new List<AddressPrefixItem>();
            destinations ??= new List<AddressPrefixItem>();
            sourcePortRanges ??= new List<string>();
            destinationPortRanges ??= new List<string>();

            return new EffectiveDefaultSecurityAdminRule(
                resourceId,
                configurationDescription,
                ruleCollectionDescription,
                ruleCollectionAppliesToGroups?.ToList(),
                ruleGroups?.ToList(),
                EffectiveAdminRuleKind.Default,
                serializedAdditionalRawData: null,
                description,
                flag,
                protocol,
                sources?.ToList(),
                destinations?.ToList(),
                sourcePortRanges?.ToList(),
                destinationPortRanges?.ToList(),
                access,
                priority,
                direction,
                provisioningState,
                resourceGuid);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkAdminRule"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="description"> A description for this rule. Restricted to 140 chars. </param>
        /// <param name="protocol"> Network protocol this rule applies to. </param>
        /// <param name="sources"> The CIDR or source IP ranges. </param>
        /// <param name="destinations"> The destination address prefixes. CIDR or destination IP ranges. </param>
        /// <param name="sourcePortRanges"> The source port ranges. </param>
        /// <param name="destinationPortRanges"> The destination port ranges. </param>
        /// <param name="access"> Indicates the access allowed for this particular rule. </param>
        /// <param name="priority"> The priority of the rule. The value can be between 1 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule. </param>
        /// <param name="direction"> Indicates if the traffic matched against the rule in inbound or outbound. </param>
        /// <param name="provisioningState"> The provisioning state of the resource. </param>
        /// <param name="resourceGuid"> Unique identifier for this resource. </param>
        /// <returns> A new <see cref="Models.NetworkAdminRule"/> instance for mocking. </returns>
        public static NetworkAdminRule NetworkAdminRule(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ETag? etag = null, string description = null, SecurityConfigurationRuleProtocol? protocol = null, IEnumerable<AddressPrefixItem> sources = null, IEnumerable<AddressPrefixItem> destinations = null, IEnumerable<string> sourcePortRanges = null, IEnumerable<string> destinationPortRanges = null, SecurityConfigurationRuleAccess? access = null, int? priority = null, SecurityConfigurationRuleDirection? direction = null, NetworkProvisioningState? provisioningState = null, Guid? resourceGuid = null)
        {
            sources ??= new List<AddressPrefixItem>();
            destinations ??= new List<AddressPrefixItem>();
            sourcePortRanges ??= new List<string>();
            destinationPortRanges ??= new List<string>();

            return new NetworkAdminRule(
                id,
                name,
                resourceType,
                systemData,
                AdminRuleKind.Custom,
                etag,
                serializedAdditionalRawData: null,
                description,
                protocol,
                sources?.ToList(),
                destinations?.ToList(),
                sourcePortRanges?.ToList(),
                destinationPortRanges?.ToList(),
                access,
                priority,
                direction,
                provisioningState,
                resourceGuid);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkDefaultAdminRule"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="description"> A description for this rule. Restricted to 140 chars. </param>
        /// <param name="flag"> Default rule flag. </param>
        /// <param name="protocol"> Network protocol this rule applies to. </param>
        /// <param name="sources"> The CIDR or source IP ranges. </param>
        /// <param name="destinations"> The destination address prefixes. CIDR or destination IP ranges. </param>
        /// <param name="sourcePortRanges"> The source port ranges. </param>
        /// <param name="destinationPortRanges"> The destination port ranges. </param>
        /// <param name="access"> Indicates the access allowed for this particular rule. </param>
        /// <param name="priority"> The priority of the rule. The value can be between 1 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule. </param>
        /// <param name="direction"> Indicates if the traffic matched against the rule in inbound or outbound. </param>
        /// <param name="provisioningState"> The provisioning state of the resource. </param>
        /// <param name="resourceGuid"> Unique identifier for this resource. </param>
        /// <returns> A new <see cref="Models.NetworkDefaultAdminRule"/> instance for mocking. </returns>
        public static NetworkDefaultAdminRule NetworkDefaultAdminRule(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ETag? etag = null, string description = null, string flag = null, SecurityConfigurationRuleProtocol? protocol = null, IEnumerable<AddressPrefixItem> sources = null, IEnumerable<AddressPrefixItem> destinations = null, IEnumerable<string> sourcePortRanges = null, IEnumerable<string> destinationPortRanges = null, SecurityConfigurationRuleAccess? access = null, int? priority = null, SecurityConfigurationRuleDirection? direction = null, NetworkProvisioningState? provisioningState = null, Guid? resourceGuid = null)
        {
            sources ??= new List<AddressPrefixItem>();
            destinations ??= new List<AddressPrefixItem>();
            sourcePortRanges ??= new List<string>();
            destinationPortRanges ??= new List<string>();

            return new NetworkDefaultAdminRule(
                id,
                name,
                resourceType,
                systemData,
                AdminRuleKind.Default,
                etag,
                serializedAdditionalRawData: null,
                description,
                flag,
                protocol,
                sources?.ToList(),
                destinations?.ToList(),
                sourcePortRanges?.ToList(),
                destinationPortRanges?.ToList(),
                access,
                priority,
                direction,
                provisioningState,
                resourceGuid);
        }

        /// <summary> Initializes a new instance of <see cref="T:Azure.ResourceManager.Network.PrivateLinkServiceData" />. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="extendedLocation"> The extended location of the load balancer. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="loadBalancerFrontendIPConfigurations"> An array of references to the load balancer IP configurations. </param>
        /// <param name="ipConfigurations"> An array of private link service IP configurations. </param>
        /// <param name="networkInterfaces"> An array of references to the network interfaces created for this private link service. </param>
        /// <param name="provisioningState"> The provisioning state of the private link service resource. </param>
        /// <param name="privateEndpointConnections"> An array of list about connections to the private endpoint. </param>
        /// <param name="visibilitySubscriptions"> The visibility list of the private link service. </param>
        /// <param name="autoApprovalSubscriptions"> The auto-approval list of the private link service. </param>
        /// <param name="fqdns"> The list of Fqdn. </param>
        /// <param name="alias"> The alias of the private link service. </param>
        /// <param name="enableProxyProtocol"> Whether the private link service is enabled for proxy protocol or not. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.Network.PrivateLinkServiceData" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static PrivateLinkServiceData PrivateLinkServiceData(ResourceIdentifier id, string name, ResourceType? resourceType, AzureLocation? location, IDictionary<string, string> tags, ExtendedLocation extendedLocation, ETag? etag, IEnumerable<FrontendIPConfigurationData> loadBalancerFrontendIPConfigurations, IEnumerable<PrivateLinkServiceIPConfiguration> ipConfigurations, IEnumerable<NetworkInterfaceData> networkInterfaces, NetworkProvisioningState? provisioningState, IEnumerable<NetworkPrivateEndpointConnectionData> privateEndpointConnections, IEnumerable<string> visibilitySubscriptions, IEnumerable<string> autoApprovalSubscriptions, IEnumerable<string> fqdns, string @alias, bool? enableProxyProtocol)
        {
            return PrivateLinkServiceData(id: id, name: name, resourceType: resourceType, location: location, tags: tags, extendedLocation: extendedLocation, etag: etag, loadBalancerFrontendIPConfigurations: loadBalancerFrontendIPConfigurations, ipConfigurations: ipConfigurations, destinationIPAddress: default, networkInterfaces: networkInterfaces, provisioningState: provisioningState, privateEndpointConnections: privateEndpointConnections, visibilitySubscriptions: visibilitySubscriptions, autoApprovalSubscriptions: autoApprovalSubscriptions, fqdns: fqdns, alias: @alias, enableProxyProtocol: enableProxyProtocol);
        }

        /// <summary> Initializes a new instance of <see cref="T:Azure.ResourceManager.Network.FlowLogData" />. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="targetResourceId"> ID of network security group to which flow log will be applied. </param>
        /// <param name="targetResourceGuid"> Guid of network security group to which flow log will be applied. </param>
        /// <param name="storageId"> ID of the storage account which is used to store the flow log. </param>
        /// <param name="enabled"> Flag to enable/disable flow logging. </param>
        /// <param name="retentionPolicy"> Parameters that define the retention policy for flow log. </param>
        /// <param name="format"> Parameters that define the flow log format. </param>
        /// <param name="trafficAnalyticsConfiguration"> Parameters that define the configuration of traffic analytics. </param>
        /// <param name="provisioningState"> The provisioning state of the flow log. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.Network.FlowLogData" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static FlowLogData FlowLogData(ResourceIdentifier id, string name, ResourceType? resourceType, AzureLocation? location, IDictionary<string, string> tags, ETag? etag, ResourceIdentifier targetResourceId, Guid? targetResourceGuid, ResourceIdentifier storageId, bool? enabled, RetentionPolicyParameters retentionPolicy, FlowLogProperties format, TrafficAnalyticsConfigurationProperties trafficAnalyticsConfiguration, NetworkProvisioningState? provisioningState)
        {
            return FlowLogData(id: id, name: name, resourceType: resourceType, location: location, tags: tags, etag: etag, identity: default, targetResourceId: targetResourceId, targetResourceGuid: targetResourceGuid, storageId: storageId, enabledFilteringCriteria: default, enabled: enabled, retentionPolicy: retentionPolicy, format: format, trafficAnalyticsConfiguration: trafficAnalyticsConfiguration, provisioningState: provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="T:Azure.ResourceManager.Network.Models.ServiceEndpointProperties" />. </summary>
        /// <param name="service"> The type of the endpoint service. </param>
        /// <param name="locations"> A list of locations. </param>
        /// <param name="provisioningState"> The provisioning state of the service endpoint resource. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.Network.Models.ServiceEndpointProperties" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static ServiceEndpointProperties ServiceEndpointProperties(string service, IEnumerable<AzureLocation> locations, NetworkProvisioningState? provisioningState)
        {
            return ServiceEndpointProperties(service: service, networkIdentifierId: default, locations: locations, provisioningState: provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="T:Azure.ResourceManager.Network.AzureFirewallData" />. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="zones"> A list of availability zones denoting where the resource needs to come from. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="applicationRuleCollections"> Collection of application rule collections used by Azure Firewall. </param>
        /// <param name="natRuleCollections"> Collection of NAT rule collections used by Azure Firewall. </param>
        /// <param name="networkRuleCollections"> Collection of network rule collections used by Azure Firewall. </param>
        /// <param name="ipConfigurations"> IP configuration of the Azure Firewall resource. </param>
        /// <param name="managementIPConfiguration"> IP configuration of the Azure Firewall used for management traffic. </param>
        /// <param name="provisioningState"> The provisioning state of the Azure firewall resource. </param>
        /// <param name="threatIntelMode"> The operation mode for Threat Intelligence. </param>
        /// <param name="virtualHubId"> The virtualHub to which the firewall belongs. </param>
        /// <param name="firewallPolicyId"> The firewallPolicy associated with this azure firewall. </param>
        /// <param name="hubIPAddresses"> IP addresses associated with AzureFirewall. </param>
        /// <param name="ipGroups"> IpGroups associated with AzureFirewall. </param>
        /// <param name="sku"> The Azure Firewall Resource SKU. </param>
        /// <param name="additionalProperties"> The additional properties used to further config this azure firewall. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.Network.AzureFirewallData" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static AzureFirewallData AzureFirewallData(ResourceIdentifier id, string name, ResourceType? resourceType, AzureLocation? location, IDictionary<string, string> tags, IEnumerable<string> zones, ETag? etag, IEnumerable<AzureFirewallApplicationRuleCollectionData> applicationRuleCollections, IEnumerable<AzureFirewallNatRuleCollectionData> natRuleCollections, IEnumerable<AzureFirewallNetworkRuleCollectionData> networkRuleCollections, IEnumerable<AzureFirewallIPConfiguration> ipConfigurations, AzureFirewallIPConfiguration managementIPConfiguration, NetworkProvisioningState? provisioningState, AzureFirewallThreatIntelMode? threatIntelMode, ResourceIdentifier virtualHubId, ResourceIdentifier firewallPolicyId, HubIPAddresses hubIPAddresses, IEnumerable<AzureFirewallIPGroups> ipGroups, AzureFirewallSku sku, IDictionary<string, string> additionalProperties)
        {
            return AzureFirewallData(id: id, name: name, resourceType: resourceType, location: location, tags: tags, zones: zones, etag: etag, applicationRuleCollections: applicationRuleCollections, natRuleCollections: natRuleCollections, networkRuleCollections: networkRuleCollections, ipConfigurations: ipConfigurations, managementIPConfiguration: managementIPConfiguration, provisioningState: provisioningState, threatIntelMode: threatIntelMode, virtualHubId: virtualHubId, firewallPolicyId: firewallPolicyId, hubIPAddresses: hubIPAddresses, ipGroups: ipGroups, sku: sku, additionalProperties: additionalProperties, autoscaleConfiguration: default);
        }

        /// <summary> Initializes a new instance of <see cref="T:Azure.ResourceManager.Network.BastionHostData" />. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="zones"> A list of availability zones denoting where the resource needs to come from. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="skuName"> The sku of this Bastion Host. </param>
        /// <param name="ipConfigurations"> IP configuration of the Bastion Host resource. </param>
        /// <param name="dnsName"> FQDN for the endpoint on which bastion host is accessible. </param>
        /// <param name="virtualNetworkId"> Reference to an existing virtual network required for Developer Bastion Host only. </param>
        /// <param name="networkAclsIPRules"></param>
        /// <param name="provisioningState"> The provisioning state of the bastion host resource. </param>
        /// <param name="scaleUnits"> The scale units for the Bastion Host resource. </param>
        /// <param name="disableCopyPaste"> Enable/Disable Copy/Paste feature of the Bastion Host resource. </param>
        /// <param name="enableFileCopy"> Enable/Disable File Copy feature of the Bastion Host resource. </param>
        /// <param name="enableIPConnect"> Enable/Disable IP Connect feature of the Bastion Host resource. </param>
        /// <param name="enableShareableLink"> Enable/Disable Shareable Link of the Bastion Host resource. </param>
        /// <param name="enableTunneling"> Enable/Disable Tunneling feature of the Bastion Host resource. </param>
        /// <param name="enableKerberos"> Enable/Disable Kerberos feature of the Bastion Host resource. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.Network.BastionHostData" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static BastionHostData BastionHostData(ResourceIdentifier id, string name, ResourceType? resourceType, AzureLocation? location, IDictionary<string, string> tags, IEnumerable<string> zones, ETag? etag, BastionHostSkuName? skuName, IEnumerable<BastionHostIPConfiguration> ipConfigurations, string dnsName, ResourceIdentifier virtualNetworkId, IEnumerable<BastionHostIPRule> networkAclsIPRules, NetworkProvisioningState? provisioningState, int? scaleUnits, bool? disableCopyPaste, bool? enableFileCopy, bool? enableIPConnect, bool? enableShareableLink, bool? enableTunneling, bool? enableKerberos)
        {
            return BastionHostData(id: id, name: name, resourceType: resourceType, location: location, tags: tags, zones: zones, etag: etag, skuName: skuName, ipConfigurations: ipConfigurations, dnsName: dnsName, virtualNetworkId: virtualNetworkId, networkAclsIPRules: networkAclsIPRules, provisioningState: provisioningState, scaleUnits: scaleUnits, disableCopyPaste: disableCopyPaste, enableFileCopy: enableFileCopy, enableIPConnect: enableIPConnect, enableShareableLink: enableShareableLink, enableTunneling: enableTunneling, enableKerberos: enableKerberos, enableSessionRecording: default);
        }

        /// <summary> Initializes a new instance of <see cref="T:Azure.ResourceManager.Network.ExpressRouteCircuitAuthorizationData" />. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="authorizationKey"> The authorization key. </param>
        /// <param name="authorizationUseStatus"> The authorization use status. </param>
        /// <param name="provisioningState"> The provisioning state of the authorization resource. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.Network.ExpressRouteCircuitAuthorizationData" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static ExpressRouteCircuitAuthorizationData ExpressRouteCircuitAuthorizationData(ResourceIdentifier id, string name, ResourceType? resourceType, ETag? etag, string authorizationKey, AuthorizationUseStatus? authorizationUseStatus, NetworkProvisioningState? provisioningState)
        {
            return ExpressRouteCircuitAuthorizationData(id: id, name: name, resourceType: resourceType, etag: etag, authorizationKey: authorizationKey, authorizationUseStatus: authorizationUseStatus, connectionResourceUri: default, provisioningState: provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="T:Azure.ResourceManager.Network.ProbeData" />. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="loadBalancingRules"> The load balancer rules that use this probe. </param>
        /// <param name="protocol"> The protocol of the end point. If 'Tcp' is specified, a received ACK is required for the probe to be successful. If 'Http' or 'Https' is specified, a 200 OK response from the specifies URI is required for the probe to be successful. </param>
        /// <param name="port"> The port for communicating the probe. Possible values range from 1 to 65535, inclusive. </param>
        /// <param name="intervalInSeconds"> The interval, in seconds, for how frequently to probe the endpoint for health status. Typically, the interval is slightly less than half the allocated timeout period (in seconds) which allows two full probes before taking the instance out of rotation. The default value is 15, the minimum value is 5. </param>
        /// <param name="numberOfProbes"> The number of probes where if no response, will result in stopping further traffic from being delivered to the endpoint. This values allows endpoints to be taken out of rotation faster or slower than the typical times used in Azure. </param>
        /// <param name="probeThreshold"> The number of consecutive successful or failed probes in order to allow or deny traffic from being delivered to this endpoint. After failing the number of consecutive probes equal to this value, the endpoint will be taken out of rotation and require the same number of successful consecutive probes to be placed back in rotation. </param>
        /// <param name="requestPath"> The URI used for requesting health status from the VM. Path is required if a protocol is set to http. Otherwise, it is not allowed. There is no default value. </param>
        /// <param name="provisioningState"> The provisioning state of the probe resource. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.Network.ProbeData" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static ProbeData ProbeData(ResourceIdentifier id, string name, ResourceType? resourceType, ETag? etag, IEnumerable<WritableSubResource> loadBalancingRules, ProbeProtocol? protocol, int? port, int? intervalInSeconds, int? numberOfProbes, int? probeThreshold, string requestPath, NetworkProvisioningState? provisioningState)
        {
            return ProbeData(id: id, name: name, resourceType: resourceType, etag: etag, loadBalancingRules: loadBalancingRules, protocol: protocol, port: port, intervalInSeconds: intervalInSeconds, noHealthyBackendsBehavior: default, numberOfProbes: numberOfProbes, probeThreshold: probeThreshold, requestPath: requestPath, provisioningState: provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="T:Azure.ResourceManager.Network.Models.NetworkConfigurationGroup" />. </summary>
        /// <param name="id"> Network group ID. </param>
        /// <param name="description"> A description of the network group. </param>
        /// <param name="provisioningState"> The provisioning state of the scope assignment resource. </param>
        /// <param name="resourceGuid"> Unique identifier for this resource. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.Network.Models.NetworkConfigurationGroup" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static NetworkConfigurationGroup NetworkConfigurationGroup(string id, string description, NetworkProvisioningState? provisioningState, Guid? resourceGuid)
        {
            return NetworkConfigurationGroup(id: id, description: description, memberType: default, provisioningState: provisioningState, resourceGuid: resourceGuid);
        }

        /// <summary> Initializes a new instance of <see cref="T:Azure.ResourceManager.Network.NetworkGroupData" />. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> A description of the network group. </param>
        /// <param name="provisioningState"> The provisioning state of the scope assignment resource. </param>
        /// <param name="resourceGuid"> Unique identifier for this resource. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.Network.NetworkGroupData" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static NetworkGroupData NetworkGroupData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string description, NetworkProvisioningState? provisioningState, Guid? resourceGuid, ETag? etag)
        {
            return NetworkGroupData(id: id, name: name, resourceType: resourceType, systemData: systemData, description: description, memberType: default, provisioningState: provisioningState, resourceGuid: resourceGuid, etag: etag);
        }

        /// <summary> Initializes a new instance of <see cref="T:Azure.ResourceManager.Network.VirtualNetworkData" />. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="extendedLocation"> The extended location of the virtual network. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="addressPrefixes"> The AddressSpace that contains an array of IP address ranges that can be used by subnets. </param>
        /// <param name="dhcpOptionsDnsServers"> The dhcpOptions that contains an array of DNS servers available to VMs deployed in the virtual network. </param>
        /// <param name="flowTimeoutInMinutes"> The FlowTimeout value (in minutes) for the Virtual Network. </param>
        /// <param name="subnets"> A list of subnets in a Virtual Network. </param>
        /// <param name="virtualNetworkPeerings"> A list of peerings in a Virtual Network. </param>
        /// <param name="resourceGuid"> The resourceGuid property of the Virtual Network resource. </param>
        /// <param name="provisioningState"> The provisioning state of the virtual network resource. </param>
        /// <param name="enableDdosProtection"> Indicates if DDoS protection is enabled for all the protected resources in the virtual network. It requires a DDoS protection plan associated with the resource. </param>
        /// <param name="enableVmProtection"> Indicates if VM protection is enabled for all the subnets in the virtual network. </param>
        /// <param name="ddosProtectionPlanId"> The DDoS protection plan associated with the virtual network. </param>
        /// <param name="bgpCommunities"> Bgp Communities sent over ExpressRoute with each route corresponding to a prefix in this VNET. </param>
        /// <param name="encryption"> Indicates if encryption is enabled on virtual network and if VM without encryption is allowed in encrypted VNet. </param>
        /// <param name="ipAllocations"> Array of IpAllocation which reference this VNET. </param>
        /// <param name="flowLogs"> A collection of references to flow log resources. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.Network.VirtualNetworkData" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static VirtualNetworkData VirtualNetworkData(ResourceIdentifier id, string name, ResourceType? resourceType, AzureLocation? location, IDictionary<string, string> tags, ExtendedLocation extendedLocation, ETag? etag, IEnumerable<string> addressPrefixes, IEnumerable<string> dhcpOptionsDnsServers, int? flowTimeoutInMinutes, IEnumerable<SubnetData> subnets, IEnumerable<VirtualNetworkPeeringData> virtualNetworkPeerings, Guid? resourceGuid, NetworkProvisioningState? provisioningState, bool? enableDdosProtection, bool? enableVmProtection, ResourceIdentifier ddosProtectionPlanId, VirtualNetworkBgpCommunities bgpCommunities, VirtualNetworkEncryption encryption, IEnumerable<WritableSubResource> ipAllocations, IEnumerable<FlowLogData> flowLogs)
        {
            return VirtualNetworkData(id: id, name: name, resourceType: resourceType, location: location, tags: tags, extendedLocation: extendedLocation, etag: etag, addressPrefixes: addressPrefixes, dhcpOptionsDnsServers: dhcpOptionsDnsServers, flowTimeoutInMinutes: flowTimeoutInMinutes, subnets: subnets, virtualNetworkPeerings: virtualNetworkPeerings, resourceGuid: resourceGuid, provisioningState: provisioningState, enableDdosProtection: enableDdosProtection, enableVmProtection: enableVmProtection, ddosProtectionPlanId: ddosProtectionPlanId, bgpCommunities: bgpCommunities, encryption: encryption, ipAllocations: ipAllocations, flowLogs: flowLogs, privateEndpointVnetPolicy: default);
        }

        /// <summary> Initializes a new instance of <see cref="T:Azure.ResourceManager.Network.VirtualNetworkGatewayData" />. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="extendedLocation"> The extended location of type local virtual network gateway. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="autoScaleBounds"> Autoscale configuration for virutal network gateway. </param>
        /// <param name="ipConfigurations"> IP configurations for virtual network gateway. </param>
        /// <param name="gatewayType"> The type of this virtual network gateway. </param>
        /// <param name="vpnType"> The type of this virtual network gateway. </param>
        /// <param name="vpnGatewayGeneration"> The generation for this VirtualNetworkGateway. Must be None if gatewayType is not VPN. </param>
        /// <param name="enableBgp"> Whether BGP is enabled for this virtual network gateway or not. </param>
        /// <param name="enablePrivateIPAddress"> Whether private IP needs to be enabled on this gateway for connections or not. </param>
        /// <param name="active"> ActiveActive flag. </param>
        /// <param name="disableIPSecReplayProtection"> disableIPSecReplayProtection flag. </param>
        /// <param name="gatewayDefaultSiteId"> The reference to the LocalNetworkGateway resource which represents local network site having default routes. Assign Null value in case of removing existing default site setting. </param>
        /// <param name="sku"> The reference to the VirtualNetworkGatewaySku resource which represents the SKU selected for Virtual network gateway. </param>
        /// <param name="vpnClientConfiguration"> The reference to the VpnClientConfiguration resource which represents the P2S VpnClient configurations. </param>
        /// <param name="virtualNetworkGatewayPolicyGroups"> The reference to the VirtualNetworkGatewayPolicyGroup resource which represents the available VirtualNetworkGatewayPolicyGroup for the gateway. </param>
        /// <param name="bgpSettings"> Virtual network gateway's BGP speaker settings. </param>
        /// <param name="customRoutesAddressPrefixes"> The reference to the address space resource which represents the custom routes address space specified by the customer for virtual network gateway and VpnClient. </param>
        /// <param name="resourceGuid"> The resource GUID property of the virtual network gateway resource. </param>
        /// <param name="provisioningState"> The provisioning state of the virtual network gateway resource. </param>
        /// <param name="enableDnsForwarding"> Whether dns forwarding is enabled or not. </param>
        /// <param name="inboundDnsForwardingEndpoint"> The IP address allocated by the gateway to which dns requests can be sent. </param>
        /// <param name="vNetExtendedLocationResourceId"> Customer vnet resource id. VirtualNetworkGateway of type local gateway is associated with the customer vnet. </param>
        /// <param name="natRules"> NatRules for virtual network gateway. </param>
        /// <param name="enableBgpRouteTranslationForNat"> EnableBgpRouteTranslationForNat flag. </param>
        /// <param name="allowVirtualWanTraffic"> Configures this gateway to accept traffic from remote Virtual WAN networks. </param>
        /// <param name="allowRemoteVnetTraffic"> Configure this gateway to accept traffic from other Azure Virtual Networks. This configuration does not support connectivity to Azure Virtual WAN. </param>
        /// <param name="adminState"> Property to indicate if the Express Route Gateway serves traffic when there are multiple Express Route Gateways in the vnet. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.Network.VirtualNetworkGatewayData" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static VirtualNetworkGatewayData VirtualNetworkGatewayData(ResourceIdentifier id, string name, ResourceType? resourceType, AzureLocation? location, IDictionary<string, string> tags, ExtendedLocation extendedLocation, ETag? etag, VirtualNetworkGatewayAutoScaleBounds autoScaleBounds, IEnumerable<VirtualNetworkGatewayIPConfiguration> ipConfigurations, VirtualNetworkGatewayType? gatewayType, VpnType? vpnType, VpnGatewayGeneration? vpnGatewayGeneration, bool? enableBgp, bool? enablePrivateIPAddress, bool? active, bool? disableIPSecReplayProtection, ResourceIdentifier gatewayDefaultSiteId, VirtualNetworkGatewaySku sku, VpnClientConfiguration vpnClientConfiguration, IEnumerable<VirtualNetworkGatewayPolicyGroup> virtualNetworkGatewayPolicyGroups, BgpSettings bgpSettings, IEnumerable<string> customRoutesAddressPrefixes, Guid? resourceGuid, NetworkProvisioningState? provisioningState, bool? enableDnsForwarding, string inboundDnsForwardingEndpoint, ResourceIdentifier vNetExtendedLocationResourceId, IEnumerable<VirtualNetworkGatewayNatRuleData> natRules, bool? enableBgpRouteTranslationForNat, bool? allowVirtualWanTraffic, bool? allowRemoteVnetTraffic, ExpressRouteGatewayAdminState? adminState)
        {
            return VirtualNetworkGatewayData(id: id, name: name, resourceType: resourceType, location: location, tags: tags, extendedLocation: extendedLocation, etag: etag, identity: default, autoScaleBounds: autoScaleBounds, ipConfigurations: ipConfigurations, gatewayType: gatewayType, vpnType: vpnType, vpnGatewayGeneration: vpnGatewayGeneration, enableBgp: enableBgp, enablePrivateIPAddress: enablePrivateIPAddress, active: active, disableIPSecReplayProtection: disableIPSecReplayProtection, gatewayDefaultSiteId: gatewayDefaultSiteId, sku: sku, vpnClientConfiguration: vpnClientConfiguration, virtualNetworkGatewayPolicyGroups: virtualNetworkGatewayPolicyGroups, bgpSettings: bgpSettings, customRoutesAddressPrefixes: customRoutesAddressPrefixes, resourceGuid: resourceGuid, provisioningState: provisioningState, enableDnsForwarding: enableDnsForwarding, inboundDnsForwardingEndpoint: inboundDnsForwardingEndpoint, vNetExtendedLocationResourceId: vNetExtendedLocationResourceId, natRules: natRules, enableBgpRouteTranslationForNat: enableBgpRouteTranslationForNat, allowVirtualWanTraffic: allowVirtualWanTraffic, allowRemoteVnetTraffic: allowRemoteVnetTraffic, adminState: adminState, resiliencyModel: default);
        }

        /// <summary> Initializes a new instance of <see cref="T:Azure.ResourceManager.Network.WebApplicationFirewallPolicyData" />. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="policySettings"> The PolicySettings for policy. </param>
        /// <param name="customRules"> The custom rules inside the policy. </param>
        /// <param name="applicationGateways"> A collection of references to application gateways. </param>
        /// <param name="provisioningState"> The provisioning state of the web application firewall policy resource. </param>
        /// <param name="resourceState"> Resource status of the policy. </param>
        /// <param name="managedRules"> Describes the managedRules structure. </param>
        /// <param name="httpListeners"> A collection of references to application gateway http listeners. </param>
        /// <param name="pathBasedRules"> A collection of references to application gateway path rules. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.Network.WebApplicationFirewallPolicyData" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static WebApplicationFirewallPolicyData WebApplicationFirewallPolicyData(ResourceIdentifier id, string name, ResourceType? resourceType, AzureLocation? location, IDictionary<string, string> tags, ETag? etag, PolicySettings policySettings, IEnumerable<WebApplicationFirewallCustomRule> customRules, IEnumerable<ApplicationGatewayData> applicationGateways, NetworkProvisioningState? provisioningState, WebApplicationFirewallPolicyResourceState? resourceState, ManagedRulesDefinition managedRules, IEnumerable<WritableSubResource> httpListeners, IEnumerable<WritableSubResource> pathBasedRules)
        {
            return WebApplicationFirewallPolicyData(id: id, name: name, resourceType: resourceType, location: location, tags: tags, etag: etag, policySettings: policySettings, customRules: customRules, applicationGateways: applicationGateways, provisioningState: provisioningState, resourceState: resourceState, managedRules: managedRules, httpListeners: httpListeners, pathBasedRules: pathBasedRules, applicationGatewayForContainers: default);
        }

        /// <summary> Initializes a new instance of <see cref="T:Azure.ResourceManager.Network.NetworkInterfaceIPConfigurationData" />. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="gatewayLoadBalancerId"> The reference to gateway load balancer frontend IP. </param>
        /// <param name="virtualNetworkTaps"> The reference to Virtual Network Taps. </param>
        /// <param name="applicationGatewayBackendAddressPools"> The reference to ApplicationGatewayBackendAddressPool resource. </param>
        /// <param name="loadBalancerBackendAddressPools"> The reference to LoadBalancerBackendAddressPool resource. </param>
        /// <param name="loadBalancerInboundNatRules"> A list of references of LoadBalancerInboundNatRules. </param>
        /// <param name="privateIPAddress"> Private IP address of the IP configuration. </param>
        /// <param name="privateIPAllocationMethod"> The private IP address allocation method. </param>
        /// <param name="privateIPAddressVersion"> Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4. </param>
        /// <param name="subnet"> Subnet bound to the IP configuration. </param>
        /// <param name="primary"> Whether this is a primary customer address on the network interface. </param>
        /// <param name="publicIPAddress"> Public IP address bound to the IP configuration. </param>
        /// <param name="applicationSecurityGroups"> Application security groups in which the IP configuration is included. </param>
        /// <param name="provisioningState"> The provisioning state of the network interface IP configuration. </param>
        /// <param name="privateLinkConnectionProperties"> PrivateLinkConnection properties for the network interface. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.Network.NetworkInterfaceIPConfigurationData" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static NetworkInterfaceIPConfigurationData NetworkInterfaceIPConfigurationData(ResourceIdentifier id, string name, ResourceType? resourceType, ETag? etag, ResourceIdentifier gatewayLoadBalancerId, IEnumerable<VirtualNetworkTapData> virtualNetworkTaps, IEnumerable<ApplicationGatewayBackendAddressPool> applicationGatewayBackendAddressPools, IEnumerable<BackendAddressPoolData> loadBalancerBackendAddressPools, IEnumerable<InboundNatRuleData> loadBalancerInboundNatRules, string privateIPAddress, NetworkIPAllocationMethod? privateIPAllocationMethod, NetworkIPVersion? privateIPAddressVersion, SubnetData subnet, bool? primary, PublicIPAddressData publicIPAddress, IEnumerable<ApplicationSecurityGroupData> applicationSecurityGroups, NetworkProvisioningState? provisioningState, NetworkInterfaceIPConfigurationPrivateLinkConnectionProperties privateLinkConnectionProperties)
        {
            return NetworkInterfaceIPConfigurationData(id: id, name: name, resourceType: resourceType, etag: etag, gatewayLoadBalancerId: gatewayLoadBalancerId, virtualNetworkTaps: virtualNetworkTaps, applicationGatewayBackendAddressPools: applicationGatewayBackendAddressPools, loadBalancerBackendAddressPools: loadBalancerBackendAddressPools, loadBalancerInboundNatRules: loadBalancerInboundNatRules, privateIPAddress: privateIPAddress, privateIPAddressPrefixLength: default, privateIPAllocationMethod: privateIPAllocationMethod, privateIPAddressVersion: privateIPAddressVersion, subnet: subnet, primary: primary, publicIPAddress: publicIPAddress, applicationSecurityGroups: applicationSecurityGroups, provisioningState: provisioningState, privateLinkConnectionProperties: privateLinkConnectionProperties);
        }

        /// <summary> Initializes a new instance of <see cref="T:Azure.ResourceManager.Network.SubnetData" />. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="addressPrefix"> The address prefix for the subnet. </param>
        /// <param name="addressPrefixes"> List of address prefixes for the subnet. </param>
        /// <param name="networkSecurityGroup"> The reference to the NetworkSecurityGroup resource. </param>
        /// <param name="routeTable"> The reference to the RouteTable resource. </param>
        /// <param name="natGatewayId"> Nat gateway associated with this subnet. </param>
        /// <param name="serviceEndpoints"> An array of service endpoints. </param>
        /// <param name="serviceEndpointPolicies"> An array of service endpoint policies. </param>
        /// <param name="privateEndpoints"> An array of references to private endpoints. </param>
        /// <param name="ipConfigurations"> An array of references to the network interface IP configurations using subnet. </param>
        /// <param name="ipConfigurationProfiles"> Array of IP configuration profiles which reference this subnet. </param>
        /// <param name="ipAllocations"> Array of IpAllocation which reference this subnet. </param>
        /// <param name="resourceNavigationLinks"> An array of references to the external resources using subnet. </param>
        /// <param name="serviceAssociationLinks"> An array of references to services injecting into this subnet. </param>
        /// <param name="delegations"> An array of references to the delegations on the subnet. </param>
        /// <param name="purpose"> A read-only string identifying the intention of use for this subnet based on delegations and other user-defined properties. </param>
        /// <param name="provisioningState"> The provisioning state of the subnet resource. </param>
        /// <param name="privateEndpointNetworkPolicy"> Enable or Disable apply network policies on private end point in the subnet. </param>
        /// <param name="privateLinkServiceNetworkPolicy"> Enable or Disable apply network policies on private link service in the subnet. </param>
        /// <param name="applicationGatewayIPConfigurations"> Application gateway IP configurations of virtual network resource. </param>
        /// <param name="defaultOutboundAccess"> Set this property to false to disable default outbound connectivity for all VMs in the subnet. This property can only be set at the time of subnet creation and cannot be updated for an existing subnet. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.Network.SubnetData" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static SubnetData SubnetData(ResourceIdentifier id, string name, ResourceType? resourceType, ETag? etag, string addressPrefix, IEnumerable<string> addressPrefixes, NetworkSecurityGroupData networkSecurityGroup, RouteTableData routeTable, ResourceIdentifier natGatewayId, IEnumerable<ServiceEndpointProperties> serviceEndpoints, IEnumerable<ServiceEndpointPolicyData> serviceEndpointPolicies, IEnumerable<PrivateEndpointData> privateEndpoints, IEnumerable<NetworkIPConfiguration> ipConfigurations, IEnumerable<NetworkIPConfigurationProfile> ipConfigurationProfiles, IEnumerable<WritableSubResource> ipAllocations, IEnumerable<ResourceNavigationLink> resourceNavigationLinks, IEnumerable<ServiceAssociationLink> serviceAssociationLinks, IEnumerable<ServiceDelegation> delegations, string purpose, NetworkProvisioningState? provisioningState, VirtualNetworkPrivateEndpointNetworkPolicy? privateEndpointNetworkPolicy, VirtualNetworkPrivateLinkServiceNetworkPolicy? privateLinkServiceNetworkPolicy, IEnumerable<ApplicationGatewayIPConfiguration> applicationGatewayIPConfigurations, bool? defaultOutboundAccess)
        {
            return SubnetData(id: id, name: name, resourceType: resourceType, etag: etag, addressPrefix: addressPrefix, addressPrefixes: addressPrefixes, networkSecurityGroup: networkSecurityGroup, routeTable: routeTable, natGatewayId: natGatewayId, serviceEndpoints: serviceEndpoints, serviceEndpointPolicies: serviceEndpointPolicies, privateEndpoints: privateEndpoints, ipConfigurations: ipConfigurations, ipConfigurationProfiles: ipConfigurationProfiles, ipAllocations: ipAllocations, resourceNavigationLinks: resourceNavigationLinks, serviceAssociationLinks: serviceAssociationLinks, delegations: delegations, purpose: purpose, provisioningState: provisioningState, privateEndpointNetworkPolicy: privateEndpointNetworkPolicy, privateLinkServiceNetworkPolicy: privateLinkServiceNetworkPolicy, applicationGatewayIPConfigurations: applicationGatewayIPConfigurations, sharingScope: default, defaultOutboundAccess: defaultOutboundAccess);
        }

        /// <summary> Initializes a new instance of <see cref="T:Azure.ResourceManager.Network.ExpressRouteCircuitData" />. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="sku"> The SKU. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="allowClassicOperations"> Allow classic operations. </param>
        /// <param name="circuitProvisioningState"> The CircuitProvisioningState state of the resource. </param>
        /// <param name="serviceProviderProvisioningState"> The ServiceProviderProvisioningState state of the resource. </param>
        /// <param name="authorizations"> The list of authorizations. </param>
        /// <param name="peerings"> The list of peerings. </param>
        /// <param name="serviceKey"> The ServiceKey. </param>
        /// <param name="serviceProviderNotes"> The ServiceProviderNotes. </param>
        /// <param name="serviceProviderProperties"> The ServiceProviderProperties. </param>
        /// <param name="expressRoutePortId"> The reference to the ExpressRoutePort resource when the circuit is provisioned on an ExpressRoutePort resource. </param>
        /// <param name="bandwidthInGbps"> The bandwidth of the circuit when the circuit is provisioned on an ExpressRoutePort resource. </param>
        /// <param name="stag"> The identifier of the circuit traffic. Outer tag for QinQ encapsulation. </param>
        /// <param name="provisioningState"> The provisioning state of the express route circuit resource. </param>
        /// <param name="gatewayManagerETag"> The GatewayManager Etag. </param>
        /// <param name="globalReachEnabled"> Flag denoting global reach status. </param>
        /// <param name="authorizationKey"> The authorizationKey. </param>
        /// <param name="authorizationStatus"> The authorization status of the Circuit. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.Network.ExpressRouteCircuitData" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static ExpressRouteCircuitData ExpressRouteCircuitData(ResourceIdentifier id, string name, ResourceType? resourceType, AzureLocation? location, IDictionary<string, string> tags, ExpressRouteCircuitSku sku, ETag? etag, bool? allowClassicOperations, string circuitProvisioningState, ServiceProviderProvisioningState? serviceProviderProvisioningState, IEnumerable<ExpressRouteCircuitAuthorizationData> authorizations, IEnumerable<ExpressRouteCircuitPeeringData> peerings, string serviceKey, string serviceProviderNotes, ExpressRouteCircuitServiceProviderProperties serviceProviderProperties, ResourceIdentifier expressRoutePortId, float? bandwidthInGbps, int? stag, NetworkProvisioningState? provisioningState, string gatewayManagerETag, bool? globalReachEnabled, string authorizationKey, string authorizationStatus)
        {
            return ExpressRouteCircuitData(id: id, name: name, resourceType: resourceType, location: location, tags: tags, sku: sku, etag: etag, allowClassicOperations: allowClassicOperations, circuitProvisioningState: circuitProvisioningState, serviceProviderProvisioningState: serviceProviderProvisioningState, authorizations: authorizations, peerings: peerings, serviceKey: serviceKey, serviceProviderNotes: serviceProviderNotes, serviceProviderProperties: serviceProviderProperties, expressRoutePortId: expressRoutePortId, bandwidthInGbps: bandwidthInGbps, stag: stag, provisioningState: provisioningState, gatewayManagerETag: gatewayManagerETag, globalReachEnabled: globalReachEnabled, authorizationKey: authorizationKey, authorizationStatus: authorizationStatus, enableDirectPortRateLimit: default);
        }

        /// <summary> Initializes a new instance of <see cref="T:Azure.ResourceManager.Network.NetworkVirtualApplianceData" />. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="identity"> The service principal that has read access to cloud-init and config blob. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="nvaSku"> Network Virtual Appliance SKU. </param>
        /// <param name="addressPrefix"> Address Prefix. </param>
        /// <param name="bootStrapConfigurationBlobs"> BootStrapConfigurationBlobs storage URLs. </param>
        /// <param name="virtualHubId"> The Virtual Hub where Network Virtual Appliance is being deployed. </param>
        /// <param name="cloudInitConfigurationBlobs"> CloudInitConfigurationBlob storage URLs. </param>
        /// <param name="cloudInitConfiguration"> CloudInitConfiguration string in plain text. </param>
        /// <param name="virtualApplianceAsn"> VirtualAppliance ASN. Microsoft private, public and IANA reserved ASN are not supported. </param>
        /// <param name="sshPublicKey"> Public key for SSH login. </param>
        /// <param name="virtualApplianceNics"> List of Virtual Appliance Network Interfaces. </param>
        /// <param name="additionalNics"> Details required for Additional Network Interface. </param>
        /// <param name="internetIngressPublicIPs"> List of Resource Uri of Public IPs for Internet Ingress Scenario. </param>
        /// <param name="virtualApplianceSites"> List of references to VirtualApplianceSite. </param>
        /// <param name="virtualApplianceConnections"> List of references to VirtualApplianceConnections. </param>
        /// <param name="inboundSecurityRules"> List of references to InboundSecurityRules. </param>
        /// <param name="provisioningState"> The provisioning state of the resource. </param>
        /// <param name="deploymentType"> The deployment type. PartnerManaged for the SaaS NVA. </param>
        /// <param name="delegation"> The delegation for the Virtual Appliance. </param>
        /// <param name="partnerManagedResource"> The delegation for the Virtual Appliance. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.Network.NetworkVirtualApplianceData" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static NetworkVirtualApplianceData NetworkVirtualApplianceData(ResourceIdentifier id, string name, ResourceType? resourceType, AzureLocation? location, IDictionary<string, string> tags, ManagedServiceIdentity identity, ETag? etag, VirtualApplianceSkuProperties nvaSku, string addressPrefix, IEnumerable<string> bootStrapConfigurationBlobs, ResourceIdentifier virtualHubId, IEnumerable<string> cloudInitConfigurationBlobs, string cloudInitConfiguration, long? virtualApplianceAsn, string sshPublicKey, IEnumerable<VirtualApplianceNicProperties> virtualApplianceNics, IEnumerable<VirtualApplianceAdditionalNicProperties> additionalNics, IEnumerable<WritableSubResource> internetIngressPublicIPs, IEnumerable<WritableSubResource> virtualApplianceSites, IEnumerable<WritableSubResource> virtualApplianceConnections, IEnumerable<WritableSubResource> inboundSecurityRules, NetworkProvisioningState? provisioningState, string deploymentType, VirtualApplianceDelegationProperties delegation, PartnerManagedResourceProperties partnerManagedResource)
        {
            return NetworkVirtualApplianceData(id: id, name: name, resourceType: resourceType, location: location, tags: tags, identity: identity, etag: etag, nvaSku: nvaSku, addressPrefix: addressPrefix, bootStrapConfigurationBlobs: bootStrapConfigurationBlobs, virtualHubId: virtualHubId, cloudInitConfigurationBlobs: cloudInitConfigurationBlobs, cloudInitConfiguration: cloudInitConfiguration, virtualApplianceAsn: virtualApplianceAsn, sshPublicKey: sshPublicKey, virtualApplianceNics: virtualApplianceNics, networkInterfaceConfigurations: default, additionalNics: additionalNics, internetIngressPublicIPs: internetIngressPublicIPs, virtualApplianceSites: virtualApplianceSites, virtualApplianceConnections: virtualApplianceConnections, inboundSecurityRules: inboundSecurityRules, provisioningState: provisioningState, deploymentType: deploymentType, delegation: delegation, partnerManagedResource: partnerManagedResource);
        }

        /// <summary> Initializes a new instance of <see cref="T:Azure.ResourceManager.Network.Models.VirtualApplianceNicProperties" />. </summary>
        /// <param name="name"> NIC name. </param>
        /// <param name="publicIPAddress"> Public IP address. </param>
        /// <param name="privateIPAddress"> Private IP address. </param>
        /// <param name="instanceName"> Instance on which nic is attached. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.Network.Models.VirtualApplianceNicProperties" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static VirtualApplianceNicProperties VirtualApplianceNicProperties(string name, string publicIPAddress, string privateIPAddress, string instanceName)
        {
            return VirtualApplianceNicProperties(nicType: default, name: name, publicIPAddress: publicIPAddress, privateIPAddress: privateIPAddress, instanceName: instanceName);
        }

        /// <summary> Initializes a new instance of <see cref="T:Azure.ResourceManager.Network.Models.PacketCaptureCreateOrUpdateContent" />. </summary>
        /// <param name="target"> The ID of the targeted resource, only AzureVM and AzureVMSS as target type are currently supported. </param>
        /// <param name="scope"> A list of AzureVMSS instances which can be included or excluded to run packet capture. If both included and excluded are empty, then the packet capture will run on all instances of AzureVMSS. </param>
        /// <param name="targetType"> Target type of the resource provided. </param>
        /// <param name="bytesToCapturePerPacket"> Number of bytes captured per packet, the remaining bytes are truncated. </param>
        /// <param name="totalBytesPerSession"> Maximum size of the capture output. </param>
        /// <param name="timeLimitInSeconds"> Maximum duration of the capture session in seconds. </param>
        /// <param name="storageLocation"> The storage location for a packet capture session. </param>
        /// <param name="filters"> A list of packet capture filters. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.Network.Models.PacketCaptureCreateOrUpdateContent" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static PacketCaptureCreateOrUpdateContent PacketCaptureCreateOrUpdateContent(string target, PacketCaptureMachineScope scope, PacketCaptureTargetType? targetType, long? bytesToCapturePerPacket, long? totalBytesPerSession, int? timeLimitInSeconds, PacketCaptureStorageLocation storageLocation, IEnumerable<PacketCaptureFilter> filters)
        {
            return PacketCaptureCreateOrUpdateContent(target: target, scope: scope, targetType: targetType, bytesToCapturePerPacket: bytesToCapturePerPacket, totalBytesPerSession: totalBytesPerSession, timeLimitInSeconds: timeLimitInSeconds, storageLocation: storageLocation, filters: filters, isContinuousCapture: default, captureSettings: default);
        }

        /// <summary> Initializes a new instance of <see cref="T:Azure.ResourceManager.Network.PacketCaptureData" />. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="target"> The ID of the targeted resource, only AzureVM and AzureVMSS as target type are currently supported. </param>
        /// <param name="scope"> A list of AzureVMSS instances which can be included or excluded to run packet capture. If both included and excluded are empty, then the packet capture will run on all instances of AzureVMSS. </param>
        /// <param name="targetType"> Target type of the resource provided. </param>
        /// <param name="bytesToCapturePerPacket"> Number of bytes captured per packet, the remaining bytes are truncated. </param>
        /// <param name="totalBytesPerSession"> Maximum size of the capture output. </param>
        /// <param name="timeLimitInSeconds"> Maximum duration of the capture session in seconds. </param>
        /// <param name="storageLocation"> The storage location for a packet capture session. </param>
        /// <param name="filters"> A list of packet capture filters. </param>
        /// <param name="provisioningState"> The provisioning state of the packet capture session. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.Network.PacketCaptureData" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static PacketCaptureData PacketCaptureData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, ETag? etag, string target, PacketCaptureMachineScope scope, PacketCaptureTargetType? targetType, long? bytesToCapturePerPacket, long? totalBytesPerSession, int? timeLimitInSeconds, PacketCaptureStorageLocation storageLocation, IEnumerable<PacketCaptureFilter> filters, NetworkProvisioningState? provisioningState)
        {
            return PacketCaptureData(id: id, name: name, resourceType: resourceType, systemData: systemData, etag: etag, target: target, scope: scope, targetType: targetType, bytesToCapturePerPacket: bytesToCapturePerPacket, totalBytesPerSession: totalBytesPerSession, timeLimitInSeconds: timeLimitInSeconds, storageLocation: storageLocation, filters: filters, isContinuousCapture: default, captureSettings: default, provisioningState: provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="T:Azure.ResourceManager.Network.VirtualNetworkPeeringData" />. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="allowVirtualNetworkAccess"> Whether the VMs in the local virtual network space would be able to access the VMs in remote virtual network space. </param>
        /// <param name="allowForwardedTraffic"> Whether the forwarded traffic from the VMs in the local virtual network will be allowed/disallowed in remote virtual network. </param>
        /// <param name="allowGatewayTransit"> If gateway links can be used in remote virtual networking to link to this virtual network. </param>
        /// <param name="useRemoteGateways"> If remote gateways can be used on this virtual network. If the flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to true. This flag cannot be set if virtual network already has a gateway. </param>
        /// <param name="remoteVirtualNetworkId"> The reference to the remote virtual network. The remote virtual network can be in the same or different region (preview). See here to register for the preview and learn more (https://docs.microsoft.com/en-us/azure/virtual-network/virtual-network-create-peering). </param>
        /// <param name="remoteAddressPrefixes"> The reference to the address space peered with the remote virtual network. </param>
        /// <param name="remoteVirtualNetworkAddressPrefixes"> The reference to the current address space of the remote virtual network. </param>
        /// <param name="remoteBgpCommunities"> The reference to the remote virtual network's Bgp Communities. </param>
        /// <param name="remoteVirtualNetworkEncryption"> The reference to the remote virtual network's encryption. </param>
        /// <param name="peeringState"> The status of the virtual network peering. </param>
        /// <param name="peeringSyncLevel"> The peering sync status of the virtual network peering. </param>
        /// <param name="provisioningState"> The provisioning state of the virtual network peering resource. </param>
        /// <param name="doNotVerifyRemoteGateways"> If we need to verify the provisioning state of the remote gateway. </param>
        /// <param name="resourceGuid"> The resourceGuid property of the Virtual Network peering resource. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.Network.VirtualNetworkPeeringData" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static VirtualNetworkPeeringData VirtualNetworkPeeringData(ResourceIdentifier id, string name, ResourceType? resourceType, ETag? etag, bool? allowVirtualNetworkAccess, bool? allowForwardedTraffic, bool? allowGatewayTransit, bool? useRemoteGateways, ResourceIdentifier remoteVirtualNetworkId, IEnumerable<string> remoteAddressPrefixes, IEnumerable<string> remoteVirtualNetworkAddressPrefixes, VirtualNetworkBgpCommunities remoteBgpCommunities, VirtualNetworkEncryption remoteVirtualNetworkEncryption, VirtualNetworkPeeringState? peeringState, VirtualNetworkPeeringLevel? peeringSyncLevel, NetworkProvisioningState? provisioningState, bool? doNotVerifyRemoteGateways, Guid? resourceGuid)
        {
            return VirtualNetworkPeeringData(id: id, name: name, resourceType: resourceType, etag: etag, allowVirtualNetworkAccess: allowVirtualNetworkAccess, allowForwardedTraffic: allowForwardedTraffic, allowGatewayTransit: allowGatewayTransit, useRemoteGateways: useRemoteGateways, remoteVirtualNetworkId: remoteVirtualNetworkId, localAddressPrefixes: default, localVirtualNetworkAddressPrefixes: default, remoteAddressPrefixes: remoteAddressPrefixes, remoteVirtualNetworkAddressPrefixes: remoteVirtualNetworkAddressPrefixes, remoteBgpCommunities: remoteBgpCommunities, remoteVirtualNetworkEncryption: remoteVirtualNetworkEncryption, peeringState: peeringState, peeringSyncLevel: peeringSyncLevel, provisioningState: provisioningState, doNotVerifyRemoteGateways: doNotVerifyRemoteGateways, resourceGuid: resourceGuid, areCompleteVnetsPeered: default, enableOnlyIPv6Peering: default, localSubnetNames: default, remoteSubnetNames: default);
        }

        /// <summary> Initializes a new instance of <see cref="T:Azure.ResourceManager.Network.VpnSiteLinkConnectionData" />. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="vpnSiteLinkId"> Id of the connected vpn site link. </param>
        /// <param name="routingWeight"> Routing weight for vpn connection. </param>
        /// <param name="vpnLinkConnectionMode"> Vpn link connection mode. </param>
        /// <param name="connectionStatus"> The connection status. </param>
        /// <param name="vpnConnectionProtocolType"> Connection protocol used for this connection. </param>
        /// <param name="ingressBytesTransferred"> Ingress bytes transferred. </param>
        /// <param name="egressBytesTransferred"> Egress bytes transferred. </param>
        /// <param name="connectionBandwidth"> Expected bandwidth in MBPS. </param>
        /// <param name="sharedKey"> SharedKey for the vpn connection. </param>
        /// <param name="enableBgp"> EnableBgp flag. </param>
        /// <param name="vpnGatewayCustomBgpAddresses"> vpnGatewayCustomBgpAddresses used by this connection. </param>
        /// <param name="usePolicyBasedTrafficSelectors"> Enable policy-based traffic selectors. </param>
        /// <param name="ipsecPolicies"> The IPSec Policies to be considered by this connection. </param>
        /// <param name="enableRateLimiting"> EnableBgp flag. </param>
        /// <param name="useLocalAzureIPAddress"> Use local azure ip to initiate connection. </param>
        /// <param name="provisioningState"> The provisioning state of the VPN site link connection resource. </param>
        /// <param name="ingressNatRules"> List of ingress NatRules. </param>
        /// <param name="egressNatRules"> List of egress NatRules. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.Network.VpnSiteLinkConnectionData" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static VpnSiteLinkConnectionData VpnSiteLinkConnectionData(ResourceIdentifier id, string name, ResourceType? resourceType, ETag? etag, ResourceIdentifier vpnSiteLinkId, int? routingWeight, VpnLinkConnectionMode? vpnLinkConnectionMode, VpnConnectionStatus? connectionStatus, VirtualNetworkGatewayConnectionProtocol? vpnConnectionProtocolType, long? ingressBytesTransferred, long? egressBytesTransferred, int? connectionBandwidth, string sharedKey, bool? enableBgp, IEnumerable<GatewayCustomBgpIPAddressIPConfiguration> vpnGatewayCustomBgpAddresses, bool? usePolicyBasedTrafficSelectors, IEnumerable<IPsecPolicy> ipsecPolicies, bool? enableRateLimiting, bool? useLocalAzureIPAddress, NetworkProvisioningState? provisioningState, IEnumerable<WritableSubResource> ingressNatRules, IEnumerable<WritableSubResource> egressNatRules)
        {
            return VpnSiteLinkConnectionData(id: id, name: name, resourceType: resourceType, etag: etag, vpnSiteLinkId: vpnSiteLinkId, routingWeight: routingWeight, vpnLinkConnectionMode: vpnLinkConnectionMode, connectionStatus: connectionStatus, vpnConnectionProtocolType: vpnConnectionProtocolType, ingressBytesTransferred: ingressBytesTransferred, egressBytesTransferred: egressBytesTransferred, connectionBandwidth: connectionBandwidth, sharedKey: sharedKey, enableBgp: enableBgp, vpnGatewayCustomBgpAddresses: vpnGatewayCustomBgpAddresses, usePolicyBasedTrafficSelectors: usePolicyBasedTrafficSelectors, ipsecPolicies: ipsecPolicies, enableRateLimiting: enableRateLimiting, useLocalAzureIPAddress: useLocalAzureIPAddress, provisioningState: provisioningState, ingressNatRules: ingressNatRules, egressNatRules: egressNatRules, dpdTimeoutSeconds: default);
        }
    }
}
