// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Network.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Network
{
    public partial class ApplicationGatewayData : IUtf8JsonSerializable, IJsonModel<ApplicationGatewayData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ApplicationGatewayData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ApplicationGatewayData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ApplicationGatewayData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ApplicationGatewayData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (options.Format != "W" && Optional.IsDefined(ETag))
            {
                writer.WritePropertyName("etag"u8);
                writer.WriteStringValue(ETag.Value.ToString());
            }
            if (Optional.IsCollectionDefined(AvailabilityZones))
            {
                writer.WritePropertyName("zones"u8);
                writer.WriteStartArray();
                foreach (var item in AvailabilityZones)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(Identity))
            {
                writer.WritePropertyName("identity"u8);
                JsonSerializer.Serialize(writer, Identity);
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(Sku))
            {
                writer.WritePropertyName("sku"u8);
                writer.WriteObjectValue(Sku, options);
            }
            if (Optional.IsDefined(SslPolicy))
            {
                writer.WritePropertyName("sslPolicy"u8);
                writer.WriteObjectValue(SslPolicy, options);
            }
            if (options.Format != "W" && Optional.IsDefined(OperationalState))
            {
                writer.WritePropertyName("operationalState"u8);
                writer.WriteStringValue(OperationalState.Value.ToString());
            }
            if (Optional.IsCollectionDefined(GatewayIPConfigurations))
            {
                writer.WritePropertyName("gatewayIPConfigurations"u8);
                writer.WriteStartArray();
                foreach (var item in GatewayIPConfigurations)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(AuthenticationCertificates))
            {
                writer.WritePropertyName("authenticationCertificates"u8);
                writer.WriteStartArray();
                foreach (var item in AuthenticationCertificates)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(TrustedRootCertificates))
            {
                writer.WritePropertyName("trustedRootCertificates"u8);
                writer.WriteStartArray();
                foreach (var item in TrustedRootCertificates)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(TrustedClientCertificates))
            {
                writer.WritePropertyName("trustedClientCertificates"u8);
                writer.WriteStartArray();
                foreach (var item in TrustedClientCertificates)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(SslCertificates))
            {
                writer.WritePropertyName("sslCertificates"u8);
                writer.WriteStartArray();
                foreach (var item in SslCertificates)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(FrontendIPConfigurations))
            {
                writer.WritePropertyName("frontendIPConfigurations"u8);
                writer.WriteStartArray();
                foreach (var item in FrontendIPConfigurations)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(FrontendPorts))
            {
                writer.WritePropertyName("frontendPorts"u8);
                writer.WriteStartArray();
                foreach (var item in FrontendPorts)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Probes))
            {
                writer.WritePropertyName("probes"u8);
                writer.WriteStartArray();
                foreach (var item in Probes)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(BackendAddressPools))
            {
                writer.WritePropertyName("backendAddressPools"u8);
                writer.WriteStartArray();
                foreach (var item in BackendAddressPools)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(BackendHttpSettingsCollection))
            {
                writer.WritePropertyName("backendHttpSettingsCollection"u8);
                writer.WriteStartArray();
                foreach (var item in BackendHttpSettingsCollection)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(BackendSettingsCollection))
            {
                writer.WritePropertyName("backendSettingsCollection"u8);
                writer.WriteStartArray();
                foreach (var item in BackendSettingsCollection)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(HttpListeners))
            {
                writer.WritePropertyName("httpListeners"u8);
                writer.WriteStartArray();
                foreach (var item in HttpListeners)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Listeners))
            {
                writer.WritePropertyName("listeners"u8);
                writer.WriteStartArray();
                foreach (var item in Listeners)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(SslProfiles))
            {
                writer.WritePropertyName("sslProfiles"u8);
                writer.WriteStartArray();
                foreach (var item in SslProfiles)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(UrlPathMaps))
            {
                writer.WritePropertyName("urlPathMaps"u8);
                writer.WriteStartArray();
                foreach (var item in UrlPathMaps)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(RequestRoutingRules))
            {
                writer.WritePropertyName("requestRoutingRules"u8);
                writer.WriteStartArray();
                foreach (var item in RequestRoutingRules)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(RoutingRules))
            {
                writer.WritePropertyName("routingRules"u8);
                writer.WriteStartArray();
                foreach (var item in RoutingRules)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(RewriteRuleSets))
            {
                writer.WritePropertyName("rewriteRuleSets"u8);
                writer.WriteStartArray();
                foreach (var item in RewriteRuleSets)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(RedirectConfigurations))
            {
                writer.WritePropertyName("redirectConfigurations"u8);
                writer.WriteStartArray();
                foreach (var item in RedirectConfigurations)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(WebApplicationFirewallConfiguration))
            {
                writer.WritePropertyName("webApplicationFirewallConfiguration"u8);
                writer.WriteObjectValue(WebApplicationFirewallConfiguration, options);
            }
            if (Optional.IsDefined(FirewallPolicy))
            {
                writer.WritePropertyName("firewallPolicy"u8);
                JsonSerializer.Serialize(writer, FirewallPolicy);
            }
            if (Optional.IsDefined(EnableHttp2))
            {
                writer.WritePropertyName("enableHttp2"u8);
                writer.WriteBooleanValue(EnableHttp2.Value);
            }
            if (Optional.IsDefined(EnableFips))
            {
                writer.WritePropertyName("enableFips"u8);
                writer.WriteBooleanValue(EnableFips.Value);
            }
            if (Optional.IsDefined(AutoscaleConfiguration))
            {
                writer.WritePropertyName("autoscaleConfiguration"u8);
                writer.WriteObjectValue(AutoscaleConfiguration, options);
            }
            if (Optional.IsCollectionDefined(PrivateLinkConfigurations))
            {
                writer.WritePropertyName("privateLinkConfigurations"u8);
                writer.WriteStartArray();
                foreach (var item in PrivateLinkConfigurations)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(PrivateEndpointConnections))
            {
                writer.WritePropertyName("privateEndpointConnections"u8);
                writer.WriteStartArray();
                foreach (var item in PrivateEndpointConnections)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(ResourceGuid))
            {
                writer.WritePropertyName("resourceGuid"u8);
                writer.WriteStringValue(ResourceGuid.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (Optional.IsCollectionDefined(CustomErrorConfigurations))
            {
                writer.WritePropertyName("customErrorConfigurations"u8);
                writer.WriteStartArray();
                foreach (var item in CustomErrorConfigurations)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(ForceFirewallPolicyAssociation))
            {
                writer.WritePropertyName("forceFirewallPolicyAssociation"u8);
                writer.WriteBooleanValue(ForceFirewallPolicyAssociation.Value);
            }
            if (Optional.IsCollectionDefined(LoadDistributionPolicies))
            {
                writer.WritePropertyName("loadDistributionPolicies"u8);
                writer.WriteStartArray();
                foreach (var item in LoadDistributionPolicies)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(GlobalConfiguration))
            {
                writer.WritePropertyName("globalConfiguration"u8);
                writer.WriteObjectValue(GlobalConfiguration, options);
            }
            if (options.Format != "W" && Optional.IsDefined(DefaultPredefinedSslPolicy))
            {
                writer.WritePropertyName("defaultPredefinedSslPolicy"u8);
                writer.WriteStringValue(DefaultPredefinedSslPolicy.Value.ToString());
            }
            writer.WriteEndObject();
        }

        ApplicationGatewayData IJsonModel<ApplicationGatewayData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ApplicationGatewayData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ApplicationGatewayData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeApplicationGatewayData(document.RootElement, options);
        }

        internal static ApplicationGatewayData DeserializeApplicationGatewayData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ETag? etag = default;
            IList<string> zones = default;
            ManagedServiceIdentity identity = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType? type = default;
            AzureLocation? location = default;
            IDictionary<string, string> tags = default;
            ApplicationGatewaySku sku = default;
            ApplicationGatewaySslPolicy sslPolicy = default;
            ApplicationGatewayOperationalState? operationalState = default;
            IList<ApplicationGatewayIPConfiguration> gatewayIPConfigurations = default;
            IList<ApplicationGatewayAuthenticationCertificate> authenticationCertificates = default;
            IList<ApplicationGatewayTrustedRootCertificate> trustedRootCertificates = default;
            IList<ApplicationGatewayTrustedClientCertificate> trustedClientCertificates = default;
            IList<ApplicationGatewaySslCertificate> sslCertificates = default;
            IList<ApplicationGatewayFrontendIPConfiguration> frontendIPConfigurations = default;
            IList<ApplicationGatewayFrontendPort> frontendPorts = default;
            IList<ApplicationGatewayProbe> probes = default;
            IList<ApplicationGatewayBackendAddressPool> backendAddressPools = default;
            IList<ApplicationGatewayBackendHttpSettings> backendHttpSettingsCollection = default;
            IList<ApplicationGatewayBackendSettings> backendSettingsCollection = default;
            IList<ApplicationGatewayHttpListener> httpListeners = default;
            IList<ApplicationGatewayListener> listeners = default;
            IList<ApplicationGatewaySslProfile> sslProfiles = default;
            IList<ApplicationGatewayUrlPathMap> urlPathMaps = default;
            IList<ApplicationGatewayRequestRoutingRule> requestRoutingRules = default;
            IList<ApplicationGatewayRoutingRule> routingRules = default;
            IList<ApplicationGatewayRewriteRuleSet> rewriteRuleSets = default;
            IList<ApplicationGatewayRedirectConfiguration> redirectConfigurations = default;
            ApplicationGatewayWebApplicationFirewallConfiguration webApplicationFirewallConfiguration = default;
            WritableSubResource firewallPolicy = default;
            bool? enableHttp2 = default;
            bool? enableFips = default;
            ApplicationGatewayAutoscaleConfiguration autoscaleConfiguration = default;
            IList<ApplicationGatewayPrivateLinkConfiguration> privateLinkConfigurations = default;
            IReadOnlyList<ApplicationGatewayPrivateEndpointConnectionData> privateEndpointConnections = default;
            Guid? resourceGuid = default;
            NetworkProvisioningState? provisioningState = default;
            IList<ApplicationGatewayCustomError> customErrorConfigurations = default;
            bool? forceFirewallPolicyAssociation = default;
            IList<ApplicationGatewayLoadDistributionPolicy> loadDistributionPolicies = default;
            ApplicationGatewayGlobalConfiguration globalConfiguration = default;
            ApplicationGatewaySslPolicyName? defaultPredefinedSslPolicy = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("etag"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    etag = new ETag(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("zones"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    zones = array;
                    continue;
                }
                if (property.NameEquals("identity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    identity = JsonSerializer.Deserialize<ManagedServiceIdentity>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("sku"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            sku = ApplicationGatewaySku.DeserializeApplicationGatewaySku(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("sslPolicy"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            sslPolicy = ApplicationGatewaySslPolicy.DeserializeApplicationGatewaySslPolicy(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("operationalState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            operationalState = new ApplicationGatewayOperationalState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("gatewayIPConfigurations"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ApplicationGatewayIPConfiguration> array = new List<ApplicationGatewayIPConfiguration>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ApplicationGatewayIPConfiguration.DeserializeApplicationGatewayIPConfiguration(item, options));
                            }
                            gatewayIPConfigurations = array;
                            continue;
                        }
                        if (property0.NameEquals("authenticationCertificates"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ApplicationGatewayAuthenticationCertificate> array = new List<ApplicationGatewayAuthenticationCertificate>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ApplicationGatewayAuthenticationCertificate.DeserializeApplicationGatewayAuthenticationCertificate(item, options));
                            }
                            authenticationCertificates = array;
                            continue;
                        }
                        if (property0.NameEquals("trustedRootCertificates"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ApplicationGatewayTrustedRootCertificate> array = new List<ApplicationGatewayTrustedRootCertificate>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ApplicationGatewayTrustedRootCertificate.DeserializeApplicationGatewayTrustedRootCertificate(item, options));
                            }
                            trustedRootCertificates = array;
                            continue;
                        }
                        if (property0.NameEquals("trustedClientCertificates"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ApplicationGatewayTrustedClientCertificate> array = new List<ApplicationGatewayTrustedClientCertificate>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ApplicationGatewayTrustedClientCertificate.DeserializeApplicationGatewayTrustedClientCertificate(item, options));
                            }
                            trustedClientCertificates = array;
                            continue;
                        }
                        if (property0.NameEquals("sslCertificates"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ApplicationGatewaySslCertificate> array = new List<ApplicationGatewaySslCertificate>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ApplicationGatewaySslCertificate.DeserializeApplicationGatewaySslCertificate(item, options));
                            }
                            sslCertificates = array;
                            continue;
                        }
                        if (property0.NameEquals("frontendIPConfigurations"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ApplicationGatewayFrontendIPConfiguration> array = new List<ApplicationGatewayFrontendIPConfiguration>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ApplicationGatewayFrontendIPConfiguration.DeserializeApplicationGatewayFrontendIPConfiguration(item, options));
                            }
                            frontendIPConfigurations = array;
                            continue;
                        }
                        if (property0.NameEquals("frontendPorts"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ApplicationGatewayFrontendPort> array = new List<ApplicationGatewayFrontendPort>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ApplicationGatewayFrontendPort.DeserializeApplicationGatewayFrontendPort(item, options));
                            }
                            frontendPorts = array;
                            continue;
                        }
                        if (property0.NameEquals("probes"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ApplicationGatewayProbe> array = new List<ApplicationGatewayProbe>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ApplicationGatewayProbe.DeserializeApplicationGatewayProbe(item, options));
                            }
                            probes = array;
                            continue;
                        }
                        if (property0.NameEquals("backendAddressPools"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ApplicationGatewayBackendAddressPool> array = new List<ApplicationGatewayBackendAddressPool>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ApplicationGatewayBackendAddressPool.DeserializeApplicationGatewayBackendAddressPool(item, options));
                            }
                            backendAddressPools = array;
                            continue;
                        }
                        if (property0.NameEquals("backendHttpSettingsCollection"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ApplicationGatewayBackendHttpSettings> array = new List<ApplicationGatewayBackendHttpSettings>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ApplicationGatewayBackendHttpSettings.DeserializeApplicationGatewayBackendHttpSettings(item, options));
                            }
                            backendHttpSettingsCollection = array;
                            continue;
                        }
                        if (property0.NameEquals("backendSettingsCollection"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ApplicationGatewayBackendSettings> array = new List<ApplicationGatewayBackendSettings>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ApplicationGatewayBackendSettings.DeserializeApplicationGatewayBackendSettings(item, options));
                            }
                            backendSettingsCollection = array;
                            continue;
                        }
                        if (property0.NameEquals("httpListeners"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ApplicationGatewayHttpListener> array = new List<ApplicationGatewayHttpListener>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ApplicationGatewayHttpListener.DeserializeApplicationGatewayHttpListener(item, options));
                            }
                            httpListeners = array;
                            continue;
                        }
                        if (property0.NameEquals("listeners"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ApplicationGatewayListener> array = new List<ApplicationGatewayListener>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ApplicationGatewayListener.DeserializeApplicationGatewayListener(item, options));
                            }
                            listeners = array;
                            continue;
                        }
                        if (property0.NameEquals("sslProfiles"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ApplicationGatewaySslProfile> array = new List<ApplicationGatewaySslProfile>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ApplicationGatewaySslProfile.DeserializeApplicationGatewaySslProfile(item, options));
                            }
                            sslProfiles = array;
                            continue;
                        }
                        if (property0.NameEquals("urlPathMaps"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ApplicationGatewayUrlPathMap> array = new List<ApplicationGatewayUrlPathMap>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ApplicationGatewayUrlPathMap.DeserializeApplicationGatewayUrlPathMap(item, options));
                            }
                            urlPathMaps = array;
                            continue;
                        }
                        if (property0.NameEquals("requestRoutingRules"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ApplicationGatewayRequestRoutingRule> array = new List<ApplicationGatewayRequestRoutingRule>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ApplicationGatewayRequestRoutingRule.DeserializeApplicationGatewayRequestRoutingRule(item, options));
                            }
                            requestRoutingRules = array;
                            continue;
                        }
                        if (property0.NameEquals("routingRules"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ApplicationGatewayRoutingRule> array = new List<ApplicationGatewayRoutingRule>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ApplicationGatewayRoutingRule.DeserializeApplicationGatewayRoutingRule(item, options));
                            }
                            routingRules = array;
                            continue;
                        }
                        if (property0.NameEquals("rewriteRuleSets"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ApplicationGatewayRewriteRuleSet> array = new List<ApplicationGatewayRewriteRuleSet>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ApplicationGatewayRewriteRuleSet.DeserializeApplicationGatewayRewriteRuleSet(item, options));
                            }
                            rewriteRuleSets = array;
                            continue;
                        }
                        if (property0.NameEquals("redirectConfigurations"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ApplicationGatewayRedirectConfiguration> array = new List<ApplicationGatewayRedirectConfiguration>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ApplicationGatewayRedirectConfiguration.DeserializeApplicationGatewayRedirectConfiguration(item, options));
                            }
                            redirectConfigurations = array;
                            continue;
                        }
                        if (property0.NameEquals("webApplicationFirewallConfiguration"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            webApplicationFirewallConfiguration = ApplicationGatewayWebApplicationFirewallConfiguration.DeserializeApplicationGatewayWebApplicationFirewallConfiguration(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("firewallPolicy"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            firewallPolicy = JsonSerializer.Deserialize<WritableSubResource>(property0.Value.GetRawText());
                            continue;
                        }
                        if (property0.NameEquals("enableHttp2"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableHttp2 = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("enableFips"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableFips = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("autoscaleConfiguration"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            autoscaleConfiguration = ApplicationGatewayAutoscaleConfiguration.DeserializeApplicationGatewayAutoscaleConfiguration(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("privateLinkConfigurations"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ApplicationGatewayPrivateLinkConfiguration> array = new List<ApplicationGatewayPrivateLinkConfiguration>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ApplicationGatewayPrivateLinkConfiguration.DeserializeApplicationGatewayPrivateLinkConfiguration(item, options));
                            }
                            privateLinkConfigurations = array;
                            continue;
                        }
                        if (property0.NameEquals("privateEndpointConnections"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ApplicationGatewayPrivateEndpointConnectionData> array = new List<ApplicationGatewayPrivateEndpointConnectionData>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ApplicationGatewayPrivateEndpointConnectionData.DeserializeApplicationGatewayPrivateEndpointConnectionData(item, options));
                            }
                            privateEndpointConnections = array;
                            continue;
                        }
                        if (property0.NameEquals("resourceGuid"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            resourceGuid = property0.Value.GetGuid();
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new NetworkProvisioningState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("customErrorConfigurations"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ApplicationGatewayCustomError> array = new List<ApplicationGatewayCustomError>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ApplicationGatewayCustomError.DeserializeApplicationGatewayCustomError(item, options));
                            }
                            customErrorConfigurations = array;
                            continue;
                        }
                        if (property0.NameEquals("forceFirewallPolicyAssociation"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            forceFirewallPolicyAssociation = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("loadDistributionPolicies"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ApplicationGatewayLoadDistributionPolicy> array = new List<ApplicationGatewayLoadDistributionPolicy>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ApplicationGatewayLoadDistributionPolicy.DeserializeApplicationGatewayLoadDistributionPolicy(item, options));
                            }
                            loadDistributionPolicies = array;
                            continue;
                        }
                        if (property0.NameEquals("globalConfiguration"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            globalConfiguration = ApplicationGatewayGlobalConfiguration.DeserializeApplicationGatewayGlobalConfiguration(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("defaultPredefinedSslPolicy"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            defaultPredefinedSslPolicy = new ApplicationGatewaySslPolicyName(property0.Value.GetString());
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ApplicationGatewayData(
                id,
                name,
                type,
                location,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                serializedAdditionalRawData,
                etag,
                zones ?? new ChangeTrackingList<string>(),
                identity,
                sku,
                sslPolicy,
                operationalState,
                gatewayIPConfigurations ?? new ChangeTrackingList<ApplicationGatewayIPConfiguration>(),
                authenticationCertificates ?? new ChangeTrackingList<ApplicationGatewayAuthenticationCertificate>(),
                trustedRootCertificates ?? new ChangeTrackingList<ApplicationGatewayTrustedRootCertificate>(),
                trustedClientCertificates ?? new ChangeTrackingList<ApplicationGatewayTrustedClientCertificate>(),
                sslCertificates ?? new ChangeTrackingList<ApplicationGatewaySslCertificate>(),
                frontendIPConfigurations ?? new ChangeTrackingList<ApplicationGatewayFrontendIPConfiguration>(),
                frontendPorts ?? new ChangeTrackingList<ApplicationGatewayFrontendPort>(),
                probes ?? new ChangeTrackingList<ApplicationGatewayProbe>(),
                backendAddressPools ?? new ChangeTrackingList<ApplicationGatewayBackendAddressPool>(),
                backendHttpSettingsCollection ?? new ChangeTrackingList<ApplicationGatewayBackendHttpSettings>(),
                backendSettingsCollection ?? new ChangeTrackingList<ApplicationGatewayBackendSettings>(),
                httpListeners ?? new ChangeTrackingList<ApplicationGatewayHttpListener>(),
                listeners ?? new ChangeTrackingList<ApplicationGatewayListener>(),
                sslProfiles ?? new ChangeTrackingList<ApplicationGatewaySslProfile>(),
                urlPathMaps ?? new ChangeTrackingList<ApplicationGatewayUrlPathMap>(),
                requestRoutingRules ?? new ChangeTrackingList<ApplicationGatewayRequestRoutingRule>(),
                routingRules ?? new ChangeTrackingList<ApplicationGatewayRoutingRule>(),
                rewriteRuleSets ?? new ChangeTrackingList<ApplicationGatewayRewriteRuleSet>(),
                redirectConfigurations ?? new ChangeTrackingList<ApplicationGatewayRedirectConfiguration>(),
                webApplicationFirewallConfiguration,
                firewallPolicy,
                enableHttp2,
                enableFips,
                autoscaleConfiguration,
                privateLinkConfigurations ?? new ChangeTrackingList<ApplicationGatewayPrivateLinkConfiguration>(),
                privateEndpointConnections ?? new ChangeTrackingList<ApplicationGatewayPrivateEndpointConnectionData>(),
                resourceGuid,
                provisioningState,
                customErrorConfigurations ?? new ChangeTrackingList<ApplicationGatewayCustomError>(),
                forceFirewallPolicyAssociation,
                loadDistributionPolicies ?? new ChangeTrackingList<ApplicationGatewayLoadDistributionPolicy>(),
                globalConfiguration,
                defaultPredefinedSslPolicy);
        }

        BinaryData IPersistableModel<ApplicationGatewayData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ApplicationGatewayData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ApplicationGatewayData)} does not support writing '{options.Format}' format.");
            }
        }

        ApplicationGatewayData IPersistableModel<ApplicationGatewayData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ApplicationGatewayData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeApplicationGatewayData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ApplicationGatewayData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ApplicationGatewayData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
