// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Network.Models;

namespace Azure.ResourceManager.Network.Samples
{
    public partial class Sample_VirtualNetworkGatewayResource
    {
        // GetVirtualNetworkGateway
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetVirtualNetworkGateway()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/VirtualNetworkGatewayGet.json
            // this example is just showing the usage of "VirtualNetworkGateways_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this VirtualNetworkGatewayResource created on azure
            // for more information of creating VirtualNetworkGatewayResource, please refer to the document of VirtualNetworkGatewayResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string virtualNetworkGatewayName = "vpngw";
            ResourceIdentifier virtualNetworkGatewayResourceId = VirtualNetworkGatewayResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, virtualNetworkGatewayName);
            VirtualNetworkGatewayResource virtualNetworkGateway = client.GetVirtualNetworkGatewayResource(virtualNetworkGatewayResourceId);

            // invoke the operation
            VirtualNetworkGatewayResource result = await virtualNetworkGateway.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            VirtualNetworkGatewayData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // GetVirtualNetworkScalableGateway
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetVirtualNetworkScalableGateway()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/VirtualNetworkScalableGatewayGet.json
            // this example is just showing the usage of "VirtualNetworkGateways_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this VirtualNetworkGatewayResource created on azure
            // for more information of creating VirtualNetworkGatewayResource, please refer to the document of VirtualNetworkGatewayResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string virtualNetworkGatewayName = "ergw";
            ResourceIdentifier virtualNetworkGatewayResourceId = VirtualNetworkGatewayResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, virtualNetworkGatewayName);
            VirtualNetworkGatewayResource virtualNetworkGateway = client.GetVirtualNetworkGatewayResource(virtualNetworkGatewayResourceId);

            // invoke the operation
            VirtualNetworkGatewayResource result = await virtualNetworkGateway.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            VirtualNetworkGatewayData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // DeleteVirtualNetworkGateway
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteVirtualNetworkGateway()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/VirtualNetworkGatewayDelete.json
            // this example is just showing the usage of "VirtualNetworkGateways_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this VirtualNetworkGatewayResource created on azure
            // for more information of creating VirtualNetworkGatewayResource, please refer to the document of VirtualNetworkGatewayResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string virtualNetworkGatewayName = "vpngw";
            ResourceIdentifier virtualNetworkGatewayResourceId = VirtualNetworkGatewayResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, virtualNetworkGatewayName);
            VirtualNetworkGatewayResource virtualNetworkGateway = client.GetVirtualNetworkGatewayResource(virtualNetworkGatewayResourceId);

            // invoke the operation
            await virtualNetworkGateway.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // UpdateVirtualNetworkGatewayTags
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateVirtualNetworkGatewayTags()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/VirtualNetworkGatewayUpdateTags.json
            // this example is just showing the usage of "VirtualNetworkGateways_UpdateTags" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this VirtualNetworkGatewayResource created on azure
            // for more information of creating VirtualNetworkGatewayResource, please refer to the document of VirtualNetworkGatewayResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string virtualNetworkGatewayName = "vpngw";
            ResourceIdentifier virtualNetworkGatewayResourceId = VirtualNetworkGatewayResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, virtualNetworkGatewayName);
            VirtualNetworkGatewayResource virtualNetworkGateway = client.GetVirtualNetworkGatewayResource(virtualNetworkGatewayResourceId);

            // invoke the operation
            NetworkTagsObject networkTagsObject = new NetworkTagsObject()
            {
                Tags =
{
["tag1"] = "value1",
["tag2"] = "value2",
},
            };
            ArmOperation<VirtualNetworkGatewayResource> lro = await virtualNetworkGateway.UpdateAsync(WaitUntil.Completed, networkTagsObject);
            VirtualNetworkGatewayResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            VirtualNetworkGatewayData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // VirtualNetworkGatewaysListConnections
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetConnections_VirtualNetworkGatewaysListConnections()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/VirtualNetworkGatewaysListConnections.json
            // this example is just showing the usage of "VirtualNetworkGateways_ListConnections" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this VirtualNetworkGatewayResource created on azure
            // for more information of creating VirtualNetworkGatewayResource, please refer to the document of VirtualNetworkGatewayResource
            string subscriptionId = "subid";
            string resourceGroupName = "testrg";
            string virtualNetworkGatewayName = "test-vpn-gateway-1";
            ResourceIdentifier virtualNetworkGatewayResourceId = VirtualNetworkGatewayResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, virtualNetworkGatewayName);
            VirtualNetworkGatewayResource virtualNetworkGateway = client.GetVirtualNetworkGatewayResource(virtualNetworkGatewayResourceId);

            // invoke the operation and iterate over the result
            await foreach (VirtualNetworkGatewayConnectionListEntity item in virtualNetworkGateway.GetConnectionsAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // ResetVirtualNetworkGateway
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Reset_ResetVirtualNetworkGateway()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/VirtualNetworkGatewayReset.json
            // this example is just showing the usage of "VirtualNetworkGateways_Reset" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this VirtualNetworkGatewayResource created on azure
            // for more information of creating VirtualNetworkGatewayResource, please refer to the document of VirtualNetworkGatewayResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string virtualNetworkGatewayName = "vpngw";
            ResourceIdentifier virtualNetworkGatewayResourceId = VirtualNetworkGatewayResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, virtualNetworkGatewayName);
            VirtualNetworkGatewayResource virtualNetworkGateway = client.GetVirtualNetworkGatewayResource(virtualNetworkGatewayResourceId);

            // invoke the operation
            ArmOperation<VirtualNetworkGatewayResource> lro = await virtualNetworkGateway.ResetAsync(WaitUntil.Completed);
            VirtualNetworkGatewayResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            VirtualNetworkGatewayData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ResetVpnClientSharedKey
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task ResetVpnClientSharedKey_ResetVpnClientSharedKey()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/VirtualNetworkGatewayResetVpnClientSharedKey.json
            // this example is just showing the usage of "VirtualNetworkGateways_ResetVpnClientSharedKey" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this VirtualNetworkGatewayResource created on azure
            // for more information of creating VirtualNetworkGatewayResource, please refer to the document of VirtualNetworkGatewayResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string virtualNetworkGatewayName = "vpngw";
            ResourceIdentifier virtualNetworkGatewayResourceId = VirtualNetworkGatewayResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, virtualNetworkGatewayName);
            VirtualNetworkGatewayResource virtualNetworkGateway = client.GetVirtualNetworkGatewayResource(virtualNetworkGatewayResourceId);

            // invoke the operation
            await virtualNetworkGateway.ResetVpnClientSharedKeyAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // GenerateVPNClientPackage
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GenerateVpnClientPackage_GenerateVPNClientPackage()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/VirtualNetworkGatewayGenerateVpnClientPackage.json
            // this example is just showing the usage of "VirtualNetworkGateways_Generatevpnclientpackage" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this VirtualNetworkGatewayResource created on azure
            // for more information of creating VirtualNetworkGatewayResource, please refer to the document of VirtualNetworkGatewayResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string virtualNetworkGatewayName = "vpngw";
            ResourceIdentifier virtualNetworkGatewayResourceId = VirtualNetworkGatewayResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, virtualNetworkGatewayName);
            VirtualNetworkGatewayResource virtualNetworkGateway = client.GetVirtualNetworkGatewayResource(virtualNetworkGatewayResourceId);

            // invoke the operation
            VpnClientContent content = new VpnClientContent();
            ArmOperation<string> lro = await virtualNetworkGateway.GenerateVpnClientPackageAsync(WaitUntil.Completed, content);
            string result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // GenerateVirtualNetworkGatewayVPNProfile
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GenerateVpnProfile_GenerateVirtualNetworkGatewayVPNProfile()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/VirtualNetworkGatewayGenerateVpnProfile.json
            // this example is just showing the usage of "VirtualNetworkGateways_GenerateVpnProfile" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this VirtualNetworkGatewayResource created on azure
            // for more information of creating VirtualNetworkGatewayResource, please refer to the document of VirtualNetworkGatewayResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string virtualNetworkGatewayName = "vpngw";
            ResourceIdentifier virtualNetworkGatewayResourceId = VirtualNetworkGatewayResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, virtualNetworkGatewayName);
            VirtualNetworkGatewayResource virtualNetworkGateway = client.GetVirtualNetworkGatewayResource(virtualNetworkGatewayResourceId);

            // invoke the operation
            VpnClientContent content = new VpnClientContent();
            ArmOperation<string> lro = await virtualNetworkGateway.GenerateVpnProfileAsync(WaitUntil.Completed, content);
            string result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // GetVirtualNetworkGatewayVPNProfilePackageURL
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetVpnProfilePackageUrl_GetVirtualNetworkGatewayVPNProfilePackageURL()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/VirtualNetworkGatewayGetVpnProfilePackageUrl.json
            // this example is just showing the usage of "VirtualNetworkGateways_GetVpnProfilePackageUrl" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this VirtualNetworkGatewayResource created on azure
            // for more information of creating VirtualNetworkGatewayResource, please refer to the document of VirtualNetworkGatewayResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string virtualNetworkGatewayName = "vpngw";
            ResourceIdentifier virtualNetworkGatewayResourceId = VirtualNetworkGatewayResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, virtualNetworkGatewayName);
            VirtualNetworkGatewayResource virtualNetworkGateway = client.GetVirtualNetworkGatewayResource(virtualNetworkGatewayResourceId);

            // invoke the operation
            ArmOperation<string> lro = await virtualNetworkGateway.GetVpnProfilePackageUrlAsync(WaitUntil.Completed);
            string result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // GetVirtualNetworkGatewayBGPPeerStatus
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetBgpPeerStatus_GetVirtualNetworkGatewayBGPPeerStatus()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/VirtualNetworkGatewayGetBGPPeerStatus.json
            // this example is just showing the usage of "VirtualNetworkGateways_GetBgpPeerStatus" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this VirtualNetworkGatewayResource created on azure
            // for more information of creating VirtualNetworkGatewayResource, please refer to the document of VirtualNetworkGatewayResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string virtualNetworkGatewayName = "vpngw";
            ResourceIdentifier virtualNetworkGatewayResourceId = VirtualNetworkGatewayResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, virtualNetworkGatewayName);
            VirtualNetworkGatewayResource virtualNetworkGateway = client.GetVirtualNetworkGatewayResource(virtualNetworkGatewayResourceId);

            // invoke the operation
            ArmOperation<BgpPeerStatusListResult> lro = await virtualNetworkGateway.GetBgpPeerStatusAsync(WaitUntil.Completed);
            BgpPeerStatusListResult result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // ListVirtualNetworkGatewaySupportedVPNDevices
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task SupportedVpnDevices_ListVirtualNetworkGatewaySupportedVPNDevices()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/VirtualNetworkGatewaySupportedVpnDevice.json
            // this example is just showing the usage of "VirtualNetworkGateways_SupportedVpnDevices" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this VirtualNetworkGatewayResource created on azure
            // for more information of creating VirtualNetworkGatewayResource, please refer to the document of VirtualNetworkGatewayResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string virtualNetworkGatewayName = "vpngw";
            ResourceIdentifier virtualNetworkGatewayResourceId = VirtualNetworkGatewayResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, virtualNetworkGatewayName);
            VirtualNetworkGatewayResource virtualNetworkGateway = client.GetVirtualNetworkGatewayResource(virtualNetworkGatewayResourceId);

            // invoke the operation
            string result = await virtualNetworkGateway.SupportedVpnDevicesAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // GetVirtualNetworkGatewayLearnedRoutes
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetLearnedRoutes_GetVirtualNetworkGatewayLearnedRoutes()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/VirtualNetworkGatewayLearnedRoutes.json
            // this example is just showing the usage of "VirtualNetworkGateways_GetLearnedRoutes" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this VirtualNetworkGatewayResource created on azure
            // for more information of creating VirtualNetworkGatewayResource, please refer to the document of VirtualNetworkGatewayResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string virtualNetworkGatewayName = "vpngw";
            ResourceIdentifier virtualNetworkGatewayResourceId = VirtualNetworkGatewayResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, virtualNetworkGatewayName);
            VirtualNetworkGatewayResource virtualNetworkGateway = client.GetVirtualNetworkGatewayResource(virtualNetworkGatewayResourceId);

            // invoke the operation
            ArmOperation<GatewayRouteListResult> lro = await virtualNetworkGateway.GetLearnedRoutesAsync(WaitUntil.Completed);
            GatewayRouteListResult result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // GetVirtualNetworkGatewayAdvertisedRoutes
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAdvertisedRoutes_GetVirtualNetworkGatewayAdvertisedRoutes()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/VirtualNetworkGatewayGetAdvertisedRoutes.json
            // this example is just showing the usage of "VirtualNetworkGateways_GetAdvertisedRoutes" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this VirtualNetworkGatewayResource created on azure
            // for more information of creating VirtualNetworkGatewayResource, please refer to the document of VirtualNetworkGatewayResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string virtualNetworkGatewayName = "vpngw";
            ResourceIdentifier virtualNetworkGatewayResourceId = VirtualNetworkGatewayResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, virtualNetworkGatewayName);
            VirtualNetworkGatewayResource virtualNetworkGateway = client.GetVirtualNetworkGatewayResource(virtualNetworkGatewayResourceId);

            // invoke the operation
            string peer = "test";
            ArmOperation<GatewayRouteListResult> lro = await virtualNetworkGateway.GetAdvertisedRoutesAsync(WaitUntil.Completed, peer);
            GatewayRouteListResult result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // Set VirtualNetworkGateway VpnClientIpsecParameters
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task SetVpnclientIPsecParameters_SetVirtualNetworkGatewayVpnClientIpsecParameters()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/VirtualNetworkGatewaySetVpnClientIpsecParameters.json
            // this example is just showing the usage of "VirtualNetworkGateways_SetVpnclientIPsecParameters" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this VirtualNetworkGatewayResource created on azure
            // for more information of creating VirtualNetworkGatewayResource, please refer to the document of VirtualNetworkGatewayResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string virtualNetworkGatewayName = "vpngw";
            ResourceIdentifier virtualNetworkGatewayResourceId = VirtualNetworkGatewayResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, virtualNetworkGatewayName);
            VirtualNetworkGatewayResource virtualNetworkGateway = client.GetVirtualNetworkGatewayResource(virtualNetworkGatewayResourceId);

            // invoke the operation
            VpnClientIPsecParameters vpnclientIPsecParams = new VpnClientIPsecParameters(86473, 429497, IPsecEncryption.Aes256, IPsecIntegrity.Sha256, IkeEncryption.Aes256, IkeIntegrity.Sha384, DHGroup.DHGroup2, PfsGroup.Pfs2);
            ArmOperation<VpnClientIPsecParameters> lro = await virtualNetworkGateway.SetVpnclientIPsecParametersAsync(WaitUntil.Completed, vpnclientIPsecParams);
            VpnClientIPsecParameters result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get VirtualNetworkGateway VpnClientIpsecParameters
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetVpnclientIPsecParameters_GetVirtualNetworkGatewayVpnClientIpsecParameters()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/VirtualNetworkGatewayGetVpnClientIpsecParameters.json
            // this example is just showing the usage of "VirtualNetworkGateways_GetVpnclientIPsecParameters" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this VirtualNetworkGatewayResource created on azure
            // for more information of creating VirtualNetworkGatewayResource, please refer to the document of VirtualNetworkGatewayResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string virtualNetworkGatewayName = "vpngw";
            ResourceIdentifier virtualNetworkGatewayResourceId = VirtualNetworkGatewayResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, virtualNetworkGatewayName);
            VirtualNetworkGatewayResource virtualNetworkGateway = client.GetVirtualNetworkGatewayResource(virtualNetworkGatewayResourceId);

            // invoke the operation
            ArmOperation<VpnClientIPsecParameters> lro = await virtualNetworkGateway.GetVpnclientIPsecParametersAsync(WaitUntil.Completed);
            VpnClientIPsecParameters result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // Start packet capture on virtual network gateway with filter
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task StartPacketCapture_StartPacketCaptureOnVirtualNetworkGatewayWithFilter()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/VirtualNetworkGatewayStartPacketCaptureFilterData.json
            // this example is just showing the usage of "VirtualNetworkGateways_StartPacketCapture" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this VirtualNetworkGatewayResource created on azure
            // for more information of creating VirtualNetworkGatewayResource, please refer to the document of VirtualNetworkGatewayResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string virtualNetworkGatewayName = "vpngw";
            ResourceIdentifier virtualNetworkGatewayResourceId = VirtualNetworkGatewayResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, virtualNetworkGatewayName);
            VirtualNetworkGatewayResource virtualNetworkGateway = client.GetVirtualNetworkGatewayResource(virtualNetworkGatewayResourceId);

            // invoke the operation
            VpnPacketCaptureStartContent content = new VpnPacketCaptureStartContent()
            {
                FilterData = "{'TracingFlags': 11,'MaxPacketBufferSize': 120,'MaxFileSize': 200,'Filters': [{'SourceSubnets': ['20.1.1.0/24'],'DestinationSubnets': ['10.1.1.0/24'],'SourcePort': [500],'DestinationPort': [4500],'Protocol': 6,'TcpFlags': 16,'CaptureSingleDirectionTrafficOnly': true}]}",
            };
            ArmOperation<string> lro = await virtualNetworkGateway.StartPacketCaptureAsync(WaitUntil.Completed, content: content);
            string result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // Start packet capture on virtual network gateway without filter
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task StartPacketCapture_StartPacketCaptureOnVirtualNetworkGatewayWithoutFilter()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/VirtualNetworkGatewayStartPacketCapture.json
            // this example is just showing the usage of "VirtualNetworkGateways_StartPacketCapture" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this VirtualNetworkGatewayResource created on azure
            // for more information of creating VirtualNetworkGatewayResource, please refer to the document of VirtualNetworkGatewayResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string virtualNetworkGatewayName = "vpngw";
            ResourceIdentifier virtualNetworkGatewayResourceId = VirtualNetworkGatewayResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, virtualNetworkGatewayName);
            VirtualNetworkGatewayResource virtualNetworkGateway = client.GetVirtualNetworkGatewayResource(virtualNetworkGatewayResourceId);

            // invoke the operation
            ArmOperation<string> lro = await virtualNetworkGateway.StartPacketCaptureAsync(WaitUntil.Completed);
            string result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // Stop packet capture on virtual network gateway
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task StopPacketCapture_StopPacketCaptureOnVirtualNetworkGateway()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/VirtualNetworkGatewayStopPacketCapture.json
            // this example is just showing the usage of "VirtualNetworkGateways_StopPacketCapture" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this VirtualNetworkGatewayResource created on azure
            // for more information of creating VirtualNetworkGatewayResource, please refer to the document of VirtualNetworkGatewayResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string virtualNetworkGatewayName = "vpngw";
            ResourceIdentifier virtualNetworkGatewayResourceId = VirtualNetworkGatewayResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, virtualNetworkGatewayName);
            VirtualNetworkGatewayResource virtualNetworkGateway = client.GetVirtualNetworkGatewayResource(virtualNetworkGatewayResourceId);

            // invoke the operation
            VpnPacketCaptureStopContent content = new VpnPacketCaptureStopContent()
            {
                SasUri = new Uri("https://teststorage.blob.core.windows.net/?sv=2018-03-28&ss=bfqt&srt=sco&sp=rwdlacup&se=2019-09-13T07:44:05Z&st=2019-09-06T23:44:05Z&spr=https&sig=V1h9D1riltvZMI69d6ihENnFo%2FrCvTqGgjO2lf%2FVBhE%3D"),
            };
            ArmOperation<string> lro = await virtualNetworkGateway.StopPacketCaptureAsync(WaitUntil.Completed, content);
            string result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // GetVirtualNetworkGatewayVpnclientConnectionHealth
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetVpnclientConnectionHealth_GetVirtualNetworkGatewayVpnclientConnectionHealth()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/VirtualNetworkGatewayGetVpnclientConnectionHealth.json
            // this example is just showing the usage of "VirtualNetworkGateways_GetVpnclientConnectionHealth" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this VirtualNetworkGatewayResource created on azure
            // for more information of creating VirtualNetworkGatewayResource, please refer to the document of VirtualNetworkGatewayResource
            string subscriptionId = "subid";
            string resourceGroupName = "p2s-vnet-test";
            string virtualNetworkGatewayName = "vpnp2sgw";
            ResourceIdentifier virtualNetworkGatewayResourceId = VirtualNetworkGatewayResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, virtualNetworkGatewayName);
            VirtualNetworkGatewayResource virtualNetworkGateway = client.GetVirtualNetworkGatewayResource(virtualNetworkGatewayResourceId);

            // invoke the operation
            ArmOperation<VpnClientConnectionHealthDetailListResult> lro = await virtualNetworkGateway.GetVpnclientConnectionHealthAsync(WaitUntil.Completed);
            VpnClientConnectionHealthDetailListResult result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // Disconnect VpnConnections from Virtual Network Gateway
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task DisconnectVirtualNetworkGatewayVpnConnections_DisconnectVpnConnectionsFromVirtualNetworkGateway()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/VirtualNetworkGatewaysDisconnectP2sVpnConnections.json
            // this example is just showing the usage of "VirtualNetworkGateways_DisconnectVirtualNetworkGatewayVpnConnections" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this VirtualNetworkGatewayResource created on azure
            // for more information of creating VirtualNetworkGatewayResource, please refer to the document of VirtualNetworkGatewayResource
            string subscriptionId = "subid";
            string resourceGroupName = "vpn-gateway-test";
            string virtualNetworkGatewayName = "vpngateway";
            ResourceIdentifier virtualNetworkGatewayResourceId = VirtualNetworkGatewayResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, virtualNetworkGatewayName);
            VirtualNetworkGatewayResource virtualNetworkGateway = client.GetVirtualNetworkGatewayResource(virtualNetworkGatewayResourceId);

            // invoke the operation
            P2SVpnConnectionRequest request = new P2SVpnConnectionRequest()
            {
                VpnConnectionIds =
{
"vpnconnId1","vpnconnId2"
},
            };
            await virtualNetworkGateway.DisconnectVirtualNetworkGatewayVpnConnectionsAsync(WaitUntil.Completed, request);

            Console.WriteLine($"Succeeded");
        }
    }
}
