// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Network.Samples
{
    public partial class Sample_ScopeConnectionResource
    {
        // Create or Update Network Manager Scope Connection
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateOrUpdateNetworkManagerScopeConnection()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/NetworkManagerScopeConnectionPut.json
            // this example is just showing the usage of "ScopeConnections_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ScopeConnectionResource created on azure
            // for more information of creating ScopeConnectionResource, please refer to the document of ScopeConnectionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string networkManagerName = "testNetworkManager";
            string scopeConnectionName = "TestScopeConnection";
            ResourceIdentifier scopeConnectionResourceId = ScopeConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, networkManagerName, scopeConnectionName);
            ScopeConnectionResource scopeConnection = client.GetScopeConnectionResource(scopeConnectionResourceId);

            // invoke the operation
            ScopeConnectionData data = new ScopeConnectionData()
            {
                TenantId = Guid.Parse("6babcaad-604b-40ac-a9d7-9fd97c0b779f"),
                ResourceId = new ResourceIdentifier("subscriptions/f0dc2b34-dfad-40e4-83e0-2309fed8d00b"),
                Description = "This is a scope connection to a cross tenant subscription.",
            };
            ArmOperation<ScopeConnectionResource> lro = await scopeConnection.UpdateAsync(WaitUntil.Completed, data);
            ScopeConnectionResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ScopeConnectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get Network Manager Scope Connection
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetNetworkManagerScopeConnection()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/NetworkManagerScopeConnectionGet.json
            // this example is just showing the usage of "ScopeConnections_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ScopeConnectionResource created on azure
            // for more information of creating ScopeConnectionResource, please refer to the document of ScopeConnectionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string networkManagerName = "testNetworkManager";
            string scopeConnectionName = "TestScopeConnection";
            ResourceIdentifier scopeConnectionResourceId = ScopeConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, networkManagerName, scopeConnectionName);
            ScopeConnectionResource scopeConnection = client.GetScopeConnectionResource(scopeConnectionResourceId);

            // invoke the operation
            ScopeConnectionResource result = await scopeConnection.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ScopeConnectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete Network Manager Scope Connection
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteNetworkManagerScopeConnection()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/NetworkManagerScopeConnectionDelete.json
            // this example is just showing the usage of "ScopeConnections_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ScopeConnectionResource created on azure
            // for more information of creating ScopeConnectionResource, please refer to the document of ScopeConnectionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string networkManagerName = "testNetworkManager";
            string scopeConnectionName = "TestScopeConnection";
            ResourceIdentifier scopeConnectionResourceId = ScopeConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, networkManagerName, scopeConnectionName);
            ScopeConnectionResource scopeConnection = client.GetScopeConnectionResource(scopeConnectionResourceId);

            // invoke the operation
            await scopeConnection.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
