// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Network.Models;

namespace Azure.ResourceManager.Network.Samples
{
    public partial class Sample_RouteFilterRuleResource
    {
        // RouteFilterRuleDelete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_RouteFilterRuleDelete()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/RouteFilterRuleDelete.json
            // this example is just showing the usage of "RouteFilterRules_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RouteFilterRuleResource created on azure
            // for more information of creating RouteFilterRuleResource, please refer to the document of RouteFilterRuleResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string routeFilterName = "filterName";
            string ruleName = "ruleName";
            ResourceIdentifier routeFilterRuleResourceId = RouteFilterRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, routeFilterName, ruleName);
            RouteFilterRuleResource routeFilterRule = client.GetRouteFilterRuleResource(routeFilterRuleResourceId);

            // invoke the operation
            await routeFilterRule.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // RouteFilterRuleGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_RouteFilterRuleGet()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/RouteFilterRuleGet.json
            // this example is just showing the usage of "RouteFilterRules_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RouteFilterRuleResource created on azure
            // for more information of creating RouteFilterRuleResource, please refer to the document of RouteFilterRuleResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string routeFilterName = "filterName";
            string ruleName = "filterName";
            ResourceIdentifier routeFilterRuleResourceId = RouteFilterRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, routeFilterName, ruleName);
            RouteFilterRuleResource routeFilterRule = client.GetRouteFilterRuleResource(routeFilterRuleResourceId);

            // invoke the operation
            RouteFilterRuleResource result = await routeFilterRule.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            RouteFilterRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // RouteFilterRuleCreate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_RouteFilterRuleCreate()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/RouteFilterRuleCreate.json
            // this example is just showing the usage of "RouteFilterRules_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RouteFilterRuleResource created on azure
            // for more information of creating RouteFilterRuleResource, please refer to the document of RouteFilterRuleResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string routeFilterName = "filterName";
            string ruleName = "ruleName";
            ResourceIdentifier routeFilterRuleResourceId = RouteFilterRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, routeFilterName, ruleName);
            RouteFilterRuleResource routeFilterRule = client.GetRouteFilterRuleResource(routeFilterRuleResourceId);

            // invoke the operation
            RouteFilterRuleData data = new RouteFilterRuleData()
            {
                Access = NetworkAccess.Allow,
                RouteFilterRuleType = RouteFilterRuleType.Community,
                Communities =
{
"12076:5030","12076:5040"
},
            };
            ArmOperation<RouteFilterRuleResource> lro = await routeFilterRule.UpdateAsync(WaitUntil.Completed, data);
            RouteFilterRuleResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            RouteFilterRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
