// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Network.Models;

namespace Azure.ResourceManager.Network.Samples
{
    public partial class Sample_RouteFilterRuleCollection
    {
        // RouteFilterRuleGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_RouteFilterRuleGet()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/RouteFilterRuleGet.json
            // this example is just showing the usage of "RouteFilterRules_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RouteFilterResource created on azure
            // for more information of creating RouteFilterResource, please refer to the document of RouteFilterResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string routeFilterName = "filterName";
            ResourceIdentifier routeFilterResourceId = RouteFilterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, routeFilterName);
            RouteFilterResource routeFilter = client.GetRouteFilterResource(routeFilterResourceId);

            // get the collection of this RouteFilterRuleResource
            RouteFilterRuleCollection collection = routeFilter.GetRouteFilterRules();

            // invoke the operation
            string ruleName = "filterName";
            RouteFilterRuleResource result = await collection.GetAsync(ruleName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            RouteFilterRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // RouteFilterRuleGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_RouteFilterRuleGet()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/RouteFilterRuleGet.json
            // this example is just showing the usage of "RouteFilterRules_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RouteFilterResource created on azure
            // for more information of creating RouteFilterResource, please refer to the document of RouteFilterResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string routeFilterName = "filterName";
            ResourceIdentifier routeFilterResourceId = RouteFilterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, routeFilterName);
            RouteFilterResource routeFilter = client.GetRouteFilterResource(routeFilterResourceId);

            // get the collection of this RouteFilterRuleResource
            RouteFilterRuleCollection collection = routeFilter.GetRouteFilterRules();

            // invoke the operation
            string ruleName = "filterName";
            bool result = await collection.ExistsAsync(ruleName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // RouteFilterRuleGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_RouteFilterRuleGet()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/RouteFilterRuleGet.json
            // this example is just showing the usage of "RouteFilterRules_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RouteFilterResource created on azure
            // for more information of creating RouteFilterResource, please refer to the document of RouteFilterResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string routeFilterName = "filterName";
            ResourceIdentifier routeFilterResourceId = RouteFilterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, routeFilterName);
            RouteFilterResource routeFilter = client.GetRouteFilterResource(routeFilterResourceId);

            // get the collection of this RouteFilterRuleResource
            RouteFilterRuleCollection collection = routeFilter.GetRouteFilterRules();

            // invoke the operation
            string ruleName = "filterName";
            NullableResponse<RouteFilterRuleResource> response = await collection.GetIfExistsAsync(ruleName);
            RouteFilterRuleResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                RouteFilterRuleData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // RouteFilterRuleCreate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_RouteFilterRuleCreate()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/RouteFilterRuleCreate.json
            // this example is just showing the usage of "RouteFilterRules_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RouteFilterResource created on azure
            // for more information of creating RouteFilterResource, please refer to the document of RouteFilterResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string routeFilterName = "filterName";
            ResourceIdentifier routeFilterResourceId = RouteFilterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, routeFilterName);
            RouteFilterResource routeFilter = client.GetRouteFilterResource(routeFilterResourceId);

            // get the collection of this RouteFilterRuleResource
            RouteFilterRuleCollection collection = routeFilter.GetRouteFilterRules();

            // invoke the operation
            string ruleName = "ruleName";
            RouteFilterRuleData data = new RouteFilterRuleData()
            {
                Access = NetworkAccess.Allow,
                RouteFilterRuleType = RouteFilterRuleType.Community,
                Communities =
{
"12076:5030","12076:5040"
},
            };
            ArmOperation<RouteFilterRuleResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, ruleName, data);
            RouteFilterRuleResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            RouteFilterRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // RouteFilterRuleListByRouteFilter
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_RouteFilterRuleListByRouteFilter()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/RouteFilterRuleListByRouteFilter.json
            // this example is just showing the usage of "RouteFilterRules_ListByRouteFilter" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RouteFilterResource created on azure
            // for more information of creating RouteFilterResource, please refer to the document of RouteFilterResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string routeFilterName = "filterName";
            ResourceIdentifier routeFilterResourceId = RouteFilterResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, routeFilterName);
            RouteFilterResource routeFilter = client.GetRouteFilterResource(routeFilterResourceId);

            // get the collection of this RouteFilterRuleResource
            RouteFilterRuleCollection collection = routeFilter.GetRouteFilterRules();

            // invoke the operation and iterate over the result
            await foreach (RouteFilterRuleResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                RouteFilterRuleData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
