// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Network.Models;

namespace Azure.ResourceManager.Network.Samples
{
    public partial class Sample_RouteCollection
    {
        // Get route
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetRoute()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/RouteTableRouteGet.json
            // this example is just showing the usage of "Routes_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RouteTableResource created on azure
            // for more information of creating RouteTableResource, please refer to the document of RouteTableResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string routeTableName = "testrt";
            ResourceIdentifier routeTableResourceId = RouteTableResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, routeTableName);
            RouteTableResource routeTable = client.GetRouteTableResource(routeTableResourceId);

            // get the collection of this RouteResource
            RouteCollection collection = routeTable.GetRoutes();

            // invoke the operation
            string routeName = "route1";
            RouteResource result = await collection.GetAsync(routeName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            RouteData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get route
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetRoute()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/RouteTableRouteGet.json
            // this example is just showing the usage of "Routes_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RouteTableResource created on azure
            // for more information of creating RouteTableResource, please refer to the document of RouteTableResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string routeTableName = "testrt";
            ResourceIdentifier routeTableResourceId = RouteTableResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, routeTableName);
            RouteTableResource routeTable = client.GetRouteTableResource(routeTableResourceId);

            // get the collection of this RouteResource
            RouteCollection collection = routeTable.GetRoutes();

            // invoke the operation
            string routeName = "route1";
            bool result = await collection.ExistsAsync(routeName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get route
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetRoute()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/RouteTableRouteGet.json
            // this example is just showing the usage of "Routes_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RouteTableResource created on azure
            // for more information of creating RouteTableResource, please refer to the document of RouteTableResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string routeTableName = "testrt";
            ResourceIdentifier routeTableResourceId = RouteTableResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, routeTableName);
            RouteTableResource routeTable = client.GetRouteTableResource(routeTableResourceId);

            // get the collection of this RouteResource
            RouteCollection collection = routeTable.GetRoutes();

            // invoke the operation
            string routeName = "route1";
            NullableResponse<RouteResource> response = await collection.GetIfExistsAsync(routeName);
            RouteResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                RouteData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Create route
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateRoute()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/RouteTableRouteCreate.json
            // this example is just showing the usage of "Routes_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RouteTableResource created on azure
            // for more information of creating RouteTableResource, please refer to the document of RouteTableResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string routeTableName = "testrt";
            ResourceIdentifier routeTableResourceId = RouteTableResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, routeTableName);
            RouteTableResource routeTable = client.GetRouteTableResource(routeTableResourceId);

            // get the collection of this RouteResource
            RouteCollection collection = routeTable.GetRoutes();

            // invoke the operation
            string routeName = "route1";
            RouteData data = new RouteData()
            {
                AddressPrefix = "10.0.3.0/24",
                NextHopType = RouteNextHopType.VirtualNetworkGateway,
            };
            ArmOperation<RouteResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, routeName, data);
            RouteResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            RouteData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // List routes
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListRoutes()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/RouteTableRouteList.json
            // this example is just showing the usage of "Routes_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RouteTableResource created on azure
            // for more information of creating RouteTableResource, please refer to the document of RouteTableResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string routeTableName = "testrt";
            ResourceIdentifier routeTableResourceId = RouteTableResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, routeTableName);
            RouteTableResource routeTable = client.GetRouteTableResource(routeTableResourceId);

            // get the collection of this RouteResource
            RouteCollection collection = routeTable.GetRoutes();

            // invoke the operation and iterate over the result
            await foreach (RouteResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                RouteData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
