// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Network.Models;

namespace Azure.ResourceManager.Network.Samples
{
    public partial class Sample_PrivateDnsZoneGroupCollection
    {
        // Get private dns zone group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetPrivateDnsZoneGroup()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/PrivateEndpointDnsZoneGroupGet.json
            // this example is just showing the usage of "PrivateDnsZoneGroups_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateEndpointResource created on azure
            // for more information of creating PrivateEndpointResource, please refer to the document of PrivateEndpointResource
            string subscriptionId = "subId";
            string resourceGroupName = "rg1";
            string privateEndpointName = "testPe";
            ResourceIdentifier privateEndpointResourceId = PrivateEndpointResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, privateEndpointName);
            PrivateEndpointResource privateEndpoint = client.GetPrivateEndpointResource(privateEndpointResourceId);

            // get the collection of this PrivateDnsZoneGroupResource
            PrivateDnsZoneGroupCollection collection = privateEndpoint.GetPrivateDnsZoneGroups();

            // invoke the operation
            string privateDnsZoneGroupName = "testPdnsgroup";
            PrivateDnsZoneGroupResource result = await collection.GetAsync(privateDnsZoneGroupName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PrivateDnsZoneGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get private dns zone group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetPrivateDnsZoneGroup()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/PrivateEndpointDnsZoneGroupGet.json
            // this example is just showing the usage of "PrivateDnsZoneGroups_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateEndpointResource created on azure
            // for more information of creating PrivateEndpointResource, please refer to the document of PrivateEndpointResource
            string subscriptionId = "subId";
            string resourceGroupName = "rg1";
            string privateEndpointName = "testPe";
            ResourceIdentifier privateEndpointResourceId = PrivateEndpointResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, privateEndpointName);
            PrivateEndpointResource privateEndpoint = client.GetPrivateEndpointResource(privateEndpointResourceId);

            // get the collection of this PrivateDnsZoneGroupResource
            PrivateDnsZoneGroupCollection collection = privateEndpoint.GetPrivateDnsZoneGroups();

            // invoke the operation
            string privateDnsZoneGroupName = "testPdnsgroup";
            bool result = await collection.ExistsAsync(privateDnsZoneGroupName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get private dns zone group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetPrivateDnsZoneGroup()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/PrivateEndpointDnsZoneGroupGet.json
            // this example is just showing the usage of "PrivateDnsZoneGroups_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateEndpointResource created on azure
            // for more information of creating PrivateEndpointResource, please refer to the document of PrivateEndpointResource
            string subscriptionId = "subId";
            string resourceGroupName = "rg1";
            string privateEndpointName = "testPe";
            ResourceIdentifier privateEndpointResourceId = PrivateEndpointResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, privateEndpointName);
            PrivateEndpointResource privateEndpoint = client.GetPrivateEndpointResource(privateEndpointResourceId);

            // get the collection of this PrivateDnsZoneGroupResource
            PrivateDnsZoneGroupCollection collection = privateEndpoint.GetPrivateDnsZoneGroups();

            // invoke the operation
            string privateDnsZoneGroupName = "testPdnsgroup";
            NullableResponse<PrivateDnsZoneGroupResource> response = await collection.GetIfExistsAsync(privateDnsZoneGroupName);
            PrivateDnsZoneGroupResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                PrivateDnsZoneGroupData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Create private dns zone group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreatePrivateDnsZoneGroup()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/PrivateEndpointDnsZoneGroupCreate.json
            // this example is just showing the usage of "PrivateDnsZoneGroups_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateEndpointResource created on azure
            // for more information of creating PrivateEndpointResource, please refer to the document of PrivateEndpointResource
            string subscriptionId = "subId";
            string resourceGroupName = "rg1";
            string privateEndpointName = "testPe";
            ResourceIdentifier privateEndpointResourceId = PrivateEndpointResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, privateEndpointName);
            PrivateEndpointResource privateEndpoint = client.GetPrivateEndpointResource(privateEndpointResourceId);

            // get the collection of this PrivateDnsZoneGroupResource
            PrivateDnsZoneGroupCollection collection = privateEndpoint.GetPrivateDnsZoneGroups();

            // invoke the operation
            string privateDnsZoneGroupName = "testPdnsgroup";
            PrivateDnsZoneGroupData data = new PrivateDnsZoneGroupData()
            {
                PrivateDnsZoneConfigs =
{
new PrivateDnsZoneConfig()
{
PrivateDnsZoneId = "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateDnsZones/zone1.com",
}
},
            };
            ArmOperation<PrivateDnsZoneGroupResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, privateDnsZoneGroupName, data);
            PrivateDnsZoneGroupResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PrivateDnsZoneGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // List private endpoints in resource group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListPrivateEndpointsInResourceGroup()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/PrivateEndpointDnsZoneGroupList.json
            // this example is just showing the usage of "PrivateDnsZoneGroups_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateEndpointResource created on azure
            // for more information of creating PrivateEndpointResource, please refer to the document of PrivateEndpointResource
            string subscriptionId = "subId";
            string resourceGroupName = "rg1";
            string privateEndpointName = "testPe";
            ResourceIdentifier privateEndpointResourceId = PrivateEndpointResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, privateEndpointName);
            PrivateEndpointResource privateEndpoint = client.GetPrivateEndpointResource(privateEndpointResourceId);

            // get the collection of this PrivateDnsZoneGroupResource
            PrivateDnsZoneGroupCollection collection = privateEndpoint.GetPrivateDnsZoneGroups();

            // invoke the operation and iterate over the result
            await foreach (PrivateDnsZoneGroupResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                PrivateDnsZoneGroupData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
