// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Network.Samples
{
    public partial class Sample_PeerExpressRouteCircuitConnectionResource
    {
        // PeerExpressRouteCircuitConnectionGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_PeerExpressRouteCircuitConnectionGet()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/PeerExpressRouteCircuitConnectionGet.json
            // this example is just showing the usage of "PeerExpressRouteCircuitConnections_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PeerExpressRouteCircuitConnectionResource created on azure
            // for more information of creating PeerExpressRouteCircuitConnectionResource, please refer to the document of PeerExpressRouteCircuitConnectionResource
            string subscriptionId = "subid1";
            string resourceGroupName = "rg1";
            string circuitName = "ExpressRouteARMCircuitA";
            string peeringName = "AzurePrivatePeering";
            string connectionName = "60aee347-e889-4a42-8c1b-0aae8b1e4013";
            ResourceIdentifier peerExpressRouteCircuitConnectionResourceId = PeerExpressRouteCircuitConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, circuitName, peeringName, connectionName);
            PeerExpressRouteCircuitConnectionResource peerExpressRouteCircuitConnection = client.GetPeerExpressRouteCircuitConnectionResource(peerExpressRouteCircuitConnectionResourceId);

            // invoke the operation
            PeerExpressRouteCircuitConnectionResource result = await peerExpressRouteCircuitConnection.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PeerExpressRouteCircuitConnectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
