// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Network.Samples
{
    public partial class Sample_PeerExpressRouteCircuitConnectionCollection
    {
        // PeerExpressRouteCircuitConnectionGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_PeerExpressRouteCircuitConnectionGet()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/PeerExpressRouteCircuitConnectionGet.json
            // this example is just showing the usage of "PeerExpressRouteCircuitConnections_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ExpressRouteCircuitPeeringResource created on azure
            // for more information of creating ExpressRouteCircuitPeeringResource, please refer to the document of ExpressRouteCircuitPeeringResource
            string subscriptionId = "subid1";
            string resourceGroupName = "rg1";
            string circuitName = "ExpressRouteARMCircuitA";
            string peeringName = "AzurePrivatePeering";
            ResourceIdentifier expressRouteCircuitPeeringResourceId = ExpressRouteCircuitPeeringResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, circuitName, peeringName);
            ExpressRouteCircuitPeeringResource expressRouteCircuitPeering = client.GetExpressRouteCircuitPeeringResource(expressRouteCircuitPeeringResourceId);

            // get the collection of this PeerExpressRouteCircuitConnectionResource
            PeerExpressRouteCircuitConnectionCollection collection = expressRouteCircuitPeering.GetPeerExpressRouteCircuitConnections();

            // invoke the operation
            string connectionName = "60aee347-e889-4a42-8c1b-0aae8b1e4013";
            PeerExpressRouteCircuitConnectionResource result = await collection.GetAsync(connectionName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PeerExpressRouteCircuitConnectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // PeerExpressRouteCircuitConnectionGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_PeerExpressRouteCircuitConnectionGet()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/PeerExpressRouteCircuitConnectionGet.json
            // this example is just showing the usage of "PeerExpressRouteCircuitConnections_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ExpressRouteCircuitPeeringResource created on azure
            // for more information of creating ExpressRouteCircuitPeeringResource, please refer to the document of ExpressRouteCircuitPeeringResource
            string subscriptionId = "subid1";
            string resourceGroupName = "rg1";
            string circuitName = "ExpressRouteARMCircuitA";
            string peeringName = "AzurePrivatePeering";
            ResourceIdentifier expressRouteCircuitPeeringResourceId = ExpressRouteCircuitPeeringResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, circuitName, peeringName);
            ExpressRouteCircuitPeeringResource expressRouteCircuitPeering = client.GetExpressRouteCircuitPeeringResource(expressRouteCircuitPeeringResourceId);

            // get the collection of this PeerExpressRouteCircuitConnectionResource
            PeerExpressRouteCircuitConnectionCollection collection = expressRouteCircuitPeering.GetPeerExpressRouteCircuitConnections();

            // invoke the operation
            string connectionName = "60aee347-e889-4a42-8c1b-0aae8b1e4013";
            bool result = await collection.ExistsAsync(connectionName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // PeerExpressRouteCircuitConnectionGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_PeerExpressRouteCircuitConnectionGet()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/PeerExpressRouteCircuitConnectionGet.json
            // this example is just showing the usage of "PeerExpressRouteCircuitConnections_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ExpressRouteCircuitPeeringResource created on azure
            // for more information of creating ExpressRouteCircuitPeeringResource, please refer to the document of ExpressRouteCircuitPeeringResource
            string subscriptionId = "subid1";
            string resourceGroupName = "rg1";
            string circuitName = "ExpressRouteARMCircuitA";
            string peeringName = "AzurePrivatePeering";
            ResourceIdentifier expressRouteCircuitPeeringResourceId = ExpressRouteCircuitPeeringResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, circuitName, peeringName);
            ExpressRouteCircuitPeeringResource expressRouteCircuitPeering = client.GetExpressRouteCircuitPeeringResource(expressRouteCircuitPeeringResourceId);

            // get the collection of this PeerExpressRouteCircuitConnectionResource
            PeerExpressRouteCircuitConnectionCollection collection = expressRouteCircuitPeering.GetPeerExpressRouteCircuitConnections();

            // invoke the operation
            string connectionName = "60aee347-e889-4a42-8c1b-0aae8b1e4013";
            NullableResponse<PeerExpressRouteCircuitConnectionResource> response = await collection.GetIfExistsAsync(connectionName);
            PeerExpressRouteCircuitConnectionResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                PeerExpressRouteCircuitConnectionData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // List Peer ExpressRouteCircuit Connection
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListPeerExpressRouteCircuitConnection()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/PeerExpressRouteCircuitConnectionList.json
            // this example is just showing the usage of "PeerExpressRouteCircuitConnections_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ExpressRouteCircuitPeeringResource created on azure
            // for more information of creating ExpressRouteCircuitPeeringResource, please refer to the document of ExpressRouteCircuitPeeringResource
            string subscriptionId = "subid1";
            string resourceGroupName = "rg1";
            string circuitName = "ExpressRouteARMCircuitA";
            string peeringName = "AzurePrivatePeering";
            ResourceIdentifier expressRouteCircuitPeeringResourceId = ExpressRouteCircuitPeeringResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, circuitName, peeringName);
            ExpressRouteCircuitPeeringResource expressRouteCircuitPeering = client.GetExpressRouteCircuitPeeringResource(expressRouteCircuitPeeringResourceId);

            // get the collection of this PeerExpressRouteCircuitConnectionResource
            PeerExpressRouteCircuitConnectionCollection collection = expressRouteCircuitPeering.GetPeerExpressRouteCircuitConnections();

            // invoke the operation and iterate over the result
            await foreach (PeerExpressRouteCircuitConnectionResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                PeerExpressRouteCircuitConnectionData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
