// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Network.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.Network.Samples
{
    public partial class Sample_NetworkProfileResource
    {
        // Delete network profile
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteNetworkProfile()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/NetworkProfileDelete.json
            // this example is just showing the usage of "NetworkProfiles_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this NetworkProfileResource created on azure
            // for more information of creating NetworkProfileResource, please refer to the document of NetworkProfileResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string networkProfileName = "networkProfile1";
            ResourceIdentifier networkProfileResourceId = NetworkProfileResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, networkProfileName);
            NetworkProfileResource networkProfile = client.GetNetworkProfileResource(networkProfileResourceId);

            // invoke the operation
            await networkProfile.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Get network profile
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetNetworkProfile()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/NetworkProfileGetConfigOnly.json
            // this example is just showing the usage of "NetworkProfiles_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this NetworkProfileResource created on azure
            // for more information of creating NetworkProfileResource, please refer to the document of NetworkProfileResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string networkProfileName = "networkProfile1";
            ResourceIdentifier networkProfileResourceId = NetworkProfileResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, networkProfileName);
            NetworkProfileResource networkProfile = client.GetNetworkProfileResource(networkProfileResourceId);

            // invoke the operation
            NetworkProfileResource result = await networkProfile.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            NetworkProfileData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get network profile with container network interfaces
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetNetworkProfileWithContainerNetworkInterfaces()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/NetworkProfileGetWithContainerNic.json
            // this example is just showing the usage of "NetworkProfiles_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this NetworkProfileResource created on azure
            // for more information of creating NetworkProfileResource, please refer to the document of NetworkProfileResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string networkProfileName = "networkProfile1";
            ResourceIdentifier networkProfileResourceId = NetworkProfileResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, networkProfileName);
            NetworkProfileResource networkProfile = client.GetNetworkProfileResource(networkProfileResourceId);

            // invoke the operation
            NetworkProfileResource result = await networkProfile.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            NetworkProfileData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update network profile tags
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateNetworkProfileTags()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/NetworkProfileUpdateTags.json
            // this example is just showing the usage of "NetworkProfiles_UpdateTags" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this NetworkProfileResource created on azure
            // for more information of creating NetworkProfileResource, please refer to the document of NetworkProfileResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string networkProfileName = "test-np";
            ResourceIdentifier networkProfileResourceId = NetworkProfileResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, networkProfileName);
            NetworkProfileResource networkProfile = client.GetNetworkProfileResource(networkProfileResourceId);

            // invoke the operation
            NetworkTagsObject networkTagsObject = new NetworkTagsObject()
            {
                Tags =
{
["tag1"] = "value1",
["tag2"] = "value2",
},
            };
            NetworkProfileResource result = await networkProfile.UpdateAsync(networkTagsObject);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            NetworkProfileData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // List all network profiles
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetNetworkProfiles_ListAllNetworkProfiles()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/NetworkProfileListAll.json
            // this example is just showing the usage of "NetworkProfiles_ListAll" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "subid";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (NetworkProfileResource item in subscriptionResource.GetNetworkProfilesAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                NetworkProfileData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
