// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Network.Models;

namespace Azure.ResourceManager.Network.Samples
{
    public partial class Sample_NetworkPrivateEndpointConnectionResource
    {
        // Get private end point connection
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetPrivateEndPointConnection()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/PrivateLinkServiceGetPrivateEndpointConnection.json
            // this example is just showing the usage of "PrivateLinkServices_GetPrivateEndpointConnection" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this NetworkPrivateEndpointConnectionResource created on azure
            // for more information of creating NetworkPrivateEndpointConnectionResource, please refer to the document of NetworkPrivateEndpointConnectionResource
            string subscriptionId = "subId";
            string resourceGroupName = "rg1";
            string serviceName = "testPls";
            string peConnectionName = "testPlePeConnection";
            ResourceIdentifier networkPrivateEndpointConnectionResourceId = NetworkPrivateEndpointConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, peConnectionName);
            NetworkPrivateEndpointConnectionResource networkPrivateEndpointConnection = client.GetNetworkPrivateEndpointConnectionResource(networkPrivateEndpointConnectionResourceId);

            // invoke the operation
            NetworkPrivateEndpointConnectionResource result = await networkPrivateEndpointConnection.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            NetworkPrivateEndpointConnectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // approve or reject private end point connection for a private link service
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ApproveOrRejectPrivateEndPointConnectionForAPrivateLinkService()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/PrivateLinkServiceUpdatePrivateEndpointConnection.json
            // this example is just showing the usage of "PrivateLinkServices_UpdatePrivateEndpointConnection" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this NetworkPrivateEndpointConnectionResource created on azure
            // for more information of creating NetworkPrivateEndpointConnectionResource, please refer to the document of NetworkPrivateEndpointConnectionResource
            string subscriptionId = "subId";
            string resourceGroupName = "rg1";
            string serviceName = "testPls";
            string peConnectionName = "testPlePeConnection";
            ResourceIdentifier networkPrivateEndpointConnectionResourceId = NetworkPrivateEndpointConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, peConnectionName);
            NetworkPrivateEndpointConnectionResource networkPrivateEndpointConnection = client.GetNetworkPrivateEndpointConnectionResource(networkPrivateEndpointConnectionResourceId);

            // invoke the operation
            NetworkPrivateEndpointConnectionData data = new NetworkPrivateEndpointConnectionData()
            {
                ConnectionState = new NetworkPrivateLinkServiceConnectionState()
                {
                    Status = "Approved",
                    Description = "approved it for some reason.",
                },
                Name = "testPlePeConnection",
            };
            ArmOperation<NetworkPrivateEndpointConnectionResource> lro = await networkPrivateEndpointConnection.UpdateAsync(WaitUntil.Completed, data);
            NetworkPrivateEndpointConnectionResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            NetworkPrivateEndpointConnectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // delete private end point connection for a private link service
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeletePrivateEndPointConnectionForAPrivateLinkService()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/PrivateLinkServiceDeletePrivateEndpointConnection.json
            // this example is just showing the usage of "PrivateLinkServices_DeletePrivateEndpointConnection" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this NetworkPrivateEndpointConnectionResource created on azure
            // for more information of creating NetworkPrivateEndpointConnectionResource, please refer to the document of NetworkPrivateEndpointConnectionResource
            string subscriptionId = "subId";
            string resourceGroupName = "rg1";
            string serviceName = "testPls";
            string peConnectionName = "testPlePeConnection";
            ResourceIdentifier networkPrivateEndpointConnectionResourceId = NetworkPrivateEndpointConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, peConnectionName);
            NetworkPrivateEndpointConnectionResource networkPrivateEndpointConnection = client.GetNetworkPrivateEndpointConnectionResource(networkPrivateEndpointConnectionResourceId);

            // invoke the operation
            await networkPrivateEndpointConnection.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
