// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Network.Models;

namespace Azure.ResourceManager.Network.Samples
{
    public partial class Sample_NetworkPrivateEndpointConnectionCollection
    {
        // Get private end point connection
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetPrivateEndPointConnection()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/PrivateLinkServiceGetPrivateEndpointConnection.json
            // this example is just showing the usage of "PrivateLinkServices_GetPrivateEndpointConnection" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateLinkServiceResource created on azure
            // for more information of creating PrivateLinkServiceResource, please refer to the document of PrivateLinkServiceResource
            string subscriptionId = "subId";
            string resourceGroupName = "rg1";
            string serviceName = "testPls";
            ResourceIdentifier privateLinkServiceResourceId = PrivateLinkServiceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName);
            PrivateLinkServiceResource privateLinkService = client.GetPrivateLinkServiceResource(privateLinkServiceResourceId);

            // get the collection of this NetworkPrivateEndpointConnectionResource
            NetworkPrivateEndpointConnectionCollection collection = privateLinkService.GetNetworkPrivateEndpointConnections();

            // invoke the operation
            string peConnectionName = "testPlePeConnection";
            NetworkPrivateEndpointConnectionResource result = await collection.GetAsync(peConnectionName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            NetworkPrivateEndpointConnectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get private end point connection
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetPrivateEndPointConnection()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/PrivateLinkServiceGetPrivateEndpointConnection.json
            // this example is just showing the usage of "PrivateLinkServices_GetPrivateEndpointConnection" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateLinkServiceResource created on azure
            // for more information of creating PrivateLinkServiceResource, please refer to the document of PrivateLinkServiceResource
            string subscriptionId = "subId";
            string resourceGroupName = "rg1";
            string serviceName = "testPls";
            ResourceIdentifier privateLinkServiceResourceId = PrivateLinkServiceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName);
            PrivateLinkServiceResource privateLinkService = client.GetPrivateLinkServiceResource(privateLinkServiceResourceId);

            // get the collection of this NetworkPrivateEndpointConnectionResource
            NetworkPrivateEndpointConnectionCollection collection = privateLinkService.GetNetworkPrivateEndpointConnections();

            // invoke the operation
            string peConnectionName = "testPlePeConnection";
            bool result = await collection.ExistsAsync(peConnectionName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get private end point connection
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetPrivateEndPointConnection()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/PrivateLinkServiceGetPrivateEndpointConnection.json
            // this example is just showing the usage of "PrivateLinkServices_GetPrivateEndpointConnection" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateLinkServiceResource created on azure
            // for more information of creating PrivateLinkServiceResource, please refer to the document of PrivateLinkServiceResource
            string subscriptionId = "subId";
            string resourceGroupName = "rg1";
            string serviceName = "testPls";
            ResourceIdentifier privateLinkServiceResourceId = PrivateLinkServiceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName);
            PrivateLinkServiceResource privateLinkService = client.GetPrivateLinkServiceResource(privateLinkServiceResourceId);

            // get the collection of this NetworkPrivateEndpointConnectionResource
            NetworkPrivateEndpointConnectionCollection collection = privateLinkService.GetNetworkPrivateEndpointConnections();

            // invoke the operation
            string peConnectionName = "testPlePeConnection";
            NullableResponse<NetworkPrivateEndpointConnectionResource> response = await collection.GetIfExistsAsync(peConnectionName);
            NetworkPrivateEndpointConnectionResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                NetworkPrivateEndpointConnectionData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // approve or reject private end point connection for a private link service
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_ApproveOrRejectPrivateEndPointConnectionForAPrivateLinkService()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/PrivateLinkServiceUpdatePrivateEndpointConnection.json
            // this example is just showing the usage of "PrivateLinkServices_UpdatePrivateEndpointConnection" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateLinkServiceResource created on azure
            // for more information of creating PrivateLinkServiceResource, please refer to the document of PrivateLinkServiceResource
            string subscriptionId = "subId";
            string resourceGroupName = "rg1";
            string serviceName = "testPls";
            ResourceIdentifier privateLinkServiceResourceId = PrivateLinkServiceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName);
            PrivateLinkServiceResource privateLinkService = client.GetPrivateLinkServiceResource(privateLinkServiceResourceId);

            // get the collection of this NetworkPrivateEndpointConnectionResource
            NetworkPrivateEndpointConnectionCollection collection = privateLinkService.GetNetworkPrivateEndpointConnections();

            // invoke the operation
            string peConnectionName = "testPlePeConnection";
            NetworkPrivateEndpointConnectionData data = new NetworkPrivateEndpointConnectionData()
            {
                ConnectionState = new NetworkPrivateLinkServiceConnectionState()
                {
                    Status = "Approved",
                    Description = "approved it for some reason.",
                },
                Name = "testPlePeConnection",
            };
            ArmOperation<NetworkPrivateEndpointConnectionResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, peConnectionName, data);
            NetworkPrivateEndpointConnectionResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            NetworkPrivateEndpointConnectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // List private link service in resource group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListPrivateLinkServiceInResourceGroup()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/PrivateLinkServiceListPrivateEndpointConnection.json
            // this example is just showing the usage of "PrivateLinkServices_ListPrivateEndpointConnections" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateLinkServiceResource created on azure
            // for more information of creating PrivateLinkServiceResource, please refer to the document of PrivateLinkServiceResource
            string subscriptionId = "subId";
            string resourceGroupName = "rg1";
            string serviceName = "testPls";
            ResourceIdentifier privateLinkServiceResourceId = PrivateLinkServiceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName);
            PrivateLinkServiceResource privateLinkService = client.GetPrivateLinkServiceResource(privateLinkServiceResourceId);

            // get the collection of this NetworkPrivateEndpointConnectionResource
            NetworkPrivateEndpointConnectionCollection collection = privateLinkService.GetNetworkPrivateEndpointConnections();

            // invoke the operation and iterate over the result
            await foreach (NetworkPrivateEndpointConnectionResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                NetworkPrivateEndpointConnectionData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
