// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Network.Models;

namespace Azure.ResourceManager.Network.Samples
{
    public partial class Sample_NetworkManagerSecurityUserRulesResource
    {
        // Gets security user rule collection
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsSecurityUserRuleCollection()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/NetworkManagerSecurityUserRuleCollectionGet.json
            // this example is just showing the usage of "SecurityUserRuleCollections_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this NetworkManagerSecurityUserRulesResource created on azure
            // for more information of creating NetworkManagerSecurityUserRulesResource, please refer to the document of NetworkManagerSecurityUserRulesResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string networkManagerName = "testNetworkManager";
            string configurationName = "myTestSecurityConfig";
            string ruleCollectionName = "testRuleCollection";
            ResourceIdentifier networkManagerSecurityUserRulesResourceId = NetworkManagerSecurityUserRulesResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, networkManagerName, configurationName, ruleCollectionName);
            NetworkManagerSecurityUserRulesResource networkManagerSecurityUserRules = client.GetNetworkManagerSecurityUserRulesResource(networkManagerSecurityUserRulesResourceId);

            // invoke the operation
            NetworkManagerSecurityUserRulesResource result = await networkManagerSecurityUserRules.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            NetworkManagerSecurityUserRulesData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or Update a Security User Rule Collection
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateOrUpdateASecurityUserRuleCollection()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/NetworkManagerSecurityUserRuleCollectionPut.json
            // this example is just showing the usage of "SecurityUserRuleCollections_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this NetworkManagerSecurityUserRulesResource created on azure
            // for more information of creating NetworkManagerSecurityUserRulesResource, please refer to the document of NetworkManagerSecurityUserRulesResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string networkManagerName = "testNetworkManager";
            string configurationName = "myTestSecurityConfig";
            string ruleCollectionName = "testRuleCollection";
            ResourceIdentifier networkManagerSecurityUserRulesResourceId = NetworkManagerSecurityUserRulesResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, networkManagerName, configurationName, ruleCollectionName);
            NetworkManagerSecurityUserRulesResource networkManagerSecurityUserRules = client.GetNetworkManagerSecurityUserRulesResource(networkManagerSecurityUserRulesResourceId);

            // invoke the operation
            NetworkManagerSecurityUserRulesData data = new NetworkManagerSecurityUserRulesData()
            {
                Description = "A sample policy",
                AppliesToGroups =
{
new SecurityUserGroupItem("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/networkManagers/testNetworkManager/networkGroups/testGroup")
},
            };
            ArmOperation<NetworkManagerSecurityUserRulesResource> lro = await networkManagerSecurityUserRules.UpdateAsync(WaitUntil.Completed, data);
            NetworkManagerSecurityUserRulesResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            NetworkManagerSecurityUserRulesData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Deletes a Security User Rule collection
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeletesASecurityUserRuleCollection()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/NetworkManagerSecurityUserRuleCollectionDelete.json
            // this example is just showing the usage of "SecurityUserRuleCollections_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this NetworkManagerSecurityUserRulesResource created on azure
            // for more information of creating NetworkManagerSecurityUserRulesResource, please refer to the document of NetworkManagerSecurityUserRulesResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string networkManagerName = "testNetworkManager";
            string configurationName = "myTestSecurityConfig";
            string ruleCollectionName = "testRuleCollection";
            ResourceIdentifier networkManagerSecurityUserRulesResourceId = NetworkManagerSecurityUserRulesResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, networkManagerName, configurationName, ruleCollectionName);
            NetworkManagerSecurityUserRulesResource networkManagerSecurityUserRules = client.GetNetworkManagerSecurityUserRulesResource(networkManagerSecurityUserRulesResourceId);

            // invoke the operation
            bool? force = false;
            await networkManagerSecurityUserRules.DeleteAsync(WaitUntil.Completed, force: force);

            Console.WriteLine($"Succeeded");
        }
    }
}
