// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Network.Samples
{
    public partial class Sample_ExpressRouteCircuitPeeringCollection
    {
        // Get ExpressRouteCircuit Peering
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetExpressRouteCircuitPeering()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/ExpressRouteCircuitPeeringGet.json
            // this example is just showing the usage of "ExpressRouteCircuitPeerings_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ExpressRouteCircuitResource created on azure
            // for more information of creating ExpressRouteCircuitResource, please refer to the document of ExpressRouteCircuitResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string circuitName = "circuitName";
            ResourceIdentifier expressRouteCircuitResourceId = ExpressRouteCircuitResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, circuitName);
            ExpressRouteCircuitResource expressRouteCircuit = client.GetExpressRouteCircuitResource(expressRouteCircuitResourceId);

            // get the collection of this ExpressRouteCircuitPeeringResource
            ExpressRouteCircuitPeeringCollection collection = expressRouteCircuit.GetExpressRouteCircuitPeerings();

            // invoke the operation
            string peeringName = "MicrosoftPeering";
            ExpressRouteCircuitPeeringResource result = await collection.GetAsync(peeringName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ExpressRouteCircuitPeeringData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get ExpressRouteCircuit Peering
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetExpressRouteCircuitPeering()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/ExpressRouteCircuitPeeringGet.json
            // this example is just showing the usage of "ExpressRouteCircuitPeerings_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ExpressRouteCircuitResource created on azure
            // for more information of creating ExpressRouteCircuitResource, please refer to the document of ExpressRouteCircuitResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string circuitName = "circuitName";
            ResourceIdentifier expressRouteCircuitResourceId = ExpressRouteCircuitResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, circuitName);
            ExpressRouteCircuitResource expressRouteCircuit = client.GetExpressRouteCircuitResource(expressRouteCircuitResourceId);

            // get the collection of this ExpressRouteCircuitPeeringResource
            ExpressRouteCircuitPeeringCollection collection = expressRouteCircuit.GetExpressRouteCircuitPeerings();

            // invoke the operation
            string peeringName = "MicrosoftPeering";
            bool result = await collection.ExistsAsync(peeringName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get ExpressRouteCircuit Peering
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetExpressRouteCircuitPeering()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/ExpressRouteCircuitPeeringGet.json
            // this example is just showing the usage of "ExpressRouteCircuitPeerings_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ExpressRouteCircuitResource created on azure
            // for more information of creating ExpressRouteCircuitResource, please refer to the document of ExpressRouteCircuitResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string circuitName = "circuitName";
            ResourceIdentifier expressRouteCircuitResourceId = ExpressRouteCircuitResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, circuitName);
            ExpressRouteCircuitResource expressRouteCircuit = client.GetExpressRouteCircuitResource(expressRouteCircuitResourceId);

            // get the collection of this ExpressRouteCircuitPeeringResource
            ExpressRouteCircuitPeeringCollection collection = expressRouteCircuit.GetExpressRouteCircuitPeerings();

            // invoke the operation
            string peeringName = "MicrosoftPeering";
            NullableResponse<ExpressRouteCircuitPeeringResource> response = await collection.GetIfExistsAsync(peeringName);
            ExpressRouteCircuitPeeringResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ExpressRouteCircuitPeeringData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Create ExpressRouteCircuit Peerings
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateExpressRouteCircuitPeerings()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/ExpressRouteCircuitPeeringCreate.json
            // this example is just showing the usage of "ExpressRouteCircuitPeerings_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ExpressRouteCircuitResource created on azure
            // for more information of creating ExpressRouteCircuitResource, please refer to the document of ExpressRouteCircuitResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string circuitName = "circuitName";
            ResourceIdentifier expressRouteCircuitResourceId = ExpressRouteCircuitResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, circuitName);
            ExpressRouteCircuitResource expressRouteCircuit = client.GetExpressRouteCircuitResource(expressRouteCircuitResourceId);

            // get the collection of this ExpressRouteCircuitPeeringResource
            ExpressRouteCircuitPeeringCollection collection = expressRouteCircuit.GetExpressRouteCircuitPeerings();

            // invoke the operation
            string peeringName = "AzurePrivatePeering";
            ExpressRouteCircuitPeeringData data = new ExpressRouteCircuitPeeringData()
            {
                PeerASN = 200L,
                PrimaryPeerAddressPrefix = "192.168.16.252/30",
                SecondaryPeerAddressPrefix = "192.168.18.252/30",
                VlanId = 200,
            };
            ArmOperation<ExpressRouteCircuitPeeringResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, peeringName, data);
            ExpressRouteCircuitPeeringResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ExpressRouteCircuitPeeringData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // List ExpressRouteCircuit Peerings
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListExpressRouteCircuitPeerings()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/ExpressRouteCircuitPeeringList.json
            // this example is just showing the usage of "ExpressRouteCircuitPeerings_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ExpressRouteCircuitResource created on azure
            // for more information of creating ExpressRouteCircuitResource, please refer to the document of ExpressRouteCircuitResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string circuitName = "circuitName";
            ResourceIdentifier expressRouteCircuitResourceId = ExpressRouteCircuitResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, circuitName);
            ExpressRouteCircuitResource expressRouteCircuit = client.GetExpressRouteCircuitResource(expressRouteCircuitResourceId);

            // get the collection of this ExpressRouteCircuitPeeringResource
            ExpressRouteCircuitPeeringCollection collection = expressRouteCircuit.GetExpressRouteCircuitPeerings();

            // invoke the operation and iterate over the result
            await foreach (ExpressRouteCircuitPeeringResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ExpressRouteCircuitPeeringData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
