// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Network.Samples
{
    public partial class Sample_ExpressRouteCircuitAuthorizationCollection
    {
        // Get ExpressRouteCircuit Authorization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetExpressRouteCircuitAuthorization()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/ExpressRouteCircuitAuthorizationGet.json
            // this example is just showing the usage of "ExpressRouteCircuitAuthorizations_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ExpressRouteCircuitResource created on azure
            // for more information of creating ExpressRouteCircuitResource, please refer to the document of ExpressRouteCircuitResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string circuitName = "circuitName";
            ResourceIdentifier expressRouteCircuitResourceId = ExpressRouteCircuitResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, circuitName);
            ExpressRouteCircuitResource expressRouteCircuit = client.GetExpressRouteCircuitResource(expressRouteCircuitResourceId);

            // get the collection of this ExpressRouteCircuitAuthorizationResource
            ExpressRouteCircuitAuthorizationCollection collection = expressRouteCircuit.GetExpressRouteCircuitAuthorizations();

            // invoke the operation
            string authorizationName = "authorizationName";
            ExpressRouteCircuitAuthorizationResource result = await collection.GetAsync(authorizationName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ExpressRouteCircuitAuthorizationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get ExpressRouteCircuit Authorization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetExpressRouteCircuitAuthorization()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/ExpressRouteCircuitAuthorizationGet.json
            // this example is just showing the usage of "ExpressRouteCircuitAuthorizations_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ExpressRouteCircuitResource created on azure
            // for more information of creating ExpressRouteCircuitResource, please refer to the document of ExpressRouteCircuitResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string circuitName = "circuitName";
            ResourceIdentifier expressRouteCircuitResourceId = ExpressRouteCircuitResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, circuitName);
            ExpressRouteCircuitResource expressRouteCircuit = client.GetExpressRouteCircuitResource(expressRouteCircuitResourceId);

            // get the collection of this ExpressRouteCircuitAuthorizationResource
            ExpressRouteCircuitAuthorizationCollection collection = expressRouteCircuit.GetExpressRouteCircuitAuthorizations();

            // invoke the operation
            string authorizationName = "authorizationName";
            bool result = await collection.ExistsAsync(authorizationName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get ExpressRouteCircuit Authorization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetExpressRouteCircuitAuthorization()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/ExpressRouteCircuitAuthorizationGet.json
            // this example is just showing the usage of "ExpressRouteCircuitAuthorizations_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ExpressRouteCircuitResource created on azure
            // for more information of creating ExpressRouteCircuitResource, please refer to the document of ExpressRouteCircuitResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string circuitName = "circuitName";
            ResourceIdentifier expressRouteCircuitResourceId = ExpressRouteCircuitResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, circuitName);
            ExpressRouteCircuitResource expressRouteCircuit = client.GetExpressRouteCircuitResource(expressRouteCircuitResourceId);

            // get the collection of this ExpressRouteCircuitAuthorizationResource
            ExpressRouteCircuitAuthorizationCollection collection = expressRouteCircuit.GetExpressRouteCircuitAuthorizations();

            // invoke the operation
            string authorizationName = "authorizationName";
            NullableResponse<ExpressRouteCircuitAuthorizationResource> response = await collection.GetIfExistsAsync(authorizationName);
            ExpressRouteCircuitAuthorizationResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ExpressRouteCircuitAuthorizationData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Create ExpressRouteCircuit Authorization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateExpressRouteCircuitAuthorization()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/ExpressRouteCircuitAuthorizationCreate.json
            // this example is just showing the usage of "ExpressRouteCircuitAuthorizations_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ExpressRouteCircuitResource created on azure
            // for more information of creating ExpressRouteCircuitResource, please refer to the document of ExpressRouteCircuitResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string circuitName = "circuitName";
            ResourceIdentifier expressRouteCircuitResourceId = ExpressRouteCircuitResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, circuitName);
            ExpressRouteCircuitResource expressRouteCircuit = client.GetExpressRouteCircuitResource(expressRouteCircuitResourceId);

            // get the collection of this ExpressRouteCircuitAuthorizationResource
            ExpressRouteCircuitAuthorizationCollection collection = expressRouteCircuit.GetExpressRouteCircuitAuthorizations();

            // invoke the operation
            string authorizationName = "authorizatinName";
            ExpressRouteCircuitAuthorizationData data = new ExpressRouteCircuitAuthorizationData();
            ArmOperation<ExpressRouteCircuitAuthorizationResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, authorizationName, data);
            ExpressRouteCircuitAuthorizationResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ExpressRouteCircuitAuthorizationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // List ExpressRouteCircuit Authorization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListExpressRouteCircuitAuthorization()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/ExpressRouteCircuitAuthorizationList.json
            // this example is just showing the usage of "ExpressRouteCircuitAuthorizations_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ExpressRouteCircuitResource created on azure
            // for more information of creating ExpressRouteCircuitResource, please refer to the document of ExpressRouteCircuitResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string circuitName = "circuitName";
            ResourceIdentifier expressRouteCircuitResourceId = ExpressRouteCircuitResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, circuitName);
            ExpressRouteCircuitResource expressRouteCircuit = client.GetExpressRouteCircuitResource(expressRouteCircuitResourceId);

            // get the collection of this ExpressRouteCircuitAuthorizationResource
            ExpressRouteCircuitAuthorizationCollection collection = expressRouteCircuit.GetExpressRouteCircuitAuthorizations();

            // invoke the operation and iterate over the result
            await foreach (ExpressRouteCircuitAuthorizationResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ExpressRouteCircuitAuthorizationData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
