// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Network.Models;

namespace Azure.ResourceManager.Network.Samples
{
    public partial class Sample_CloudServiceSwapResource
    {
        // Get swap resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetSwapResource()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/CloudServiceSwapGet.json
            // this example is just showing the usage of "VipSwap_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CloudServiceSwapResource created on azure
            // for more information of creating CloudServiceSwapResource, please refer to the document of CloudServiceSwapResource
            string subscriptionId = "subid";
            string groupName = "rg1";
            string resourceName = "testCloudService";
            ResourceIdentifier cloudServiceSwapResourceId = CloudServiceSwapResource.CreateResourceIdentifier(subscriptionId, groupName, resourceName);
            CloudServiceSwapResource cloudServiceSwap = client.GetCloudServiceSwapResource(cloudServiceSwapResourceId);

            // invoke the operation
            CloudServiceSwapResource result = await cloudServiceSwap.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CloudServiceSwapData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Put vip swap operation.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_PutVipSwapOperation()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/CloudServiceSwapPut.json
            // this example is just showing the usage of "VipSwap_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CloudServiceSwapResource created on azure
            // for more information of creating CloudServiceSwapResource, please refer to the document of CloudServiceSwapResource
            string subscriptionId = "subid";
            string groupName = "rg1";
            string resourceName = "testCloudService";
            ResourceIdentifier cloudServiceSwapResourceId = CloudServiceSwapResource.CreateResourceIdentifier(subscriptionId, groupName, resourceName);
            CloudServiceSwapResource cloudServiceSwap = client.GetCloudServiceSwapResource(cloudServiceSwapResourceId);

            // invoke the operation
            CloudServiceSwapData data = new CloudServiceSwapData()
            {
                CloudServiceSwapSlotType = SwapSlotType.Production,
            };
            await cloudServiceSwap.UpdateAsync(WaitUntil.Completed, data);

            Console.WriteLine($"Succeeded");
        }
    }
}
