// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Network.Models;

namespace Azure.ResourceManager.Network.Samples
{
    public partial class Sample_BaseAdminRuleResource
    {
        // Gets security admin rule
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsSecurityAdminRule()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/NetworkManagerAdminRuleGet.json
            // this example is just showing the usage of "AdminRules_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BaseAdminRuleResource created on azure
            // for more information of creating BaseAdminRuleResource, please refer to the document of BaseAdminRuleResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string networkManagerName = "testNetworkManager";
            string configurationName = "myTestSecurityConfig";
            string ruleCollectionName = "testRuleCollection";
            string ruleName = "SampleAdminRule";
            ResourceIdentifier baseAdminRuleResourceId = BaseAdminRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, networkManagerName, configurationName, ruleCollectionName, ruleName);
            BaseAdminRuleResource baseAdminRule = client.GetBaseAdminRuleResource(baseAdminRuleResourceId);

            // invoke the operation
            BaseAdminRuleResource result = await baseAdminRule.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BaseAdminRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Gets security default admin rule
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsSecurityDefaultAdminRule()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/NetworkManagerDefaultAdminRuleGet.json
            // this example is just showing the usage of "AdminRules_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BaseAdminRuleResource created on azure
            // for more information of creating BaseAdminRuleResource, please refer to the document of BaseAdminRuleResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string networkManagerName = "testNetworkManager";
            string configurationName = "myTestSecurityConfig";
            string ruleCollectionName = "testRuleCollection";
            string ruleName = "SampleDefaultAdminRule";
            ResourceIdentifier baseAdminRuleResourceId = BaseAdminRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, networkManagerName, configurationName, ruleCollectionName, ruleName);
            BaseAdminRuleResource baseAdminRule = client.GetBaseAdminRuleResource(baseAdminRuleResourceId);

            // invoke the operation
            BaseAdminRuleResource result = await baseAdminRule.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BaseAdminRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a default admin rule
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateADefaultAdminRule()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/NetworkManagerDefaultAdminRulePut.json
            // this example is just showing the usage of "AdminRules_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BaseAdminRuleResource created on azure
            // for more information of creating BaseAdminRuleResource, please refer to the document of BaseAdminRuleResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string networkManagerName = "testNetworkManager";
            string configurationName = "myTestSecurityConfig";
            string ruleCollectionName = "testRuleCollection";
            string ruleName = "SampleDefaultAdminRule";
            ResourceIdentifier baseAdminRuleResourceId = BaseAdminRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, networkManagerName, configurationName, ruleCollectionName, ruleName);
            BaseAdminRuleResource baseAdminRule = client.GetBaseAdminRuleResource(baseAdminRuleResourceId);

            // invoke the operation
            BaseAdminRuleData data = new NetworkDefaultAdminRule()
            {
                Flag = "AllowVnetInbound",
            };
            ArmOperation<BaseAdminRuleResource> lro = await baseAdminRule.UpdateAsync(WaitUntil.Completed, data);
            BaseAdminRuleResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BaseAdminRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create an admin rule
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateAnAdminRule()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/NetworkManagerAdminRulePut.json
            // this example is just showing the usage of "AdminRules_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BaseAdminRuleResource created on azure
            // for more information of creating BaseAdminRuleResource, please refer to the document of BaseAdminRuleResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string networkManagerName = "testNetworkManager";
            string configurationName = "myTestSecurityConfig";
            string ruleCollectionName = "testRuleCollection";
            string ruleName = "SampleAdminRule";
            ResourceIdentifier baseAdminRuleResourceId = BaseAdminRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, networkManagerName, configurationName, ruleCollectionName, ruleName);
            BaseAdminRuleResource baseAdminRule = client.GetBaseAdminRuleResource(baseAdminRuleResourceId);

            // invoke the operation
            BaseAdminRuleData data = new NetworkAdminRule()
            {
                Description = "This is Sample Admin Rule",
                Protocol = SecurityConfigurationRuleProtocol.Tcp,
                Sources =
{
new AddressPrefixItem()
{
AddressPrefix = "Internet",
AddressPrefixType = AddressPrefixType.ServiceTag,
}
},
                Destinations =
{
new AddressPrefixItem()
{
AddressPrefix = "*",
AddressPrefixType = AddressPrefixType.IPPrefix,
}
},
                SourcePortRanges =
{
"0-65535"
},
                DestinationPortRanges =
{
"22"
},
                Access = SecurityConfigurationRuleAccess.Deny,
                Priority = 1,
                Direction = SecurityConfigurationRuleDirection.Inbound,
            };
            ArmOperation<BaseAdminRuleResource> lro = await baseAdminRule.UpdateAsync(WaitUntil.Completed, data);
            BaseAdminRuleResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BaseAdminRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Deletes an admin rule
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeletesAnAdminRule()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/NetworkManagerAdminRuleDelete.json
            // this example is just showing the usage of "AdminRules_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BaseAdminRuleResource created on azure
            // for more information of creating BaseAdminRuleResource, please refer to the document of BaseAdminRuleResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string networkManagerName = "testNetworkManager";
            string configurationName = "myTestSecurityConfig";
            string ruleCollectionName = "testRuleCollection";
            string ruleName = "SampleAdminRule";
            ResourceIdentifier baseAdminRuleResourceId = BaseAdminRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, networkManagerName, configurationName, ruleCollectionName, ruleName);
            BaseAdminRuleResource baseAdminRule = client.GetBaseAdminRuleResource(baseAdminRuleResourceId);

            // invoke the operation
            bool? force = false;
            await baseAdminRule.DeleteAsync(WaitUntil.Completed, force: force);

            Console.WriteLine($"Succeeded");
        }
    }
}
