// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Network.Models;

namespace Azure.ResourceManager.Network.Samples
{
    public partial class Sample_BackendAddressPoolCollection
    {
        // Load balancer with BackendAddressPool containing BackendAddresses
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_LoadBalancerWithBackendAddressPoolContainingBackendAddresses()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/LBBackendAddressPoolListWithBackendAddressesPoolType.json
            // this example is just showing the usage of "LoadBalancerBackendAddressPools_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this LoadBalancerResource created on azure
            // for more information of creating LoadBalancerResource, please refer to the document of LoadBalancerResource
            string subscriptionId = "subid";
            string resourceGroupName = "testrg";
            string loadBalancerName = "lb";
            ResourceIdentifier loadBalancerResourceId = LoadBalancerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, loadBalancerName);
            LoadBalancerResource loadBalancer = client.GetLoadBalancerResource(loadBalancerResourceId);

            // get the collection of this BackendAddressPoolResource
            BackendAddressPoolCollection collection = loadBalancer.GetBackendAddressPools();

            // invoke the operation and iterate over the result
            await foreach (BackendAddressPoolResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BackendAddressPoolData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // LoadBalancerBackendAddressPoolList
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_LoadBalancerBackendAddressPoolList()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/LoadBalancerBackendAddressPoolList.json
            // this example is just showing the usage of "LoadBalancerBackendAddressPools_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this LoadBalancerResource created on azure
            // for more information of creating LoadBalancerResource, please refer to the document of LoadBalancerResource
            string subscriptionId = "subid";
            string resourceGroupName = "testrg";
            string loadBalancerName = "lb";
            ResourceIdentifier loadBalancerResourceId = LoadBalancerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, loadBalancerName);
            LoadBalancerResource loadBalancer = client.GetLoadBalancerResource(loadBalancerResourceId);

            // get the collection of this BackendAddressPoolResource
            BackendAddressPoolCollection collection = loadBalancer.GetBackendAddressPools();

            // invoke the operation and iterate over the result
            await foreach (BackendAddressPoolResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BackendAddressPoolData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // LoadBalancer with BackendAddressPool with BackendAddresses
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_LoadBalancerWithBackendAddressPoolWithBackendAddresses()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/LBBackendAddressPoolWithBackendAddressesGet.json
            // this example is just showing the usage of "LoadBalancerBackendAddressPools_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this LoadBalancerResource created on azure
            // for more information of creating LoadBalancerResource, please refer to the document of LoadBalancerResource
            string subscriptionId = "subid";
            string resourceGroupName = "testrg";
            string loadBalancerName = "lb";
            ResourceIdentifier loadBalancerResourceId = LoadBalancerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, loadBalancerName);
            LoadBalancerResource loadBalancer = client.GetLoadBalancerResource(loadBalancerResourceId);

            // get the collection of this BackendAddressPoolResource
            BackendAddressPoolCollection collection = loadBalancer.GetBackendAddressPools();

            // invoke the operation
            string backendAddressPoolName = "backend";
            BackendAddressPoolResource result = await collection.GetAsync(backendAddressPoolName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BackendAddressPoolData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // LoadBalancer with BackendAddressPool with BackendAddresses
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_LoadBalancerWithBackendAddressPoolWithBackendAddresses()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/LBBackendAddressPoolWithBackendAddressesGet.json
            // this example is just showing the usage of "LoadBalancerBackendAddressPools_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this LoadBalancerResource created on azure
            // for more information of creating LoadBalancerResource, please refer to the document of LoadBalancerResource
            string subscriptionId = "subid";
            string resourceGroupName = "testrg";
            string loadBalancerName = "lb";
            ResourceIdentifier loadBalancerResourceId = LoadBalancerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, loadBalancerName);
            LoadBalancerResource loadBalancer = client.GetLoadBalancerResource(loadBalancerResourceId);

            // get the collection of this BackendAddressPoolResource
            BackendAddressPoolCollection collection = loadBalancer.GetBackendAddressPools();

            // invoke the operation
            string backendAddressPoolName = "backend";
            bool result = await collection.ExistsAsync(backendAddressPoolName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // LoadBalancer with BackendAddressPool with BackendAddresses
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_LoadBalancerWithBackendAddressPoolWithBackendAddresses()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/LBBackendAddressPoolWithBackendAddressesGet.json
            // this example is just showing the usage of "LoadBalancerBackendAddressPools_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this LoadBalancerResource created on azure
            // for more information of creating LoadBalancerResource, please refer to the document of LoadBalancerResource
            string subscriptionId = "subid";
            string resourceGroupName = "testrg";
            string loadBalancerName = "lb";
            ResourceIdentifier loadBalancerResourceId = LoadBalancerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, loadBalancerName);
            LoadBalancerResource loadBalancer = client.GetLoadBalancerResource(loadBalancerResourceId);

            // get the collection of this BackendAddressPoolResource
            BackendAddressPoolCollection collection = loadBalancer.GetBackendAddressPools();

            // invoke the operation
            string backendAddressPoolName = "backend";
            NullableResponse<BackendAddressPoolResource> response = await collection.GetIfExistsAsync(backendAddressPoolName);
            BackendAddressPoolResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BackendAddressPoolData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // LoadBalancerBackendAddressPoolGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_LoadBalancerBackendAddressPoolGet()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/LoadBalancerBackendAddressPoolGet.json
            // this example is just showing the usage of "LoadBalancerBackendAddressPools_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this LoadBalancerResource created on azure
            // for more information of creating LoadBalancerResource, please refer to the document of LoadBalancerResource
            string subscriptionId = "subid";
            string resourceGroupName = "testrg";
            string loadBalancerName = "lb";
            ResourceIdentifier loadBalancerResourceId = LoadBalancerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, loadBalancerName);
            LoadBalancerResource loadBalancer = client.GetLoadBalancerResource(loadBalancerResourceId);

            // get the collection of this BackendAddressPoolResource
            BackendAddressPoolCollection collection = loadBalancer.GetBackendAddressPools();

            // invoke the operation
            string backendAddressPoolName = "backend";
            BackendAddressPoolResource result = await collection.GetAsync(backendAddressPoolName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BackendAddressPoolData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // LoadBalancerBackendAddressPoolGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_LoadBalancerBackendAddressPoolGet()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/LoadBalancerBackendAddressPoolGet.json
            // this example is just showing the usage of "LoadBalancerBackendAddressPools_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this LoadBalancerResource created on azure
            // for more information of creating LoadBalancerResource, please refer to the document of LoadBalancerResource
            string subscriptionId = "subid";
            string resourceGroupName = "testrg";
            string loadBalancerName = "lb";
            ResourceIdentifier loadBalancerResourceId = LoadBalancerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, loadBalancerName);
            LoadBalancerResource loadBalancer = client.GetLoadBalancerResource(loadBalancerResourceId);

            // get the collection of this BackendAddressPoolResource
            BackendAddressPoolCollection collection = loadBalancer.GetBackendAddressPools();

            // invoke the operation
            string backendAddressPoolName = "backend";
            bool result = await collection.ExistsAsync(backendAddressPoolName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // LoadBalancerBackendAddressPoolGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_LoadBalancerBackendAddressPoolGet()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/LoadBalancerBackendAddressPoolGet.json
            // this example is just showing the usage of "LoadBalancerBackendAddressPools_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this LoadBalancerResource created on azure
            // for more information of creating LoadBalancerResource, please refer to the document of LoadBalancerResource
            string subscriptionId = "subid";
            string resourceGroupName = "testrg";
            string loadBalancerName = "lb";
            ResourceIdentifier loadBalancerResourceId = LoadBalancerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, loadBalancerName);
            LoadBalancerResource loadBalancer = client.GetLoadBalancerResource(loadBalancerResourceId);

            // get the collection of this BackendAddressPoolResource
            BackendAddressPoolCollection collection = loadBalancer.GetBackendAddressPools();

            // invoke the operation
            string backendAddressPoolName = "backend";
            NullableResponse<BackendAddressPoolResource> response = await collection.GetIfExistsAsync(backendAddressPoolName);
            BackendAddressPoolResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BackendAddressPoolData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Update load balancer backend pool with backend addresses containing virtual network and  IP address.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_UpdateLoadBalancerBackendPoolWithBackendAddressesContainingVirtualNetworkAndIPAddress()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/LBBackendAddressPoolWithBackendAddressesPut.json
            // this example is just showing the usage of "LoadBalancerBackendAddressPools_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this LoadBalancerResource created on azure
            // for more information of creating LoadBalancerResource, please refer to the document of LoadBalancerResource
            string subscriptionId = "subid";
            string resourceGroupName = "testrg";
            string loadBalancerName = "lb";
            ResourceIdentifier loadBalancerResourceId = LoadBalancerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, loadBalancerName);
            LoadBalancerResource loadBalancer = client.GetLoadBalancerResource(loadBalancerResourceId);

            // get the collection of this BackendAddressPoolResource
            BackendAddressPoolCollection collection = loadBalancer.GetBackendAddressPools();

            // invoke the operation
            string backendAddressPoolName = "backend";
            BackendAddressPoolData data = new BackendAddressPoolData()
            {
                LoadBalancerBackendAddresses =
{
new LoadBalancerBackendAddress()
{
Name = "address1",
VirtualNetworkId = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb"),
IPAddress = "10.0.0.4",
},new LoadBalancerBackendAddress()
{
Name = "address2",
VirtualNetworkId = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb"),
IPAddress = "10.0.0.5",
}
},
            };
            ArmOperation<BackendAddressPoolResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, backendAddressPoolName, data);
            BackendAddressPoolResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BackendAddressPoolData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
