// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Network.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.Network.Samples
{
    public partial class Sample_AzureFirewallCollection
    {
        // Get Azure Firewall
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAzureFirewall()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/AzureFirewallGet.json
            // this example is just showing the usage of "AzureFirewalls_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AzureFirewallResource
            AzureFirewallCollection collection = resourceGroupResource.GetAzureFirewalls();

            // invoke the operation
            string azureFirewallName = "azurefirewall";
            AzureFirewallResource result = await collection.GetAsync(azureFirewallName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AzureFirewallData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get Azure Firewall
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetAzureFirewall()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/AzureFirewallGet.json
            // this example is just showing the usage of "AzureFirewalls_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AzureFirewallResource
            AzureFirewallCollection collection = resourceGroupResource.GetAzureFirewalls();

            // invoke the operation
            string azureFirewallName = "azurefirewall";
            bool result = await collection.ExistsAsync(azureFirewallName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get Azure Firewall
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetAzureFirewall()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/AzureFirewallGet.json
            // this example is just showing the usage of "AzureFirewalls_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AzureFirewallResource
            AzureFirewallCollection collection = resourceGroupResource.GetAzureFirewalls();

            // invoke the operation
            string azureFirewallName = "azurefirewall";
            NullableResponse<AzureFirewallResource> response = await collection.GetIfExistsAsync(azureFirewallName);
            AzureFirewallResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                AzureFirewallData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Get Azure Firewall With Additional Properties
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAzureFirewallWithAdditionalProperties()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/AzureFirewallGetWithAdditionalProperties.json
            // this example is just showing the usage of "AzureFirewalls_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AzureFirewallResource
            AzureFirewallCollection collection = resourceGroupResource.GetAzureFirewalls();

            // invoke the operation
            string azureFirewallName = "azurefirewall";
            AzureFirewallResource result = await collection.GetAsync(azureFirewallName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AzureFirewallData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get Azure Firewall With Additional Properties
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetAzureFirewallWithAdditionalProperties()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/AzureFirewallGetWithAdditionalProperties.json
            // this example is just showing the usage of "AzureFirewalls_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AzureFirewallResource
            AzureFirewallCollection collection = resourceGroupResource.GetAzureFirewalls();

            // invoke the operation
            string azureFirewallName = "azurefirewall";
            bool result = await collection.ExistsAsync(azureFirewallName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get Azure Firewall With Additional Properties
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetAzureFirewallWithAdditionalProperties()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/AzureFirewallGetWithAdditionalProperties.json
            // this example is just showing the usage of "AzureFirewalls_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AzureFirewallResource
            AzureFirewallCollection collection = resourceGroupResource.GetAzureFirewalls();

            // invoke the operation
            string azureFirewallName = "azurefirewall";
            NullableResponse<AzureFirewallResource> response = await collection.GetIfExistsAsync(azureFirewallName);
            AzureFirewallResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                AzureFirewallData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Get Azure Firewall With IpGroups
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAzureFirewallWithIpGroups()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/AzureFirewallGetWithIpGroups.json
            // this example is just showing the usage of "AzureFirewalls_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AzureFirewallResource
            AzureFirewallCollection collection = resourceGroupResource.GetAzureFirewalls();

            // invoke the operation
            string azureFirewallName = "azurefirewall";
            AzureFirewallResource result = await collection.GetAsync(azureFirewallName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AzureFirewallData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get Azure Firewall With IpGroups
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetAzureFirewallWithIpGroups()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/AzureFirewallGetWithIpGroups.json
            // this example is just showing the usage of "AzureFirewalls_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AzureFirewallResource
            AzureFirewallCollection collection = resourceGroupResource.GetAzureFirewalls();

            // invoke the operation
            string azureFirewallName = "azurefirewall";
            bool result = await collection.ExistsAsync(azureFirewallName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get Azure Firewall With IpGroups
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetAzureFirewallWithIpGroups()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/AzureFirewallGetWithIpGroups.json
            // this example is just showing the usage of "AzureFirewalls_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AzureFirewallResource
            AzureFirewallCollection collection = resourceGroupResource.GetAzureFirewalls();

            // invoke the operation
            string azureFirewallName = "azurefirewall";
            NullableResponse<AzureFirewallResource> response = await collection.GetIfExistsAsync(azureFirewallName);
            AzureFirewallResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                AzureFirewallData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Get Azure Firewall With Zones
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAzureFirewallWithZones()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/AzureFirewallGetWithZones.json
            // this example is just showing the usage of "AzureFirewalls_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AzureFirewallResource
            AzureFirewallCollection collection = resourceGroupResource.GetAzureFirewalls();

            // invoke the operation
            string azureFirewallName = "azurefirewall";
            AzureFirewallResource result = await collection.GetAsync(azureFirewallName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AzureFirewallData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get Azure Firewall With Zones
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetAzureFirewallWithZones()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/AzureFirewallGetWithZones.json
            // this example is just showing the usage of "AzureFirewalls_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AzureFirewallResource
            AzureFirewallCollection collection = resourceGroupResource.GetAzureFirewalls();

            // invoke the operation
            string azureFirewallName = "azurefirewall";
            bool result = await collection.ExistsAsync(azureFirewallName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get Azure Firewall With Zones
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetAzureFirewallWithZones()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/AzureFirewallGetWithZones.json
            // this example is just showing the usage of "AzureFirewalls_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AzureFirewallResource
            AzureFirewallCollection collection = resourceGroupResource.GetAzureFirewalls();

            // invoke the operation
            string azureFirewallName = "azurefirewall";
            NullableResponse<AzureFirewallResource> response = await collection.GetIfExistsAsync(azureFirewallName);
            AzureFirewallResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                AzureFirewallData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Get Azure Firewall With management subnet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAzureFirewallWithManagementSubnet()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/AzureFirewallGetWithMgmtSubnet.json
            // this example is just showing the usage of "AzureFirewalls_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AzureFirewallResource
            AzureFirewallCollection collection = resourceGroupResource.GetAzureFirewalls();

            // invoke the operation
            string azureFirewallName = "azurefirewall";
            AzureFirewallResource result = await collection.GetAsync(azureFirewallName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AzureFirewallData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get Azure Firewall With management subnet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetAzureFirewallWithManagementSubnet()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/AzureFirewallGetWithMgmtSubnet.json
            // this example is just showing the usage of "AzureFirewalls_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AzureFirewallResource
            AzureFirewallCollection collection = resourceGroupResource.GetAzureFirewalls();

            // invoke the operation
            string azureFirewallName = "azurefirewall";
            bool result = await collection.ExistsAsync(azureFirewallName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get Azure Firewall With management subnet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetAzureFirewallWithManagementSubnet()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/AzureFirewallGetWithMgmtSubnet.json
            // this example is just showing the usage of "AzureFirewalls_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AzureFirewallResource
            AzureFirewallCollection collection = resourceGroupResource.GetAzureFirewalls();

            // invoke the operation
            string azureFirewallName = "azurefirewall";
            NullableResponse<AzureFirewallResource> response = await collection.GetIfExistsAsync(azureFirewallName);
            AzureFirewallResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                AzureFirewallData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Create Azure Firewall
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAzureFirewall()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/AzureFirewallPut.json
            // this example is just showing the usage of "AzureFirewalls_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AzureFirewallResource
            AzureFirewallCollection collection = resourceGroupResource.GetAzureFirewalls();

            // invoke the operation
            string azureFirewallName = "azurefirewall";
            AzureFirewallData data = new AzureFirewallData()
            {
                Zones =
{
},
                ApplicationRuleCollections =
{
new AzureFirewallApplicationRuleCollectionData()
{
Priority = 110,
ActionType = AzureFirewallRCActionType.Deny,
Rules =
{
new AzureFirewallApplicationRule()
{
Name = "rule1",
Description = "Deny inbound rule",
SourceAddresses =
{
"216.58.216.164","10.0.0.0/24"
},
Protocols =
{
new AzureFirewallApplicationRuleProtocol()
{
ProtocolType = AzureFirewallApplicationRuleProtocolType.Https,
Port = 443,
}
},
TargetFqdns =
{
"www.test.com"
},
}
},
Id = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewall/applicationRuleCollections/apprulecoll"),
Name = "apprulecoll",
}
},
                NatRuleCollections =
{
new AzureFirewallNatRuleCollectionData()
{
Priority = 112,
ActionType = AzureFirewallNatRCActionType.Dnat,
Rules =
{
new AzureFirewallNatRule()
{
Name = "DNAT-HTTPS-traffic",
Description = "D-NAT all outbound web traffic for inspection",
SourceAddresses =
{
"*"
},
DestinationAddresses =
{
"1.2.3.4"
},
DestinationPorts =
{
"443"
},
Protocols =
{
AzureFirewallNetworkRuleProtocol.Tcp
},
TranslatedAddress = "1.2.3.5",
TranslatedPort = "8443",
},new AzureFirewallNatRule()
{
Name = "DNAT-HTTP-traffic-With-FQDN",
Description = "D-NAT all inbound web traffic for inspection",
SourceAddresses =
{
"*"
},
DestinationAddresses =
{
"1.2.3.4"
},
DestinationPorts =
{
"80"
},
Protocols =
{
AzureFirewallNetworkRuleProtocol.Tcp
},
TranslatedPort = "880",
TranslatedFqdn = "internalhttpserver",
}
},
Id = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewall/natRuleCollections/natrulecoll"),
Name = "natrulecoll",
}
},
                NetworkRuleCollections =
{
new AzureFirewallNetworkRuleCollectionData()
{
Priority = 112,
ActionType = AzureFirewallRCActionType.Deny,
Rules =
{
new AzureFirewallNetworkRule()
{
Name = "L4-traffic",
Description = "Block traffic based on source IPs and ports",
Protocols =
{
AzureFirewallNetworkRuleProtocol.Tcp
},
SourceAddresses =
{
"192.168.1.1-192.168.1.12","10.1.4.12-10.1.4.255"
},
DestinationAddresses =
{
"*"
},
DestinationPorts =
{
"443-444","8443"
},
},new AzureFirewallNetworkRule()
{
Name = "L4-traffic-with-FQDN",
Description = "Block traffic based on source IPs and ports to amazon",
Protocols =
{
AzureFirewallNetworkRuleProtocol.Tcp
},
SourceAddresses =
{
"10.2.4.12-10.2.4.255"
},
DestinationPorts =
{
"443-444","8443"
},
DestinationFqdns =
{
"www.amazon.com"
},
}
},
Id = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewall/networkRuleCollections/netrulecoll"),
Name = "netrulecoll",
}
},
                IPConfigurations =
{
new AzureFirewallIPConfiguration()
{
SubnetId = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
PublicIPAddressId = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
Name = "azureFirewallIpConfiguration",
}
},
                ThreatIntelMode = AzureFirewallThreatIntelMode.Alert,
                Sku = new AzureFirewallSku()
                {
                    Name = AzureFirewallSkuName.AzfwVnet,
                    Tier = AzureFirewallSkuTier.Standard,
                },
                Location = new AzureLocation("West US"),
                Tags =
{
["key1"] = "value1",
},
            };
            ArmOperation<AzureFirewallResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, azureFirewallName, data);
            AzureFirewallResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AzureFirewallData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Azure Firewall With Additional Properties
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAzureFirewallWithAdditionalProperties()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/AzureFirewallPutWithAdditionalProperties.json
            // this example is just showing the usage of "AzureFirewalls_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AzureFirewallResource
            AzureFirewallCollection collection = resourceGroupResource.GetAzureFirewalls();

            // invoke the operation
            string azureFirewallName = "azurefirewall";
            AzureFirewallData data = new AzureFirewallData()
            {
                Zones =
{
},
                ApplicationRuleCollections =
{
new AzureFirewallApplicationRuleCollectionData()
{
Priority = 110,
ActionType = AzureFirewallRCActionType.Deny,
Rules =
{
new AzureFirewallApplicationRule()
{
Name = "rule1",
Description = "Deny inbound rule",
SourceAddresses =
{
"216.58.216.164","10.0.0.0/24"
},
Protocols =
{
new AzureFirewallApplicationRuleProtocol()
{
ProtocolType = AzureFirewallApplicationRuleProtocolType.Https,
Port = 443,
}
},
TargetFqdns =
{
"www.test.com"
},
}
},
Id = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewall/applicationRuleCollections/apprulecoll"),
Name = "apprulecoll",
}
},
                NatRuleCollections =
{
new AzureFirewallNatRuleCollectionData()
{
Priority = 112,
ActionType = AzureFirewallNatRCActionType.Dnat,
Rules =
{
new AzureFirewallNatRule()
{
Name = "DNAT-HTTPS-traffic",
Description = "D-NAT all outbound web traffic for inspection",
SourceAddresses =
{
"*"
},
DestinationAddresses =
{
"1.2.3.4"
},
DestinationPorts =
{
"443"
},
Protocols =
{
AzureFirewallNetworkRuleProtocol.Tcp
},
TranslatedAddress = "1.2.3.5",
TranslatedPort = "8443",
},new AzureFirewallNatRule()
{
Name = "DNAT-HTTP-traffic-With-FQDN",
Description = "D-NAT all inbound web traffic for inspection",
SourceAddresses =
{
"*"
},
DestinationAddresses =
{
"1.2.3.4"
},
DestinationPorts =
{
"80"
},
Protocols =
{
AzureFirewallNetworkRuleProtocol.Tcp
},
TranslatedPort = "880",
TranslatedFqdn = "internalhttpserver",
}
},
Id = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewall/natRuleCollections/natrulecoll"),
Name = "natrulecoll",
}
},
                NetworkRuleCollections =
{
new AzureFirewallNetworkRuleCollectionData()
{
Priority = 112,
ActionType = AzureFirewallRCActionType.Deny,
Rules =
{
new AzureFirewallNetworkRule()
{
Name = "L4-traffic",
Description = "Block traffic based on source IPs and ports",
Protocols =
{
AzureFirewallNetworkRuleProtocol.Tcp
},
SourceAddresses =
{
"192.168.1.1-192.168.1.12","10.1.4.12-10.1.4.255"
},
DestinationAddresses =
{
"*"
},
DestinationPorts =
{
"443-444","8443"
},
},new AzureFirewallNetworkRule()
{
Name = "L4-traffic-with-FQDN",
Description = "Block traffic based on source IPs and ports to amazon",
Protocols =
{
AzureFirewallNetworkRuleProtocol.Tcp
},
SourceAddresses =
{
"10.2.4.12-10.2.4.255"
},
DestinationPorts =
{
"443-444","8443"
},
DestinationFqdns =
{
"www.amazon.com"
},
}
},
Id = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewall/networkRuleCollections/netrulecoll"),
Name = "netrulecoll",
}
},
                IPConfigurations =
{
new AzureFirewallIPConfiguration()
{
SubnetId = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
PublicIPAddressId = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
Name = "azureFirewallIpConfiguration",
}
},
                ThreatIntelMode = AzureFirewallThreatIntelMode.Alert,
                Sku = new AzureFirewallSku()
                {
                    Name = AzureFirewallSkuName.AzfwVnet,
                    Tier = AzureFirewallSkuTier.Standard,
                },
                AdditionalProperties =
{
["key1"] = "value1",
["key2"] = "value2",
},
                Location = new AzureLocation("West US"),
                Tags =
{
["key1"] = "value1",
},
            };
            ArmOperation<AzureFirewallResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, azureFirewallName, data);
            AzureFirewallResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AzureFirewallData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Azure Firewall With IpGroups
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAzureFirewallWithIpGroups()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/AzureFirewallPutWithIpGroups.json
            // this example is just showing the usage of "AzureFirewalls_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AzureFirewallResource
            AzureFirewallCollection collection = resourceGroupResource.GetAzureFirewalls();

            // invoke the operation
            string azureFirewallName = "azurefirewall";
            AzureFirewallData data = new AzureFirewallData()
            {
                Zones =
{
},
                ApplicationRuleCollections =
{
new AzureFirewallApplicationRuleCollectionData()
{
Priority = 110,
ActionType = AzureFirewallRCActionType.Deny,
Rules =
{
new AzureFirewallApplicationRule()
{
Name = "rule1",
Description = "Deny inbound rule",
SourceAddresses =
{
"216.58.216.164","10.0.0.0/24"
},
Protocols =
{
new AzureFirewallApplicationRuleProtocol()
{
ProtocolType = AzureFirewallApplicationRuleProtocolType.Https,
Port = 443,
}
},
TargetFqdns =
{
"www.test.com"
},
}
},
Id = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewall/applicationRuleCollections/apprulecoll"),
Name = "apprulecoll",
}
},
                NatRuleCollections =
{
new AzureFirewallNatRuleCollectionData()
{
Priority = 112,
ActionType = AzureFirewallNatRCActionType.Dnat,
Rules =
{
new AzureFirewallNatRule()
{
Name = "DNAT-HTTPS-traffic",
Description = "D-NAT all outbound web traffic for inspection",
SourceAddresses =
{
"*"
},
DestinationAddresses =
{
"1.2.3.4"
},
DestinationPorts =
{
"443"
},
Protocols =
{
AzureFirewallNetworkRuleProtocol.Tcp
},
TranslatedAddress = "1.2.3.5",
TranslatedPort = "8443",
},new AzureFirewallNatRule()
{
Name = "DNAT-HTTP-traffic-With-FQDN",
Description = "D-NAT all inbound web traffic for inspection",
SourceAddresses =
{
"*"
},
DestinationAddresses =
{
"1.2.3.4"
},
DestinationPorts =
{
"80"
},
Protocols =
{
AzureFirewallNetworkRuleProtocol.Tcp
},
TranslatedPort = "880",
TranslatedFqdn = "internalhttpserver",
}
},
Id = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewall/natRuleCollections/natrulecoll"),
Name = "natrulecoll",
}
},
                NetworkRuleCollections =
{
new AzureFirewallNetworkRuleCollectionData()
{
Priority = 112,
ActionType = AzureFirewallRCActionType.Deny,
Rules =
{
new AzureFirewallNetworkRule()
{
Name = "L4-traffic",
Description = "Block traffic based on source IPs and ports",
Protocols =
{
AzureFirewallNetworkRuleProtocol.Tcp
},
SourceAddresses =
{
"192.168.1.1-192.168.1.12","10.1.4.12-10.1.4.255"
},
DestinationAddresses =
{
"*"
},
DestinationPorts =
{
"443-444","8443"
},
},new AzureFirewallNetworkRule()
{
Name = "L4-traffic-with-FQDN",
Description = "Block traffic based on source IPs and ports to amazon",
Protocols =
{
AzureFirewallNetworkRuleProtocol.Tcp
},
SourceAddresses =
{
"10.2.4.12-10.2.4.255"
},
DestinationPorts =
{
"443-444","8443"
},
DestinationFqdns =
{
"www.amazon.com"
},
}
},
Id = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewall/networkRuleCollections/netrulecoll"),
Name = "netrulecoll",
}
},
                IPConfigurations =
{
new AzureFirewallIPConfiguration()
{
SubnetId = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
PublicIPAddressId = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
Name = "azureFirewallIpConfiguration",
}
},
                ThreatIntelMode = AzureFirewallThreatIntelMode.Alert,
                Sku = new AzureFirewallSku()
                {
                    Name = AzureFirewallSkuName.AzfwVnet,
                    Tier = AzureFirewallSkuTier.Standard,
                },
                Location = new AzureLocation("West US"),
                Tags =
{
["key1"] = "value1",
},
            };
            ArmOperation<AzureFirewallResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, azureFirewallName, data);
            AzureFirewallResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AzureFirewallData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Azure Firewall With Zones
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAzureFirewallWithZones()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/AzureFirewallPutWithZones.json
            // this example is just showing the usage of "AzureFirewalls_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AzureFirewallResource
            AzureFirewallCollection collection = resourceGroupResource.GetAzureFirewalls();

            // invoke the operation
            string azureFirewallName = "azurefirewall";
            AzureFirewallData data = new AzureFirewallData()
            {
                Zones =
{
"1","2","3"
},
                ApplicationRuleCollections =
{
new AzureFirewallApplicationRuleCollectionData()
{
Priority = 110,
ActionType = AzureFirewallRCActionType.Deny,
Rules =
{
new AzureFirewallApplicationRule()
{
Name = "rule1",
Description = "Deny inbound rule",
SourceAddresses =
{
"216.58.216.164","10.0.0.0/24"
},
Protocols =
{
new AzureFirewallApplicationRuleProtocol()
{
ProtocolType = AzureFirewallApplicationRuleProtocolType.Https,
Port = 443,
}
},
TargetFqdns =
{
"www.test.com"
},
}
},
Id = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewall/applicationRuleCollections/apprulecoll"),
Name = "apprulecoll",
}
},
                NatRuleCollections =
{
new AzureFirewallNatRuleCollectionData()
{
Priority = 112,
ActionType = AzureFirewallNatRCActionType.Dnat,
Rules =
{
new AzureFirewallNatRule()
{
Name = "DNAT-HTTPS-traffic",
Description = "D-NAT all outbound web traffic for inspection",
SourceAddresses =
{
"*"
},
DestinationAddresses =
{
"1.2.3.4"
},
DestinationPorts =
{
"443"
},
Protocols =
{
AzureFirewallNetworkRuleProtocol.Tcp
},
TranslatedAddress = "1.2.3.5",
TranslatedPort = "8443",
},new AzureFirewallNatRule()
{
Name = "DNAT-HTTP-traffic-With-FQDN",
Description = "D-NAT all inbound web traffic for inspection",
SourceAddresses =
{
"*"
},
DestinationAddresses =
{
"1.2.3.4"
},
DestinationPorts =
{
"80"
},
Protocols =
{
AzureFirewallNetworkRuleProtocol.Tcp
},
TranslatedPort = "880",
TranslatedFqdn = "internalhttpserver",
}
},
Id = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewall/natRuleCollections/natrulecoll"),
Name = "natrulecoll",
}
},
                NetworkRuleCollections =
{
new AzureFirewallNetworkRuleCollectionData()
{
Priority = 112,
ActionType = AzureFirewallRCActionType.Deny,
Rules =
{
new AzureFirewallNetworkRule()
{
Name = "L4-traffic",
Description = "Block traffic based on source IPs and ports",
Protocols =
{
AzureFirewallNetworkRuleProtocol.Tcp
},
SourceAddresses =
{
"192.168.1.1-192.168.1.12","10.1.4.12-10.1.4.255"
},
DestinationAddresses =
{
"*"
},
DestinationPorts =
{
"443-444","8443"
},
},new AzureFirewallNetworkRule()
{
Name = "L4-traffic-with-FQDN",
Description = "Block traffic based on source IPs and ports to amazon",
Protocols =
{
AzureFirewallNetworkRuleProtocol.Tcp
},
SourceAddresses =
{
"10.2.4.12-10.2.4.255"
},
DestinationPorts =
{
"443-444","8443"
},
DestinationFqdns =
{
"www.amazon.com"
},
}
},
Id = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewall/networkRuleCollections/netrulecoll"),
Name = "netrulecoll",
}
},
                IPConfigurations =
{
new AzureFirewallIPConfiguration()
{
SubnetId = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
PublicIPAddressId = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
Name = "azureFirewallIpConfiguration",
}
},
                ThreatIntelMode = AzureFirewallThreatIntelMode.Alert,
                Sku = new AzureFirewallSku()
                {
                    Name = AzureFirewallSkuName.AzfwVnet,
                    Tier = AzureFirewallSkuTier.Standard,
                },
                Location = new AzureLocation("West US 2"),
                Tags =
{
["key1"] = "value1",
},
            };
            ArmOperation<AzureFirewallResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, azureFirewallName, data);
            AzureFirewallResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AzureFirewallData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Azure Firewall With management subnet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAzureFirewallWithManagementSubnet()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/AzureFirewallPutWithMgmtSubnet.json
            // this example is just showing the usage of "AzureFirewalls_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AzureFirewallResource
            AzureFirewallCollection collection = resourceGroupResource.GetAzureFirewalls();

            // invoke the operation
            string azureFirewallName = "azurefirewall";
            AzureFirewallData data = new AzureFirewallData()
            {
                Zones =
{
},
                ApplicationRuleCollections =
{
new AzureFirewallApplicationRuleCollectionData()
{
Priority = 110,
ActionType = AzureFirewallRCActionType.Deny,
Rules =
{
new AzureFirewallApplicationRule()
{
Name = "rule1",
Description = "Deny inbound rule",
SourceAddresses =
{
"216.58.216.164","10.0.0.0/24"
},
Protocols =
{
new AzureFirewallApplicationRuleProtocol()
{
ProtocolType = AzureFirewallApplicationRuleProtocolType.Https,
Port = 443,
}
},
TargetFqdns =
{
"www.test.com"
},
}
},
Id = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewall/applicationRuleCollections/apprulecoll"),
Name = "apprulecoll",
}
},
                NatRuleCollections =
{
new AzureFirewallNatRuleCollectionData()
{
Priority = 112,
ActionType = AzureFirewallNatRCActionType.Dnat,
Rules =
{
new AzureFirewallNatRule()
{
Name = "DNAT-HTTPS-traffic",
Description = "D-NAT all outbound web traffic for inspection",
SourceAddresses =
{
"*"
},
DestinationAddresses =
{
"1.2.3.4"
},
DestinationPorts =
{
"443"
},
Protocols =
{
AzureFirewallNetworkRuleProtocol.Tcp
},
TranslatedAddress = "1.2.3.5",
TranslatedPort = "8443",
},new AzureFirewallNatRule()
{
Name = "DNAT-HTTP-traffic-With-FQDN",
Description = "D-NAT all inbound web traffic for inspection",
SourceAddresses =
{
"*"
},
DestinationAddresses =
{
"1.2.3.4"
},
DestinationPorts =
{
"80"
},
Protocols =
{
AzureFirewallNetworkRuleProtocol.Tcp
},
TranslatedPort = "880",
TranslatedFqdn = "internalhttpserver",
}
},
Id = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewall/natRuleCollections/natrulecoll"),
Name = "natrulecoll",
}
},
                NetworkRuleCollections =
{
new AzureFirewallNetworkRuleCollectionData()
{
Priority = 112,
ActionType = AzureFirewallRCActionType.Deny,
Rules =
{
new AzureFirewallNetworkRule()
{
Name = "L4-traffic",
Description = "Block traffic based on source IPs and ports",
Protocols =
{
AzureFirewallNetworkRuleProtocol.Tcp
},
SourceAddresses =
{
"192.168.1.1-192.168.1.12","10.1.4.12-10.1.4.255"
},
DestinationAddresses =
{
"*"
},
DestinationPorts =
{
"443-444","8443"
},
},new AzureFirewallNetworkRule()
{
Name = "L4-traffic-with-FQDN",
Description = "Block traffic based on source IPs and ports to amazon",
Protocols =
{
AzureFirewallNetworkRuleProtocol.Tcp
},
SourceAddresses =
{
"10.2.4.12-10.2.4.255"
},
DestinationPorts =
{
"443-444","8443"
},
DestinationFqdns =
{
"www.amazon.com"
},
}
},
Id = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewall/networkRuleCollections/netrulecoll"),
Name = "netrulecoll",
}
},
                IPConfigurations =
{
new AzureFirewallIPConfiguration()
{
SubnetId = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
PublicIPAddressId = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
Name = "azureFirewallIpConfiguration",
}
},
                ManagementIPConfiguration = new AzureFirewallIPConfiguration()
                {
                    SubnetId = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallManagementSubnet"),
                    PublicIPAddressId = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/managementPipName"),
                    Name = "azureFirewallMgmtIpConfiguration",
                },
                ThreatIntelMode = AzureFirewallThreatIntelMode.Alert,
                Sku = new AzureFirewallSku()
                {
                    Name = AzureFirewallSkuName.AzfwVnet,
                    Tier = AzureFirewallSkuTier.Standard,
                },
                Location = new AzureLocation("West US"),
                Tags =
{
["key1"] = "value1",
},
            };
            ArmOperation<AzureFirewallResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, azureFirewallName, data);
            AzureFirewallResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AzureFirewallData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Azure Firewall in virtual Hub
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAzureFirewallInVirtualHub()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/AzureFirewallPutInHub.json
            // this example is just showing the usage of "AzureFirewalls_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AzureFirewallResource
            AzureFirewallCollection collection = resourceGroupResource.GetAzureFirewalls();

            // invoke the operation
            string azureFirewallName = "azurefirewall";
            AzureFirewallData data = new AzureFirewallData()
            {
                Zones =
{
},
                ThreatIntelMode = AzureFirewallThreatIntelMode.Alert,
                VirtualHubId = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1"),
                FirewallPolicyId = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/firewallPolicies/policy1"),
                HubIPAddresses = new HubIPAddresses()
                {
                    PublicIPs = new HubPublicIPAddresses()
                    {
                        Addresses =
{
},
                        Count = 1,
                    },
                },
                Sku = new AzureFirewallSku()
                {
                    Name = AzureFirewallSkuName.AzfwHub,
                    Tier = AzureFirewallSkuTier.Standard,
                },
                Location = new AzureLocation("West US"),
                Tags =
{
["key1"] = "value1",
},
            };
            ArmOperation<AzureFirewallResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, azureFirewallName, data);
            AzureFirewallResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AzureFirewallData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // List all Azure Firewalls for a given resource group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListAllAzureFirewallsForAGivenResourceGroup()
        {
            // Generated from example definition: specification/network/resource-manager/Microsoft.Network/stable/2024-03-01/examples/AzureFirewallListByResourceGroup.json
            // this example is just showing the usage of "AzureFirewalls_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AzureFirewallResource
            AzureFirewallCollection collection = resourceGroupResource.GetAzureFirewalls();

            // invoke the operation and iterate over the result
            await foreach (AzureFirewallResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                AzureFirewallData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
