// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetApp.Models
{
    /// <summary> Enables access-based enumeration share property for SMB Shares. Only applicable for SMB/DualProtocol volume. </summary>
    public readonly partial struct SmbAccessBasedEnumeration : IEquatable<SmbAccessBasedEnumeration>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SmbAccessBasedEnumeration"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SmbAccessBasedEnumeration(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "Disabled";
        private const string EnabledValue = "Enabled";

        /// <summary> smbAccessBasedEnumeration share setting is disabled. </summary>
        public static SmbAccessBasedEnumeration Disabled { get; } = new SmbAccessBasedEnumeration(DisabledValue);
        /// <summary> smbAccessBasedEnumeration share setting is enabled. </summary>
        public static SmbAccessBasedEnumeration Enabled { get; } = new SmbAccessBasedEnumeration(EnabledValue);
        /// <summary> Determines if two <see cref="SmbAccessBasedEnumeration"/> values are the same. </summary>
        public static bool operator ==(SmbAccessBasedEnumeration left, SmbAccessBasedEnumeration right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SmbAccessBasedEnumeration"/> values are not the same. </summary>
        public static bool operator !=(SmbAccessBasedEnumeration left, SmbAccessBasedEnumeration right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SmbAccessBasedEnumeration"/>. </summary>
        public static implicit operator SmbAccessBasedEnumeration(string value) => new SmbAccessBasedEnumeration(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SmbAccessBasedEnumeration other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SmbAccessBasedEnumeration other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
