// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.NetApp.Models
{
    /// <summary> The full path to a volume that is to be migrated into ANF. Required for Migration volumes. </summary>
    public partial class RemotePath
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RemotePath"/>. </summary>
        /// <param name="externalHostName"> The Path to a ONTAP Host. </param>
        /// <param name="serverName"> The name of a server on the ONTAP Host. </param>
        /// <param name="volumeName"> The name of a volume on the server. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="externalHostName"/>, <paramref name="serverName"/> or <paramref name="volumeName"/> is null. </exception>
        public RemotePath(string externalHostName, string serverName, string volumeName)
        {
            Argument.AssertNotNull(externalHostName, nameof(externalHostName));
            Argument.AssertNotNull(serverName, nameof(serverName));
            Argument.AssertNotNull(volumeName, nameof(volumeName));

            ExternalHostName = externalHostName;
            ServerName = serverName;
            VolumeName = volumeName;
        }

        /// <summary> Initializes a new instance of <see cref="RemotePath"/>. </summary>
        /// <param name="externalHostName"> The Path to a ONTAP Host. </param>
        /// <param name="serverName"> The name of a server on the ONTAP Host. </param>
        /// <param name="volumeName"> The name of a volume on the server. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RemotePath(string externalHostName, string serverName, string volumeName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ExternalHostName = externalHostName;
            ServerName = serverName;
            VolumeName = volumeName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="RemotePath"/> for deserialization. </summary>
        internal RemotePath()
        {
        }

        /// <summary> The Path to a ONTAP Host. </summary>
        public string ExternalHostName { get; set; }
        /// <summary> The name of a server on the ONTAP Host. </summary>
        public string ServerName { get; set; }
        /// <summary> The name of a volume on the server. </summary>
        public string VolumeName { get; set; }
    }
}
