// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.NetApp.Models
{
    /// <summary> Source Cluster properties for a cluster peer request. </summary>
    public partial class PeerClusterForVolumeMigrationContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PeerClusterForVolumeMigrationContent"/>. </summary>
        /// <param name="peerIPAddresses"> A list of IC-LIF IPs that can be used to connect to the On-prem cluster. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="peerIPAddresses"/> is null. </exception>
        public PeerClusterForVolumeMigrationContent(IEnumerable<string> peerIPAddresses)
        {
            Argument.AssertNotNull(peerIPAddresses, nameof(peerIPAddresses));

            PeerIPAddresses = peerIPAddresses.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="PeerClusterForVolumeMigrationContent"/>. </summary>
        /// <param name="peerIPAddresses"> A list of IC-LIF IPs that can be used to connect to the On-prem cluster. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PeerClusterForVolumeMigrationContent(IList<string> peerIPAddresses, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PeerIPAddresses = peerIPAddresses;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="PeerClusterForVolumeMigrationContent"/> for deserialization. </summary>
        internal PeerClusterForVolumeMigrationContent()
        {
        }

        /// <summary> A list of IC-LIF IPs that can be used to connect to the On-prem cluster. </summary>
        public IList<string> PeerIPAddresses { get; }
    }
}
