// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetApp.Models
{
    /// <summary> Gets the status of the NetworkSiblingSet at the time the operation was called. </summary>
    public readonly partial struct NetworkSiblingSetProvisioningState : IEquatable<NetworkSiblingSetProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkSiblingSetProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkSiblingSetProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string UpdatingValue = "Updating";

        /// <summary> Succeeded. </summary>
        public static NetworkSiblingSetProvisioningState Succeeded { get; } = new NetworkSiblingSetProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static NetworkSiblingSetProvisioningState Failed { get; } = new NetworkSiblingSetProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static NetworkSiblingSetProvisioningState Canceled { get; } = new NetworkSiblingSetProvisioningState(CanceledValue);
        /// <summary> Updating. </summary>
        public static NetworkSiblingSetProvisioningState Updating { get; } = new NetworkSiblingSetProvisioningState(UpdatingValue);
        /// <summary> Determines if two <see cref="NetworkSiblingSetProvisioningState"/> values are the same. </summary>
        public static bool operator ==(NetworkSiblingSetProvisioningState left, NetworkSiblingSetProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkSiblingSetProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(NetworkSiblingSetProvisioningState left, NetworkSiblingSetProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkSiblingSetProvisioningState"/>. </summary>
        public static implicit operator NetworkSiblingSetProvisioningState(string value) => new NetworkSiblingSetProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkSiblingSetProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkSiblingSetProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
