// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.NetApp.Models
{
    /// <summary> Describes the contents of a network sibling set. </summary>
    public partial class NetworkSiblingSet
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetworkSiblingSet"/>. </summary>
        internal NetworkSiblingSet()
        {
            NicInfoList = new ChangeTrackingList<NicInfo>();
        }

        /// <summary> Initializes a new instance of <see cref="NetworkSiblingSet"/>. </summary>
        /// <param name="networkSiblingSetId"> Network Sibling Set ID for a group of volumes sharing networking resources in a subnet. </param>
        /// <param name="subnetId"> The Azure Resource URI for a delegated subnet. Must have the delegation Microsoft.NetApp/volumes. Example /subscriptions/subscriptionId/resourceGroups/resourceGroup/providers/Microsoft.Network/virtualNetworks/testVnet/subnets/{mySubnet}. </param>
        /// <param name="networkSiblingSetStateId"> Network sibling set state Id identifying the current state of the sibling set. </param>
        /// <param name="networkFeatures"> Network features available to the volume, or current state of update. </param>
        /// <param name="provisioningState"> Gets the status of the NetworkSiblingSet at the time the operation was called. </param>
        /// <param name="nicInfoList"> List of NIC information. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetworkSiblingSet(string networkSiblingSetId, ResourceIdentifier subnetId, string networkSiblingSetStateId, NetAppNetworkFeature? networkFeatures, NetworkSiblingSetProvisioningState? provisioningState, IReadOnlyList<NicInfo> nicInfoList, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            NetworkSiblingSetId = networkSiblingSetId;
            SubnetId = subnetId;
            NetworkSiblingSetStateId = networkSiblingSetStateId;
            NetworkFeatures = networkFeatures;
            ProvisioningState = provisioningState;
            NicInfoList = nicInfoList;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Network Sibling Set ID for a group of volumes sharing networking resources in a subnet. </summary>
        public string NetworkSiblingSetId { get; }
        /// <summary> The Azure Resource URI for a delegated subnet. Must have the delegation Microsoft.NetApp/volumes. Example /subscriptions/subscriptionId/resourceGroups/resourceGroup/providers/Microsoft.Network/virtualNetworks/testVnet/subnets/{mySubnet}. </summary>
        public ResourceIdentifier SubnetId { get; }
        /// <summary> Network sibling set state Id identifying the current state of the sibling set. </summary>
        public string NetworkSiblingSetStateId { get; }
        /// <summary> Network features available to the volume, or current state of update. </summary>
        public NetAppNetworkFeature? NetworkFeatures { get; }
        /// <summary> Gets the status of the NetworkSiblingSet at the time the operation was called. </summary>
        public NetworkSiblingSetProvisioningState? ProvisioningState { get; }
        /// <summary> List of NIC information. </summary>
        public IReadOnlyList<NicInfo> NicInfoList { get; }
    }
}
