// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetApp.Models
{
    /// <summary> Provides storage to network proximity information for the volume. </summary>
    public readonly partial struct NetAppVolumeStorageToNetworkProximity : IEquatable<NetAppVolumeStorageToNetworkProximity>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetAppVolumeStorageToNetworkProximity"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetAppVolumeStorageToNetworkProximity(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "Default";
        private const string T1Value = "T1";
        private const string T2Value = "T2";
        private const string AcrossT2Value = "AcrossT2";

        /// <summary> Basic storage to network connectivity. </summary>
        public static NetAppVolumeStorageToNetworkProximity Default { get; } = new NetAppVolumeStorageToNetworkProximity(DefaultValue);
        /// <summary> Standard T1 storage to network connectivity. </summary>
        public static NetAppVolumeStorageToNetworkProximity T1 { get; } = new NetAppVolumeStorageToNetworkProximity(T1Value);
        /// <summary> Standard T2 storage to network connectivity. </summary>
        public static NetAppVolumeStorageToNetworkProximity T2 { get; } = new NetAppVolumeStorageToNetworkProximity(T2Value);
        /// <summary> Standard AcrossT2 storage to network connectivity. </summary>
        public static NetAppVolumeStorageToNetworkProximity AcrossT2 { get; } = new NetAppVolumeStorageToNetworkProximity(AcrossT2Value);
        /// <summary> Determines if two <see cref="NetAppVolumeStorageToNetworkProximity"/> values are the same. </summary>
        public static bool operator ==(NetAppVolumeStorageToNetworkProximity left, NetAppVolumeStorageToNetworkProximity right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetAppVolumeStorageToNetworkProximity"/> values are not the same. </summary>
        public static bool operator !=(NetAppVolumeStorageToNetworkProximity left, NetAppVolumeStorageToNetworkProximity right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetAppVolumeStorageToNetworkProximity"/>. </summary>
        public static implicit operator NetAppVolumeStorageToNetworkProximity(string value) => new NetAppVolumeStorageToNetworkProximity(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetAppVolumeStorageToNetworkProximity other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetAppVolumeStorageToNetworkProximity other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
