// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.NetApp.Models
{
    /// <summary> Volume relocation properties. </summary>
    public partial class NetAppVolumeRelocationProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetAppVolumeRelocationProperties"/>. </summary>
        public NetAppVolumeRelocationProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="NetAppVolumeRelocationProperties"/>. </summary>
        /// <param name="isRelocationRequested"> Has relocation been requested for this volume. </param>
        /// <param name="isReadyToBeFinalized"> Has relocation finished and is ready to be cleaned up. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetAppVolumeRelocationProperties(bool? isRelocationRequested, bool? isReadyToBeFinalized, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsRelocationRequested = isRelocationRequested;
            IsReadyToBeFinalized = isReadyToBeFinalized;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Has relocation been requested for this volume. </summary>
        public bool? IsRelocationRequested { get; set; }
        /// <summary> Has relocation finished and is ready to be cleaned up. </summary>
        public bool? IsReadyToBeFinalized { get; }
    }
}
