// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetApp.Models
{
    /// <summary> Type of quota. </summary>
    public readonly partial struct NetAppVolumeQuotaType : IEquatable<NetAppVolumeQuotaType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetAppVolumeQuotaType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetAppVolumeQuotaType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultUserQuotaValue = "DefaultUserQuota";
        private const string DefaultGroupQuotaValue = "DefaultGroupQuota";
        private const string IndividualUserQuotaValue = "IndividualUserQuota";
        private const string IndividualGroupQuotaValue = "IndividualGroupQuota";

        /// <summary> Default user quota. </summary>
        public static NetAppVolumeQuotaType DefaultUserQuota { get; } = new NetAppVolumeQuotaType(DefaultUserQuotaValue);
        /// <summary> Default group quota. </summary>
        public static NetAppVolumeQuotaType DefaultGroupQuota { get; } = new NetAppVolumeQuotaType(DefaultGroupQuotaValue);
        /// <summary> Individual user quota. </summary>
        public static NetAppVolumeQuotaType IndividualUserQuota { get; } = new NetAppVolumeQuotaType(IndividualUserQuotaValue);
        /// <summary> Individual group quota. </summary>
        public static NetAppVolumeQuotaType IndividualGroupQuota { get; } = new NetAppVolumeQuotaType(IndividualGroupQuotaValue);
        /// <summary> Determines if two <see cref="NetAppVolumeQuotaType"/> values are the same. </summary>
        public static bool operator ==(NetAppVolumeQuotaType left, NetAppVolumeQuotaType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetAppVolumeQuotaType"/> values are not the same. </summary>
        public static bool operator !=(NetAppVolumeQuotaType left, NetAppVolumeQuotaType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetAppVolumeQuotaType"/>. </summary>
        public static implicit operator NetAppVolumeQuotaType(string value) => new NetAppVolumeQuotaType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetAppVolumeQuotaType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetAppVolumeQuotaType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
