// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.NetApp.Models
{
    /// <summary> Pool change request. </summary>
    public partial class NetAppVolumePoolChangeContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetAppVolumePoolChangeContent"/>. </summary>
        /// <param name="newPoolResourceId"> Resource id of the pool to move volume to. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="newPoolResourceId"/> is null. </exception>
        public NetAppVolumePoolChangeContent(ResourceIdentifier newPoolResourceId)
        {
            Argument.AssertNotNull(newPoolResourceId, nameof(newPoolResourceId));

            NewPoolResourceId = newPoolResourceId;
        }

        /// <summary> Initializes a new instance of <see cref="NetAppVolumePoolChangeContent"/>. </summary>
        /// <param name="newPoolResourceId"> Resource id of the pool to move volume to. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetAppVolumePoolChangeContent(ResourceIdentifier newPoolResourceId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            NewPoolResourceId = newPoolResourceId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="NetAppVolumePoolChangeContent"/> for deserialization. </summary>
        internal NetAppVolumePoolChangeContent()
        {
        }

        /// <summary> Resource id of the pool to move volume to. </summary>
        public ResourceIdentifier NewPoolResourceId { get; }
    }
}
