// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Net;

namespace Azure.ResourceManager.NetApp.Models
{
    /// <summary> Mount target properties. </summary>
    public partial class NetAppVolumeMountTarget
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetAppVolumeMountTarget"/>. </summary>
        /// <param name="fileSystemId"> UUID v4 used to identify the MountTarget. </param>
        internal NetAppVolumeMountTarget(Guid fileSystemId)
        {
            FileSystemId = fileSystemId;
        }

        /// <summary> Initializes a new instance of <see cref="NetAppVolumeMountTarget"/>. </summary>
        /// <param name="mountTargetId"> UUID v4 used to identify the MountTarget. </param>
        /// <param name="fileSystemId"> UUID v4 used to identify the MountTarget. </param>
        /// <param name="ipAddress"> The mount target's IPv4 address. </param>
        /// <param name="smbServerFqdn"> The SMB server's Fully Qualified Domain Name, FQDN. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetAppVolumeMountTarget(Guid? mountTargetId, Guid fileSystemId, IPAddress ipAddress, string smbServerFqdn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MountTargetId = mountTargetId;
            FileSystemId = fileSystemId;
            IPAddress = ipAddress;
            SmbServerFqdn = smbServerFqdn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="NetAppVolumeMountTarget"/> for deserialization. </summary>
        internal NetAppVolumeMountTarget()
        {
        }

        /// <summary> UUID v4 used to identify the MountTarget. </summary>
        public Guid? MountTargetId { get; }
        /// <summary> UUID v4 used to identify the MountTarget. </summary>
        public Guid FileSystemId { get; }
        /// <summary> The mount target's IPv4 address. </summary>
        public IPAddress IPAddress { get; }
        /// <summary> The SMB server's Fully Qualified Domain Name, FQDN. </summary>
        public string SmbServerFqdn { get; }
    }
}
