// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.NetApp.Models
{
    /// <summary> Volume details using the backup policy. </summary>
    public partial class NetAppVolumeBackupDetail
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetAppVolumeBackupDetail"/>. </summary>
        internal NetAppVolumeBackupDetail()
        {
        }

        /// <summary> Initializes a new instance of <see cref="NetAppVolumeBackupDetail"/>. </summary>
        /// <param name="volumeName"> Volume name. </param>
        /// <param name="volumeResourceId"> ResourceId used to identify the Volume. </param>
        /// <param name="backupsCount"> Total count of backups for volume. </param>
        /// <param name="isPolicyEnabled"> Policy enabled. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetAppVolumeBackupDetail(string volumeName, ResourceIdentifier volumeResourceId, int? backupsCount, bool? isPolicyEnabled, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            VolumeName = volumeName;
            VolumeResourceId = volumeResourceId;
            BackupsCount = backupsCount;
            IsPolicyEnabled = isPolicyEnabled;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Volume name. </summary>
        public string VolumeName { get; }
        /// <summary> ResourceId used to identify the Volume. </summary>
        public ResourceIdentifier VolumeResourceId { get; }
        /// <summary> Total count of backups for volume. </summary>
        public int? BackupsCount { get; }
        /// <summary> Policy enabled. </summary>
        public bool? IsPolicyEnabled { get; }
    }
}
