// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.NetApp.Models
{
    public partial class NetAppRestoreStatus : IUtf8JsonSerializable, IJsonModel<NetAppRestoreStatus>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<NetAppRestoreStatus>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<NetAppRestoreStatus>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NetAppRestoreStatus>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(NetAppRestoreStatus)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(IsHealthy))
            {
                writer.WritePropertyName("healthy"u8);
                writer.WriteBooleanValue(IsHealthy.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(RelationshipStatus))
            {
                writer.WritePropertyName("relationshipStatus"u8);
                writer.WriteStringValue(RelationshipStatus.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(MirrorState))
            {
                writer.WritePropertyName("mirrorState"u8);
                writer.WriteStringValue(MirrorState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(UnhealthyReason))
            {
                writer.WritePropertyName("unhealthyReason"u8);
                writer.WriteStringValue(UnhealthyReason);
            }
            if (options.Format != "W" && Optional.IsDefined(ErrorMessage))
            {
                writer.WritePropertyName("errorMessage"u8);
                writer.WriteStringValue(ErrorMessage);
            }
            if (options.Format != "W" && Optional.IsDefined(TotalTransferBytes))
            {
                writer.WritePropertyName("totalTransferBytes"u8);
                writer.WriteNumberValue(TotalTransferBytes.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        NetAppRestoreStatus IJsonModel<NetAppRestoreStatus>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NetAppRestoreStatus>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(NetAppRestoreStatus)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeNetAppRestoreStatus(document.RootElement, options);
        }

        internal static NetAppRestoreStatus DeserializeNetAppRestoreStatus(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool? healthy = default;
            NetAppRelationshipStatus? relationshipStatus = default;
            NetAppMirrorState? mirrorState = default;
            string unhealthyReason = default;
            string errorMessage = default;
            long? totalTransferBytes = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("healthy"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    healthy = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("relationshipStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    relationshipStatus = new NetAppRelationshipStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("mirrorState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    mirrorState = new NetAppMirrorState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("unhealthyReason"u8))
                {
                    unhealthyReason = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("errorMessage"u8))
                {
                    errorMessage = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("totalTransferBytes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalTransferBytes = property.Value.GetInt64();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new NetAppRestoreStatus(
                healthy,
                relationshipStatus,
                mirrorState,
                unhealthyReason,
                errorMessage,
                totalTransferBytes,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<NetAppRestoreStatus>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NetAppRestoreStatus>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(NetAppRestoreStatus)} does not support writing '{options.Format}' format.");
            }
        }

        NetAppRestoreStatus IPersistableModel<NetAppRestoreStatus>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NetAppRestoreStatus>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeNetAppRestoreStatus(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(NetAppRestoreStatus)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<NetAppRestoreStatus>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
