// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetApp.Models
{
    /// <summary> Schedule. </summary>
    public readonly partial struct NetAppReplicationSchedule : IEquatable<NetAppReplicationSchedule>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetAppReplicationSchedule"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetAppReplicationSchedule(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TenMinutelyValue = "_10minutely";
        private const string HourlyValue = "hourly";
        private const string DailyValue = "daily";

        /// <summary> _10minutely. </summary>
        public static NetAppReplicationSchedule TenMinutely { get; } = new NetAppReplicationSchedule(TenMinutelyValue);
        /// <summary> hourly. </summary>
        public static NetAppReplicationSchedule Hourly { get; } = new NetAppReplicationSchedule(HourlyValue);
        /// <summary> daily. </summary>
        public static NetAppReplicationSchedule Daily { get; } = new NetAppReplicationSchedule(DailyValue);
        /// <summary> Determines if two <see cref="NetAppReplicationSchedule"/> values are the same. </summary>
        public static bool operator ==(NetAppReplicationSchedule left, NetAppReplicationSchedule right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetAppReplicationSchedule"/> values are not the same. </summary>
        public static bool operator !=(NetAppReplicationSchedule left, NetAppReplicationSchedule right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetAppReplicationSchedule"/>. </summary>
        public static implicit operator NetAppReplicationSchedule(string value) => new NetAppReplicationSchedule(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetAppReplicationSchedule other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetAppReplicationSchedule other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
