// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetApp.Models
{
    /// <summary> Network features available to the volume, or current state of update. </summary>
    public readonly partial struct NetAppNetworkFeature : IEquatable<NetAppNetworkFeature>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetAppNetworkFeature"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetAppNetworkFeature(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BasicValue = "Basic";
        private const string StandardValue = "Standard";
        private const string BasicStandardValue = "Basic_Standard";
        private const string StandardBasicValue = "Standard_Basic";

        /// <summary> Basic network features. </summary>
        public static NetAppNetworkFeature Basic { get; } = new NetAppNetworkFeature(BasicValue);
        /// <summary> Standard network features. </summary>
        public static NetAppNetworkFeature Standard { get; } = new NetAppNetworkFeature(StandardValue);
        /// <summary> Updating from Basic to Standard network features. </summary>
        public static NetAppNetworkFeature BasicStandard { get; } = new NetAppNetworkFeature(BasicStandardValue);
        /// <summary> Updating from Standard to Basic network features. </summary>
        public static NetAppNetworkFeature StandardBasic { get; } = new NetAppNetworkFeature(StandardBasicValue);
        /// <summary> Determines if two <see cref="NetAppNetworkFeature"/> values are the same. </summary>
        public static bool operator ==(NetAppNetworkFeature left, NetAppNetworkFeature right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetAppNetworkFeature"/> values are not the same. </summary>
        public static bool operator !=(NetAppNetworkFeature left, NetAppNetworkFeature right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetAppNetworkFeature"/>. </summary>
        public static implicit operator NetAppNetworkFeature(string value) => new NetAppNetworkFeature(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetAppNetworkFeature other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetAppNetworkFeature other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
