// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.NetApp.Models
{
    public partial class NetAppLdapSearchScopeConfiguration : IUtf8JsonSerializable, IJsonModel<NetAppLdapSearchScopeConfiguration>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<NetAppLdapSearchScopeConfiguration>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<NetAppLdapSearchScopeConfiguration>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NetAppLdapSearchScopeConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(NetAppLdapSearchScopeConfiguration)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(UserDN))
            {
                writer.WritePropertyName("userDN"u8);
                writer.WriteStringValue(UserDN);
            }
            if (Optional.IsDefined(GroupDN))
            {
                writer.WritePropertyName("groupDN"u8);
                writer.WriteStringValue(GroupDN);
            }
            if (Optional.IsDefined(GroupMembershipFilter))
            {
                writer.WritePropertyName("groupMembershipFilter"u8);
                writer.WriteStringValue(GroupMembershipFilter);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        NetAppLdapSearchScopeConfiguration IJsonModel<NetAppLdapSearchScopeConfiguration>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NetAppLdapSearchScopeConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(NetAppLdapSearchScopeConfiguration)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeNetAppLdapSearchScopeConfiguration(document.RootElement, options);
        }

        internal static NetAppLdapSearchScopeConfiguration DeserializeNetAppLdapSearchScopeConfiguration(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string userDN = default;
            string groupDN = default;
            string groupMembershipFilter = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("userDN"u8))
                {
                    userDN = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("groupDN"u8))
                {
                    groupDN = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("groupMembershipFilter"u8))
                {
                    groupMembershipFilter = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new NetAppLdapSearchScopeConfiguration(userDN, groupDN, groupMembershipFilter, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<NetAppLdapSearchScopeConfiguration>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NetAppLdapSearchScopeConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(NetAppLdapSearchScopeConfiguration)} does not support writing '{options.Format}' format.");
            }
        }

        NetAppLdapSearchScopeConfiguration IPersistableModel<NetAppLdapSearchScopeConfiguration>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NetAppLdapSearchScopeConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeNetAppLdapSearchScopeConfiguration(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(NetAppLdapSearchScopeConfiguration)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<NetAppLdapSearchScopeConfiguration>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
