// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetApp.Models
{
    /// <summary> Status of the KeyVault connection. </summary>
    public readonly partial struct NetAppKeyVaultStatus : IEquatable<NetAppKeyVaultStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetAppKeyVaultStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetAppKeyVaultStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatedValue = "Created";
        private const string InUseValue = "InUse";
        private const string DeletedValue = "Deleted";
        private const string ErrorValue = "Error";
        private const string UpdatingValue = "Updating";

        /// <summary> KeyVault connection created but not in use. </summary>
        public static NetAppKeyVaultStatus Created { get; } = new NetAppKeyVaultStatus(CreatedValue);
        /// <summary> KeyVault connection in use by SMB Volume. </summary>
        public static NetAppKeyVaultStatus InUse { get; } = new NetAppKeyVaultStatus(InUseValue);
        /// <summary> KeyVault connection Deleted. </summary>
        public static NetAppKeyVaultStatus Deleted { get; } = new NetAppKeyVaultStatus(DeletedValue);
        /// <summary> Error with the KeyVault connection. </summary>
        public static NetAppKeyVaultStatus Error { get; } = new NetAppKeyVaultStatus(ErrorValue);
        /// <summary> KeyVault connection Updating. </summary>
        public static NetAppKeyVaultStatus Updating { get; } = new NetAppKeyVaultStatus(UpdatingValue);
        /// <summary> Determines if two <see cref="NetAppKeyVaultStatus"/> values are the same. </summary>
        public static bool operator ==(NetAppKeyVaultStatus left, NetAppKeyVaultStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetAppKeyVaultStatus"/> values are not the same. </summary>
        public static bool operator !=(NetAppKeyVaultStatus left, NetAppKeyVaultStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetAppKeyVaultStatus"/>. </summary>
        public static implicit operator NetAppKeyVaultStatus(string value) => new NetAppKeyVaultStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetAppKeyVaultStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetAppKeyVaultStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
