// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetApp.Models
{
    /// <summary> Status of the Active Directory. </summary>
    public readonly partial struct NetAppAccountActiveDirectoryStatus : IEquatable<NetAppAccountActiveDirectoryStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetAppAccountActiveDirectoryStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetAppAccountActiveDirectoryStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatedValue = "Created";
        private const string InUseValue = "InUse";
        private const string DeletedValue = "Deleted";
        private const string ErrorValue = "Error";
        private const string UpdatingValue = "Updating";

        /// <summary> Active Directory created but not in use. </summary>
        public static NetAppAccountActiveDirectoryStatus Created { get; } = new NetAppAccountActiveDirectoryStatus(CreatedValue);
        /// <summary> Active Directory in use by SMB Volume. </summary>
        public static NetAppAccountActiveDirectoryStatus InUse { get; } = new NetAppAccountActiveDirectoryStatus(InUseValue);
        /// <summary> Active Directory Deleted. </summary>
        public static NetAppAccountActiveDirectoryStatus Deleted { get; } = new NetAppAccountActiveDirectoryStatus(DeletedValue);
        /// <summary> Error with the Active Directory. </summary>
        public static NetAppAccountActiveDirectoryStatus Error { get; } = new NetAppAccountActiveDirectoryStatus(ErrorValue);
        /// <summary> Active Directory Updating. </summary>
        public static NetAppAccountActiveDirectoryStatus Updating { get; } = new NetAppAccountActiveDirectoryStatus(UpdatingValue);
        /// <summary> Determines if two <see cref="NetAppAccountActiveDirectoryStatus"/> values are the same. </summary>
        public static bool operator ==(NetAppAccountActiveDirectoryStatus left, NetAppAccountActiveDirectoryStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetAppAccountActiveDirectoryStatus"/> values are not the same. </summary>
        public static bool operator !=(NetAppAccountActiveDirectoryStatus left, NetAppAccountActiveDirectoryStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetAppAccountActiveDirectoryStatus"/>. </summary>
        public static implicit operator NetAppAccountActiveDirectoryStatus(string value) => new NetAppAccountActiveDirectoryStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetAppAccountActiveDirectoryStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetAppAccountActiveDirectoryStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
