// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetApp.Models
{
    /// <summary>
    /// coolAccessRetrievalPolicy determines the data retrieval behavior from the cool tier to standard storage based on the read pattern for cool access enabled volumes. The possible values for this field are:
    ///  Default - Data will be pulled from cool tier to standard storage on random reads. This policy is the default.
    ///  OnRead - All client-driven data read is pulled from cool tier to standard storage on both sequential and random reads.
    ///  Never - No client-driven data is pulled from cool tier to standard storage.
    /// </summary>
    public readonly partial struct CoolAccessRetrievalPolicy : IEquatable<CoolAccessRetrievalPolicy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CoolAccessRetrievalPolicy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CoolAccessRetrievalPolicy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "Default";
        private const string OnReadValue = "OnRead";
        private const string NeverValue = "Never";

        /// <summary> Default. </summary>
        public static CoolAccessRetrievalPolicy Default { get; } = new CoolAccessRetrievalPolicy(DefaultValue);
        /// <summary> OnRead. </summary>
        public static CoolAccessRetrievalPolicy OnRead { get; } = new CoolAccessRetrievalPolicy(OnReadValue);
        /// <summary> Never. </summary>
        public static CoolAccessRetrievalPolicy Never { get; } = new CoolAccessRetrievalPolicy(NeverValue);
        /// <summary> Determines if two <see cref="CoolAccessRetrievalPolicy"/> values are the same. </summary>
        public static bool operator ==(CoolAccessRetrievalPolicy left, CoolAccessRetrievalPolicy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CoolAccessRetrievalPolicy"/> values are not the same. </summary>
        public static bool operator !=(CoolAccessRetrievalPolicy left, CoolAccessRetrievalPolicy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CoolAccessRetrievalPolicy"/>. </summary>
        public static implicit operator CoolAccessRetrievalPolicy(string value) => new CoolAccessRetrievalPolicy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CoolAccessRetrievalPolicy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CoolAccessRetrievalPolicy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
