// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetApp.Models
{
    /// <summary> The qos type of the pool. </summary>
    public readonly partial struct CapacityPoolQosType : IEquatable<CapacityPoolQosType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CapacityPoolQosType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CapacityPoolQosType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AutoValue = "Auto";
        private const string ManualValue = "Manual";

        /// <summary> qos type Auto. </summary>
        public static CapacityPoolQosType Auto { get; } = new CapacityPoolQosType(AutoValue);
        /// <summary> qos type Manual. </summary>
        public static CapacityPoolQosType Manual { get; } = new CapacityPoolQosType(ManualValue);
        /// <summary> Determines if two <see cref="CapacityPoolQosType"/> values are the same. </summary>
        public static bool operator ==(CapacityPoolQosType left, CapacityPoolQosType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CapacityPoolQosType"/> values are not the same. </summary>
        public static bool operator !=(CapacityPoolQosType left, CapacityPoolQosType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CapacityPoolQosType"/>. </summary>
        public static implicit operator CapacityPoolQosType(string value) => new CapacityPoolQosType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CapacityPoolQosType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CapacityPoolQosType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
