// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.NetApp
{
    internal class SnapshotPolicyOperationSource : IOperationSource<SnapshotPolicyResource>
    {
        private readonly ArmClient _client;

        internal SnapshotPolicyOperationSource(ArmClient client)
        {
            _client = client;
        }

        SnapshotPolicyResource IOperationSource<SnapshotPolicyResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SnapshotPolicyData.DeserializeSnapshotPolicyData(document.RootElement);
            return new SnapshotPolicyResource(_client, data);
        }

        async ValueTask<SnapshotPolicyResource> IOperationSource<SnapshotPolicyResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SnapshotPolicyData.DeserializeSnapshotPolicyData(document.RootElement);
            return new SnapshotPolicyResource(_client, data);
        }
    }
}
