// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.NetApp
{
    internal class NetAppVolumeSnapshotOperationSource : IOperationSource<NetAppVolumeSnapshotResource>
    {
        private readonly ArmClient _client;

        internal NetAppVolumeSnapshotOperationSource(ArmClient client)
        {
            _client = client;
        }

        NetAppVolumeSnapshotResource IOperationSource<NetAppVolumeSnapshotResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = NetAppVolumeSnapshotData.DeserializeNetAppVolumeSnapshotData(document.RootElement);
            return new NetAppVolumeSnapshotResource(_client, data);
        }

        async ValueTask<NetAppVolumeSnapshotResource> IOperationSource<NetAppVolumeSnapshotResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = NetAppVolumeSnapshotData.DeserializeNetAppVolumeSnapshotData(document.RootElement);
            return new NetAppVolumeSnapshotResource(_client, data);
        }
    }
}
