// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.NetApp
{
    internal class NetAppVolumeQuotaRuleOperationSource : IOperationSource<NetAppVolumeQuotaRuleResource>
    {
        private readonly ArmClient _client;

        internal NetAppVolumeQuotaRuleOperationSource(ArmClient client)
        {
            _client = client;
        }

        NetAppVolumeQuotaRuleResource IOperationSource<NetAppVolumeQuotaRuleResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = NetAppVolumeQuotaRuleData.DeserializeNetAppVolumeQuotaRuleData(document.RootElement);
            return new NetAppVolumeQuotaRuleResource(_client, data);
        }

        async ValueTask<NetAppVolumeQuotaRuleResource> IOperationSource<NetAppVolumeQuotaRuleResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = NetAppVolumeQuotaRuleData.DeserializeNetAppVolumeQuotaRuleData(document.RootElement);
            return new NetAppVolumeQuotaRuleResource(_client, data);
        }
    }
}
