// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.NetApp
{
    internal class NetAppVolumeOperationSource : IOperationSource<NetAppVolumeResource>
    {
        private readonly ArmClient _client;

        internal NetAppVolumeOperationSource(ArmClient client)
        {
            _client = client;
        }

        NetAppVolumeResource IOperationSource<NetAppVolumeResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = NetAppVolumeData.DeserializeNetAppVolumeData(document.RootElement);
            return new NetAppVolumeResource(_client, data);
        }

        async ValueTask<NetAppVolumeResource> IOperationSource<NetAppVolumeResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = NetAppVolumeData.DeserializeNetAppVolumeData(document.RootElement);
            return new NetAppVolumeResource(_client, data);
        }
    }
}
