// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.NetApp
{
    internal class NetAppVolumeGroupOperationSource : IOperationSource<NetAppVolumeGroupResource>
    {
        private readonly ArmClient _client;

        internal NetAppVolumeGroupOperationSource(ArmClient client)
        {
            _client = client;
        }

        NetAppVolumeGroupResource IOperationSource<NetAppVolumeGroupResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = NetAppVolumeGroupData.DeserializeNetAppVolumeGroupData(document.RootElement);
            return new NetAppVolumeGroupResource(_client, data);
        }

        async ValueTask<NetAppVolumeGroupResource> IOperationSource<NetAppVolumeGroupResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = NetAppVolumeGroupData.DeserializeNetAppVolumeGroupData(document.RootElement);
            return new NetAppVolumeGroupResource(_client, data);
        }
    }
}
