// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.NetApp
{
    internal class NetAppBackupVaultBackupOperationSource : IOperationSource<NetAppBackupVaultBackupResource>
    {
        private readonly ArmClient _client;

        internal NetAppBackupVaultBackupOperationSource(ArmClient client)
        {
            _client = client;
        }

        NetAppBackupVaultBackupResource IOperationSource<NetAppBackupVaultBackupResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = NetAppBackupData.DeserializeNetAppBackupData(document.RootElement);
            return new NetAppBackupVaultBackupResource(_client, data);
        }

        async ValueTask<NetAppBackupVaultBackupResource> IOperationSource<NetAppBackupVaultBackupResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = NetAppBackupData.DeserializeNetAppBackupData(document.RootElement);
            return new NetAppBackupVaultBackupResource(_client, data);
        }
    }
}
