// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.NetApp
{
    internal class NetAppBackupPolicyOperationSource : IOperationSource<NetAppBackupPolicyResource>
    {
        private readonly ArmClient _client;

        internal NetAppBackupPolicyOperationSource(ArmClient client)
        {
            _client = client;
        }

        NetAppBackupPolicyResource IOperationSource<NetAppBackupPolicyResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = NetAppBackupPolicyData.DeserializeNetAppBackupPolicyData(document.RootElement);
            return new NetAppBackupPolicyResource(_client, data);
        }

        async ValueTask<NetAppBackupPolicyResource> IOperationSource<NetAppBackupPolicyResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = NetAppBackupPolicyData.DeserializeNetAppBackupPolicyData(document.RootElement);
            return new NetAppBackupPolicyResource(_client, data);
        }
    }
}
