// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.NetApp
{
    internal class NetAppAccountOperationSource : IOperationSource<NetAppAccountResource>
    {
        private readonly ArmClient _client;

        internal NetAppAccountOperationSource(ArmClient client)
        {
            _client = client;
        }

        NetAppAccountResource IOperationSource<NetAppAccountResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = NetAppAccountData.DeserializeNetAppAccountData(document.RootElement);
            return new NetAppAccountResource(_client, data);
        }

        async ValueTask<NetAppAccountResource> IOperationSource<NetAppAccountResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = NetAppAccountData.DeserializeNetAppAccountData(document.RootElement);
            return new NetAppAccountResource(_client, data);
        }
    }
}
